/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command;

import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.definition.config.CommandConfig;
import org.iplass.mtp.command.definition.config.CompositeCommandConfig;
import org.iplass.mtp.impl.command.CompositeCommand;
import org.iplass.mtp.impl.command.MetaCommand;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaCompositeCommand
extends MetaCommand {
    private static final long serialVersionUID = 2767161125283111456L;
    private static Logger logger = LoggerFactory.getLogger(MetaCompositeCommand.class);
    private MetaCommand[] commands;
    private String rule;

    public MetaCommand[] getCommands() {
        return this.commands;
    }

    public void setCommands(MetaCommand[] commands) {
        this.commands = commands;
    }

    public String getRule() {
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    @Override
    public CompositeCommandRuntime createRuntime() {
        return new CompositeCommandRuntime("CompositeCommand");
    }

    @Override
    public void applyConfig(CommandConfig definition) {
        this.fillFrom(definition);
        CompositeCommandConfig def = (CompositeCommandConfig)definition;
        if (def.getCommands() != null) {
            this.commands = new MetaCommand[def.getCommands().length];
            int i = 0;
            for (CommandConfig config : def.getCommands()) {
                this.commands[i] = MetaCommand.createInstance(config);
                this.commands[i].applyConfig(config);
                ++i;
            }
        }
        this.rule = def.getExecuteScript();
    }

    @Override
    public CompositeCommandConfig currentConfig() {
        CompositeCommandConfig definition = new CompositeCommandConfig();
        this.fillTo(definition);
        if (this.commands != null) {
            CommandConfig[] configs = new CommandConfig[this.commands.length];
            int i = 0;
            for (MetaCommand command : this.commands) {
                configs[i] = command.currentConfig();
                ++i;
            }
            definition.setCommands(configs);
        }
        definition.setExecuteScript(this.rule);
        return definition;
    }

    public class CompositeCommandRuntime
    extends MetaCommand.CommandRuntime {
        private static final String SCRIPT_PREFIX = "CompositeCommandRuntime_rule";
        private boolean readOnly;
        private boolean newInstancePerRequest;
        private MetaCommand.CommandRuntime[] crs;
        Script executeRule;

        public CompositeCommandRuntime(String identifer) {
            super(identifer);
        }

        @Override
        protected void initImpl(String identifer) {
            this.crs = new MetaCommand.CommandRuntime[MetaCompositeCommand.this.commands.length];
            this.readOnly = true;
            this.newInstancePerRequest = false;
            for (int i = 0; i < MetaCompositeCommand.this.commands.length; ++i) {
                this.crs[i] = MetaCompositeCommand.this.commands[i].createRuntime();
                this.readOnly &= this.crs[i].readOnly();
                this.newInstancePerRequest |= this.crs[i].newInstancePerRequest();
            }
            if (MetaCompositeCommand.this.rule != null) {
                TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
                KeyGenerator keyGen = new KeyGenerator();
                this.executeRule = tc.getScriptEngine().createScript(MetaCompositeCommand.this.rule, "CompositeCommandRuntime_rule_" + identifer + "_" + keyGen.generateId());
            }
        }

        @Override
        public MetaCompositeCommand getMetaData() {
            return MetaCompositeCommand.this;
        }

        @Override
        protected Command newCommand() {
            CompositeCommand cmd = new CompositeCommand(this.crs, this.executeRule);
            this.initCommand(cmd);
            return cmd;
        }

        private void initCommand(CompositeCommand cmd) {
            logger.debug("init CompositeCommand instance:" + String.valueOf(cmd));
            if (this.configScript != null) {
                TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
                ScriptEngine ss = tc.getScriptEngine();
                ScriptContext sc = ss.newScriptContext();
                sc.setAttribute("cmd", cmd.getCommands());
                this.configScript.eval(sc);
            }
        }

        @Override
        public boolean readOnly() {
            return this.readOnly;
        }

        @Override
        protected boolean newInstancePerRequest() {
            return this.newInstancePerRequest;
        }

        @Override
        public String name() {
            return "CompositeCommand";
        }
    }
}

