/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command;

import jakarta.xml.bind.annotation.XmlSeeAlso;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.definition.CommandDefinition;
import org.iplass.mtp.command.definition.JavaClassCommandDefinition;
import org.iplass.mtp.command.definition.ScriptingCommandDefinition;
import org.iplass.mtp.impl.command.MetaMetaJavaCommand;
import org.iplass.mtp.impl.command.MetaMetaScriptingCommand;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.util.ObjectUtil;

@XmlSeeAlso(value={MetaMetaJavaCommand.class, MetaMetaScriptingCommand.class})
public abstract class MetaMetaCommand
extends BaseRootMetaData
implements DefinableMetaData<CommandDefinition> {
    private static final long serialVersionUID = -5145049329757303334L;
    private boolean readOnly;
    private boolean newInstancePerRequest;

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isNewInstancePerRequest() {
        return this.newInstancePerRequest;
    }

    public void setNewInstancePerRequest(boolean newInstancePerRequest) {
        this.newInstancePerRequest = newInstancePerRequest;
    }

    @Override
    public MetaMetaCommand copy() {
        return ObjectUtil.deepCopy(this);
    }

    public static MetaMetaCommand createInstance(CommandDefinition definition) {
        if (definition instanceof JavaClassCommandDefinition) {
            return new MetaMetaJavaCommand();
        }
        if (definition instanceof ScriptingCommandDefinition) {
            return new MetaMetaScriptingCommand();
        }
        return null;
    }

    @Override
    public abstract void applyConfig(CommandDefinition var1);

    @Override
    public abstract CommandDefinition currentConfig();

    protected void fillFrom(CommandDefinition definition) {
        this.name = definition.getName();
        this.displayName = definition.getDisplayName();
        this.localizedDisplayNameList = I18nUtil.toMeta(definition.getLocalizedDisplayNameList());
        this.description = definition.getDescription();
        this.readOnly = definition.isReadOnly();
        this.newInstancePerRequest = definition.isNewInstancePerRequest();
    }

    protected void fillTo(CommandDefinition definition) {
        definition.setName(this.name);
        definition.setDisplayName(this.displayName);
        definition.setLocalizedDisplayNameList(I18nUtil.toDef(this.localizedDisplayNameList));
        definition.setDescription(this.description);
        definition.setReadOnly(this.readOnly);
        definition.setNewInstancePerRequest(this.newInstancePerRequest);
    }

    public abstract class MetaCommandRuntime
    extends BaseMetaDataRuntime {
        public MetaCommandRuntime(MetaMetaCommand this$0) {
        }

        public abstract Command newCommand();

        @Override
        public abstract MetaMetaCommand getMetaData();
    }
}

