/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command;

import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.RequestContext;
import org.iplass.mtp.command.definition.CommandDefinition;
import org.iplass.mtp.command.definition.ScriptingCommandDefinition;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.impl.command.MetaMetaCommand;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;

public class MetaMetaScriptingCommand
extends MetaMetaCommand {
    private static final long serialVersionUID = -9093215091573995083L;
    private static final String REQUEST_BINDING_NAME = "request";
    private String script;

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public void applyConfig(CommandDefinition definition) {
        this.fillFrom(definition);
        ScriptingCommandDefinition def = (ScriptingCommandDefinition)definition;
        this.script = def.getScript();
    }

    @Override
    public CommandDefinition currentConfig() {
        ScriptingCommandDefinition definition = new ScriptingCommandDefinition();
        this.fillTo(definition);
        definition.setScript(this.script);
        return definition;
    }

    @Override
    public MetaScriptingCommandRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new MetaScriptingCommandRuntime();
    }

    public class MetaScriptingCommandRuntime
    extends MetaMetaCommand.MetaCommandRuntime {
        private static final String SCRIPT_PREFIX = "MetaScriptingCommandRuntime_script";
        private Script compiledScript;
        private ScriptEngine ss;

        public MetaScriptingCommandRuntime() {
            super(MetaMetaScriptingCommand.this);
            try {
                if (MetaMetaScriptingCommand.this.script != null) {
                    TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
                    this.ss = tc.getScriptEngine();
                    this.compiledScript = this.ss.createScript(MetaMetaScriptingCommand.this.script, "MetaScriptingCommandRuntime_script_" + MetaMetaScriptingCommand.this.getId());
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        @Override
        public MetaMetaScriptingCommand getMetaData() {
            return MetaMetaScriptingCommand.this;
        }

        @Override
        public Command newCommand() {
            this.checkState();
            if (this.compiledScript != null) {
                if (this.compiledScript.isInstantiateAs(Command.class)) {
                    return this.compiledScript.createInstanceAs(Command.class, null);
                }
                return new Command(){

                    @Override
                    public String execute(RequestContext request) {
                        ScriptContext sc = MetaScriptingCommandRuntime.this.ss.newScriptContext();
                        sc.setAttribute(MetaMetaScriptingCommand.REQUEST_BINDING_NAME, request);
                        ManagerLocator sl = ManagerLocator.getInstance();
                        sc.setAttribute("em", sl.getManager(EntityManager.class));
                        sc.setAttribute("edm", sl.getManager(EntityDefinitionManager.class));
                        sc.setAttribute("auth", AuthContext.getCurrentContext());
                        Object ret = MetaScriptingCommandRuntime.this.compiledScript.eval(sc);
                        if (ret == null) {
                            return null;
                        }
                        return ret.toString();
                    }
                };
            }
            return null;
        }
    }
}

