/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command;

import org.iplass.mtp.command.Command;
import org.iplass.mtp.command.definition.config.CommandConfig;
import org.iplass.mtp.command.definition.config.SingleCommandConfig;
import org.iplass.mtp.impl.command.CommandService;
import org.iplass.mtp.impl.command.MetaCommand;
import org.iplass.mtp.impl.command.MetaMetaCommand;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaSingleCommand
extends MetaCommand {
    private static final long serialVersionUID = 4170356067972278213L;
    private static Logger logger = LoggerFactory.getLogger(MetaSingleCommand.class);
    private String metaMetaCommandId;

    public String getMetaMetaCommandId() {
        return this.metaMetaCommandId;
    }

    public void setMetaMetaCommandId(String metaMetaCommandId) {
        this.metaMetaCommandId = metaMetaCommandId;
    }

    @Override
    public SingleCommandRuntime createRuntime() {
        return new SingleCommandRuntime(this.metaMetaCommandId);
    }

    @Override
    public void applyConfig(CommandConfig definition) {
        this.fillFrom(definition);
        SingleCommandConfig def = (SingleCommandConfig)definition;
        CommandService service = ServiceRegistry.getRegistry().getService(CommandService.class);
        MetaMetaCommand.MetaCommandRuntime runtime = (MetaMetaCommand.MetaCommandRuntime)service.getRuntimeByName(def.getCommandName());
        this.metaMetaCommandId = runtime.getMetaData().getId();
    }

    @Override
    public SingleCommandConfig currentConfig() {
        SingleCommandConfig definition = new SingleCommandConfig();
        this.fillTo(definition);
        CommandService service = ServiceRegistry.getRegistry().getService(CommandService.class);
        MetaMetaCommand.MetaCommandRuntime runtime = (MetaMetaCommand.MetaCommandRuntime)service.getRuntimeById(this.metaMetaCommandId);
        if (runtime != null) {
            definition.setCommandName(runtime.getMetaData().getName());
        }
        return definition;
    }

    public class SingleCommandRuntime
    extends MetaCommand.CommandRuntime {
        private boolean readOnly;
        private String name;

        public SingleCommandRuntime(String identifer) {
            super(identifer);
        }

        @Override
        protected void initImpl(String identifer) {
            MetaMetaCommand.MetaCommandRuntime mcr = this.getMetaCommandRuntime();
            this.readOnly = mcr.getMetaData().isReadOnly();
            this.name = mcr.getMetaData().getName();
        }

        private MetaMetaCommand.MetaCommandRuntime getMetaCommandRuntime() {
            CommandService service = ServiceRegistry.getRegistry().getService(CommandService.class);
            MetaMetaCommand.MetaCommandRuntime runtime = (MetaMetaCommand.MetaCommandRuntime)service.getRuntimeById(MetaSingleCommand.this.metaMetaCommandId);
            if (runtime == null) {
                throw new NullPointerException("CommandClassId:" + MetaSingleCommand.this.metaMetaCommandId + " Command class not found");
            }
            return runtime;
        }

        @Override
        public MetaSingleCommand getMetaData() {
            return MetaSingleCommand.this;
        }

        @Override
        protected Command newCommand() {
            MetaMetaCommand.MetaCommandRuntime runtime = this.getMetaCommandRuntime();
            Command cmd = runtime.newCommand();
            if (cmd != null) {
                this.initCommand(cmd);
            }
            return cmd;
        }

        private void initCommand(Command cmd) {
            logger.debug("init Command instance:" + String.valueOf(cmd));
            if (this.configScript != null) {
                TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
                ScriptEngine ss = tc.getScriptEngine();
                ScriptContext sc = ss.newScriptContext();
                sc.setAttribute("cmd", cmd);
                this.configScript.eval(sc);
            }
        }

        @Override
        public boolean readOnly() {
            return this.readOnly;
        }

        @Override
        protected boolean newInstancePerRequest() {
            MetaMetaCommand.MetaCommandRuntime runtime = this.getMetaCommandRuntime();
            return runtime.getMetaData().isNewInstancePerRequest();
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

