/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import jakarta.el.ELContext;
import jakarta.el.TypeConverter;
import java.lang.reflect.Array;

public class ArrayTypeConverter
extends TypeConverter {
    public <T> T convertToType(ELContext context, Object obj, Class<T> targetType) {
        if (targetType.isArray() && obj instanceof Object[]) {
            if (targetType.isAssignableFrom(obj.getClass())) {
                context.setPropertyResolved(true);
                return (T)obj;
            }
            Object[] src = (Object[])obj;
            Object converted = Array.newInstance(targetType.getComponentType(), src.length);
            for (int i = 0; i < src.length; ++i) {
                Array.set(converted, i, context.convertToType(src[i], targetType.getComponentType()));
            }
            context.setPropertyResolved(true);
            return (T)converted;
        }
        if (targetType.isArray() && !(obj instanceof Object[])) {
            Object converted = Array.newInstance(targetType.getComponentType(), 1);
            if (targetType.getComponentType().isAssignableFrom(obj.getClass())) {
                Array.set(converted, 0, obj);
            } else {
                Array.set(converted, 0, context.convertToType(obj, targetType.getComponentType()));
            }
            context.setPropertyResolved(true);
            return (T)converted;
        }
        if (!targetType.isArray() && obj instanceof Object[]) {
            Object indexZero = ((Object[])obj)[0];
            if (indexZero == null) {
                context.setPropertyResolved(true);
                return null;
            }
            if (targetType.isAssignableFrom(indexZero.getClass())) {
                context.setPropertyResolved(true);
                return (T)indexZero;
            }
            context.setPropertyResolved(true);
            return (T)context.convertToType(indexZero, targetType);
        }
        return null;
    }
}

