/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import jakarta.el.ELContext;
import jakarta.el.ExpressionFactory;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.ValueExpression;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.function.Consumer;
import org.iplass.mtp.command.beanmapper.MappingError;
import org.iplass.mtp.command.beanmapper.MappingResult;
import org.iplass.mtp.impl.command.beanmapper.Mapper;
import org.iplass.mtp.impl.command.beanmapper.el.BeanMapperELContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ELMapper
implements Mapper {
    private static Logger log = LoggerFactory.getLogger(ELMapper.class);
    private static ExpressionFactory exprFactory = ExpressionFactory.newInstance();
    private boolean trim;
    private boolean emptyToNull;
    private boolean autoGrow;
    private int indexedPropertySizeLimit;
    private Consumer<MappingError> typeConversionErrorHandler;
    private BeanMapperELContext elContext;

    public boolean isTrim() {
        return this.trim;
    }

    @Override
    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean isEmptyToNull() {
        return this.emptyToNull;
    }

    @Override
    public void setEmptyToNull(boolean emptyToNull) {
        this.emptyToNull = emptyToNull;
    }

    public boolean isAutoGrow() {
        return this.autoGrow;
    }

    public int getIndexedPropertySizeLimit() {
        return this.indexedPropertySizeLimit;
    }

    @Override
    public void setIndexedPropertySizeLimit(int indexedPropertySizeLimit) {
        this.indexedPropertySizeLimit = indexedPropertySizeLimit;
    }

    @Override
    public void setTypeConversionErrorHandler(Consumer<MappingError> typeConversionErrorHandler) {
        this.typeConversionErrorHandler = typeConversionErrorHandler;
    }

    @Override
    public void setTargetBean(Object bean) {
        this.elContext = new BeanMapperELContext(bean, this);
    }

    private void checkPropPath(String path) {
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '[' || c == ']' || c == '_' || c == '\'') continue;
            throw new IllegalArgumentException(" not valid property name:" + path);
        }
    }

    @Override
    public Object getValue(String propPath) {
        this.checkPropPath(propPath);
        return this.getValue(this.elContext, propPath);
    }

    @Override
    public void map(Map<String, Object> valueMap, MappingResult result) {
        for (Map.Entry<String, Object> e : valueMap.entrySet()) {
            this.checkPropPath(e.getKey());
            try {
                if (log.isTraceEnabled()) {
                    log.trace("setValue key=" + e.getKey() + ", value=" + String.valueOf(e.getValue()));
                }
                this.setValue(this.elContext, e.getKey(), e.getValue());
            }
            catch (PropertyNotFoundException | PropertyNotWritableException ee) {
                if (!log.isDebugEnabled()) continue;
                log.debug(e.getKey() + " not reachable in target bean: " + ee.toString());
            }
            catch (Exception ee) {
                Class<?> type;
                Object val = e.getValue();
                if (val != null && val.getClass().isArray() && !(type = this.getType(this.elContext, e.getKey())).isArray() && Array.getLength(val) > 0) {
                    val = Array.get(val, 0);
                }
                if (this.typeConversionErrorHandler == null) {
                    result.addError(new MappingError(e.getKey(), "type unmatch", val, (Object)ee));
                    continue;
                }
                MappingError me = new MappingError(e.getKey(), val);
                me.setCause(ee);
                this.typeConversionErrorHandler.accept(me);
                result.addError(me);
            }
        }
    }

    private Object getValue(ELContext elContext, String exp) {
        ValueExpression ve = exprFactory.createValueExpression(elContext, "${R." + exp + "}", Object.class);
        return ve.getValue(elContext);
    }

    private void setValue(ELContext elContext, String exp, Object value) {
        ValueExpression ve = exprFactory.createValueExpression(elContext, "${R." + exp + "}", Object.class);
        if (value instanceof String) {
            if (this.trim) {
                value = ((String)value).trim();
            }
            if (this.emptyToNull && ((String)value).isEmpty()) {
                value = null;
            }
        }
        ve.setValue(elContext, value);
    }

    private Class<?> getType(ELContext elContext, String exp) {
        ValueExpression ve = exprFactory.createValueExpression(elContext, "${R." + exp + "}", Object.class);
        return ve.getType(elContext);
    }

    @Override
    public void setAutoGrow(boolean autoGrow) {
        this.autoGrow = autoGrow;
    }
}

