/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.impl.command.beanmapper.el.BeanMapperELContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;

public class EntityELResolver
extends ELResolver {
    public Object getValue(ELContext context, Object base, Object property) {
        if (!this.checkArgs(context, base, property)) {
            return null;
        }
        Entity entity = (Entity)base;
        EntityContext ec = EntityContext.getCurrentContext();
        EntityHandler eh = ec.getHandlerByName(entity.getDefinitionName());
        if (eh == null) {
            return null;
        }
        String propName = property.toString();
        PropertyHandler ph = eh.getProperty(propName, ec);
        if (ph != null) {
            context.setPropertyResolved(base, property);
            BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
            Object value = entity.getValue(propName);
            if (value == null && bmc.getElMapper().isAutoGrow()) {
                if (ph instanceof ReferencePropertyHandler) {
                    ReferencePropertyHandler rph = (ReferencePropertyHandler)ph;
                    value = rph.getMetaData().getMultiplicity() == 1 ? rph.getReferenceEntityHandler(ec).newInstance() : rph.newArrayInstance(0, ec);
                }
                if (value != null) {
                    entity.setValue(propName, value);
                }
            }
            if (bmc.getElMapper().isAutoGrow() && ph instanceof ReferencePropertyHandler) {
                bmc.setPropertyRef(base, (ReferencePropertyHandler)ph, value);
            }
            return value;
        }
        throw new PropertyNotFoundException("Entity:" + entity.getDefinitionName() + " property:" + propName + " not defined.");
    }

    private boolean checkArgs(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        if (!(base instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)base;
        return entity.getDefinitionName() != null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (!this.checkArgs(context, base, property)) {
            return null;
        }
        Entity entity = (Entity)base;
        EntityContext ec = EntityContext.getCurrentContext();
        EntityHandler eh = ec.getHandlerByName(entity.getDefinitionName());
        if (eh == null) {
            return null;
        }
        String propName = property.toString();
        PropertyHandler ph = eh.getProperty(propName, ec);
        if (ph != null) {
            context.setPropertyResolved(base, property);
            Class<?> t = ph.getEnumType().getJavaType();
            if (ph.getMetaData().getMultiplicity() != 1) {
                t = Array.newInstance(t, 0).getClass();
            }
            return t;
        }
        throw new PropertyNotFoundException("Entity:" + entity.getDefinitionName() + " property:" + propName + " not defined.");
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (!this.checkArgs(context, base, property)) {
            return;
        }
        Entity entity = (Entity)base;
        EntityContext ec = EntityContext.getCurrentContext();
        EntityHandler eh = ec.getHandlerByName(entity.getDefinitionName());
        if (eh == null) {
            return;
        }
        String propName = property.toString();
        PropertyHandler ph = eh.getProperty(propName, ec);
        if (ph == null) {
            throw new PropertyNotFoundException("Entity:" + entity.getDefinitionName() + " property:" + propName + " not defined.");
        }
        entity.setValue(propName, value);
        context.setPropertyResolved(base, property);
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }
}

