/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Array;
import java.util.Iterator;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.impl.command.beanmapper.el.BeanMapperELContext;
import org.iplass.mtp.impl.command.beanmapper.el.PropertyInfo;
import org.iplass.mtp.impl.command.beanmapper.el.PropertyRef;
import org.iplass.mtp.impl.entity.EntityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedArrayELResolver
extends ELResolver {
    private static Logger log = LoggerFactory.getLogger(ExtendedArrayELResolver.class);

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base.getClass().isArray()) {
            context.setPropertyResolved(base, property);
            BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
            int index = this.toInt(property);
            int arrayLength = Array.getLength(base);
            if (this.isInvalidIndex(index, arrayLength, bmc)) {
                return null;
            }
            try {
                Object value;
                PropertyRef pr = null;
                if (bmc.getElMapper().isAutoGrow()) {
                    pr = bmc.getPropertyRef(base);
                    if (index >= arrayLength && (pr.getComponentTypeKind() == PropertyInfo.TypeKind.BEAN || pr.getComponentTypeKind() == PropertyInfo.TypeKind.ENTITY)) {
                        Object newArray = Array.newInstance(base.getClass().getComponentType(), index + 1);
                        System.arraycopy(base, 0, newArray, 0, arrayLength);
                        bmc.replacePropertyRef(base, newArray);
                        base = newArray;
                    }
                }
                if ((value = Array.get(base, index)) == null && bmc.getElMapper().isAutoGrow()) {
                    switch (pr.getComponentTypeKind()) {
                        case BEAN: {
                            value = pr.getPropertyInfo().getComponentType().newInstance();
                            break;
                        }
                        case ENTITY: {
                            if (pr.getReferencePropertyHandler() != null) {
                                value = pr.getReferencePropertyHandler().getReferenceEntityHandler(EntityContext.getCurrentContext()).newInstance();
                                break;
                            }
                            if (pr.getPropertyInfo().getComponentType().isInterface()) {
                                value = new GenericEntity();
                                break;
                            }
                            value = pr.getPropertyInfo().getComponentType().newInstance();
                            break;
                        }
                        case ARRAY: 
                        case LIST: 
                        case MAP: {
                            if (log.isDebugEnabled()) {
                                log.debug("Nested collection auto grow not supported.");
                            }
                        }
                        case SIMPLE: {
                            break;
                        }
                    }
                    if (value != null) {
                        Array.set(base, index, value);
                    }
                }
                return value;
            }
            catch (ELException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ELException((Throwable)e);
            }
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base.getClass().isArray()) {
            context.setPropertyResolved(true);
            BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
            int index = this.toInt(property);
            if (this.isInvalidIndex(index, Array.getLength(base), bmc)) {
                throw new PropertyNotFoundException();
            }
            return base.getClass().getComponentType();
        }
        return null;
    }

    private int toInt(Object p) {
        if (p instanceof Number) {
            return ((Number)p).intValue();
        }
        if (p instanceof Character) {
            return ((Character)p).charValue();
        }
        if (p instanceof Boolean) {
            return (Boolean)p != false ? 1 : 0;
        }
        if (p instanceof String) {
            return Integer.parseInt((String)p);
        }
        throw new IllegalArgumentException();
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base.getClass().isArray()) {
            context.setPropertyResolved(base, property);
            int index = this.toInt(property);
            int arrayLength = Array.getLength(base);
            BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
            try {
                if (bmc.getElMapper().isAutoGrow() && index < bmc.getElMapper().getIndexedPropertySizeLimit() && index >= arrayLength) {
                    Object newArray = Array.newInstance(base.getClass().getComponentType(), index + 1);
                    System.arraycopy(base, 0, newArray, 0, arrayLength);
                    bmc.replacePropertyRef(base, newArray);
                    base = newArray;
                    arrayLength = index + 1;
                }
            }
            catch (ELException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ELException((Throwable)e);
            }
            if (index < 0 || index >= arrayLength) {
                throw new PropertyNotFoundException();
            }
            if (value instanceof String) {
                if (bmc.getElMapper().isTrim()) {
                    value = ((String)value).trim();
                }
                if (bmc.getElMapper().isEmptyToNull() && ((String)value).isEmpty()) {
                    value = null;
                }
            }
            Array.set(base, index, value);
        }
    }

    private boolean isInvalidIndex(int index, int arrayLength, BeanMapperELContext bmc) {
        return index < 0 || !bmc.getElMapper().isAutoGrow() && index >= arrayLength || bmc.getElMapper().isAutoGrow() && index >= bmc.getElMapper().getIndexedPropertySizeLimit();
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base.getClass().isArray()) {
            context.setPropertyResolved(true);
            int index = this.toInt(property);
            BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
            if (this.isInvalidIndex(index, Array.getLength(base), bmc)) {
                throw new PropertyNotFoundException();
            }
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null && base.getClass().isArray()) {
            return Integer.class;
        }
        return null;
    }
}

