/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.impl.command.beanmapper.el.BeanMapperELContext;
import org.iplass.mtp.impl.command.beanmapper.el.PropertyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedMapELResolver
extends ELResolver {
    private static Logger log = LoggerFactory.getLogger(ExtendedMapELResolver.class);
    private static Class<?> unmodifiableMapClass = Collections.unmodifiableMap(new HashMap()).getClass();

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof Map) {
            BeanMapperELContext bmc;
            context.setPropertyResolved(base, property);
            Map map = (Map)base;
            Object value = map.get(property);
            if (value == null && (bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class))).getElMapper().isAutoGrow()) {
                PropertyInfo pi = bmc.getPropertyRef(map).getPropertyInfo();
                try {
                    switch (pi.getComponentTypeKind()) {
                        case BEAN: {
                            value = pi.getComponentType().newInstance();
                            break;
                        }
                        case ENTITY: {
                            if (pi.getComponentType().isInterface()) {
                                value = new GenericEntity();
                                break;
                            }
                            value = pi.getComponentType().newInstance();
                            break;
                        }
                        case ARRAY: 
                        case LIST: 
                        case MAP: {
                            if (log.isDebugEnabled()) {
                                log.debug("Nested collection auto grow not supported.");
                            }
                        }
                        case SIMPLE: {
                            break;
                        }
                    }
                }
                catch (ELException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ELException((Throwable)e);
                }
                if (value != null) {
                    map.put(property, value);
                }
            }
            return value;
        }
        return null;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof Map) {
            context.setPropertyResolved(true);
            return Object.class;
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof Map) {
            context.setPropertyResolved(base, property);
            Map map = (Map)base;
            if (map.getClass() == unmodifiableMapClass) {
                throw new PropertyNotWritableException();
            }
            try {
                if (value instanceof String) {
                    BeanMapperELContext bmc = (BeanMapperELContext)((Object)context.getContext(BeanMapperELContext.class));
                    if (bmc.getElMapper().isTrim()) {
                        value = ((String)value).trim();
                    }
                    if (bmc.getElMapper().isEmptyToNull() && ((String)value).isEmpty()) {
                        value = null;
                    }
                }
                map.put(property, value);
            }
            catch (UnsupportedOperationException e) {
                throw new PropertyNotWritableException();
            }
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base != null && base instanceof Map) {
            context.setPropertyResolved(true);
            return base.getClass() == unmodifiableMapClass;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base != null && base instanceof Map) {
            Map map = (Map)base;
            Iterator iter = map.keySet().iterator();
            ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>();
            while (iter.hasNext()) {
                Object key = iter.next();
                FeatureDescriptor descriptor = new FeatureDescriptor();
                String name = key == null ? null : key.toString();
                descriptor.setName(name);
                descriptor.setDisplayName(name);
                descriptor.setShortDescription("");
                descriptor.setExpert(false);
                descriptor.setHidden(false);
                descriptor.setPreferred(true);
                if (key != null) {
                    descriptor.setValue("type", key.getClass());
                }
                descriptor.setValue("resolvableAtDesignTime", Boolean.TRUE);
                list.add(descriptor);
            }
            return list.iterator();
        }
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base != null && base instanceof Map) {
            return Object.class;
        }
        return null;
    }
}

