/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import jakarta.el.ELContext;
import jakarta.el.TypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import org.iplass.mtp.impl.core.ExecuteContext;

public class NumberTypeConverter
extends TypeConverter {
    public <T> T convertToType(ELContext context, Object obj, Class<T> targetType) {
        if (obj instanceof String && this.isNumber(targetType)) {
            if ("".equals(obj)) {
                return null;
            }
            context.setPropertyResolved(true);
            try {
                return (T)this.toNumber((String)obj, targetType);
            }
            catch (RuntimeException e) {
                DecimalFormatSymbols dfs = DecimalFormatSymbols.getInstance(ExecuteContext.getCurrentContext().getLocale());
                if (this.hasCamma((String)obj, dfs)) {
                    try {
                        return (T)this.toNumber(this.trimCamma((String)obj, dfs), targetType);
                    }
                    catch (Exception ee) {
                        e.addSuppressed(ee);
                    }
                }
                throw e;
            }
        }
        return null;
    }

    private boolean isNumber(Class<?> type) {
        return type == Long.TYPE || type == Integer.TYPE || type == Double.TYPE || Number.class.isAssignableFrom(type) || type == Short.TYPE || type == Byte.TYPE || type == Float.TYPE;
    }

    private boolean hasCamma(String val, DecimalFormatSymbols dfs) {
        char camma = dfs.getGroupingSeparator();
        return val.indexOf(camma) != -1;
    }

    private String trimCamma(String val, DecimalFormatSymbols dfs) {
        char camma = dfs.getGroupingSeparator();
        StringBuilder sb = new StringBuilder(val.length());
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            if (c == camma) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    private Number toNumber(String val, Class<?> type) throws IllegalArgumentException {
        if (Long.TYPE == type || Long.class.equals(type)) {
            return Long.valueOf(val);
        }
        if (Integer.TYPE == type || Integer.class.equals(type)) {
            return Integer.valueOf(val);
        }
        if (Double.TYPE == type || Double.class.equals(type)) {
            return Double.valueOf(val);
        }
        if (BigDecimal.class.equals(type)) {
            return new BigDecimal(val);
        }
        if (BigInteger.class.equals(type)) {
            return new BigInteger(val);
        }
        if (Byte.TYPE == type || Byte.class.equals(type)) {
            return Byte.valueOf(val);
        }
        if (Short.TYPE == type || Short.class.equals(type)) {
            return Short.valueOf(val);
        }
        if (Float.TYPE == type || Float.class.equals(type)) {
            return Float.valueOf(val);
        }
        throw new IllegalArgumentException("Can not parse to " + type.getName() + ":" + val);
    }
}

