/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import jakarta.el.ELContext;
import jakarta.el.TypeConverter;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.LocaleFormat;
import org.iplass.mtp.util.DateUtil;

public class SqlDateConverter
extends TypeConverter {
    public <T> T convertToType(ELContext context, Object obj, Class<T> targetType) {
        if (Date.class == targetType && obj instanceof String) {
            context.setPropertyResolved(true);
            return (T)this.conv(obj);
        }
        return null;
    }

    private Date toDate(String exp, DateFormat sdf) {
        try {
            sdf.setLenient(false);
            return new Date(sdf.parse(exp).getTime());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    Date conv(Object obj) {
        if (obj instanceof String) {
            String exp = ((String)obj).trim();
            if ("".equals(exp)) {
                return null;
            }
            ExecuteContext ec = ExecuteContext.getCurrentContext();
            LocaleFormat lf = ec.getLocaleFormat();
            Date d = this.toDate(exp, DateUtil.getSimpleDateFormat(lf.getServerDateFormat(), false));
            if (d == null) {
                d = this.toDate(exp, DateUtil.getDateInstance(2, false));
            }
            if (d == null) {
                d = this.toDate(exp, DateUtil.getSimpleDateFormat("yyyy-MM-dd", false));
            }
            if (d == null) {
                d = this.toDate(exp, DateUtil.getSimpleDateFormat("yyyyMMdd", false));
            }
            if (d == null) {
                d = this.toDate(exp, DateUtil.getSimpleDateFormat(lf.getOutputDateFormat(), false));
            }
            if (d == null) {
                d = this.toDate(exp, DateUtil.getSimpleDateFormat(lf.getExcelDateFormat(), false));
            }
            if (d == null) {
                throw new IllegalArgumentException("Can't convert to Date:" + String.valueOf(obj));
            }
            return d;
        }
        return null;
    }
}

