/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.command.beanmapper.el;

import jakarta.el.ELContext;
import jakarta.el.TypeConverter;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.i18n.LocaleFormat;
import org.iplass.mtp.util.DateUtil;

public class TimeConverter
extends TypeConverter {
    public <T> T convertToType(ELContext context, Object obj, Class<T> targetType) {
        if (Time.class == targetType && obj instanceof String) {
            context.setPropertyResolved(true);
            return (T)this.conv(obj);
        }
        return null;
    }

    private Time toTime(String exp, DateFormat sdf) {
        try {
            sdf.setLenient(false);
            return new Time(sdf.parse(exp).getTime());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private Time conv(Object obj) {
        if (obj instanceof String) {
            String exp = ((String)obj).trim();
            if ("".equals(exp)) {
                return null;
            }
            Time t = null;
            try {
                t = Time.valueOf(exp);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (t == null) {
                ExecuteContext ec = ExecuteContext.getCurrentContext();
                LocaleFormat lf = ec.getLocaleFormat();
                t = this.toTime(exp, DateUtil.getSimpleDateFormat(lf.getServerTimeFormat(), false));
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getTimeInstance(2, false));
                }
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getSimpleDateFormat("HH:mm:ss.SSS", false));
                }
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getSimpleDateFormat("HHmmssSSS", false));
                }
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getSimpleDateFormat("HHmmss", false));
                }
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getSimpleDateFormat(ExecuteContext.getCurrentContext().getLocaleFormat().getOutputTimeSecFormat(), false));
                }
                if (t == null) {
                    t = this.toTime(exp, DateUtil.getSimpleDateFormat(lf.getExcelTimeFormat(), true));
                }
            }
            if (t == null) {
                throw new IllegalArgumentException("Can't convert to Time:" + String.valueOf(obj));
            }
            return t;
        }
        return null;
    }
}

