/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core;

import java.util.HashMap;
import org.iplass.mtp.impl.core.Executable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.core.TenantResource;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptService;
import org.iplass.mtp.impl.tenant.MetaTenant;
import org.iplass.mtp.impl.tenant.MetaTenantService;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.Tenant;

public class TenantContext {
    private static MetaTenantService mtService = ServiceRegistry.getRegistry().getService(MetaTenantService.class);
    private final Tenant baseTenantInfo;
    private final String tenantIdString;
    private final boolean isNoMeta;
    private final ScriptEngine scriptEngine;
    private final MetaDataContext metaDataContext;
    private HashMap<Class<?>, TenantResource> resourceMap;

    public TenantContext(int tenantId, String tenantName, String tenantUrl, boolean isNoMeta) {
        this(new Tenant(tenantId, tenantName, tenantUrl), isNoMeta);
    }

    TenantContext(int tenantId) {
        Tenant t = new Tenant();
        t.setId(tenantId);
        t.setName("___dummy");
        t.setUrl("___dummy");
        this.tenantIdString = String.valueOf(tenantId);
        this.baseTenantInfo = t;
        this.isNoMeta = true;
        this.scriptEngine = null;
        this.metaDataContext = null;
    }

    public TenantContext(Tenant tenant, boolean isNoMeta) {
        this.isNoMeta = isNoMeta;
        this.baseTenantInfo = tenant;
        this.tenantIdString = String.valueOf(tenant.getId());
        this.scriptEngine = ServiceRegistry.getRegistry().getService(ScriptService.class).createScriptEngine();
        this.metaDataContext = new MetaDataContext(this.baseTenantInfo.getId());
        this.initResource();
    }

    private void initResource() {
        this.resourceMap = new HashMap();
        TenantContextService tcService = ServiceRegistry.getRegistry().getService(TenantContextService.class);
        for (Class<?> trClass : tcService.getTenantResourceClasses()) {
            try {
                TenantResource tr = (TenantResource)trClass.newInstance();
                tr.init(this);
                this.resourceMap.put(trClass, tr);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ServiceConfigrationException(trClass.getName() + " can't instanceate.");
            }
        }
    }

    public <T extends TenantResource> T getResource(Class<T> resourceClass) {
        return (T)this.resourceMap.get(resourceClass);
    }

    public int getTenantId() {
        return this.baseTenantInfo.getId();
    }

    public String getTenantIdString() {
        return this.tenantIdString;
    }

    public String getTenantName() {
        return this.baseTenantInfo.getName();
    }

    public ScriptEngine getScriptEngine() {
        return this.scriptEngine;
    }

    public MetaDataContext getMetaDataContext() {
        return this.metaDataContext;
    }

    public String getTenantUrl() {
        return this.baseTenantInfo.getUrl();
    }

    public MetaTenant.MetaTenantHandler getTenantRuntime() {
        MetaTenant.MetaTenantHandler tr = mtService.getRuntimeByName(this.baseTenantInfo.getName());
        if (tr == null) {
            tr = new MetaTenant().createRuntime(null);
        }
        return tr;
    }

    public Tenant loadTenantInfo() {
        if (this.isNoMeta) {
            return ObjectUtil.deepCopy(this.baseTenantInfo);
        }
        return ExecuteContext.executeAs(this, new Executable<Tenant>(){

            @Override
            public Tenant execute() {
                Tenant copy = ObjectUtil.deepCopy(TenantContext.this.baseTenantInfo);
                MetaTenant.MetaTenantHandler handler = ServiceRegistry.getRegistry().getService(MetaTenantService.class).getRuntimeByName(copy.getName());
                if (handler != null) {
                    handler.applyMetaDataToTenant(copy);
                }
                return copy;
            }
        });
    }

    public void invalidate() {
        if (this.resourceMap != null) {
            for (TenantResource r : this.resourceMap.values()) {
                r.destory();
            }
        }
        this.scriptEngine.invalidate();
        this.metaDataContext.invalidate();
    }
}

