/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.core.config.DecodePreprocessor;
import org.iplass.mtp.impl.core.config.FileUtil;
import org.iplass.mtp.impl.core.config.GroovyPreprocessor;
import org.iplass.mtp.impl.core.config.LocalResourceConfigLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BootstrapProps {
    public static final String SERVER_ENV_PROP_FILE_NAME = "mtp.server.env";
    public static final String SERVER_ROLES = "mtp.server.myserverroles";
    public static final String SERVER_ID = "mtp.server.myserverid";
    public static final String SERVER_NAME = "mtp.server.myservername";
    public static final String NETWORK_INTERFACE_NAME = "mtp.server.myinterfacename";
    public static final String CONFIG_FILE_NAME = "mtp.config";
    public static final String CONFIG_LOADER_CLASS_NAME = "mtp.config.loader";
    public static final String CONFIG_PREPROCESSORS_CLASS_NAME = "mtp.config.preprocessors";
    public static final String CRYPT_CONFIG_FILE_NAME = "mtp.config.crypt";
    public static final String DEFAULT_CONFIG_FILE_NAME = "/mtp-service-config.xml";
    public static final String DEFAULT_CONFIG_PREPROCESSORS_CLASS_NAME = GroovyPreprocessor.class.getName() + "," + DecodePreprocessor.class.getName();
    public static final String DEFAULT_CONFIG_LOADER_CLASS_NAME = LocalResourceConfigLoader.class.getName();
    private static Logger logger = LoggerFactory.getLogger(BootstrapProps.class);
    private static volatile BootstrapProps bootstrapProps;
    private final Map<String, String> props;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public static BootstrapProps getInstance() {
        if (bootstrapProps == null) {
            BootstrapProps.init(null);
        }
        return bootstrapProps;
    }

    public static synchronized boolean init(Map<String, String> props) {
        if (bootstrapProps != null) {
            return false;
        }
        bootstrapProps = new BootstrapProps(props);
        return true;
    }

    private BootstrapProps(Map<String, String> initProps) {
        String serverEnvPropsFileName = null;
        if (initProps != null) {
            serverEnvPropsFileName = initProps.get(SERVER_ENV_PROP_FILE_NAME);
        }
        if (serverEnvPropsFileName == null) {
            serverEnvPropsFileName = System.getProperty(SERVER_ENV_PROP_FILE_NAME);
        }
        if (serverEnvPropsFileName != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("load bootstrap props from file:" + serverEnvPropsFileName);
            }
            try {
                String content = FileUtil.readContent(serverEnvPropsFileName);
                if (content == null) {
                    throw new SystemException("Can't find bootstrap props file:" + serverEnvPropsFileName);
                }
                Properties p = new Properties();
                p.load(new StringReader(content));
                this.props = new HashMap<Object, Object>(p);
            }
            catch (IOException e) {
                throw new SystemException("Can't read bootstrap props file:" + serverEnvPropsFileName, e);
            }
        } else {
            this.props = new HashMap<Object, Object>(System.getProperties());
            if (initProps != null) {
                this.props.putAll(initProps);
            }
        }
    }

    public String getProperty(String key) {
        try {
            this.lock.readLock().lock();
            String string = this.props.get(key);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String getProperty(String key, String defaultValue) {
        String ret = this.getProperty(key);
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    public void setProperty(String key, String value) {
        try {
            this.lock.writeLock().lock();
            this.props.put(key, value);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceProperty(String key, String value) {
        try {
            this.lock.writeLock().lock();
            String oldVal = this.props.get(key);
            if (!value.equals(oldVal)) {
                logger.debug("replace " + key + " from " + oldVal + " to " + value);
                this.props.put(key, value);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

