/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.iplass.mtp.impl.core.config.PassphraseSupplier;
import org.iplass.mtp.impl.core.config.PropertyFilePassphraseSupplier;
import org.iplass.mtp.impl.core.config.PropertyValueCoder;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class DefaultPropertyValueCoder
implements PropertyValueCoder {
    public static final String PASSPHRASE_SUPPLIER = "passphraseSupplier";
    public static final String KEY_SALT = "keySalt";
    public static final String KEY_STRETCH = "keyStretch";
    public static final String KEY_ALGORITHM = "keyFactoryAlgorithm";
    public static final String KEY_LENGTH = "keyLength";
    public static final String CIPHER_ALGORITHM = "cipherAlgorithm";
    public static final String DEFAULT_KEY_ALGORITHM = "PBKDF2WithHmacSHA256";
    public static final int DEFAULT_KEY_LENGTH = 128;
    public static final String DEFAULT_CIPHER_ALGORITHM = "AES";
    public static final int DEFAULT_STRETCH = 2048;
    private String charset = "utf-8";
    private Cipher cipher;
    private SecretKeySpec keySpec;

    @Override
    public void open(Properties prop) {
        try {
            String passphraseSupplierName = prop.getProperty(PASSPHRASE_SUPPLIER, PropertyFilePassphraseSupplier.class.getName());
            try (PassphraseSupplier passphraseSupplier = (PassphraseSupplier)Class.forName(passphraseSupplierName).newInstance();){
                int stretch;
                String cipherAlg;
                int keyLength;
                String keyAlg = prop.getProperty(KEY_ALGORITHM);
                if (keyAlg == null) {
                    keyAlg = DEFAULT_KEY_ALGORITHM;
                }
                if ((keyLength = this.toInt(prop.getProperty(KEY_LENGTH))) < 0) {
                    keyLength = 128;
                }
                if ((cipherAlg = prop.getProperty(CIPHER_ALGORITHM)) == null) {
                    cipherAlg = DEFAULT_CIPHER_ALGORITHM;
                }
                String keySalt = prop.getProperty(KEY_SALT);
                byte[] salt = null;
                if (keySalt != null) {
                    salt = MessageDigest.getInstance("SHA-256").digest(keySalt.getBytes("utf-8"));
                }
                if (salt == null) {
                    salt = new byte[]{-11, 29, 33, 61, -16, 40, 37, 109};
                }
                if ((stretch = this.toInt(prop.getProperty(KEY_STRETCH))) < 0) {
                    stretch = 2048;
                }
                passphraseSupplier.open(prop);
                char[] passphrase = passphraseSupplier.getPassphrase();
                PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase, salt, stretch, keyLength);
                try {
                    SecretKey secKey = SecretKeyFactory.getInstance(keyAlg).generateSecret(pbeKeySpec);
                    Arrays.fill(passphrase, '\u0000');
                    this.keySpec = new SecretKeySpec(secKey.getEncoded(), cipherAlg);
                    this.cipher = Cipher.getInstance(cipherAlg + "/CBC/PKCS5Padding");
                }
                catch (InvalidKeySpecException e) {
                    throw new ServiceConfigrationException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ServiceConfigrationException(e);
                }
                catch (NoSuchPaddingException e) {
                    throw new ServiceConfigrationException(e);
                }
                Arrays.fill(salt, (byte)0);
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchAlgorithmException e) {
            throw new ServiceConfigrationException(e);
        }
    }

    private int toInt(String val) {
        if (val == null) {
            return -1;
        }
        return Integer.parseInt(val);
    }

    @Override
    public String encode(String plain) {
        try {
            this.cipher.init(1, this.keySpec);
            byte[] enc = this.cipher.doFinal(plain.getBytes(this.charset));
            byte[] iv = this.cipher.getIV();
            byte[] ivAndEnc = new byte[iv.length + enc.length];
            System.arraycopy(iv, 0, ivAndEnc, 0, iv.length);
            System.arraycopy(enc, 0, ivAndEnc, iv.length, enc.length);
            return Base64.encodeBase64String((byte[])ivAndEnc);
        }
        catch (InvalidKeyException e) {
            throw new ServiceConfigrationException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ServiceConfigrationException(e);
        }
        catch (BadPaddingException e) {
            throw new ServiceConfigrationException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceConfigrationException(e);
        }
    }

    @Override
    public String decode(String encoded) {
        try {
            byte[] ivAndEnc = Base64.decodeBase64((String)encoded);
            int blockSize = this.cipher.getBlockSize();
            byte[] iv = new byte[blockSize];
            System.arraycopy(ivAndEnc, 0, iv, 0, blockSize);
            this.cipher.init(2, (Key)this.keySpec, new IvParameterSpec(iv));
            return new String(this.cipher.doFinal(ivAndEnc, blockSize, ivAndEnc.length - blockSize), this.charset);
        }
        catch (InvalidKeyException e) {
            throw new ServiceConfigrationException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ServiceConfigrationException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new ServiceConfigrationException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ServiceConfigrationException(e);
        }
        catch (BadPaddingException e) {
            throw new ServiceConfigrationException(e);
        }
    }

    @Override
    public void clear() {
        this.cipher = null;
        this.keySpec = null;
    }
}

