/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileUtil {
    private static Logger logger = LoggerFactory.getLogger(FileUtil.class);

    FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readContent(String fileName) throws IOException {
        InputStream is = null;
        try {
            File file;
            block20: {
                is = FileUtil.class.getResourceAsStream(fileName);
                if (is != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("File:" + fileName + " found from classpath(classloader).");
                    }
                } else {
                    file = new File(fileName);
                    if (file.exists()) {
                        try {
                            is = new FileInputStream(file);
                            if (logger.isDebugEnabled()) {
                                logger.debug("File:" + fileName + " found from OS file system.");
                            }
                        }
                        catch (FileNotFoundException e) {
                            if (!logger.isDebugEnabled()) break block20;
                            logger.debug("File:" + fileName + " not found.", (Throwable)e);
                        }
                    }
                }
            }
            if (is == null) {
                file = null;
                return file;
            }
            InputStreamReader r = new InputStreamReader(is, "utf-8");
            StringBuffer str = new StringBuffer();
            char[] buf = new char[1024];
            int length = 0;
            while ((length = r.read(buf)) != -1) {
                str.append(buf, 0, length);
            }
            String string = str.toString();
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.warn("resource close failed. Maybe Resource Leak.", (Throwable)e);
                }
            }
        }
    }
}

