/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.iplass.mtp.impl.core.config.BootstrapProps;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class ServerEnv {
    @Deprecated
    public static final String SERVER_ROLE_DEF_SYSTEM_PROP_NAME = "mtp.server.myserverroles";
    @Deprecated
    public static final String SERVER_ID_DEF_SYSTEM_PROP_NAME = "mtp.server.myserverid";
    @Deprecated
    public static final String SERVER_NAME_DEF_SYSTEM_PROP_NAME = "mtp.server.myservername";
    @Deprecated
    public static final String INTERFACE_NAME_DEF_SYSTEM_PROP_NAME = "mtp.server.myinterfacename";
    private static ServerEnv instance = new ServerEnv();
    private String[] serverRoles;
    private String serverId;
    private BootstrapProps props = BootstrapProps.getInstance();

    public static ServerEnv getInstance() {
        return instance;
    }

    private ServerEnv() {
        String id;
        String myserverroles = this.props.getProperty(SERVER_ROLE_DEF_SYSTEM_PROP_NAME);
        if (myserverroles != null) {
            this.serverRoles = myserverroles.trim().split("\\s*,\\s*");
        }
        if ((id = this.props.getProperty(SERVER_ID_DEF_SYSTEM_PROP_NAME)) == null) {
            try {
                id = this.getServerNameAndAddress()[0];
            }
            catch (SocketException e) {
                throw new IllegalStateException(e);
            }
        }
        this.serverId = id;
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public String getProperty(String key, String def) {
        return this.props.getProperty(key, def);
    }

    public String[] getServerRoles() {
        return this.serverRoles;
    }

    public String getServerId() {
        return this.serverId;
    }

    public String[] getServerNameAndAddress() throws SocketException {
        Enumeration<InetAddress> addresses;
        String defHostName = this.props.getProperty(SERVER_NAME_DEF_SYSTEM_PROP_NAME);
        if (defHostName != null) {
            return new String[]{defHostName};
        }
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        String networkInterfaceName = this.props.getProperty(INTERFACE_NAME_DEF_SYSTEM_PROP_NAME);
        NetworkInterface ni = null;
        NetworkInterface loopBack = null;
        if (networkInterfaceName != null) {
            ni = NetworkInterface.getByName(networkInterfaceName);
            if (ni == null) {
                throw new ServiceConfigrationException("networkInterfaceName:" + networkInterfaceName + " not found...");
            }
        } else {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface forCheck = e.nextElement();
                if (forCheck.isLoopback()) {
                    loopBack = forCheck;
                    continue;
                }
                if (!forCheck.isUp()) continue;
                ni = forCheck;
                break;
            }
        }
        if (ni != null) {
            addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                this.addHostNameAndAddress(list, addresses.nextElement());
            }
        }
        if (loopBack != null) {
            addresses = loopBack.getInetAddresses();
            while (addresses.hasMoreElements()) {
                this.addHostNameAndAddress(list, addresses.nextElement());
            }
        }
        if (list.isEmpty()) {
            try {
                this.addHostNameAndAddress(list, InetAddress.getLocalHost());
                this.addHostNameAndAddress(list, InetAddress.getLoopbackAddress());
            }
            catch (UnknownHostException e) {
                throw new ServiceConfigrationException("Unable to retrieve localhost. ", e);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private void addHostNameAndAddress(Set<String> list, InetAddress ia) {
        String hostName = ia.getHostName();
        if (ia.isLoopbackAddress()) {
            list.add("localhost");
            list.add(ia.getHostAddress());
        } else {
            list.add(hostName);
            String address = ia.getHostAddress();
            if (hostName.contains(".") && !address.equals(hostName)) {
                list.add(hostName.substring(0, hostName.indexOf(46)));
            }
            list.add(address);
        }
    }
}

