/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.Arrays;
import org.iplass.mtp.impl.core.config.ServiceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
public class ServiceDefinition {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDefinition.class);
    private String[] inherits;
    private String[] includes;
    private ServiceConfig[] service;

    public ServiceConfig[] getService() {
        return this.service;
    }

    public void setService(ServiceConfig[] service) {
        this.service = service;
    }

    public String[] getInherits() {
        return this.inherits;
    }

    public void setInherits(String[] inherits) {
        this.inherits = inherits;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public ServiceConfig search(String name) {
        if (this.service != null) {
            for (ServiceConfig sc : this.service) {
                if (!name.equals(sc.id())) continue;
                return sc;
            }
        }
        return null;
    }

    private ServiceConfig pull(ArrayList<ServiceConfig> myConfig, String id) {
        if (myConfig.size() != 0) {
            for (ServiceConfig sc : myConfig) {
                if (!id.equals(sc.id())) continue;
                myConfig.remove(sc);
                return sc;
            }
        }
        return null;
    }

    public void include(ServiceDefinition mixinDefinition) {
        ArrayList<Object> mixinConfig = mixinDefinition.service == null ? new ArrayList() : new ArrayList<ServiceConfig>(Arrays.asList(mixinDefinition.service));
        ArrayList<Object> newList = new ArrayList<Object>();
        if (this.service != null) {
            for (ServiceConfig sc : this.service) {
                ServiceConfig override = this.pull(mixinConfig, sc.id());
                if (override != null) {
                    if (sc.isFinal()) {
                        logger.warn(sc.id() + " is declared Final, so can not include configration.");
                        newList.add(sc);
                        continue;
                    }
                    if (!override.isIfnone()) {
                        if (override.isInherit()) {
                            if (logger.isTraceEnabled()) {
                                logger.trace(sc.id() + " is include and inherit current definition.");
                            }
                            newList.add(override.merge(sc));
                            continue;
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace(sc.id() + " is replaced by included definition.");
                        }
                        newList.add(override);
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace(sc.id() + " is exists and including config declared ifnone. so can not include configration.");
                    }
                    newList.add(sc);
                    continue;
                }
                newList.add(sc);
            }
        }
        if (mixinConfig.size() != 0) {
            newList.addAll(mixinConfig);
        }
        this.service = newList.toArray(new ServiceConfig[newList.size()]);
    }

    public void inherit(ServiceDefinition superDefinition) {
        ArrayList<Object> myConfig = this.service == null ? new ArrayList() : new ArrayList<ServiceConfig>(Arrays.asList(this.service));
        ArrayList<Object> newList = new ArrayList<Object>();
        if (superDefinition.getService() != null) {
            for (ServiceConfig sc : superDefinition.getService()) {
                ServiceConfig override = this.pull(myConfig, sc.id());
                if (override != null) {
                    if (sc.isFinal()) {
                        logger.warn(sc.id() + " is declared Final, so can not override configration.");
                        newList.add(sc);
                        continue;
                    }
                    if (!override.isIfnone()) {
                        if (override.isInherit()) {
                            if (logger.isTraceEnabled()) {
                                logger.trace(sc.id() + " is override parents definition.");
                            }
                            newList.add(override.merge(sc));
                            continue;
                        }
                        if (logger.isTraceEnabled()) {
                            logger.trace(sc.id() + " is replace parents definition.");
                        }
                        newList.add(override);
                        continue;
                    }
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace(sc.id() + " is exists in parents definition and this config declared ifnone. so can not override configration.");
                    continue;
                }
                newList.add(sc);
            }
        }
        if (myConfig.size() != 0) {
            newList.addAll(myConfig);
        }
        this.service = newList.toArray(new ServiceConfig[newList.size()]);
    }
}

