/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.iplass.mtp.impl.core.config.BootstrapProps;
import org.iplass.mtp.impl.core.config.ConfigLoader;
import org.iplass.mtp.impl.core.config.ConfigPreprocessor;
import org.iplass.mtp.impl.core.config.NameValue;
import org.iplass.mtp.impl.core.config.ServiceConfig;
import org.iplass.mtp.impl.core.config.ServiceDefinition;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDefinitionParser {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDefinitionParser.class);
    private JAXBContext context;
    private ConfigLoader loader;
    private ConfigPreprocessor[] prepros;

    public ServiceDefinitionParser() {
        try {
            this.context = JAXBContext.newInstance((Class[])new Class[]{NameValue.class, ServiceConfig.class, ServiceDefinition.class});
        }
        catch (JAXBException e) {
            logger.error("JAXBContext can not initialize.", (Throwable)e);
            throw new ServiceConfigrationException(e);
        }
        this.loader = this.newConfigLoader();
        this.prepros = this.newConfigPreprocessor();
    }

    private ConfigLoader newConfigLoader() {
        String clsName = BootstrapProps.getInstance().getProperty("mtp.config.loader", BootstrapProps.DEFAULT_CONFIG_LOADER_CLASS_NAME);
        try {
            ConfigLoader cls = (ConfigLoader)Class.forName(clsName).newInstance();
            return cls;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ServiceConfigrationException("Can not instanceate ConfigLoader:" + clsName, e);
        }
    }

    private ConfigPreprocessor[] newConfigPreprocessor() {
        String cpsProp = BootstrapProps.getInstance().getProperty("mtp.config.preprocessors", BootstrapProps.DEFAULT_CONFIG_PREPROCESSORS_CLASS_NAME);
        String[] cnames = cpsProp.trim().split("\\s*,\\s*");
        ConfigPreprocessor[] cps = null;
        if (cnames != null) {
            cps = new ConfigPreprocessor[cnames.length];
            for (int i = 0; i < cps.length; ++i) {
                try {
                    cps[i] = (ConfigPreprocessor)Class.forName(cnames[i]).newInstance();
                    continue;
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ServiceConfigrationException("Can not instanceate ConfigPreprocessor:" + cnames[i], e);
                }
            }
        }
        return cps;
    }

    public ServiceDefinition read(String fileName) {
        String content = this.loader.load(fileName);
        if (this.prepros != null) {
            for (ConfigPreprocessor p : this.prepros) {
                content = p.preprocess(content, fileName);
            }
        }
        try {
            Unmarshaller um = this.context.createUnmarshaller();
            ServiceDefinition sd = (ServiceDefinition)um.unmarshal((Reader)new StringReader(content));
            if (this.prepros != null) {
                ConfigPreprocessor[] configPreprocessorArray = this.prepros;
                int p = configPreprocessorArray.length;
                for (int i = 0; i < p; ++i) {
                    ConfigPreprocessor p2 = configPreprocessorArray[i];
                    sd = p2.preprocess(sd);
                }
            }
            if (sd.getInherits() != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(fileName + " inherited " + sd.getInherits()[0]);
                }
                ServiceDefinition inhSd = this.read(sd.getInherits()[0]);
                for (int i = 1; i < sd.getInherits().length; ++i) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(fileName + " inherited " + sd.getInherits()[i]);
                    }
                    inhSd.include(this.read(sd.getInherits()[i]));
                }
                sd.inherit(inhSd);
            }
            if (sd.getIncludes() != null) {
                for (String inc : sd.getIncludes()) {
                    ServiceDefinition incSd = this.read(inc);
                    sd.include(incSd);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(fileName + " included " + inc);
                }
            }
            if (logger.isTraceEnabled()) {
                Marshaller m = this.context.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)true);
                StringWriter w = new StringWriter();
                m.marshal((Object)sd, (Writer)w);
                logger.trace("configration of " + fileName + "\n=============\n" + w.toString() + "\n=============");
            }
            return sd;
        }
        catch (JAXBException e) {
            logger.error("Parse failed ConfigFile:" + fileName + ".Can not initialize ServiceRegistry.", (Throwable)e);
            throw new ServiceConfigrationException(e);
        }
    }
}

