/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.counter;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.iplass.mtp.impl.counter.CounterService;
import org.iplass.mtp.impl.rdb.SqlExecuter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class RdbSequenceCounterService
implements CounterService {
    private Map<String, String> sequenceNameMap;
    private RdbAdapter rdb;

    @Override
    public void init(Config config) {
        this.rdb = config.getDependentService(RdbAdapterService.class).getRdbAdapter();
        this.sequenceNameMap = config.getValue("sequenceNameMap", Map.class);
        if (this.sequenceNameMap == null) {
            throw new ServiceConfigrationException("sequenceNameMap must specify.");
        }
    }

    public Map<String, String> getSequenceNameMap() {
        return this.sequenceNameMap;
    }

    @Override
    public void destroy() {
    }

    @Override
    public long increment(final int tenantId, final String incrementUnitKey, long initialCount) {
        SqlExecuter<Long> exec = new SqlExecuter<Long>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Long logic() throws SQLException {
                String sequenceName = RdbSequenceCounterService.this.sequenceNameMap.get(incrementUnitKey);
                String seqSql = RdbSequenceCounterService.this.rdb.seqNextSelectSql(sequenceName, tenantId, incrementUnitKey);
                try (ResultSet rs = this.getStatement().executeQuery(seqSql);){
                    rs.next();
                    Long l = rs.getLong(1);
                    return l;
                }
            }
        };
        return (Long)exec.execute(this.rdb, true);
    }

    @Override
    public void resetCounter(int tenantId, String incrementUnitKey) {
        throw new UnsupportedOperationException("sequence counter not supported online sequence generation");
    }

    @Override
    public void resetCounter(int tenantId, String incrementUnitKey, long currentCount) {
        throw new UnsupportedOperationException("sequence counter not supported online sequence generation");
    }

    @Override
    public void deleteCounter(int tenantId, String incrementUnitKey) {
        throw new UnsupportedOperationException("sequence counter not supported online sequence generation");
    }

    @Override
    public long current(int tenantId, String incrementUnitKey) {
        throw new UnsupportedOperationException("sequence counter's current() method is unsupported");
    }

    @Override
    public Set<String> keySet(int tenantId, String prefixIncrementUnitKey) {
        throw new UnsupportedOperationException("sequence counter's keySet() method is unsupported");
    }
}

