/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.MetaPropertyStore;
import org.iplass.mtp.impl.datastore.PropertyStoreHandler;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.datastore.grdb.GRdbDataStore;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.RawColType;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.MetaSchemalessRdbStoreMapping;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.spi.ServiceRegistry;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class MetaGRdbPropertyStore
extends MetaPropertyStore {
    private static final long serialVersionUID = -1971559137948520477L;
    private int pageNo = 0;
    private String columnName;
    private boolean isNative;
    private Boolean externalIndex;
    private Integer indexPageNo;
    private Integer indexColumnNo;

    public MetaGRdbPropertyStore() {
    }

    public MetaGRdbPropertyStore(int pageNo, String columnName) {
        this.pageNo = pageNo;
        this.columnName = columnName;
    }

    public MetaGRdbPropertyStore(int pageNo, String columnName, boolean isNative) {
        if (!isNative) {
            this.pageNo = pageNo;
        }
        this.columnName = columnName;
        this.isNative = isNative;
    }

    public static String makeInternalIndexKey(int tenantId, String metaEntityId, int pageNo) {
        return tenantId + ":" + metaEntityId + ":" + pageNo;
    }

    public static String makeExternalIndexColName(int pageNo, String columnName) {
        return pageNo + ":" + columnName;
    }

    public int getPageNo() {
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public boolean isNative() {
        return this.isNative;
    }

    public void setNative(boolean isNative) {
        this.isNative = isNative;
    }

    public boolean isExternalIndex() {
        if (this.externalIndex == null) {
            return false;
        }
        return this.externalIndex;
    }

    public void setExternalIndex(boolean externalIndex) {
        this.externalIndex = !externalIndex ? null : Boolean.valueOf(externalIndex);
    }

    public int getIndexPageNo() {
        if (this.indexPageNo == null) {
            return -1;
        }
        return this.indexPageNo;
    }

    public void setIndexPageNo(int indexPageNo) {
        this.indexPageNo = indexPageNo < 0 ? null : Integer.valueOf(indexPageNo);
    }

    public int getIndexColumnNo() {
        if (this.indexColumnNo == null) {
            return -1;
        }
        return this.indexColumnNo;
    }

    public void setIndexColumnNo(int indexColumnNo) {
        this.indexColumnNo = indexColumnNo < 0 ? null : Integer.valueOf(indexColumnNo);
    }

    public void resetIndex() {
        this.externalIndex = null;
        this.indexPageNo = null;
        this.indexColumnNo = null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnName == null ? 0 : this.columnName.hashCode());
        result = 31 * result + (this.externalIndex == null ? 0 : this.externalIndex.hashCode());
        result = 31 * result + (this.indexColumnNo == null ? 0 : this.indexColumnNo.hashCode());
        result = 31 * result + (this.indexPageNo == null ? 0 : this.indexPageNo.hashCode());
        result = 31 * result + (this.isNative ? 1231 : 1237);
        result = 31 * result + this.pageNo;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaGRdbPropertyStore other = (MetaGRdbPropertyStore)obj;
        if (this.columnName == null ? other.columnName != null : !this.columnName.equals(other.columnName)) {
            return false;
        }
        if (this.externalIndex == null ? other.externalIndex != null : !this.externalIndex.equals(other.externalIndex)) {
            return false;
        }
        if (this.indexColumnNo == null ? other.indexColumnNo != null : !this.indexColumnNo.equals(other.indexColumnNo)) {
            return false;
        }
        if (this.indexPageNo == null ? other.indexPageNo != null : !this.indexPageNo.equals(other.indexPageNo)) {
            return false;
        }
        if (this.isNative != other.isNative) {
            return false;
        }
        return this.pageNo == other.pageNo;
    }

    @Override
    public MetaGRdbPropertyStore copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public GRdbPropertyStoreHandler createRuntime(PropertyHandler property, MetaEntity metaEntity) {
        return new GRdbPropertyStoreHandler(property, this, metaEntity);
    }

    public static class GRdbPropertyStoreHandler
    extends PropertyStoreHandler
    implements GRdbPropertyStoreRuntime {
        private BaseRdbTypeAdapter typeMapping;
        private RdbAdapter rdb;
        private PrimitivePropertyHandler propertyRuntime;
        private String indexColName;
        private RawColType rawColType;
        private List<GRdbPropertyStoreHandler> list;
        private MetaGRdbPropertyStore meta;
        private String externalIndexColName;
        private boolean adjustedExternalIndex;

        GRdbPropertyStoreHandler(PropertyHandler propertyRuntime, MetaGRdbPropertyStore meta, MetaEntity metaEntity) {
            this.propertyRuntime = (PrimitivePropertyHandler)propertyRuntime;
            this.meta = meta;
            this.rdb = ServiceRegistry.getRegistry().getService(RdbAdapterService.class).getRdbAdapter();
            PropertyType type = this.propertyRuntime.getMetaData().getType();
            this.typeMapping = this.rdb.getRdbTypeAdapter(type);
            if (!type.isVirtual() && !meta.isNative) {
                this.rawColType = RawColType.typeOf(type);
            }
            IndexType iType = propertyRuntime.getMetaData().getIndexType();
            if (!type.isVirtual() && !meta.isNative && iType != null && iType != IndexType.NON_INDEXED) {
                if (propertyRuntime.getMetaData().getMultiplicity() > 1) {
                    throw new IllegalStateException("No support of index on multipled property(" + propertyRuntime.getMetaData().getName() + ").");
                }
                this.adjustedExternalIndex = this.checkUseExternalIndex(iType, metaEntity);
                if (!this.adjustedExternalIndex) {
                    IndexType it = propertyRuntime.getMetaData().getIndexType();
                    if (it != null) {
                        switch (it) {
                            case UNIQUE: 
                            case UNIQUE_WITHOUT_NULL: {
                                this.indexColName = this.rawColType.getUniqueIndexColNamePrefix() + meta.getIndexColumnNo();
                                break;
                            }
                            case NON_UNIQUE: {
                                this.indexColName = this.rawColType.getNonUniqueIndexColNamePrefix() + meta.getIndexColumnNo();
                                break;
                            }
                        }
                    }
                } else {
                    this.externalIndexColName = MetaGRdbPropertyStore.makeExternalIndexColName(meta.getPageNo(), meta.columnName);
                }
            }
            this.list = Collections.singletonList(this);
        }

        private boolean checkUseExternalIndex(IndexType iType, MetaEntity metaEntity) {
            if (this.meta.isNative()) {
                return false;
            }
            if (this.meta.isExternalIndex()) {
                return true;
            }
            GRdbDataStore ds = (GRdbDataStore)ServiceRegistry.getRegistry().getService(StoreService.class).getDataStore();
            StorageSpaceMap ssm = ds.getStorageSpaceMapOrDefault((MetaSchemalessRdbStoreMapping)metaEntity.getStoreMapping());
            int max = 0;
            switch (iType) {
                case UNIQUE: 
                case UNIQUE_WITHOUT_NULL: {
                    max = this.rawColType.getMaxUniqueIndexCol(ssm);
                    break;
                }
                case NON_UNIQUE: {
                    max = this.rawColType.getMaxIndexCol(ssm);
                    break;
                }
            }
            return max < this.meta.getIndexColumnNo();
        }

        public String getExternalIndexColName() {
            return this.externalIndexColName;
        }

        @Override
        public BaseRdbTypeAdapter getSingleColumnRdbTypeAdapter() {
            return this.typeMapping;
        }

        @Override
        public int getColCount() {
            return 1;
        }

        @Override
        public boolean isNative() {
            return this.meta.isNative;
        }

        public String getIndexColName() {
            return this.indexColName;
        }

        @Override
        public boolean isExternalIndex() {
            return this.adjustedExternalIndex;
        }

        public IndexType getIndexType() {
            IndexType it = this.propertyRuntime.getMetaData().getIndexType();
            if (it == null) {
                return IndexType.NON_INDEXED;
            }
            return it;
        }

        public PropertyType getPropertyType() {
            return this.propertyRuntime.getMetaData().getType();
        }

        public RawColType getRawColType() {
            return this.rawColType;
        }

        @Override
        public PrimitivePropertyHandler getPropertyRuntime() {
            return this.propertyRuntime;
        }

        @Override
        public Object fromDataStore(ResultSet rs, int colNum) throws SQLException {
            return this.getSingleColumnRdbTypeAdapter().fromDataStore(rs, colNum, this.rdb);
        }

        @Override
        public MetaGRdbPropertyStore getMetaData() {
            return this.meta;
        }

        @Override
        public boolean isMulti() {
            return false;
        }

        @Override
        public List<GRdbPropertyStoreHandler> asList() {
            return this.list;
        }
    }
}

