/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb;

import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.impl.datastore.grdb.ColumnPosition;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.RawColIndexType;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;

public enum RawColType {
    VARCHAR{

        @Override
        public String getColNamePrefix() {
            return "STR_";
        }

        @Override
        public String getNonUniqueIndexColNamePrefix() {
            return "ISTR_";
        }

        @Override
        public String getUniqueIndexColNamePrefix() {
            return "USTR_";
        }

        @Override
        public int getMaxNormalCol(StorageSpaceMap ssm) {
            return ssm.getVarcharColumns();
        }

        @Override
        public int getMaxIndexCol(StorageSpaceMap ssm) {
            return ssm.getIndexedVarcharColumns();
        }

        @Override
        public int getMaxUniqueIndexCol(StorageSpaceMap ssm) {
            return ssm.getUniqueIndexedVarcharColumns();
        }

        @Override
        public ColumnPosition getColumnPositionOf(MetaGRdbEntityStore store, RawColIndexType type) {
            if (type == null) {
                type = RawColIndexType.NONE;
            }
            switch (type) {
                case NONE: {
                    return store.getMaxVarchar();
                }
                case INDEX: {
                    return store.getMaxIndexedVarchar();
                }
                case UNIQUE_INDEX: {
                    return store.getMaxUniqueIndexedVarchar();
                }
            }
            return null;
        }

        @Override
        public void setColumnPositionOf(MetaGRdbEntityStore store, RawColIndexType type, ColumnPosition columnPosition) {
            if (type == null) {
                type = RawColIndexType.NONE;
            }
            switch (type) {
                case NONE: {
                    store.setMaxVarchar(columnPosition);
                    break;
                }
                case INDEX: {
                    store.setMaxIndexedVarchar(columnPosition);
                    break;
                }
                case UNIQUE_INDEX: {
                    store.setMaxUniqueIndexedVarchar(columnPosition);
                    break;
                }
            }
        }
    }
    ,
    DECIMAL{

        @Override
        public String getColNamePrefix() {
            return "NUM_";
        }

        @Override
        public String getNonUniqueIndexColNamePrefix() {
            return "INUM_";
        }

        @Override
        public String getUniqueIndexColNamePrefix() {
            return "UNUM_";
        }

        @Override
        public int getMaxNormalCol(StorageSpaceMap ssm) {
            return ssm.getDecimalColumns();
        }

        @Override
        public int getMaxIndexCol(StorageSpaceMap ssm) {
            return ssm.getIndexedDecimalColumns();
        }

        @Override
        public int getMaxUniqueIndexCol(StorageSpaceMap ssm) {
            return ssm.getUniqueIndexedDecimalColumns();
        }

        @Override
        public ColumnPosition getColumnPositionOf(MetaGRdbEntityStore store, RawColIndexType type) {
            if (type == null) {
                type = RawColIndexType.NONE;
            }
            switch (type) {
                case NONE: {
                    return store.getMaxDecimal();
                }
                case INDEX: {
                    return store.getMaxIndexedDecimal();
                }
                case UNIQUE_INDEX: {
                    return store.getMaxUniqueIndexedDecimal();
                }
            }
            return null;
        }

        @Override
        public void setColumnPositionOf(MetaGRdbEntityStore store, RawColIndexType type, ColumnPosition columnPosition) {
            if (type == null) {
                type = RawColIndexType.NONE;
            }
            switch (type) {
                case NONE: {
                    store.setMaxDecimal(columnPosition);
                    break;
                }
                case INDEX: {
                    store.setMaxIndexedDecimal(columnPosition);
                    break;
                }
                case UNIQUE_INDEX: {
                    store.setMaxUniqueIndexedDecimal(columnPosition);
                    break;
                }
            }
        }
    }
    ,
    TIMESTAMP{

        @Override
        public String getColNamePrefix() {
            return "TS_";
        }

        @Override
        public String getNonUniqueIndexColNamePrefix() {
            return "ITS_";
        }

        @Override
        public String getUniqueIndexColNamePrefix() {
            return "UTS_";
        }

        @Override
        public int getMaxNormalCol(StorageSpaceMap ssm) {
            return ssm.getTimestampColumns();
        }

        @Override
        public int getMaxIndexCol(StorageSpaceMap ssm) {
            return ssm.getIndexedTimestampColumns();
        }

        @Override
        public int getMaxUniqueIndexCol(StorageSpaceMap ssm) {
            return ssm.getUniqueIndexedTimestampColumns();
        }

        @Override
        public ColumnPosition getColumnPositionOf(MetaGRdbEntityStore store, RawColIndexType type) {
            if (type == null) {
                type = RawColIndexType.NONE;
            }
            switch (type) {
                case NONE: {
                    return store.getMaxTimestamp();
                }
                case INDEX: {
                    return store.getMaxIndexedTimestamp();
                }
                case UNIQUE_INDEX: {
                    return store.getMaxUniqueIndexedTimestamp();
                }
            }
            return null;
        }

        @Override
        public void setColumnPositionOf(MetaGRdbEntityStore store, RawColIndexType type, ColumnPosition columnPosition) {
            if (type == null) {
                type = RawColIndexType.NONE;
            }
            switch (type) {
                case NONE: {
                    store.setMaxTimestamp(columnPosition);
                    break;
                }
                case INDEX: {
                    store.setMaxIndexedTimestamp(columnPosition);
                    break;
                }
                case UNIQUE_INDEX: {
                    store.setMaxUniqueIndexedTimestamp(columnPosition);
                    break;
                }
            }
        }
    }
    ,
    DOUBLE{

        @Override
        public String getColNamePrefix() {
            return "DBL_";
        }

        @Override
        public String getNonUniqueIndexColNamePrefix() {
            return "IDBL_";
        }

        @Override
        public String getUniqueIndexColNamePrefix() {
            return "UDBL_";
        }

        @Override
        public int getMaxNormalCol(StorageSpaceMap ssm) {
            return ssm.getDoubleColumns();
        }

        @Override
        public int getMaxIndexCol(StorageSpaceMap ssm) {
            return ssm.getIndexedDoubleColumns();
        }

        @Override
        public int getMaxUniqueIndexCol(StorageSpaceMap ssm) {
            return ssm.getUniqueIndexedDoubleColumns();
        }

        @Override
        public ColumnPosition getColumnPositionOf(MetaGRdbEntityStore store, RawColIndexType type) {
            if (type == null) {
                type = RawColIndexType.NONE;
            }
            switch (type) {
                case NONE: {
                    return store.getMaxDouble();
                }
                case INDEX: {
                    return store.getMaxIndexedDouble();
                }
                case UNIQUE_INDEX: {
                    return store.getMaxUniqueIndexedDouble();
                }
            }
            return null;
        }

        @Override
        public void setColumnPositionOf(MetaGRdbEntityStore store, RawColIndexType type, ColumnPosition columnPosition) {
            if (type == null) {
                type = RawColIndexType.NONE;
            }
            switch (type) {
                case NONE: {
                    store.setMaxDouble(columnPosition);
                    break;
                }
                case INDEX: {
                    store.setMaxIndexedDouble(columnPosition);
                    break;
                }
                case UNIQUE_INDEX: {
                    store.setMaxUniqueIndexedDouble(columnPosition);
                    break;
                }
            }
        }
    };


    public int getMaxCol(StorageSpaceMap ssm, RawColIndexType indexType) {
        switch (indexType) {
            case NONE: {
                return this.getMaxNormalCol(ssm);
            }
            case INDEX: {
                return this.getMaxIndexCol(ssm);
            }
            case UNIQUE_INDEX: {
                return this.getMaxUniqueIndexCol(ssm);
            }
        }
        throw new IllegalArgumentException();
    }

    public String getColNamePrefix(RawColIndexType indexType) {
        switch (indexType) {
            case NONE: {
                return this.getColNamePrefix();
            }
            case INDEX: {
                return this.getNonUniqueIndexColNamePrefix();
            }
            case UNIQUE_INDEX: {
                return this.getUniqueIndexColNamePrefix();
            }
        }
        throw new IllegalArgumentException();
    }

    public abstract String getColNamePrefix();

    public abstract String getNonUniqueIndexColNamePrefix();

    public abstract String getUniqueIndexColNamePrefix();

    public abstract int getMaxNormalCol(StorageSpaceMap var1);

    public abstract int getMaxIndexCol(StorageSpaceMap var1);

    public abstract int getMaxUniqueIndexCol(StorageSpaceMap var1);

    public abstract ColumnPosition getColumnPositionOf(MetaGRdbEntityStore var1, RawColIndexType var2);

    public abstract void setColumnPositionOf(MetaGRdbEntityStore var1, RawColIndexType var2, ColumnPosition var3);

    public void setColumnPositionOf(MetaGRdbEntityStore store, IndexType type, ColumnPosition columnPosition) {
        this.setColumnPositionOf(store, RawColIndexType.typeOf(type), columnPosition);
    }

    public ColumnPosition getColumnPositionOf(MetaGRdbEntityStore store, IndexType type) {
        return this.getColumnPositionOf(store, RawColIndexType.typeOf(type));
    }

    public int getMaxCol(StorageSpaceMap ssm, IndexType type) {
        if (type == null) {
            type = IndexType.NON_INDEXED;
        }
        switch (type) {
            case NON_INDEXED: {
                return this.getMaxNormalCol(ssm);
            }
            case NON_UNIQUE: {
                return this.getMaxIndexCol(ssm);
            }
            case UNIQUE: 
            case UNIQUE_WITHOUT_NULL: {
                return this.getMaxUniqueIndexCol(ssm);
            }
        }
        throw new IllegalArgumentException();
    }

    public String getIndexColNamePrefix(IndexType type) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case NON_UNIQUE: {
                return this.getNonUniqueIndexColNamePrefix();
            }
            case UNIQUE: 
            case UNIQUE_WITHOUT_NULL: {
                return this.getUniqueIndexColNamePrefix();
            }
        }
        return null;
    }

    public static RawColType typeOf(BaseRdbTypeAdapter type) {
        switch (type.sqlType()) {
            case 91: 
            case 92: 
            case 93: {
                return TIMESTAMP;
            }
            case -5: 
            case 3: {
                return DECIMAL;
            }
            case 8: {
                return DOUBLE;
            }
            case 12: {
                return VARCHAR;
            }
        }
        throw new IllegalArgumentException("no support sql type:" + type.sqlType() + ", rdbType:" + String.valueOf(type));
    }

    public static RawColType typeOf(PropertyType type) {
        switch (type.getDataStoreEnumType()) {
            case BOOLEAN: 
            case STRING: {
                return VARCHAR;
            }
            case DATE: 
            case DATETIME: 
            case TIME: {
                return TIMESTAMP;
            }
            case DECIMAL: 
            case INTEGER: {
                return DECIMAL;
            }
            case FLOAT: {
                return DOUBLE;
            }
        }
        throw new IllegalArgumentException("no support PropertyType:" + String.valueOf(type));
    }
}

