/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.iplass.mtp.impl.datastore.grdb.TableAllocator;
import org.iplass.mtp.impl.datastore.grdb.tableallocators.HashingTableAllocator;

public class StorageSpaceMap {
    public static final String TABLE_NAME_SEPARATOR = "__";
    private String storageSpaceName;
    private String tableNamePostfix;
    private int tableCount = 0;
    private int varcharColumns;
    private int decimalColumns;
    private int timestampColumns;
    private int doubleColumns;
    private boolean useExternalIndexedTable = true;
    private int indexedVarcharColumns;
    private int indexedDecimalColumns;
    private int indexedTimestampColumns;
    private int indexedDoubleColumns;
    private boolean useExternalUniqueIndexedTable = true;
    private int uniqueIndexedVarcharColumns;
    private int uniqueIndexedDecimalColumns;
    private int uniqueIndexedTimestampColumns;
    private int uniqueIndexedDoubleColumns;
    private boolean customPartition;
    private TableAllocator tableAllocator = new HashingTableAllocator();
    private int varcharColumnLength = -1;

    public String generateTableNamePostfix(int tenantId, String metaId) {
        if (this.tableCount == 0) {
            if (this.tableNamePostfix == null) {
                return null;
            }
            return this.tableNamePostfix;
        }
        int myCount = this.tableAllocator.allocate(tenantId, metaId, this);
        if (this.tableNamePostfix == null) {
            if (myCount == 0) {
                return null;
            }
            return String.valueOf(myCount);
        }
        if (myCount == 0) {
            return this.tableNamePostfix;
        }
        return this.tableNamePostfix + TABLE_NAME_SEPARATOR + String.valueOf(myCount);
    }

    public int maxColumns() {
        int ret = Math.max(this.varcharColumns, this.decimalColumns);
        ret = Math.max(ret, this.timestampColumns);
        ret = Math.max(ret, this.doubleColumns);
        ret = Math.max(ret, this.indexedVarcharColumns);
        ret = Math.max(ret, this.indexedDecimalColumns);
        ret = Math.max(ret, this.indexedTimestampColumns);
        ret = Math.max(ret, this.indexedDoubleColumns);
        ret = Math.max(ret, this.uniqueIndexedVarcharColumns);
        ret = Math.max(ret, this.uniqueIndexedDecimalColumns);
        ret = Math.max(ret, this.uniqueIndexedTimestampColumns);
        ret = Math.max(ret, this.uniqueIndexedDoubleColumns);
        return ret;
    }

    public int tableNo(String checkTableNamePostfix) {
        if (checkTableNamePostfix == null) {
            if (this.tableNamePostfix == null) {
                return 0;
            }
            return -1;
        }
        if (checkTableNamePostfix.equals(this.tableNamePostfix)) {
            return 0;
        }
        int i = checkTableNamePostfix.lastIndexOf(TABLE_NAME_SEPARATOR);
        if (i == -1) {
            try {
                return Integer.parseInt(checkTableNamePostfix);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        String ssPart = checkTableNamePostfix.substring(0, i);
        String noPart = checkTableNamePostfix.substring(i + TABLE_NAME_SEPARATOR.length(), checkTableNamePostfix.length());
        if (ssPart.equals(this.tableNamePostfix)) {
            try {
                return Integer.parseInt(noPart);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public List<String> allTableNamePostfix() {
        if (this.tableCount == 0) {
            if (this.tableNamePostfix == null) {
                return Collections.singletonList(null);
            }
            return Collections.singletonList(this.tableNamePostfix);
        }
        ArrayList<String> res = new ArrayList<String>();
        if (this.tableNamePostfix == null) {
            res.add(null);
            for (int i = 1; i < this.tableCount; ++i) {
                res.add(String.valueOf(i));
            }
        } else {
            res.add(this.tableNamePostfix);
            for (int i = 1; i < this.tableCount; ++i) {
                res.add(this.tableNamePostfix + TABLE_NAME_SEPARATOR + String.valueOf(i));
            }
        }
        return res;
    }

    public String getStorageSpaceName() {
        return this.storageSpaceName;
    }

    public void setStorageSpaceName(String storageSpaceName) {
        this.storageSpaceName = storageSpaceName;
    }

    public String getTableNamePostfix() {
        return this.tableNamePostfix;
    }

    public void setTableNamePostfix(String tableNamePostfix) {
        this.tableNamePostfix = tableNamePostfix;
    }

    public int getTableCount() {
        return this.tableCount;
    }

    public void setTableCount(int tableCount) {
        this.tableCount = tableCount;
    }

    public int getVarcharColumns() {
        return this.varcharColumns;
    }

    public void setVarcharColumns(int varcharColumns) {
        this.varcharColumns = varcharColumns;
    }

    public int getDecimalColumns() {
        return this.decimalColumns;
    }

    public void setDecimalColumns(int decimalColumns) {
        this.decimalColumns = decimalColumns;
    }

    public int getTimestampColumns() {
        return this.timestampColumns;
    }

    public void setTimestampColumns(int timestampColumns) {
        this.timestampColumns = timestampColumns;
    }

    public int getDoubleColumns() {
        return this.doubleColumns;
    }

    public void setDoubleColumns(int doubleColumns) {
        this.doubleColumns = doubleColumns;
    }

    public boolean isUseExternalIndexedTable() {
        return this.useExternalIndexedTable;
    }

    public void setUseExternalIndexedTable(boolean useExternalIndexedTable) {
        this.useExternalIndexedTable = useExternalIndexedTable;
    }

    public int getIndexedVarcharColumns() {
        return this.indexedVarcharColumns;
    }

    public void setIndexedVarcharColumns(int indexedVarcharColumns) {
        this.indexedVarcharColumns = indexedVarcharColumns;
    }

    public int getIndexedDecimalColumns() {
        return this.indexedDecimalColumns;
    }

    public void setIndexedDecimalColumns(int indexedDecimalColumns) {
        this.indexedDecimalColumns = indexedDecimalColumns;
    }

    public int getIndexedTimestampColumns() {
        return this.indexedTimestampColumns;
    }

    public void setIndexedTimestampColumns(int indexedTimestampColumns) {
        this.indexedTimestampColumns = indexedTimestampColumns;
    }

    public int getIndexedDoubleColumns() {
        return this.indexedDoubleColumns;
    }

    public void setIndexedDoubleColumns(int indexedDoubleColumns) {
        this.indexedDoubleColumns = indexedDoubleColumns;
    }

    public boolean isUseExternalUniqueIndexedTable() {
        return this.useExternalUniqueIndexedTable;
    }

    public void setUseExternalUniqueIndexedTable(boolean useExternalUniqueIndexedTable) {
        this.useExternalUniqueIndexedTable = useExternalUniqueIndexedTable;
    }

    public int getUniqueIndexedVarcharColumns() {
        return this.uniqueIndexedVarcharColumns;
    }

    public void setUniqueIndexedVarcharColumns(int uniqueIndexedVarcharColumns) {
        this.uniqueIndexedVarcharColumns = uniqueIndexedVarcharColumns;
    }

    public int getUniqueIndexedDecimalColumns() {
        return this.uniqueIndexedDecimalColumns;
    }

    public void setUniqueIndexedDecimalColumns(int uniqueIndexedDecimalColumns) {
        this.uniqueIndexedDecimalColumns = uniqueIndexedDecimalColumns;
    }

    public int getUniqueIndexedTimestampColumns() {
        return this.uniqueIndexedTimestampColumns;
    }

    public void setUniqueIndexedTimestampColumns(int uniqueIndexedTimestampColumns) {
        this.uniqueIndexedTimestampColumns = uniqueIndexedTimestampColumns;
    }

    public int getUniqueIndexedDoubleColumns() {
        return this.uniqueIndexedDoubleColumns;
    }

    public void setUniqueIndexedDoubleColumns(int uniqueIndexedDoubleColumns) {
        this.uniqueIndexedDoubleColumns = uniqueIndexedDoubleColumns;
    }

    public boolean isCustomPartition() {
        return this.customPartition;
    }

    public void setCustomPartition(boolean customPartition) {
        this.customPartition = customPartition;
    }

    public TableAllocator getTableAllocator() {
        return this.tableAllocator;
    }

    public void setTableAllocator(TableAllocator tableAllocator) {
        this.tableAllocator = tableAllocator;
    }

    public int getVarcharColumnLength() {
        return this.varcharColumnLength;
    }

    public void setVarcharColumnLength(int varcharColumnLength) {
        this.varcharColumnLength = varcharColumnLength;
    }
}

