/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql;

import java.sql.Timestamp;
import org.iplass.mtp.entity.DeleteCondition;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlConverter;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlQueryContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class ObjStoreDeleteSql
extends UpdateSqlHandler {
    private static final String TMP_TABLE_ALIAS = "tt";

    public String deleteMainPageByOid(int tenantId, EntityHandler eh, String objId, Long version, boolean withOptimisticLock, Timestamp timestamp, RdbAdapter adapter) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE());
        sb.append(" WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND OBJ_DEF_ID='");
        sb.append(adapter.sanitize(eh.getMetaData().getId()));
        sb.append("' AND OBJ_ID='");
        sb.append(adapter.sanitize(objId));
        sb.append("' AND OBJ_VER=");
        if (version != null) {
            sb.append(version);
        } else {
            sb.append("0");
        }
        sb.append(" AND PG_NO=0");
        if (withOptimisticLock) {
            if (timestamp == null) {
                throw new NullPointerException("specify optimistic lock, but timestamp is null.");
            }
            sb.append(" AND UP_DATE=");
            sb.append(adapter.toTimeStampExpression(timestamp));
        }
        return sb.toString();
    }

    public String deleteByOid(int tenantId, EntityHandler eh, String objId, Long version, RdbAdapter adapter) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE());
        sb.append(" WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND OBJ_DEF_ID='");
        sb.append(adapter.sanitize(eh.getMetaData().getId()));
        sb.append("' AND OBJ_ID='");
        sb.append(adapter.sanitize(objId));
        sb.append("' AND OBJ_VER=");
        if (version != null) {
            sb.append(version);
        } else {
            sb.append("0");
        }
        return sb.toString();
    }

    public String deleteByCondition(int tenantId, EntityHandler eh, DeleteCondition cond, RdbAdapter rdb, EntityContext entityContext) {
        StringBuilder sb = new StringBuilder();
        String objStoreTableName = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE();
        if (rdb.isNeedMultiTableTrick()) {
            sb.append("DELETE ");
            sb.append(objStoreTableName);
            sb.append(" FROM ");
        } else {
            sb.append("DELETE FROM ");
        }
        sb.append(objStoreTableName);
        sb.append(" WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND OBJ_DEF_ID='");
        sb.append(rdb.sanitize(eh.getMetaData().getId()));
        if (rdb.isSupportRowValueConstructor()) {
            sb.append("' AND (OBJ_ID,OBJ_VER) in(");
        } else {
            sb.append("' AND EXISTS (");
        }
        Query q = new Query();
        q.select("oid", "version").from(eh.getMetaData().getName()).setWhere(cond.getWhere());
        SqlQueryContext qc = new SqlQueryContext(eh, entityContext, rdb);
        SqlConverter conv = new SqlConverter(qc, false);
        q.accept(conv);
        if (rdb.isSupportRowValueConstructor()) {
            sb.append(rdb.tableAlias(qc.toSelectSql()));
        } else {
            String prefix = qc.getPrefix();
            String objStoreTable = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE();
            StringBuilder sbJoin = new StringBuilder();
            if (prefix != null) {
                sbJoin.append(prefix).append(".");
            }
            sbJoin.append("OBJ_ID").append("=").append(objStoreTable).append(".").append("OBJ_ID");
            sbJoin.append(" AND ");
            if (prefix != null) {
                sbJoin.append(prefix).append(".");
            }
            sbJoin.append("OBJ_VER").append("=").append(objStoreTable).append(".").append("OBJ_VER");
            sb.append(rdb.tableAlias(qc.toSelectSql(sbJoin.toString())));
        }
        sb.append(")");
        return sb.toString();
    }

    public String deleteByTempTable(int tenantId, EntityHandler eh, RdbAdapter rdb, EntityContext entityContext) {
        StringBuilder sb = new StringBuilder();
        String objStoreTableName = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE();
        if (rdb.isNeedMultiTableTrick()) {
            sb.append("DELETE ");
            sb.append(objStoreTableName);
            sb.append(" FROM ");
        } else {
            sb.append("DELETE FROM ");
        }
        sb.append(objStoreTableName);
        sb.append(" WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND OBJ_DEF_ID='");
        sb.append(rdb.sanitize(eh.getMetaData().getId())).append("'");
        if (rdb.isSupportRowValueConstructor()) {
            sb.append(" AND (OBJ_ID,OBJ_VER) IN(SELECT OBJ_ID,OBJ_VER FROM " + rdb.getTemplaryTablePrefix() + "OBJ_STORE_TMP)");
        } else {
            String objStoreTable = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE();
            sb.append(" AND EXISTS (");
            sb.append("SELECT 1 FROM ").append(rdb.getTemplaryTablePrefix()).append("OBJ_STORE_TMP").append(" ").append(TMP_TABLE_ALIAS);
            sb.append(" WHERE ").append(TMP_TABLE_ALIAS).append(".").append("OBJ_ID").append("=").append(objStoreTable).append(".").append("OBJ_ID");
            sb.append(" AND ").append(TMP_TABLE_ALIAS).append(".").append("OBJ_VER").append("=").append(objStoreTable).append(".").append("OBJ_VER");
            sb.append(")");
        }
        return sb.toString();
    }

    public String deleteAllDataByDefId(int tenantId, String defId, String tableNamePostfix, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(MetaGRdbEntityStore.makeObjStoreName(tableNamePostfix));
        sb.append(" WHERE TENANT_ID=");
        sb.append(tenantId);
        sb.append(" AND OBJ_DEF_ID='");
        sb.append(rdb.sanitize(defId)).append("'");
        return sb.toString();
    }
}

