/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.query.GroupBy;
import org.iplass.mtp.entity.query.Having;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryVisitorSupport;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.hint.BindHint;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.NoBindHint;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.entity.query.value.window.PartitionBy;
import org.iplass.mtp.entity.query.value.window.WindowOrderBy;
import org.iplass.mtp.entity.query.value.window.WindowSortSpec;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.sql.ToSqlResult;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlConverter;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlQueryContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.rdb.adapter.QuerySqlHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjStoreSearchSql
extends QuerySqlHandler {
    private static Logger logger = LoggerFactory.getLogger(ObjStoreSearchSql.class);

    public ToSqlResult query(EntityHandler metaData, EntityContext context, Query query, boolean withLock, boolean treatBindHint, Integer stringTypeLengthOnQuery, RdbAdapter rdbAdaptor) {
        return this.queryImpl(metaData, context, query, treatBindHint, stringTypeLengthOnQuery, rdbAdaptor, sql -> {
            if (withLock) {
                return rdbAdaptor.createRowLockSql(sql.toString());
            }
            return sql;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ToSqlResult queryImpl(EntityHandler metaData, EntityContext context, Query query, boolean treatBindHint, Integer stringTypeLengthOnQuery, RdbAdapter rdbAdaptor, UnaryOperator<CharSequence> modifiier) {
        long time = 0L;
        if (logger.isTraceEnabled()) {
            time = System.nanoTime();
        }
        try {
            SqlQueryContext sqlContext = new SqlQueryContext(metaData, context, rdbAdaptor);
            if (stringTypeLengthOnQuery != null && stringTypeLengthOnQuery > 0) {
                sqlContext.setStringTypeLengthOnQuery(stringTypeLengthOnQuery);
            }
            SqlConverter converter = new SqlConverter(sqlContext, treatBindHint);
            if (rdbAdaptor.isAlwaysBind()) {
                GroupByNoBinder noBinder = new GroupByNoBinder();
                noBinder.modify(query);
                boolean hasNoBindHint = false;
                if (query.select().getHintComment() != null && query.select().getHintComment().getHintList() != null) {
                    for (Hint h : query.select().getHintComment().getHintList()) {
                        if (!(h instanceof NoBindHint)) continue;
                        hasNoBindHint = true;
                        break;
                    }
                }
                if (!hasNoBindHint) {
                    query.select().hintComment().add(new BindHint());
                }
            }
            query.accept(converter);
            ToSqlResult toSqlResult = new ToSqlResult(sqlContext.sqlEnded((CharSequence)modifiier.apply(sqlContext.toSelectSql())), sqlContext.toOrderedBindVariables(true));
            return toSqlResult;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace("translate EQL to SQL:time=" + (double)(System.nanoTime() - time) / 1000000.0 + "ms.");
            }
        }
    }

    public ToSqlResult count(EntityHandler metaData, EntityContext context, Query query, boolean enableBindVariable, RdbAdapter rdbAdaptor) {
        Query subQuery = query.copy();
        subQuery.setOrderBy(null);
        UnaryOperator<CharSequence> sqlModifiier = rdbAdaptor.countQuery(subQuery);
        ToSqlResult res = this.queryImpl(metaData, context, subQuery, enableBindVariable, null, rdbAdaptor, sqlModifiier);
        return res;
    }

    public String checkExistsSql(int tenantId, EntityHandler eh, Entity entity, RdbAdapter rdbAdaptor) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT 1 FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE());
        sb.append(" WHERE TENANT_ID=? AND OBJ_DEF_ID=? AND OBJ_ID=? AND OBJ_VER=? AND PG_NO=0");
        return sb.toString();
    }

    public void checkExistsParameter(PreparedStatement stmt, int tenantId, EntityHandler eh, Entity entity) throws SQLException {
        stmt.setInt(1, tenantId);
        stmt.setString(2, eh.getMetaData().getId());
        stmt.setString(3, entity.getOid());
        if (entity.getVersion() != null) {
            stmt.setLong(4, entity.getVersion());
        } else {
            stmt.setLong(4, 0L);
        }
    }

    public static String checkExistsByKeysSql(int tenantId, EntityHandler eh, List<Object[]> keys, RdbAdapter rdbAdaptor) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT OBJ_ID,OBJ_VER FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdbAdaptor.sanitize(eh.getMetaData().getId())).append("'");
        if (rdbAdaptor.isSupportRowValueConstructor()) {
            sb.append(" AND (OBJ_ID,OBJ_VER,PG_NO) IN (");
            for (int i = 0; i < keys.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("('").append(rdbAdaptor.sanitize((String)keys.get(i)[0])).append("',").append(keys.get(i)[1]).append(",0)");
            }
            sb.append(")");
        } else {
            sb.append(" AND (");
            for (int i = 0; i < keys.size(); ++i) {
                if (i != 0) {
                    sb.append(" OR ");
                }
                sb.append("(");
                sb.append("OBJ_ID").append("='").append(rdbAdaptor.sanitize((String)keys.get(i)[0])).append("'");
                sb.append(" AND ");
                sb.append("OBJ_VER").append("=").append(keys.get(i)[1]);
                sb.append(" AND ");
                sb.append("PG_NO").append("=0");
                sb.append(")");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private static class GroupByNoBinder
    extends QueryVisitorSupport {
        GroupByCollector collector;
        boolean noBind;
        ArrayList<Literal> target;

        private GroupByNoBinder() {
        }

        public void modify(Query query) {
            this.target = new ArrayList();
            query.accept(this);
            for (Literal l : this.target) {
                l.setBindable(false);
            }
        }

        @Override
        public boolean visit(Query query) {
            this.collector = new GroupByCollector();
            query.accept(this.collector);
            return true;
        }

        @Override
        public boolean visit(SubQuery subQuery) {
            GroupByCollector prevCollector = this.collector;
            subQuery.getQuery().accept(this);
            if (subQuery.getOn() != null) {
                subQuery.getOn().accept(this);
            }
            this.collector = prevCollector;
            return false;
        }

        @Override
        public boolean visit(OrderBy orderBy) {
            for (SortSpec ss : orderBy.getSortSpecList()) {
                boolean prevNoBind = this.noBind;
                if (this.collector.groupBySet != null && this.collector.groupBySet.contains(ss.getSortKey())) {
                    this.noBind = true;
                }
                ss.getSortKey().accept(this);
                this.noBind = prevNoBind;
            }
            return false;
        }

        @Override
        public boolean visit(Having having) {
            boolean prevNoBind = this.noBind;
            this.noBind = true;
            if (having.getCondition() != null) {
                having.getCondition().accept(this);
            }
            this.noBind = prevNoBind;
            return false;
        }

        @Override
        public boolean visit(Select select) {
            for (ValueExpression ve : select.getSelectValues()) {
                boolean prevNoBind = this.noBind;
                if (this.collector.groupBySet != null && this.collector.groupBySet.contains(ve)) {
                    this.noBind = true;
                }
                ve.accept(this);
                this.noBind = prevNoBind;
            }
            return false;
        }

        @Override
        public boolean visit(GroupBy groupBy) {
            boolean prevNoBind = this.noBind;
            this.noBind = true;
            if (groupBy.getGroupingFieldList() != null) {
                for (ValueExpression ve : groupBy.getGroupingFieldList()) {
                    ve.accept(this);
                }
            }
            this.noBind = prevNoBind;
            return false;
        }

        @Override
        public boolean visit(PartitionBy partitionBy) {
            boolean prevNoBind = this.noBind;
            this.noBind = true;
            if (partitionBy.getPartitionFieldList() != null) {
                for (ValueExpression ve : partitionBy.getPartitionFieldList()) {
                    ve.accept(this);
                }
            }
            this.noBind = prevNoBind;
            return false;
        }

        @Override
        public boolean visit(WindowOrderBy orderBy) {
            boolean prevNoBind = this.noBind;
            this.noBind = true;
            if (orderBy.getSortSpecList() != null) {
                for (WindowSortSpec wss : orderBy.getSortSpecList()) {
                    wss.accept(this);
                }
            }
            this.noBind = prevNoBind;
            return false;
        }

        @Override
        public boolean visit(Literal literal) {
            if (this.noBind) {
                this.target.add(literal);
            }
            return true;
        }
    }

    private static class GroupByCollector
    extends QueryVisitorSupport {
        Set<ValueExpression> groupBySet;

        private GroupByCollector() {
        }

        private void initSet() {
            if (this.groupBySet == null) {
                this.groupBySet = new HashSet<ValueExpression>();
            }
        }

        @Override
        public boolean visit(GroupBy groupBy) {
            if (groupBy.getGroupingFieldList() != null) {
                this.initSet();
                for (ValueExpression ve : groupBy.getGroupingFieldList()) {
                    this.groupBySet.add(ve);
                }
            }
            return false;
        }

        @Override
        public boolean visit(SubQuery subQuery) {
            return false;
        }

        @Override
        public boolean visit(PartitionBy partitionBy) {
            if (partitionBy.getPartitionFieldList() != null) {
                this.initSet();
                for (ValueExpression ve : partitionBy.getPartitionFieldList()) {
                    this.groupBySet.add(ve);
                }
            }
            return false;
        }

        @Override
        public boolean visit(WindowSortSpec sortSpec) {
            if (sortSpec.getSortKey() != null) {
                this.initSet();
                this.groupBySet.add(sortSpec.getSortKey());
            }
            return false;
        }
    }
}

