/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql;

import java.sql.Timestamp;
import java.util.List;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class RecycleBinSql
extends UpdateSqlHandler {
    public String copyDataToRB(int tenantId, EntityHandler eh, Long rbid, String oid, String userId, RdbAdapter rdb, StorageSpaceMap ssmap) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE_RB());
        sb.append("(RB_ID,RB_DATE,RB_USER,");
        this.appendAllDataCols(sb, ssmap, eh);
        sb.append(") SELECT ");
        sb.append(rbid).append(",");
        sb.append(rdb.systimestamp()).append(",");
        sb.append("'").append(rdb.sanitize(userId)).append("',");
        this.appendAllDataCols(sb, ssmap, eh);
        sb.append(" FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId()));
        sb.append("' AND OBJ_ID='").append(rdb.sanitize(oid)).append("'");
        return sb.toString();
    }

    private void appendAllDataCols(StringBuilder sb, StorageSpaceMap ssmap, EntityHandler eh) {
        sb.append("TENANT_ID").append(',');
        sb.append("OBJ_DEF_ID").append(',');
        sb.append("PG_NO").append(',');
        sb.append("OBJ_ID").append(',');
        sb.append("OBJ_VER").append(',');
        sb.append("OBJ_DEF_VER").append(',');
        sb.append("STATUS").append(',');
        sb.append("OBJ_NAME").append(',');
        sb.append("OBJ_DESC").append(',');
        sb.append("CRE_DATE").append(',');
        sb.append("UP_DATE").append(',');
        sb.append("S_DATE").append(',');
        sb.append("E_DATE").append(',');
        sb.append("LOCK_USER").append(',');
        sb.append("CRE_USER").append(',');
        sb.append("UP_USER");
        this.addCol(sb, "STR_", null, ssmap.getVarcharColumns());
        this.addCol(sb, "NUM_", null, ssmap.getDecimalColumns());
        this.addCol(sb, "TS_", null, ssmap.getTimestampColumns());
        this.addCol(sb, "DBL_", null, ssmap.getDoubleColumns());
        this.addCol(sb, "ISTR_", null, ssmap.getIndexedVarcharColumns());
        this.addCol(sb, "ISTR_", "_TD", ssmap.getIndexedVarcharColumns());
        this.addCol(sb, "INUM_", null, ssmap.getIndexedDecimalColumns());
        this.addCol(sb, "INUM_", "_TD", ssmap.getIndexedDecimalColumns());
        this.addCol(sb, "ITS_", null, ssmap.getIndexedTimestampColumns());
        this.addCol(sb, "ITS_", "_TD", ssmap.getIndexedTimestampColumns());
        this.addCol(sb, "IDBL_", null, ssmap.getUniqueIndexedDoubleColumns());
        this.addCol(sb, "IDBL_", "_TD", ssmap.getUniqueIndexedDoubleColumns());
        this.addCol(sb, "USTR_", null, ssmap.getUniqueIndexedVarcharColumns());
        this.addCol(sb, "USTR_", "_TD", ssmap.getUniqueIndexedVarcharColumns());
        this.addCol(sb, "UNUM_", null, ssmap.getUniqueIndexedDecimalColumns());
        this.addCol(sb, "UNUM_", "_TD", ssmap.getUniqueIndexedDecimalColumns());
        this.addCol(sb, "UTS_", null, ssmap.getUniqueIndexedTimestampColumns());
        this.addCol(sb, "UTS_", "_TD", ssmap.getUniqueIndexedTimestampColumns());
        this.addCol(sb, "UDBL_", null, ssmap.getUniqueIndexedDoubleColumns());
        this.addCol(sb, "UDBL_", "_TD", ssmap.getUniqueIndexedDoubleColumns());
        for (PropertyHandler p : eh.getDeclaredPropertyList()) {
            GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)p.getStoreSpecProperty());
            if (col == null || !col.isNative()) continue;
            List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
            for (MetaGRdbPropertyStore.GRdbPropertyStoreHandler c : cols) {
                sb.append(',');
                sb.append(c.getMetaData().getColumnName());
            }
        }
    }

    private void addCol(StringBuilder sb, String prefix, String postFix, int count) {
        for (int i = 1; i <= count; ++i) {
            sb.append(',');
            sb.append(prefix).append(i);
            if (postFix == null) continue;
            sb.append(postFix);
        }
    }

    public String copyDataFromRB(int tenantId, EntityHandler eh, Long rbid, RdbAdapter rdb, EntityContext context, StorageSpaceMap ssmap) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE());
        sb.append("(");
        this.appendAllDataCols(sb, ssmap, eh);
        sb.append(") SELECT ");
        this.appendAllDataCols(sb, ssmap, eh);
        sb.append(" FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE_RB());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId()));
        sb.append("' AND RB_ID=").append(rbid);
        return sb.toString();
    }

    public String deleteDataRB(int tenantId, EntityHandler eh, Long rbid, Timestamp ts, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE_RB());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId())).append("'");
        if (rbid != null) {
            sb.append(" AND RB_ID=").append(rbid);
        }
        if (ts != null) {
            sb.append(" AND RB_DATE<").append(rdb.toTimeStampExpression(ts));
        }
        return sb.toString();
    }

    public String deleteRefRB(int tenantId, EntityHandler eh, Long rbid, Timestamp ts, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_REF_RB());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId())).append("'");
        if (rbid != null) {
            sb.append(" AND RB_ID=").append(rbid);
        }
        if (ts != null) {
            sb.append(" AND RB_ID IN (SELECT ").append("RB_ID FROM ");
            sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE_RB());
            sb.append(" WHERE ");
            sb.append("TENANT_ID=").append(tenantId);
            sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId())).append("'");
            if (ts != null) {
                sb.append(" AND RB_DATE<").append(rdb.toTimeStampExpression(ts));
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String copyRefToRB(int tenantId, long rbid, EntityHandler eh, String oid, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ").append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_REF_RB());
        sb.append("(").append("RB_ID").append(",");
        this.appendAllRefCols(sb);
        sb.append(") SELECT ");
        sb.append(rbid).append(",");
        this.appendAllRefCols(sb);
        sb.append(" FROM ").append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_REF());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId()));
        sb.append("' AND OBJ_ID='").append(rdb.sanitize(oid)).append("'");
        return sb.toString();
    }

    private void appendAllRefCols(StringBuilder sb) {
        sb.append("TENANT_ID,OBJ_DEF_ID,REF_DEF_ID,OBJ_ID,OBJ_VER,TARGET_OBJ_DEF_ID,TARGET_OBJ_ID,TARGET_OBJ_VER");
    }

    public String copyRefFromRB(int tenantId, long rbid, EntityHandler eh, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_REF());
        sb.append("(");
        this.appendAllRefCols(sb);
        sb.append(") SELECT ");
        this.appendAllRefCols(sb);
        sb.append(" FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_REF_RB());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId()));
        sb.append("' AND RB_ID=").append(rbid);
        return sb.toString();
    }

    public String lockData(int tenantId, EntityHandler eh, Long rbid, Timestamp ts, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,OBJ_DEF_ID,RB_ID,OBJ_ID,OBJ_VER FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE_RB());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId())).append("'");
        if (rbid != null) {
            sb.append(" AND RB_ID=").append(rbid);
        }
        if (ts != null) {
            sb.append(" AND RB_DATE<").append(rdb.toTimeStampExpression(ts));
        }
        return rdb.createRowLockSql(sb.toString());
    }

    public String searchRB(int tenantId, EntityHandler eh, Long rbid, RdbAdapter rdb) {
        return this.searchRB(tenantId, eh, rbid, null, rdb);
    }

    public String searchRB(int tenantId, EntityHandler eh, Long rbid, Timestamp ts, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT TENANT_ID,OBJ_DEF_ID,RB_ID,OBJ_ID,OBJ_NAME,RB_DATE,RB_USER FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE_RB());
        sb.append(" A WHERE ");
        sb.append("TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId())).append("'");
        if (rbid != null) {
            sb.append(" AND RB_ID=").append(rbid);
        }
        if (ts != null) {
            sb.append(" AND RB_DATE<").append(rdb.toTimeStampExpression(ts));
        }
        sb.append(" AND PG_NO=0");
        sb.append(" AND OBJ_VER=(SELECT MAX(OBJ_VER) FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE_RB());
        sb.append(" WHERE TENANT_ID=A.TENANT_ID AND OBJ_DEF_ID=A.OBJ_DEF_ID AND RB_ID=A.RB_ID AND OBJ_ID=A.OBJ_ID)");
        sb.append(" ORDER BY RB_ID DESC");
        return sb.toString();
    }

    public String count(String sql) {
        return "SELECT COUNT(*) FROM (" + sql + ") CT";
    }

    public String deleteDataRB(int tenantId, String defId, String tableNamePostfix, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(MetaGRdbEntityStore.makeObjRbTableName(tableNamePostfix));
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(defId)).append("'");
        return sb.toString();
    }

    public String deleteRefRB(int tenantId, String defId, String tableNamePostfix, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(MetaGRdbEntityStore.makeObjRefRbTableName(tableNamePostfix));
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(defId)).append("'");
        return sb.toString();
    }

    public String deleteRefRBByTargetDefId(int tenantId, String targetDefId, String tableNamePostfix, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(MetaGRdbEntityStore.makeObjRefRbTableName(tableNamePostfix));
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND TARGET_OBJ_DEF_ID='").append(rdb.sanitize(targetDefId)).append("'");
        return sb.toString();
    }

    public String deleteForDefragRB(int tenantId, EntityHandler eh, List<String> refPropertyIds, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_REF_RB());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId())).append("'");
        if (!refPropertyIds.isEmpty()) {
            sb.append(" AND REF_DEF_ID NOT IN (");
            boolean isFirst = true;
            for (String refProperty : refPropertyIds) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(",");
                }
                sb.append("'").append(rdb.sanitize(refProperty)).append("'");
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

