/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql.queryconvert;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.From;
import org.iplass.mtp.entity.query.GroupBy;
import org.iplass.mtp.entity.query.Having;
import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.QueryVisitorSupport;
import org.iplass.mtp.entity.query.Refer;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.expr.Not;
import org.iplass.mtp.entity.query.condition.expr.Or;
import org.iplass.mtp.entity.query.condition.expr.Paren;
import org.iplass.mtp.entity.query.condition.predicate.Between;
import org.iplass.mtp.entity.query.condition.predicate.Contains;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.Greater;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.condition.predicate.IsNotNull;
import org.iplass.mtp.entity.query.condition.predicate.IsNull;
import org.iplass.mtp.entity.query.condition.predicate.Lesser;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.entity.query.condition.predicate.Like;
import org.iplass.mtp.entity.query.condition.predicate.NotEquals;
import org.iplass.mtp.entity.query.hint.BindHint;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.HintComment;
import org.iplass.mtp.entity.query.hint.IndexHint;
import org.iplass.mtp.entity.query.hint.NativeHint;
import org.iplass.mtp.entity.query.hint.NoBindHint;
import org.iplass.mtp.entity.query.hint.NoIndexHint;
import org.iplass.mtp.entity.query.value.RowValueList;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.aggregate.Aggregate;
import org.iplass.mtp.entity.query.value.aggregate.Avg;
import org.iplass.mtp.entity.query.value.aggregate.Count;
import org.iplass.mtp.entity.query.value.aggregate.Listagg;
import org.iplass.mtp.entity.query.value.aggregate.Max;
import org.iplass.mtp.entity.query.value.aggregate.Median;
import org.iplass.mtp.entity.query.value.aggregate.Min;
import org.iplass.mtp.entity.query.value.aggregate.Mode;
import org.iplass.mtp.entity.query.value.aggregate.StdDevPop;
import org.iplass.mtp.entity.query.value.aggregate.StdDevSamp;
import org.iplass.mtp.entity.query.value.aggregate.Sum;
import org.iplass.mtp.entity.query.value.aggregate.VarPop;
import org.iplass.mtp.entity.query.value.aggregate.VarSamp;
import org.iplass.mtp.entity.query.value.aggregate.WithinGroup;
import org.iplass.mtp.entity.query.value.aggregate.WithinGroupSortSpec;
import org.iplass.mtp.entity.query.value.controlflow.Case;
import org.iplass.mtp.entity.query.value.controlflow.Else;
import org.iplass.mtp.entity.query.value.controlflow.When;
import org.iplass.mtp.entity.query.value.expr.MinusSign;
import org.iplass.mtp.entity.query.value.expr.Polynomial;
import org.iplass.mtp.entity.query.value.expr.Term;
import org.iplass.mtp.entity.query.value.primary.ArrayValue;
import org.iplass.mtp.entity.query.value.primary.Cast;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.entity.query.value.primary.ParenValue;
import org.iplass.mtp.entity.query.value.subquery.ScalarSubQuery;
import org.iplass.mtp.entity.query.value.window.CumeDist;
import org.iplass.mtp.entity.query.value.window.DenseRank;
import org.iplass.mtp.entity.query.value.window.PartitionBy;
import org.iplass.mtp.entity.query.value.window.PercentRank;
import org.iplass.mtp.entity.query.value.window.Rank;
import org.iplass.mtp.entity.query.value.window.RowNumber;
import org.iplass.mtp.entity.query.value.window.WindowAggregate;
import org.iplass.mtp.entity.query.value.window.WindowOrderBy;
import org.iplass.mtp.entity.query.value.window.WindowRankFunction;
import org.iplass.mtp.entity.query.value.window.WindowSortSpec;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.sql.ToSqlResult;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.MultiPageChecker;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.RefTrimmer;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlQueryContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.AggregateFunctionAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public class SqlConverter
extends QueryVisitorSupport {
    private static final String INDEX_TABLE_ALIAS = "it";
    private RdbAdapter rdbAdaptor;
    private SqlQueryContext context;
    private ArrayList<ASTNode> astNodeStack;
    private boolean treatBindHint;

    public SqlConverter(SqlQueryContext context, boolean treatBindHint) {
        this.rdbAdaptor = context.getRdb();
        this.context = context;
        boolean bl = this.treatBindHint = treatBindHint && this.rdbAdaptor.isEnableBindHint();
        if (!this.rdbAdaptor.isUseSubQueryForIndexJoin()) {
            this.astNodeStack = new ArrayList();
        }
    }

    private void push(ASTNode astNode) {
        if (!this.rdbAdaptor.isUseSubQueryForIndexJoin()) {
            this.astNodeStack.add(astNode);
        }
    }

    private void pop(ASTNode astNode) {
        ASTNode removed;
        if (!this.rdbAdaptor.isUseSubQueryForIndexJoin() && (removed = this.astNodeStack.remove(this.astNodeStack.size() - 1)) != astNode) {
            throw new IllegalStateException("astNode stack is confused...:" + String.valueOf(astNode));
        }
    }

    @Override
    public boolean visit(From from) {
        this.push(from);
        try {
            this.context.setFrom(from.getEntityName());
            boolean bl = true;
            return bl;
        }
        finally {
            this.pop(from);
        }
    }

    @Override
    public boolean visit(Query query) {
        this.push(query);
        try {
            boolean bl = super.visit(query);
            return bl;
        }
        finally {
            this.pop(query);
        }
    }

    @Override
    public boolean visit(ArrayValue arrayValue) {
        this.push(arrayValue);
        try {
            boolean bl = super.visit(arrayValue);
            return bl;
        }
        finally {
            this.pop(arrayValue);
        }
    }

    @Override
    public boolean visit(Contains contains) {
        this.push(contains);
        try {
            boolean bl = super.visit(contains);
            return bl;
        }
        finally {
            this.pop(contains);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(Select select) {
        this.push(select);
        try {
            if (select.getHintComment() != null) {
                select.getHintComment().accept(this);
            }
            this.context.changeCurrentClause(SqlQueryContext.Clause.SELECT);
            int colCount = 1;
            if (select.isDistinct()) {
                this.context.append("DISTINCT ");
            }
            boolean isFirst = true;
            for (ValueExpression selectVal : select.getSelectValues()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.context.append(",");
                }
                if (selectVal instanceof EntityField) {
                    EntityField entityField = (EntityField)selectVal;
                    PropertyHandler pDef = this.context.getProperty(entityField.getPropertyName());
                    if (pDef == null) {
                        throw new QueryException("not define property:" + String.valueOf(entityField));
                    }
                    this.context.notifyUsedPropertyName(entityField.getPropertyName());
                    GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)pDef.getStoreSpecProperty());
                    if (col == null) {
                        throw new QueryException("Reference property:" + String.valueOf(entityField) + " itself can not be specified in select clause. Specify " + String.valueOf(entityField) + ".oid or other.");
                    }
                    String[] castExp = this.castExp(pDef);
                    List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> colList = col.asList();
                    for (int i = 0; i < colList.size(); ++i) {
                        if (i != 0) {
                            this.context.append(",");
                        }
                        if (castExp != null) {
                            this.context.getCurrentSb().append(castExp[0]);
                        }
                        this.colExp(this.context.getCurrentSb(), entityField.getPropertyName(), colList.get(i), this.context.isTreatSelectAsRawValue());
                        if (castExp != null) {
                            this.context.getCurrentSb().append(castExp[1]);
                        }
                        this.context.append(" as c" + colCount);
                        ++colCount;
                    }
                    continue;
                }
                if (this.context.isTreatSelectAsRawValue()) {
                    PropertyType type = this.context.getValueTypeResolver().resolve(selectVal);
                    BaseRdbTypeAdapter typeAdapter = this.context.getRdb().getRdbTypeAdapter(type);
                    typeAdapter.appendToTypedCol(this.context.getCurrentSb(), this.rdbAdaptor, () -> selectVal.accept(this));
                } else {
                    selectVal.accept(this);
                }
                this.context.append(" as c" + colCount);
                ++colCount;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(select);
        }
    }

    @Override
    public boolean visit(Where where) {
        this.push(where);
        try {
            this.context.changeCurrentClause(SqlQueryContext.Clause.WHERE);
            boolean bl = true;
            return bl;
        }
        finally {
            this.pop(where);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(Literal literal) {
        this.push(literal);
        try {
            BaseRdbTypeAdapter type = this.rdbAdaptor.getRdbTypeAdapter(literal.getValue());
            if (literal.getValue() != null && this.context.isEnableBindVariable() && literal.isBindable()) {
                type.appendParameterPlaceholder(this.context.getCurrentSb(), this.rdbAdaptor);
                this.context.addBindVariable(literal.getValue(), type);
            } else {
                type.appendToSqlAsRealType(literal.getValue(), this.context.getCurrentSb(), this.rdbAdaptor);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.pop(literal);
        }
    }

    private void colExp(StringBuilder sb, String propName, MetaGRdbPropertyStore.GRdbPropertyStoreHandler col, boolean treatAsRawValue) {
        if (treatAsRawValue || col.isNative()) {
            String colPrefix = this.context.getColPrefix(propName, col);
            sb.append(colPrefix);
            if (col.getIndexColName() != null && this.context.checkIndexHint(propName, false)) {
                sb.append(col.getIndexColName());
            } else {
                sb.append(col.getMetaData().getColumnName());
            }
        } else {
            col.getSingleColumnRdbTypeAdapter().appendFromTypedCol(sb, this.rdbAdaptor, () -> this.colExp(sb, propName, col, true));
        }
    }

    private String[] castExp(PropertyHandler pDef) {
        GRdbPropertyStoreRuntime col;
        String[] castExp = null;
        if (!(this.context.getCurrentClause() != SqlQueryContext.Clause.SELECT && this.context.getCurrentClause() != SqlQueryContext.Clause.ORDERBYGROUPBY || this.context.getStringTypeLengthOnQuery() == null || (col = (GRdbPropertyStoreRuntime)((Object)pDef.getStoreSpecProperty())).isNative() || col.getSingleColumnRdbTypeAdapter().sqlType() != 12 || pDef.getEnumType() == PropertyDefinitionType.BINARY || pDef.getEnumType() == PropertyDefinitionType.LONGTEXT)) {
            castExp = this.context.getRdb().castExp(12, this.context.getStringTypeLengthOnQuery(), null);
        }
        return castExp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(EntityField entityField) {
        this.push(entityField);
        try {
            PropertyHandler pDef = this.context.getProperty(entityField.getPropertyName());
            if (pDef == null) {
                throw new QueryException("not define property:" + String.valueOf(entityField));
            }
            this.context.notifyUsedPropertyName(entityField.getPropertyName());
            GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)pDef.getStoreSpecProperty());
            if (col == null) {
                throw new QueryException("Reference property:" + String.valueOf(entityField) + " itself can not be specified. Specify " + String.valueOf(entityField) + ".oid or other.");
            }
            String[] castExp = this.castExp(pDef);
            List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
            for (int i = 0; i < cols.size(); ++i) {
                if (i != 0) {
                    this.context.append(",");
                }
                if (castExp != null) {
                    this.context.getCurrentSb().append(castExp[0]);
                }
                this.colExp(this.context.getCurrentSb(), entityField.getPropertyName(), cols.get(i), false);
                if (castExp == null) continue;
                this.context.getCurrentSb().append(castExp[1]);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.pop(entityField);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(RowValueList rowValueList) {
        this.push(rowValueList);
        try {
            this.context.append("(");
            boolean isFirst = true;
            for (ValueExpression e : rowValueList.getRowValues()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.context.append(",");
                }
                e.accept(this);
            }
            this.context.append(")");
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(rowValueList);
        }
    }

    @Override
    public boolean visit(Count count) {
        this.push(count);
        try {
            this.aggregateFunction(count);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(count);
        }
    }

    private void aggregateFunction(Aggregate agg) {
        AggregateFunctionAdapter<?> fa = this.rdbAdaptor.resolveAggregateFunction(agg.getClass());
        if (fa == null) {
            throw new QueryException(agg.getClass().getSimpleName() + " not supported.");
        }
        fa.toSQL(new FunctionAdapter.FunctionContext(){

            @Override
            public void appendArgument(ValueExpression arg) {
                arg.accept(SqlConverter.this);
            }

            @Override
            public void append(String str) {
                SqlConverter.this.context.append(str);
            }
        }, agg, this.rdbAdaptor);
    }

    private void simpleAggregateFunction(Aggregate agg) {
        String funcName = this.rdbAdaptor.aggregateFunctionName(agg);
        this.context.append(funcName);
        this.context.append("(");
        agg.getValue().accept(this);
        this.context.append(")");
    }

    @Override
    public boolean visit(Sum sum) {
        this.push(sum);
        try {
            this.simpleAggregateFunction(sum);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(sum);
        }
    }

    @Override
    public boolean visit(Avg avg) {
        this.push(avg);
        try {
            this.simpleAggregateFunction(avg);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(avg);
        }
    }

    @Override
    public boolean visit(Max max) {
        this.push(max);
        try {
            this.simpleAggregateFunction(max);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(max);
        }
    }

    @Override
    public boolean visit(Min min) {
        this.push(min);
        try {
            this.simpleAggregateFunction(min);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(min);
        }
    }

    @Override
    public boolean visit(StdDevPop stdDevPop) {
        this.push(stdDevPop);
        try {
            this.simpleAggregateFunction(stdDevPop);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(stdDevPop);
        }
    }

    @Override
    public boolean visit(StdDevSamp stdDevSamp) {
        this.push(stdDevSamp);
        try {
            this.simpleAggregateFunction(stdDevSamp);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(stdDevSamp);
        }
    }

    @Override
    public boolean visit(VarPop varPop) {
        this.push(varPop);
        try {
            this.simpleAggregateFunction(varPop);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(varPop);
        }
    }

    @Override
    public boolean visit(VarSamp varSamp) {
        this.push(varSamp);
        try {
            this.simpleAggregateFunction(varSamp);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(varSamp);
        }
    }

    @Override
    public boolean visit(Mode mode) {
        this.push(mode);
        try {
            this.simpleAggregateFunction(mode);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(mode);
        }
    }

    @Override
    public boolean visit(Median median) {
        this.push(median);
        try {
            this.simpleAggregateFunction(median);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(median);
        }
    }

    @Override
    public boolean visit(Listagg listagg) {
        this.push(listagg);
        try {
            this.aggregateFunction(listagg);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(listagg);
        }
    }

    @Override
    public boolean visit(WithinGroup withinGroup) {
        return false;
    }

    @Override
    public boolean visit(WithinGroupSortSpec sortSpec) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(Polynomial polynomial) {
        this.push(polynomial);
        try {
            ValueExpression child;
            int i;
            if (polynomial.getAddValues() != null) {
                for (i = 0; i < polynomial.getAddValues().size(); ++i) {
                    if (i != 0) {
                        this.context.append("+");
                    }
                    child = polynomial.getAddValues().get(i);
                    child.accept(this);
                }
            }
            if (polynomial.getSubValues() != null) {
                for (i = 0; i < polynomial.getSubValues().size(); ++i) {
                    this.context.append("-");
                    child = polynomial.getSubValues().get(i);
                    child.accept(this);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(polynomial);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(Term term) {
        this.push(term);
        try {
            ValueExpression child;
            int i;
            if (term.getMulValues() != null) {
                for (i = 0; i < term.getMulValues().size(); ++i) {
                    if (i != 0) {
                        this.context.append("*");
                    }
                    child = term.getMulValues().get(i);
                    child.accept(this);
                }
            } else {
                this.context.append("1");
            }
            if (term.getDivValues() != null) {
                for (i = 0; i < term.getDivValues().size(); ++i) {
                    this.context.append("/");
                    child = term.getDivValues().get(i);
                    child.accept(this);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(term);
        }
    }

    @Override
    public boolean visit(MinusSign minusSign) {
        this.push(minusSign);
        try {
            if (minusSign.getValue() != null) {
                this.context.append("-");
                minusSign.getValue().accept(this);
                boolean bl = false;
                return bl;
            }
            throw new QueryException("Cannt convert MinusSign because value is null.");
        }
        finally {
            this.pop(minusSign);
        }
    }

    @Override
    public boolean visit(ParenValue parenthesizedValue) {
        this.push(parenthesizedValue);
        try {
            if (parenthesizedValue.getNestedValue() != null) {
                this.context.append("(");
                parenthesizedValue.getNestedValue().accept(this);
                this.context.append(")");
                boolean bl = false;
                return bl;
            }
            throw new QueryException("Cannt convert BracketValue because nestedValue  is null.");
        }
        finally {
            this.pop(parenthesizedValue);
        }
    }

    @Override
    public boolean visit(And andExpression) {
        this.push(andExpression);
        try {
            if (andExpression.getChildExpressions() != null) {
                for (int i = 0; i < andExpression.getChildExpressions().size(); ++i) {
                    if (i != 0) {
                        this.context.append(" AND ");
                    }
                    Condition child = andExpression.getChildExpressions().get(i);
                    child.accept(this);
                }
                boolean bl = false;
                return bl;
            }
            throw new QueryException("Cannt convert AndExpression because child is null.");
        }
        finally {
            this.pop(andExpression);
        }
    }

    @Override
    public boolean visit(Or orExpression) {
        this.push(orExpression);
        try {
            if (orExpression.getChildExpressions() != null) {
                for (int i = 0; i < orExpression.getChildExpressions().size(); ++i) {
                    if (i != 0) {
                        this.context.append(" OR ");
                    }
                    Condition child = orExpression.getChildExpressions().get(i);
                    child.accept(this);
                }
                boolean bl = false;
                return bl;
            }
            throw new QueryException("Cannt convert OrExpression because child is null.");
        }
        finally {
            this.pop(orExpression);
        }
    }

    @Override
    public boolean visit(Equals equalsExpression) {
        this.push(equalsExpression);
        try {
            if (!(equalsExpression.getProperty() instanceof EntityField) && equalsExpression.getValue() instanceof EntityField) {
                this.simpleOp(equalsExpression.getValue(), "=", equalsExpression.getProperty(), true);
            } else {
                this.simpleOp(equalsExpression.getProperty(), "=", equalsExpression.getValue(), true);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(equalsExpression);
        }
    }

    @Override
    public boolean visit(NotEquals notEqualsExpression) {
        this.push(notEqualsExpression);
        try {
            if (!(notEqualsExpression.getProperty() instanceof EntityField) && notEqualsExpression.getValue() instanceof EntityField) {
                this.simpleOp(notEqualsExpression.getValue(), "!=", notEqualsExpression.getProperty(), false);
            } else {
                this.simpleOp(notEqualsExpression.getProperty(), "!=", notEqualsExpression.getValue(), false);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(notEqualsExpression);
        }
    }

    @Override
    public boolean visit(Greater greaterExpression) {
        this.push(greaterExpression);
        try {
            if (!(greaterExpression.getProperty() instanceof EntityField) && greaterExpression.getValue() instanceof EntityField) {
                this.simpleOp(greaterExpression.getValue(), "<", greaterExpression.getProperty(), true);
            } else {
                this.simpleOp(greaterExpression.getProperty(), ">", greaterExpression.getValue(), true);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(greaterExpression);
        }
    }

    @Override
    public boolean visit(GreaterEqual greaterEqualExpression) {
        this.push(greaterEqualExpression);
        try {
            if (!(greaterEqualExpression.getProperty() instanceof EntityField) && greaterEqualExpression.getValue() instanceof EntityField) {
                this.simpleOp(greaterEqualExpression.getValue(), "<=", greaterEqualExpression.getProperty(), true);
            } else {
                this.simpleOp(greaterEqualExpression.getProperty(), ">=", greaterEqualExpression.getValue(), true);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(greaterEqualExpression);
        }
    }

    @Override
    public boolean visit(Lesser lesserExpression) {
        this.push(lesserExpression);
        try {
            if (!(lesserExpression.getProperty() instanceof EntityField) && lesserExpression.getValue() instanceof EntityField) {
                this.simpleOp(lesserExpression.getValue(), ">", lesserExpression.getProperty(), true);
            } else {
                this.simpleOp(lesserExpression.getProperty(), "<", lesserExpression.getValue(), true);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(lesserExpression);
        }
    }

    @Override
    public boolean visit(LesserEqual lesserEqualExpression) {
        this.push(lesserEqualExpression);
        try {
            if (!(lesserEqualExpression.getProperty() instanceof EntityField) && lesserEqualExpression.getValue() instanceof EntityField) {
                this.simpleOp(lesserEqualExpression.getValue(), ">=", lesserEqualExpression.getProperty(), true);
            } else {
                this.simpleOp(lesserEqualExpression.getProperty(), "<=", lesserEqualExpression.getValue(), true);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(lesserEqualExpression);
        }
    }

    private void simpleOp(ValueExpression propVal, String op, ValueExpression val, boolean isAny) {
        if (propVal instanceof EntityField) {
            String propName = ((EntityField)propVal).getPropertyName();
            this.context.notifyUsedPropertyName(propName);
            PropertyHandler prop = this.context.getProperty(propName);
            if (prop == null) {
                throw new NullPointerException(this.context.getFromEntity().getMetaData().getName() + "." + propName + " is not defined..");
            }
            GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)prop.getStoreSpecProperty());
            if (col == null) {
                throw new QueryException("Reference property:" + propName + " itself can not be specified. Specify " + propName + ".oid or other.");
            }
            if (prop.getMetaData().getMultiplicity() > 1) {
                this.context.append("(");
                if (val instanceof ArrayValue) {
                    ArrayValue array = (ArrayValue)val;
                    int loops = prop.getMetaData().getMultiplicity();
                    if (array.getValues() != null && array.getValues().size() < loops) {
                        loops = array.getValues().size();
                    }
                    List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
                    for (int i = 0; i < loops; ++i) {
                        if (i != 0) {
                            this.context.append(" AND ");
                        }
                        this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                        this.context.append(op);
                        this.valueConvert(array.getValues().get(i), col.getSingleColumnRdbTypeAdapter(), false);
                    }
                } else {
                    List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
                    for (int i = 0; i < cols.size(); ++i) {
                        if (i != 0) {
                            if (isAny) {
                                this.context.append(" OR ");
                            } else {
                                this.context.append(" AND ");
                            }
                        }
                        this.context.append("(");
                        this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                        this.context.append(op);
                        this.valueConvert(val, col.getSingleColumnRdbTypeAdapter(), false);
                        if (isAny) {
                            this.context.append(" AND ");
                        } else {
                            this.context.append(" OR ");
                        }
                        this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                        if (isAny) {
                            this.context.append(" IS NOT NULL)");
                            continue;
                        }
                        this.context.append(" IS NULL)");
                    }
                }
                this.context.append(")");
            } else if (this.useExternalIndex(prop, propName)) {
                this.externalIndexedSql(propName, (PrimitivePropertyHandler)prop, tableName -> {
                    this.context.append((CharSequence)tableName).append(".VAL").append(op);
                    this.valueConvert(val, col.getSingleColumnRdbTypeAdapter(), true);
                });
            } else {
                this.internalIndexedSql(propName, (PrimitivePropertyHandler)prop, false, () -> {
                    if (val instanceof EntityField) {
                        String valPropName = ((EntityField)val).getPropertyName();
                        this.context.notifyUsedPropertyName(valPropName);
                        PropertyHandler valProp = this.context.getProperty(valPropName);
                        if (valProp == null) {
                            throw new NullPointerException(this.context.getFromEntity().getMetaData().getName() + "." + valPropName + " is not defined..");
                        }
                        GRdbPropertyStoreRuntime valCol = (GRdbPropertyStoreRuntime)((Object)valProp.getStoreSpecProperty());
                        if (valCol == null) {
                            throw new QueryException("Reference property:" + valPropName + " itself can not be specified. Specify " + valPropName + ".oid or other.");
                        }
                        this.internalIndexedSql(valPropName, (PrimitivePropertyHandler)valProp, false, () -> {
                            this.colExp(this.context.getCurrentSb(), propName, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, true);
                            this.context.append(op);
                            this.colExp(this.context.getCurrentSb(), valPropName, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)valCol, true);
                        });
                    } else {
                        this.colExp(this.context.getCurrentSb(), propName, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, true);
                        this.context.append(op);
                        if (col.isNative()) {
                            this.valueConvert(val, col.getSingleColumnRdbTypeAdapter(), false);
                        } else {
                            this.valueConvert(val, col.getSingleColumnRdbTypeAdapter(), true);
                        }
                    }
                });
            }
        } else {
            propVal.accept(this);
            this.context.append(op);
            PropertyType type = this.context.getValueTypeResolver().resolve(propVal);
            this.valueConvert(val, this.context.getRdb().getRdbTypeAdapter(type), false);
        }
    }

    private void internalIndexedSql(String propName, PrimitivePropertyHandler prop, boolean isNullOp, Runnable callback) {
        boolean useIndexCol;
        MetaGRdbPropertyStore.GRdbPropertyStoreHandler col = (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)prop.getStoreSpecProperty();
        boolean bl = useIndexCol = col.getIndexColName() != null && this.context.checkIndexHint(propName, false) && !isNullOp && this.context.getCurrentClause() == SqlQueryContext.Clause.WHERE;
        if (useIndexCol) {
            this.context.append("(");
            String colPrefix = this.context.getColPrefix(propName, col);
            this.context.append(colPrefix);
            this.context.append(col.getIndexColName());
            this.context.append("_TD");
            this.context.append("='");
            this.context.append(MetaGRdbPropertyStore.makeInternalIndexKey(this.context.getMetaContext().getTenantId(prop.getParent()), prop.getParent().getMetaData().getId(), col.getMetaData().getIndexPageNo()));
            this.context.append("'");
            this.context.append(" AND ");
        }
        callback.run();
        if (useIndexCol) {
            this.context.append(")");
        }
    }

    private boolean canUseIndexTableJoin() {
        ASTNode n;
        for (int i = this.astNodeStack.size() - 1; i >= 0 && !((n = this.astNodeStack.get(i)) instanceof Where); --i) {
            if (!(n instanceof Or) && !(n instanceof Not)) continue;
            return false;
        }
        return true;
    }

    private boolean useExternalIndex(PropertyHandler prop, String fullPropName) {
        return prop.isIndexed() && prop instanceof PrimitivePropertyHandler && this.context.isUseIndexTable() && !((GRdbPropertyStoreRuntime)((Object)prop.getStoreSpecProperty())).isNative() && ((GRdbPropertyStoreRuntime)((Object)prop.getStoreSpecProperty())).isExternalIndex() && this.context.checkIndexHint(fullPropName, true) && (this.rdbAdaptor.isUseSubQueryForIndexJoin() || this.canUseIndexTableJoin());
    }

    private void externalIndexedSql(String propName, PrimitivePropertyHandler prop, Consumer<String> callback) {
        MetaGRdbPropertyStore.GRdbPropertyStoreHandler propertyStoreHanlder = (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)prop.getStoreSpecProperty();
        String tableName = null;
        tableName = prop.getMetaData().getIndexType() == IndexType.NON_UNIQUE ? ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)prop.getParent().getEntityStoreRuntime()).OBJ_INDEX(propertyStoreHanlder.getSingleColumnRdbTypeAdapter().getColOfIndex()) : ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)prop.getParent().getEntityStoreRuntime()).OBJ_UNIQUE(propertyStoreHanlder.getSingleColumnRdbTypeAdapter().getColOfIndex());
        if (this.rdbAdaptor.isUseSubQueryForIndexJoin()) {
            String colPrefix = this.context.getColPrefix(propName, propertyStoreHanlder);
            this.context.append(" EXISTS(SELECT * FROM ");
            this.context.append(tableName);
            this.context.append(" WHERE ");
            this.context.append(colPrefix);
            this.context.append("TENANT_ID=").append(tableName).append(".TENANT_ID");
            this.context.append(" AND ");
            this.context.append(colPrefix);
            this.context.append("OBJ_DEF_ID=").append(tableName).append(".OBJ_DEF_ID");
            this.context.append(" AND ");
            this.context.append(colPrefix);
            this.context.append("OBJ_ID=").append(tableName).append(".OBJ_ID");
            if (prop.getMetaData().getIndexType() == IndexType.NON_UNIQUE) {
                this.context.append(" AND ");
                this.context.append(colPrefix);
                this.context.append("OBJ_VER=").append(tableName).append(".OBJ_VER");
            }
            this.context.append(" AND ");
            this.context.append(tableName).append(".OBJ_DEF_ID='").append(prop.getParent().getMetaData().getId()).append("'");
            this.context.append(" AND ");
            this.context.append(tableName).append(".COL_NAME='").append(propertyStoreHanlder.getExternalIndexColName());
            this.context.append("' AND ");
            callback.accept(tableName);
            this.context.append(")");
        } else {
            StringBuilder indexTableSb = new StringBuilder();
            indexTableSb.append("(SELECT ").append(INDEX_TABLE_ALIAS).append(".* FROM ").append(tableName).append(" ").append(INDEX_TABLE_ALIAS);
            indexTableSb.append(" WHERE ");
            indexTableSb.append(INDEX_TABLE_ALIAS).append(".TENANT_ID=").append(this.context.getMetaContext().getTenantId(prop.getParent()));
            indexTableSb.append(" AND ");
            indexTableSb.append(INDEX_TABLE_ALIAS).append(".OBJ_DEF_ID='").append(prop.getParent().getMetaData().getId()).append("'");
            indexTableSb.append(" AND ");
            indexTableSb.append(INDEX_TABLE_ALIAS).append(".COL_NAME='").append(propertyStoreHanlder.getExternalIndexColName());
            indexTableSb.append("' AND (");
            SqlQueryContext referContext = new SqlQueryContext(this.context.getFromEntity(), this.context.getMetaContext(), this.rdbAdaptor, this.context.getPrefix(), this.context.getAliases(), this.context.getJoinPath(), this.context.getIndexTable(), this.context.isEnableBindVariable());
            referContext.setUseIndexTable(false);
            SqlQueryContext mainContext = this.context;
            this.context = referContext;
            this.context.changeCurrentClause(SqlQueryContext.Clause.WHERE);
            callback.accept(INDEX_TABLE_ALIAS);
            if (referContext.getCurrentClause() != SqlQueryContext.Clause.WHERE) {
                referContext.changeCurrentClause(SqlQueryContext.Clause.WHERE);
            }
            this.context = mainContext;
            indexTableSb.append(referContext.getCurrentSb().toString());
            indexTableSb.append("))");
            String indexTableAlias = this.context.addIndexTable(indexTableSb.toString());
            String colPrefix = this.context.getColPrefix(propName, propertyStoreHanlder);
            this.context.append(" (");
            this.context.append(colPrefix);
            this.context.append("TENANT_ID=").append(indexTableAlias).append(".TENANT_ID");
            this.context.append(" AND ");
            this.context.append(colPrefix);
            this.context.append("OBJ_DEF_ID=").append(indexTableAlias).append(".OBJ_DEF_ID");
            this.context.append(" AND ");
            this.context.append(colPrefix);
            this.context.append("OBJ_ID=").append(indexTableAlias).append(".OBJ_ID");
            if (prop.getMetaData().getIndexType() == IndexType.NON_UNIQUE) {
                this.context.append(" AND ");
                this.context.append(colPrefix);
                this.context.append("OBJ_VER=").append(indexTableAlias).append(".OBJ_VER");
            }
            this.context.append(")");
            List<ToSqlResult.BindValue> indexTableBindVarialbes = referContext.toOrderedBindVariables(false);
            if (indexTableBindVarialbes != null && indexTableBindVarialbes.size() > 0) {
                this.context.setEnableBindVariable(true);
                for (ToSqlResult.BindValue b : indexTableBindVarialbes) {
                    ((SqlQueryContext.QueryBindValue)b).inIndexTable = true;
                    ((SqlQueryContext.QueryBindValue)b).clause = this.context.getCurrentClause();
                    this.context.getBindVariables().add(b);
                }
            }
        }
    }

    private void valueConvert(ValueExpression val, BaseRdbTypeAdapter typeAdapter, boolean adaptToRawColValue) {
        if (adaptToRawColValue) {
            typeAdapter.appendToTypedCol(this.context.getCurrentSb(), this.rdbAdaptor, () -> val.accept(this));
        } else {
            val.accept(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(Between betweenExpression) {
        this.push(betweenExpression);
        try {
            ValueExpression propVal = betweenExpression.getProperty();
            if (propVal instanceof EntityField) {
                String propName = betweenExpression.getPropertyName();
                this.context.notifyUsedPropertyName(propName);
                PropertyHandler prop = this.context.getProperty(propName);
                if (prop == null) {
                    throw new NullPointerException(propName + " is not defined..");
                }
                GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)prop.getStoreSpecProperty());
                if (col == null) {
                    throw new QueryException("Reference property:" + propName + " itself can not be specified. Specify " + propName + ".oid or other.");
                }
                if (prop.getMetaData().getMultiplicity() > 1) {
                    this.context.append("(");
                    List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
                    for (int i = 0; i < cols.size(); ++i) {
                        if (i != 0) {
                            this.context.append(" OR ");
                        }
                        this.context.append("(");
                        this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                        this.context.append(" BETWEEN ");
                        this.valueConvert(betweenExpression.getFrom(), col.getSingleColumnRdbTypeAdapter(), false);
                        this.context.append(" AND ");
                        this.valueConvert(betweenExpression.getTo(), col.getSingleColumnRdbTypeAdapter(), false);
                        this.context.append(" AND ");
                        this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                        this.context.append(" IS NOT NULL)");
                    }
                    this.context.append(")");
                } else if (this.useExternalIndex(prop, propName)) {
                    this.externalIndexedSql(propName, (PrimitivePropertyHandler)prop, tableName -> {
                        this.context.append((CharSequence)tableName).append(".VAL");
                        this.context.append(" BETWEEN ");
                        this.valueConvert(betweenExpression.getFrom(), col.getSingleColumnRdbTypeAdapter(), true);
                        this.context.append(" AND ");
                        this.valueConvert(betweenExpression.getTo(), col.getSingleColumnRdbTypeAdapter(), true);
                    });
                } else {
                    this.internalIndexedSql(propName, (PrimitivePropertyHandler)prop, false, () -> {
                        this.colExp(this.context.getCurrentSb(), propName, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, true);
                        this.context.append(" BETWEEN ");
                        this.valueConvert(betweenExpression.getFrom(), col.getSingleColumnRdbTypeAdapter(), !col.isNative());
                        this.context.append(" AND ");
                        this.valueConvert(betweenExpression.getTo(), col.getSingleColumnRdbTypeAdapter(), !col.isNative());
                    });
                }
            } else {
                propVal.accept(this);
                this.context.append(" BETWEEN ");
                PropertyType type = this.context.getValueTypeResolver().resolve(propVal);
                BaseRdbTypeAdapter rdbType = this.context.getRdb().getRdbTypeAdapter(type);
                this.valueConvert(betweenExpression.getFrom(), rdbType, false);
                this.context.append(" AND ");
                this.valueConvert(betweenExpression.getTo(), rdbType, false);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(betweenExpression);
        }
    }

    @Override
    public boolean visit(Paren paren) {
        this.push(paren);
        try {
            if (paren.getNestedExpression() != null) {
                this.context.append("(");
                paren.getNestedExpression().accept(this);
                this.context.append(")");
                boolean bl = false;
                return bl;
            }
            throw new QueryException("Cannt convert ParenExpression because nestedExpression  is null.");
        }
        finally {
            this.pop(paren);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(In in) {
        this.push(in);
        try {
            List<ValueExpression> propList = in.getPropertyList();
            if (propList.size() == 1) {
                ValueExpression propVal = propList.get(0);
                if (propVal instanceof EntityField) {
                    String propName = ((EntityField)propVal).getPropertyName();
                    this.context.notifyUsedPropertyName(propName);
                    PropertyHandler prop = this.context.getProperty(propName);
                    if (prop == null) {
                        throw new QueryException("not define property:" + propName);
                    }
                    GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)prop.getStoreSpecProperty());
                    if (col == null) {
                        throw new QueryException("Reference property:" + propName + " itself can not be specified in IN clause. Specify " + propName + ".oid or other.");
                    }
                    if (prop.getMetaData().getMultiplicity() > 1) {
                        this.context.append("(");
                        List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
                        for (int i = 0; i < cols.size(); ++i) {
                            if (i != 0) {
                                this.context.append(" OR ");
                            }
                            this.context.append("(");
                            if (in.getSubQuery() != null) {
                                this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                                this.context.append(" IN");
                                in.getSubQuery().accept(this);
                            } else {
                                boolean enableInPart;
                                boolean bl = enableInPart = this.rdbAdaptor.isEnableInPartitioning() && in.getValue().size() > this.rdbAdaptor.getInPartitioningSize();
                                if (enableInPart) {
                                    this.context.append("(");
                                }
                                boolean isFirst = true;
                                int partLimit = 0;
                                int offset = 0;
                                while (partLimit < in.getValue().size()) {
                                    if (isFirst) {
                                        isFirst = false;
                                        partLimit = enableInPart ? this.rdbAdaptor.getInPartitioningSize() : in.getValue().size();
                                    } else {
                                        this.context.append(" OR ");
                                        offset = partLimit;
                                        partLimit += this.rdbAdaptor.getInPartitioningSize();
                                        if (partLimit > in.getValue().size()) {
                                            partLimit = in.getValue().size();
                                        }
                                    }
                                    this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                                    this.context.append(" IN");
                                    this.context.append("(");
                                    for (int j = offset; j < partLimit; ++j) {
                                        if (j != offset) {
                                            this.context.append(",");
                                        }
                                        this.valueConvert(in.getValue().get(j), col.getSingleColumnRdbTypeAdapter(), false);
                                    }
                                    this.context.append(")");
                                }
                                if (enableInPart) {
                                    this.context.append(")");
                                }
                            }
                            this.context.append(" AND ");
                            this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                            this.context.append(" IS NOT NULL)");
                        }
                        this.context.append(")");
                    } else if (this.useExternalIndex(prop, propName)) {
                        this.externalIndexedSql(propName, (PrimitivePropertyHandler)prop, tableName -> {
                            if (in.getSubQuery() != null) {
                                this.context.append((CharSequence)tableName).append(".VAL");
                                this.context.append(" IN");
                                this.visit(in.getSubQuery(), true);
                            } else {
                                boolean enableInPart;
                                boolean bl = enableInPart = this.rdbAdaptor.isEnableInPartitioning() && in.getValue().size() > this.rdbAdaptor.getInPartitioningSize();
                                if (enableInPart) {
                                    this.context.append("(");
                                }
                                boolean isFirst = true;
                                int partLimit = 0;
                                int offset = 0;
                                while (partLimit < in.getValue().size()) {
                                    if (isFirst) {
                                        isFirst = false;
                                        partLimit = enableInPart ? this.rdbAdaptor.getInPartitioningSize() : in.getValue().size();
                                    } else {
                                        this.context.append(" OR ");
                                        offset = partLimit;
                                        partLimit += this.rdbAdaptor.getInPartitioningSize();
                                        if (partLimit > in.getValue().size()) {
                                            partLimit = in.getValue().size();
                                        }
                                    }
                                    this.context.append((CharSequence)tableName).append(".VAL");
                                    this.context.append(" IN");
                                    this.context.append("(");
                                    for (int i = offset; i < partLimit; ++i) {
                                        if (i != offset) {
                                            this.context.append(",");
                                        }
                                        this.valueConvert(in.getValue().get(i), col.getSingleColumnRdbTypeAdapter(), true);
                                    }
                                    this.context.append(")");
                                }
                                if (enableInPart) {
                                    this.context.append(")");
                                }
                            }
                        });
                    } else {
                        this.internalIndexedSql(propName, (PrimitivePropertyHandler)prop, false, () -> {
                            if (in.getSubQuery() != null) {
                                this.colExp(this.context.getCurrentSb(), propName, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, true);
                                this.context.append(" IN");
                                if (col.isNative()) {
                                    in.getSubQuery().accept(this);
                                } else {
                                    this.visit(in.getSubQuery(), true);
                                }
                            } else {
                                boolean enableInPart;
                                boolean bl = enableInPart = this.rdbAdaptor.isEnableInPartitioning() && in.getValue().size() > this.rdbAdaptor.getInPartitioningSize();
                                if (enableInPart) {
                                    this.context.append("(");
                                }
                                boolean isFirst = true;
                                int partLimit = 0;
                                int offset = 0;
                                while (partLimit < in.getValue().size()) {
                                    if (isFirst) {
                                        isFirst = false;
                                        partLimit = enableInPart ? this.rdbAdaptor.getInPartitioningSize() : in.getValue().size();
                                    } else {
                                        this.context.append(" OR ");
                                        offset = partLimit;
                                        partLimit += this.rdbAdaptor.getInPartitioningSize();
                                        if (partLimit > in.getValue().size()) {
                                            partLimit = in.getValue().size();
                                        }
                                    }
                                    this.colExp(this.context.getCurrentSb(), propName, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, true);
                                    this.context.append(" IN");
                                    this.context.append("(");
                                    for (int i = offset; i < partLimit; ++i) {
                                        if (i != offset) {
                                            this.context.append(",");
                                        }
                                        this.valueConvert(in.getValue().get(i), col.getSingleColumnRdbTypeAdapter(), !col.isNative());
                                    }
                                    this.context.append(")");
                                }
                                if (enableInPart) {
                                    this.context.append(")");
                                }
                            }
                        });
                    }
                } else if (in.getSubQuery() != null) {
                    propVal.accept(this);
                    this.context.append(" IN");
                    in.getSubQuery().accept(this);
                } else {
                    boolean enableInPart;
                    PropertyType type = this.context.getValueTypeResolver().resolve(propVal);
                    BaseRdbTypeAdapter rdbType = this.context.getRdb().getRdbTypeAdapter(type);
                    boolean bl = enableInPart = this.rdbAdaptor.isEnableInPartitioning() && in.getValue().size() > this.rdbAdaptor.getInPartitioningSize();
                    if (enableInPart) {
                        this.context.append("(");
                    }
                    boolean isFirst = true;
                    int partLimit = 0;
                    int offset = 0;
                    while (partLimit < in.getValue().size()) {
                        if (isFirst) {
                            isFirst = false;
                            partLimit = enableInPart ? this.rdbAdaptor.getInPartitioningSize() : in.getValue().size();
                        } else {
                            this.context.append(" OR ");
                            offset = partLimit;
                            partLimit += this.rdbAdaptor.getInPartitioningSize();
                            if (partLimit > in.getValue().size()) {
                                partLimit = in.getValue().size();
                            }
                        }
                        propVal.accept(this);
                        this.context.append(" IN");
                        this.context.append("(");
                        for (int i = offset; i < partLimit; ++i) {
                            if (i != offset) {
                                this.context.append(",");
                            }
                            this.valueConvert(in.getValue().get(i), rdbType, false);
                        }
                        this.context.append(")");
                    }
                    if (enableInPart) {
                        this.context.append(")");
                    }
                }
            } else if (in.getSubQuery() != null) {
                if (this.rdbAdaptor.isSupportRowValueConstructor()) {
                    this.context.append("(");
                    for (int i = 0; i < propList.size(); ++i) {
                        String propName;
                        PropertyHandler prop;
                        ValueExpression propVal;
                        if (i != 0) {
                            this.context.append(",");
                        }
                        if ((propVal = propList.get(i)) instanceof EntityField && (prop = this.context.getProperty(propName = ((EntityField)propVal).getPropertyName())).getMetaData().getMultiplicity() != 1) {
                            throw new QueryException("multi column IN clause can not use multiple valued property:" + propName);
                        }
                        propVal.accept(this);
                    }
                    this.context.append(") IN");
                    in.getSubQuery().accept(this);
                } else {
                    this.context.append("EXISTS");
                    SubQuery copySubQuery = new SubQuery(in.getSubQuery().getQuery().copy());
                    ArrayList<Condition> onCondList = new ArrayList<Condition>();
                    if (in.getSubQuery().getOn() != null) {
                        onCondList.add(in.getSubQuery().getOn());
                    }
                    ArrayList<Condition> havingCondList = new ArrayList<Condition>();
                    if (in.getSubQuery().getQuery().getHaving() != null) {
                        havingCondList.add(in.getSubQuery().getQuery().getHaving().getCondition());
                    }
                    for (int i = 0; i < propList.size(); ++i) {
                        Equals cond = null;
                        ValueExpression propVal = propList.get(i);
                        ValueExpression selectVal = in.getSubQuery().getQuery().select().getSelectValues().get(i);
                        if (propVal instanceof EntityField) {
                            String propName = ((EntityField)propVal).getPropertyName();
                            PropertyHandler prop = this.context.getProperty(propName);
                            if (prop.getMetaData().getMultiplicity() != 1) {
                                throw new QueryException("multi column IN clause can not use multiple valued property:" + propName);
                            }
                            cond = new Equals(new EntityField("." + propName), selectVal);
                        } else {
                            cond = new Equals(propVal, selectVal);
                        }
                        if (selectVal instanceof Aggregate) {
                            havingCondList.add(cond);
                            continue;
                        }
                        onCondList.add(cond);
                    }
                    Condition onCond = null;
                    if (!onCondList.isEmpty()) {
                        onCond = onCondList.size() > 1 ? new And(onCondList) : (Condition)onCondList.get(0);
                    }
                    copySubQuery.on(onCond);
                    Condition havingCond = null;
                    if (!havingCondList.isEmpty()) {
                        havingCond = havingCondList.size() > 1 ? new And(havingCondList) : (Condition)havingCondList.get(0);
                    }
                    copySubQuery.getQuery().setHaving(havingCond != null ? new Having(havingCond) : null);
                    this.visit(copySubQuery, false, true);
                }
            } else {
                boolean enableInPart;
                boolean bl = enableInPart = this.rdbAdaptor.isEnableInPartitioning() && in.getValue().size() > this.rdbAdaptor.getInPartitioningSize();
                if (enableInPart) {
                    this.context.append("(");
                }
                boolean isFirst = true;
                int partLimit = 0;
                int offset = 0;
                while (partLimit < in.getValue().size()) {
                    int i;
                    if (isFirst) {
                        isFirst = false;
                        partLimit = enableInPart ? this.rdbAdaptor.getInPartitioningSize() : in.getValue().size();
                    } else {
                        this.context.append(" OR ");
                        offset = partLimit;
                        partLimit += this.rdbAdaptor.getInPartitioningSize();
                        if (partLimit > in.getValue().size()) {
                            partLimit = in.getValue().size();
                        }
                    }
                    if (this.rdbAdaptor.isSupportRowValueConstructor()) {
                        this.context.append("(");
                        for (i = 0; i < propList.size(); ++i) {
                            String propName;
                            PropertyHandler prop;
                            ValueExpression propVal;
                            if (i != 0) {
                                this.context.append(",");
                            }
                            if ((propVal = propList.get(i)) instanceof EntityField && (prop = this.context.getProperty(propName = ((EntityField)propVal).getPropertyName())).getMetaData().getMultiplicity() != 1) {
                                throw new QueryException("multi column IN clause can not use multiple valued property:" + propName);
                            }
                            propVal.accept(this);
                        }
                        this.context.append(") IN(");
                        for (i = offset; i < partLimit; ++i) {
                            if (i != offset) {
                                this.context.append(",");
                            }
                            in.getValue().get(i).accept(this);
                        }
                        this.context.append(")");
                        continue;
                    }
                    this.context.append("(");
                    for (i = offset; i < partLimit; ++i) {
                        if (i != 0) {
                            this.context.append(" OR ");
                        }
                        ValueExpression rvl = in.getValue().get(i);
                        this.context.append("(");
                        for (int j = 0; j < propList.size(); ++j) {
                            String propName;
                            PropertyHandler prop;
                            ValueExpression propVal;
                            if (j != 0) {
                                this.context.append(" AND ");
                            }
                            if ((propVal = propList.get(j)) instanceof EntityField && (prop = this.context.getProperty(propName = ((EntityField)propVal).getPropertyName())).getMetaData().getMultiplicity() != 1) {
                                throw new QueryException("multi column IN clause can not use multiple valued property:" + propName);
                            }
                            new Equals(propVal, ((RowValueList)rvl).getRowValues().get(j)).accept(this);
                        }
                        this.context.append(")");
                    }
                    this.context.append(")");
                }
                if (enableInPart) {
                    this.context.append(")");
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(in);
        }
    }

    private void forLike(Literal pattern, Like.CaseType cs) {
        String patternStr = cs == Like.CaseType.CS ? pattern.getValue().toString() : pattern.getValue().toString().toUpperCase();
        patternStr = this.rdbAdaptor.likePattern(patternStr);
        BaseRdbTypeAdapter type = this.rdbAdaptor.getRdbTypeAdapter(patternStr);
        if (this.context.isEnableBindVariable() && pattern.isBindable()) {
            type.appendParameterPlaceholder(this.context.getCurrentSb(), this.rdbAdaptor);
            this.context.addBindVariable(patternStr, type);
        } else {
            type.appendToSqlAsRealType(patternStr, this.context.getCurrentSb(), this.rdbAdaptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(Like like) {
        this.push(like);
        try {
            ValueExpression propVal = like.getProperty();
            if (propVal instanceof EntityField) {
                String propName = like.getPropertyName();
                this.context.notifyUsedPropertyName(propName);
                PropertyHandler prop = this.context.getProperty(propName);
                if (prop == null) {
                    throw new QueryException("not define property:" + propName);
                }
                GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)prop.getStoreSpecProperty());
                if (col == null) {
                    throw new QueryException("Reference property:" + propName + " itself can not be specified in Like clause. Specify " + propName + ".oid or other.");
                }
                if (prop.getMetaData().getMultiplicity() > 1) {
                    this.context.append("(");
                    List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
                    for (int i = 0; i < cols.size(); ++i) {
                        if (i != 0) {
                            this.context.append(" OR ");
                        }
                        this.context.append("(");
                        if (like.getCaseType() == Like.CaseType.CS) {
                            this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                            this.context.append(" LIKE ");
                            this.forLike(like.getPatternAsLiteral(), like.getCaseType());
                            this.context.append(" ").append(this.rdbAdaptor.escape());
                        } else {
                            this.context.append(this.rdbAdaptor.upperFunctionName());
                            this.context.append("(");
                            this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                            this.context.append(")");
                            this.context.append(" LIKE ");
                            this.forLike(like.getPatternAsLiteral(), like.getCaseType());
                            this.context.append(" ").append(this.rdbAdaptor.escape());
                        }
                        this.context.append(" AND ");
                        this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                        this.context.append(" IS NOT NULL)");
                    }
                    this.context.append(")");
                } else if (like.getCaseType() == Like.CaseType.CS && !like.getPattern().startsWith("%") && !like.getPattern().startsWith("_")) {
                    if (this.useExternalIndex(prop, propName)) {
                        this.externalIndexedSql(propName, (PrimitivePropertyHandler)prop, tableName -> {
                            this.context.append((CharSequence)tableName).append(".VAL");
                            this.context.append(" LIKE ");
                            this.forLike(like.getPatternAsLiteral(), like.getCaseType());
                            this.context.append(" ").append(this.rdbAdaptor.escape());
                        });
                    } else {
                        this.internalIndexedSql(propName, (PrimitivePropertyHandler)prop, false, () -> {
                            this.colExp(this.context.getCurrentSb(), propName, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, true);
                            this.context.append(" LIKE ");
                            this.forLike(like.getPatternAsLiteral(), like.getCaseType());
                            this.context.append(" ").append(this.rdbAdaptor.escape());
                        });
                    }
                } else if (like.getCaseType() == Like.CaseType.CS) {
                    this.colExp(this.context.getCurrentSb(), propName, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, false);
                    this.context.append(" LIKE ");
                    this.forLike(like.getPatternAsLiteral(), like.getCaseType());
                    this.context.append(" ").append(this.rdbAdaptor.escape());
                } else {
                    this.context.append(this.rdbAdaptor.upperFunctionName());
                    this.context.append("(");
                    this.colExp(this.context.getCurrentSb(), propName, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, false);
                    this.context.append(")");
                    this.context.append(" LIKE ");
                    this.forLike(like.getPatternAsLiteral(), like.getCaseType());
                    this.context.append(" ").append(this.rdbAdaptor.escape());
                }
            } else if (like.getCaseType() == Like.CaseType.CS) {
                propVal.accept(this);
                this.context.append(" LIKE ");
                this.forLike(like.getPatternAsLiteral(), like.getCaseType());
                this.context.append(" " + this.rdbAdaptor.escape());
            } else {
                this.context.append(this.rdbAdaptor.upperFunctionName());
                this.context.append("(");
                propVal.accept(this);
                this.context.append(")");
                this.context.append(" LIKE ");
                this.forLike(like.getPatternAsLiteral(), like.getCaseType());
                this.context.append(" " + this.rdbAdaptor.escape());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(like);
        }
    }

    @Override
    public boolean visit(Not not) {
        this.push(not);
        try {
            if (not.getNestedExpression() != null) {
                this.context.append("NOT ");
                not.getNestedExpression().accept(this);
                boolean bl = false;
                return bl;
            }
            throw new QueryException("Cannt convert NotExpression because nestedExpression  is null.");
        }
        finally {
            this.pop(not);
        }
    }

    @Override
    public boolean visit(IsNotNull isNotNull) {
        this.push(isNotNull);
        try {
            this.nullOp(isNotNull.getProperty(), false, true);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(isNotNull);
        }
    }

    @Override
    public boolean visit(IsNull isNull) {
        this.push(isNull);
        try {
            this.nullOp(isNull.getProperty(), true, false);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(isNull);
        }
    }

    private void nullOp(ValueExpression propVal, boolean isNullOp, boolean isAny) {
        String op;
        String string = op = isNullOp ? "IS NULL" : "IS NOT NULL";
        if (propVal instanceof EntityField) {
            String propName = ((EntityField)propVal).getPropertyName();
            this.context.notifyUsedPropertyName(propName);
            PropertyHandler prop = this.context.getProperty(propName);
            if (prop == null) {
                throw new NullPointerException(propName + " is not defined..");
            }
            GRdbPropertyStoreRuntime col = (GRdbPropertyStoreRuntime)((Object)prop.getStoreSpecProperty());
            if (col == null) {
                throw new QueryException("Reference property:" + propName + " itself can not be specified. Specify " + propName + ".oid or other.");
            }
            if (prop.getMetaData().getMultiplicity() > 1) {
                this.context.append("(");
                List<MetaGRdbPropertyStore.GRdbPropertyStoreHandler> cols = col.asList();
                for (int i = 0; i < cols.size(); ++i) {
                    if (i != 0) {
                        if (isAny) {
                            this.context.append(" OR ");
                        } else {
                            this.context.append(" AND ");
                        }
                    }
                    this.colExp(this.context.getCurrentSb(), propName, cols.get(i), false);
                    this.context.append(" ").append(op);
                }
                this.context.append(")");
            } else {
                this.internalIndexedSql(propName, (PrimitivePropertyHandler)prop, isNullOp, () -> {
                    this.colExp(this.context.getCurrentSb(), propName, (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)col, true);
                    this.context.append(" ").append(op);
                });
            }
        } else {
            propVal.accept(this);
            this.context.append(" ").append(op);
        }
    }

    @Override
    public boolean visit(ScalarSubQuery scalarSubQuery) {
        this.push(scalarSubQuery);
        try {
            if (scalarSubQuery.getQuery() == null || scalarSubQuery.getQuery().getSelect() == null || scalarSubQuery.getQuery().getSelect().getSelectValues() == null || scalarSubQuery.getQuery().getSelect().getSelectValues().size() != 1) {
                throw new QueryException("ScalarSubQuery must specify only one column.");
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.pop(scalarSubQuery);
        }
    }

    @Override
    public boolean visit(SubQuery subQuery) {
        return this.visit(subQuery, false);
    }

    private boolean visit(SubQuery subQuery, boolean treatSelectAsRawColType) {
        return this.visit(subQuery, treatSelectAsRawColType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean visit(SubQuery subQuery, boolean treatSelectAsRawColType, boolean groupingCorrelation) {
        this.push(subQuery);
        try {
            SqlQueryContext subContext;
            EntityContext ec = this.context.getMetaContext();
            this.context = subContext = new SqlQueryContext(ec.getHandlerByName(subQuery.getQuery().getFrom().getEntityName()), this.context, treatSelectAsRawColType);
            if (subQuery.getQuery().getSelect() != null) {
                subQuery.getQuery().getSelect().accept(this);
            }
            if (subQuery.getQuery().getFrom() != null) {
                subQuery.getQuery().getFrom().accept(this);
            }
            if (subQuery.getQuery().getRefer() != null) {
                for (Refer r : subQuery.getQuery().getRefer()) {
                    r.accept(this);
                }
            }
            if (subQuery.getOn() != null) {
                subContext.changeCurrentClause(SqlQueryContext.Clause.WHERE);
                if (subQuery.getQuery().getWhere() != null) {
                    subContext.append("(");
                    subQuery.getQuery().getWhere().getCondition().accept(this);
                    subContext.append(") AND ");
                }
                subContext.setEnableCorrelation(true);
                subContext.setUseIndexTable(false);
                if (subQuery.getOn() instanceof Or) {
                    subContext.append("(");
                }
                subQuery.getOn().accept(this);
                if (subQuery.getOn() instanceof Or) {
                    subContext.append(")");
                }
                subContext.setEnableCorrelation(false);
                subContext.setUseIndexTable(true);
            } else if (subQuery.getQuery().getWhere() != null) {
                subQuery.getQuery().getWhere().accept(this);
            }
            if (groupingCorrelation) {
                subContext.setEnableCorrelation(true);
                subContext.setUseIndexTable(false);
            }
            if (subQuery.getQuery().getGroupBy() != null) {
                subQuery.getQuery().getGroupBy().accept(this);
            }
            if (subQuery.getQuery().getHaving() != null) {
                subQuery.getQuery().getHaving().accept(this);
            }
            if (groupingCorrelation) {
                subContext.setEnableCorrelation(false);
                subContext.setUseIndexTable(true);
            }
            if (subQuery.getQuery().getOrderBy() != null) {
                subQuery.getQuery().getOrderBy().accept(this);
            }
            if (subQuery.getQuery().getLimit() != null) {
                subQuery.getQuery().getLimit().accept(this);
            }
            this.context = this.context.getParentContext();
            this.context.append("(");
            this.context.append(subContext.toSelectSql());
            this.context.append(")");
            List<ToSqlResult.BindValue> subqueryBindVarialbes = subContext.toOrderedBindVariables(true);
            if (subqueryBindVarialbes != null && subqueryBindVarialbes.size() > 0) {
                this.context.setEnableBindVariable(true);
                for (ToSqlResult.BindValue b : subqueryBindVarialbes) {
                    ((SqlQueryContext.QueryBindValue)b).inIndexTable = false;
                    ((SqlQueryContext.QueryBindValue)b).clause = this.context.getCurrentClause();
                    this.context.getBindVariables().add(b);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(subQuery);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(SortSpec order) {
        this.push(order);
        try {
            int start = this.context.getCurrentSb().length();
            order.getSortKey().accept(this);
            CharSequence sortValue = this.context.getCurrentSb().subSequence(start, this.context.getCurrentSb().length());
            this.context.getCurrentSb().delete(start, this.context.getCurrentSb().length());
            this.context.getRdb().appendSortSpecExpression(this.context.getCurrentSb(), sortValue, order.getType(), order.getNullOrderingSpec());
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(order);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(OrderBy orderBy) {
        this.push(orderBy);
        try {
            if (!this.context.isUseRollup() || this.rdbAdaptor.isSupportGroupingExtentionWithOrderBy()) {
                this.context.changeCurrentClause(SqlQueryContext.Clause.ORDERBYGROUPBY);
                this.context.append(" ORDER BY ");
                List<SortSpec> orderSpec = orderBy.getSortSpecList();
                for (int i = 0; i < orderSpec.size(); ++i) {
                    if (i != 0) {
                        this.context.append(",");
                    }
                    orderSpec.get(i).accept(this);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(orderBy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(GroupBy groupBy) {
        this.push(groupBy);
        try {
            this.context.changeCurrentClause(SqlQueryContext.Clause.ORDERBYGROUPBY);
            this.context.append(" GROUP BY ");
            if (groupBy.getRollType() != null && this.rdbAdaptor.isSupportGroupingExtention()) {
                this.context.setUseRollup(true);
                this.context.append(this.rdbAdaptor.rollUpStart(groupBy.getRollType()));
            }
            List<ValueExpression> valueList = groupBy.getGroupingFieldList();
            for (int i = 0; i < valueList.size(); ++i) {
                if (i != 0) {
                    this.context.append(",");
                }
                valueList.get(i).accept(this);
            }
            if (groupBy.getRollType() != null && this.rdbAdaptor.isSupportGroupingExtention()) {
                this.context.append(this.rdbAdaptor.rollUpEnd(groupBy.getRollType()));
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(groupBy);
        }
    }

    @Override
    public boolean visit(Limit limit) {
        this.push(limit);
        try {
            this.context.setLimitCount(limit.getLimit());
            this.context.setLimitOffset(limit.getOffset());
            this.context.setLimitBind(limit.isBindable());
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(limit);
        }
    }

    @Override
    public boolean visit(Cast cast) {
        this.push(cast);
        try {
            String[] castExp = null;
            switch (cast.getType()) {
                case BOOLEAN: {
                    castExp = this.rdbAdaptor.castExp(12, 32, null);
                    break;
                }
                case DATE: {
                    castExp = this.rdbAdaptor.castExp(91, null, null);
                    break;
                }
                case DATETIME: {
                    castExp = this.rdbAdaptor.castExp(93, null, null);
                    break;
                }
                case DECIMAL: {
                    castExp = this.rdbAdaptor.castExp(3, null, cast.getTypeArgument(0));
                    break;
                }
                case FLOAT: {
                    castExp = this.rdbAdaptor.castExp(8, null, null);
                    break;
                }
                case INTEGER: {
                    castExp = this.rdbAdaptor.castExp(-5, null, null);
                    break;
                }
                case STRING: {
                    castExp = this.rdbAdaptor.castExp(12, cast.getTypeArgument(0), null);
                    break;
                }
                case TIME: {
                    castExp = this.rdbAdaptor.castExp(92, null, null);
                    break;
                }
                default: {
                    throw new QueryException("not support type of cast expression:" + String.valueOf((Object)cast.getType()));
                }
            }
            this.context.append(castExp[0]);
            cast.getValue().accept(this);
            this.context.append(castExp[1]);
        }
        finally {
            this.pop(cast);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(Function function) {
        this.push(function);
        try {
            FunctionAdapter<Function> fa = this.rdbAdaptor.resolveFunction(function.getName());
            if (fa == null) {
                throw new QueryException(function.getName() + " not supported.");
            }
            fa.toSQL(new FunctionAdapter.FunctionContext(){

                @Override
                public void appendArgument(ValueExpression arg) {
                    arg.accept(SqlConverter.this);
                }

                @Override
                public void append(String str) {
                    SqlConverter.this.context.append(str);
                }
            }, function, this.rdbAdaptor);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(Refer refer) {
        this.push(refer);
        try {
            if (refer.getCondition() != null) {
                List<ToSqlResult.BindValue> referBindVarialbes;
                EntityField refPropName = refer.getReferenceName();
                String oidName = refPropName.getPropertyName() + ".oid";
                String verName = refPropName.getPropertyName() + ".version";
                this.context.notifyUsedPropertyName(oidName);
                Condition refCond = refer.getCondition();
                MultiPageChecker mpc = new MultiPageChecker(this.context.getFromEntity(), this.context.getMetaContext(), refPropName.getPropertyName());
                refCond.accept(mpc);
                if (mpc.isMultiPage()) {
                    ReferencePropertyHandler refPh = (ReferencePropertyHandler)this.context.getFromEntity().getPropertyCascade(refPropName.getPropertyName(), this.context.getMetaContext());
                    EntityHandler refEh = refPh.getReferenceEntityHandler(this.context.getMetaContext());
                    Query subq = new Query();
                    if (mpc.isAllPropertyUnderRef()) {
                        if (this.context.getFromEntity().isVersioned()) {
                            subq.select(new EntityField("oid"), new EntityField("version"));
                        } else {
                            subq.select(new EntityField("oid"));
                        }
                        subq.from(refEh.getMetaData().getName());
                        RefTrimmer refTrimmer = new RefTrimmer(refPropName.getPropertyName());
                        subq.where((Condition)refer.getCondition().accept(refTrimmer));
                    } else {
                        if (this.context.getFromEntity().isVersioned()) {
                            subq.select(new EntityField(oidName), new EntityField(verName));
                        } else {
                            subq.select(new EntityField(oidName));
                        }
                        subq.from(this.context.getFromEntity().getMetaData().getName());
                        subq.where(refer.getCondition());
                    }
                    if (this.context.getFromEntity().isVersioned()) {
                        ArrayList<ValueExpression> p = new ArrayList<ValueExpression>();
                        p.add(new EntityField(oidName));
                        p.add(new EntityField(verName));
                        refCond = new In(p, subq);
                    } else {
                        refCond = new And(new In((ValueExpression)new EntityField(oidName), subq), new Equals(new EntityField(verName), new Literal(0L)));
                    }
                }
                SqlQueryContext referContext = new SqlQueryContext(this.context.getFromEntity(), this.context.getMetaContext(), this.rdbAdaptor, this.context.getPrefix(), this.context.getAliases(), this.context.getJoinPath(), this.context.getIndexTable(), this.context.isEnableBindVariable());
                referContext.setUseIndexTable(false);
                SqlQueryContext mainContext = this.context;
                this.context = referContext;
                this.context.changeCurrentClause(SqlQueryContext.Clause.WHERE);
                refCond.accept(this);
                if (referContext.getCurrentClause() != SqlQueryContext.Clause.WHERE) {
                    referContext.changeCurrentClause(SqlQueryContext.Clause.WHERE);
                }
                if ((referBindVarialbes = referContext.toOrderedBindVariables(false)) != null && referBindVarialbes.size() > 0) {
                    mainContext.setEnableBindVariable(true);
                    for (ToSqlResult.BindValue b : referBindVarialbes) {
                        ((SqlQueryContext.QueryBindValue)b).inIndexTable = false;
                        ((SqlQueryContext.QueryBindValue)b).clause = SqlQueryContext.Clause.REFER;
                    }
                }
                mainContext.getJoinPath().getJoinPath(refPropName.getPropertyName()).setAdditionalCondition(referContext.getCurrentSb().toString(), referBindVarialbes);
                if (mainContext.getIndexTable() == null) {
                    mainContext.setIndexTable(referContext.getIndexTable());
                }
                this.context = mainContext;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(refer);
        }
    }

    @Override
    public boolean visit(Having having) {
        this.push(having);
        try {
            this.context.changeCurrentClause(SqlQueryContext.Clause.ORDERBYGROUPBY);
            this.context.append(" HAVING ");
            boolean bl = true;
            return bl;
        }
        finally {
            this.pop(having);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(Case caseClause) {
        this.push(caseClause);
        try {
            this.context.append("CASE");
            for (When w : caseClause.getWhen()) {
                this.context.append(" ");
                w.accept(this);
            }
            if (caseClause.getElseClause() != null) {
                this.context.append(" ");
                caseClause.getElseClause().accept(this);
            }
            this.context.append(" END");
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(caseClause);
        }
    }

    @Override
    public boolean visit(Else elseClause) {
        this.push(elseClause);
        try {
            this.context.append("ELSE ");
            elseClause.getResult().accept(this);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(elseClause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(When when) {
        this.push(when);
        try {
            this.context.append("WHEN ");
            boolean stackedUseIndex = this.context.isUseIndexTable();
            this.context.setUseIndexTable(false);
            when.getCondition().accept(this);
            this.context.setUseIndexTable(stackedUseIndex);
            this.context.append(" THEN ");
            when.getResult().accept(this);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(when);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(HintComment hintComment) {
        this.push(hintComment);
        try {
            if (hintComment.getHintList() != null) {
                for (Hint hc : hintComment.getHintList()) {
                    hc.accept(this);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(hintComment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(IndexHint indexHint) {
        this.push(indexHint);
        try {
            if (indexHint.getPropertyNameList() != null) {
                for (String prop : indexHint.getPropertyNameList()) {
                    this.context.addIndexHint(prop);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(indexHint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(NoIndexHint noIndexHint) {
        this.push(noIndexHint);
        try {
            if (noIndexHint.getPropertyNameList() != null) {
                for (String prop : noIndexHint.getPropertyNameList()) {
                    this.context.addNoIndexHint(prop);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(noIndexHint);
        }
    }

    @Override
    public boolean visit(NativeHint nativeHint) {
        this.push(nativeHint);
        try {
            if (nativeHint.getTable() == null) {
                this.context.changeCurrentClause(SqlQueryContext.Clause.HINT);
                this.context.append(nativeHint.getHintExpression());
            } else {
                this.context.addTableHint(nativeHint.getTable(), nativeHint.getHintExpression());
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(nativeHint);
        }
    }

    @Override
    public boolean visit(BindHint bindHint) {
        this.push(bindHint);
        try {
            if (this.treatBindHint) {
                this.context.setEnableBindVariable(true);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(bindHint);
        }
    }

    @Override
    public boolean visit(NoBindHint noBindHint) {
        this.push(noBindHint);
        try {
            this.context.setEnableBindVariable(false);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(noBindHint);
        }
    }

    @Override
    public boolean visit(WindowAggregate windowAggregate) {
        this.push(windowAggregate);
        try {
            if (this.rdbAdaptor.isSupportWindowFunction()) {
                if (windowAggregate.getAggregate() != null) {
                    windowAggregate.getAggregate().accept(this);
                }
                this.context.append(" OVER (");
                if (windowAggregate.getPartitionBy() != null) {
                    windowAggregate.getPartitionBy().accept(this);
                }
                if (windowAggregate.getOrderBy() != null) {
                    if (windowAggregate.getPartitionBy() != null) {
                        this.context.append(" ");
                    }
                    windowAggregate.getOrderBy().accept(this);
                }
            } else {
                throw new QueryException("window function not supported.");
            }
            this.context.append(")");
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(windowAggregate);
        }
    }

    private void windowRankFunction(WindowRankFunction wrf) {
        if (this.rdbAdaptor.isSupportWindowFunction()) {
            String funcName = this.rdbAdaptor.windowRankFunctionName(wrf);
            this.context.append(funcName);
            this.context.append("() OVER(");
            if (wrf.getPartitionBy() != null) {
                wrf.getPartitionBy().accept(this);
            }
            if (wrf.getOrderBy() != null) {
                if (wrf.getPartitionBy() != null) {
                    this.context.append(" ");
                }
                wrf.getOrderBy().accept(this);
            }
        } else {
            throw new QueryException("window function not supported.");
        }
        this.context.append(")");
    }

    @Override
    public boolean visit(RowNumber rowNumber) {
        this.push(rowNumber);
        try {
            this.windowRankFunction(rowNumber);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(rowNumber);
        }
    }

    @Override
    public boolean visit(Rank rank) {
        this.push(rank);
        try {
            this.windowRankFunction(rank);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(rank);
        }
    }

    @Override
    public boolean visit(DenseRank denseRank) {
        this.push(denseRank);
        try {
            this.windowRankFunction(denseRank);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(denseRank);
        }
    }

    @Override
    public boolean visit(PercentRank percentRank) {
        this.push(percentRank);
        try {
            this.windowRankFunction(percentRank);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(percentRank);
        }
    }

    @Override
    public boolean visit(CumeDist cumeDist) {
        this.push(cumeDist);
        try {
            this.windowRankFunction(cumeDist);
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(cumeDist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(PartitionBy partitionBy) {
        this.push(partitionBy);
        try {
            this.context.append("PARTITION BY ");
            List<ValueExpression> valueList = partitionBy.getPartitionFieldList();
            for (int i = 0; i < valueList.size(); ++i) {
                if (i != 0) {
                    this.context.append(",");
                }
                valueList.get(i).accept(this);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(partitionBy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(WindowOrderBy orderBy) {
        this.push(orderBy);
        try {
            this.context.append("ORDER BY ");
            List<WindowSortSpec> orderSpec = orderBy.getSortSpecList();
            for (int i = 0; i < orderSpec.size(); ++i) {
                if (i != 0) {
                    this.context.append(",");
                }
                orderSpec.get(i).accept(this);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(orderBy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean visit(WindowSortSpec sortSpec) {
        this.push(sortSpec);
        try {
            int start = this.context.getCurrentSb().length();
            sortSpec.getSortKey().accept(this);
            CharSequence sortValue = this.context.getCurrentSb().subSequence(start, this.context.getCurrentSb().length());
            this.context.getCurrentSb().delete(start, this.context.getCurrentSb().length());
            this.context.getRdb().appendSortSpecExpression(this.context.getCurrentSb(), sortValue, sortSpec.getType(), sortSpec.getNullOrderingSpec());
            boolean bl = false;
            return bl;
        }
        finally {
            this.pop(sortSpec);
        }
    }
}

