/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql.queryconvert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.impl.datastore.RdbBaseValueTypeResolver;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.sql.ToSqlResult;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.JoinPath;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.TableAliasMapping;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.HintPlace;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.util.StringUtil;

public class SqlQueryContext {
    private String prefix;
    private RdbAdapter rdb;
    private EntityHandler primaryMetaData;
    private EntityContext metaContext;
    private JoinPath joinPath;
    private TableAliasMapping aliases;
    private List<String> indexTable;
    private boolean useIndexTable = true;
    private boolean enableCorrelation;
    private RdbBaseValueTypeResolver valueTypeResolver;
    private int limitCount = -1;
    private int limitOffset = -1;
    private boolean limitBind;
    private StringBuilder hintSb;
    private HashMap<String, StringBuilder> tableHintSbMap;
    private StringBuilder whereSb;
    private StringBuilder selectSb;
    private StringBuilder orderBySb;
    private Clause currentClause;
    private StringBuilder currentSb;
    private HashSet<String> indexHint;
    private HashSet<String> noIndexHint;
    private boolean useRollup;
    private boolean enableBindVariable;
    private List<ToSqlResult.BindValue> bindVariables;
    private SqlQueryContext parentContext;
    private boolean treatSelectAsRawValue;
    private Integer stringTypeLengthOnQuery;

    public SqlQueryContext(EntityHandler primaryMetaData, EntityContext metaContext, RdbAdapter rdb) {
        this(primaryMetaData, metaContext, rdb, "q0", false);
    }

    public SqlQueryContext(EntityHandler primaryMetaData, EntityContext metaContext, RdbAdapter rdb, String prefix, boolean enableBindVariable) {
        this.primaryMetaData = primaryMetaData;
        this.metaContext = metaContext;
        this.rdb = rdb;
        this.prefix = prefix;
        this.aliases = new TableAliasMapping(prefix);
        this.hintSb = new StringBuilder();
        this.whereSb = new StringBuilder();
        this.selectSb = new StringBuilder();
        this.orderBySb = new StringBuilder();
        this.joinPath = new JoinPath(this.aliases, true, primaryMetaData, metaContext);
        this.enableBindVariable = enableBindVariable;
    }

    public SqlQueryContext(EntityHandler eh, SqlQueryContext parent, boolean treatSelectAsRawValue) {
        this(eh, parent.metaContext, parent.rdb, "q" + SqlQueryContext.stackSize(parent), parent.enableBindVariable);
        this.parentContext = parent;
        this.treatSelectAsRawValue = treatSelectAsRawValue;
        this.stringTypeLengthOnQuery = parent.stringTypeLengthOnQuery;
    }

    public SqlQueryContext(EntityHandler primaryMetaData, EntityContext metaContext, RdbAdapter rdb, String prefix, TableAliasMapping aliases, JoinPath joinPath, List<String> indexTable, boolean enableBindVariable) {
        this.primaryMetaData = primaryMetaData;
        this.metaContext = metaContext;
        this.rdb = rdb;
        this.prefix = prefix;
        this.aliases = aliases;
        this.hintSb = new StringBuilder();
        this.whereSb = new StringBuilder();
        this.selectSb = new StringBuilder();
        this.orderBySb = new StringBuilder();
        this.joinPath = joinPath;
        this.indexTable = indexTable;
        this.enableBindVariable = enableBindVariable;
    }

    private static int stackSize(SqlQueryContext parent) {
        int ret = 0;
        while (parent != null) {
            ++ret;
            parent = parent.parentContext;
        }
        return ret;
    }

    public Integer getStringTypeLengthOnQuery() {
        return this.stringTypeLengthOnQuery;
    }

    public void setStringTypeLengthOnQuery(Integer stringTypeLengthOnQuery) {
        this.stringTypeLengthOnQuery = stringTypeLengthOnQuery;
    }

    public boolean isTreatSelectAsRawValue() {
        return this.treatSelectAsRawValue;
    }

    public void setTreatSelectAsRawValue(boolean treatSelectAsRawValue) {
        this.treatSelectAsRawValue = treatSelectAsRawValue;
    }

    public SqlQueryContext getParentContext() {
        return this.parentContext;
    }

    public boolean isEnableCorrelation() {
        return this.enableCorrelation;
    }

    public void setEnableCorrelation(boolean enableCorrelation) {
        this.enableCorrelation = enableCorrelation;
    }

    public void setEnableBindVariable(boolean enableBindVariable) {
        this.enableBindVariable = enableBindVariable;
    }

    public boolean isEnableBindVariable() {
        return this.enableBindVariable;
    }

    public void addBindVariable(Object value, BaseRdbTypeAdapter type) {
        if (!this.enableBindVariable) {
            throw new QueryException("bind variable not supported.");
        }
        this.getBindVariables().add(new QueryBindValue(value, type, this.currentClause, false));
    }

    public List<ToSqlResult.BindValue> getBindVariables() {
        if (this.enableBindVariable && this.bindVariables == null) {
            this.bindVariables = new ArrayList<ToSqlResult.BindValue>();
        }
        return this.bindVariables;
    }

    public boolean isUseRollup() {
        return this.useRollup;
    }

    public void setUseRollup(boolean useRollup) {
        this.useRollup = useRollup;
    }

    boolean checkIndexHint(String prop, boolean external) {
        SqlQueryContext target = this;
        if (this.enableCorrelation) {
            int unnestCount = SqlQueryContext.unnestCount(prop);
            if (external) {
                if (unnestCount != 0) {
                    return false;
                }
            } else {
                target = this.parent(unnestCount);
                if (target == null) {
                    throw new QueryException(prop + " undefined (can't unnest property).");
                }
                if (unnestCount > 0) {
                    prop = prop.substring(unnestCount);
                }
            }
        }
        return SqlQueryContext.checkIndexHint(target, prop);
    }

    private static boolean checkIndexHint(SqlQueryContext target, String prop) {
        if (target.indexHint != null) {
            return target.indexHint.contains(prop);
        }
        if (target.noIndexHint != null) {
            return !target.noIndexHint.contains(prop);
        }
        return true;
    }

    public void addIndexHint(String prop) {
        if (this.indexHint == null) {
            this.indexHint = new HashSet();
        }
        this.indexHint.add(prop);
    }

    public void addNoIndexHint(String prop) {
        if (this.noIndexHint == null) {
            this.noIndexHint = new HashSet();
        }
        this.noIndexHint.add(prop);
    }

    public boolean isUseIndexTable() {
        return this.useIndexTable;
    }

    public void setUseIndexTable(boolean useIndexTable) {
        this.useIndexTable = useIndexTable;
    }

    public RdbBaseValueTypeResolver getValueTypeResolver() {
        if (this.valueTypeResolver == null) {
            this.valueTypeResolver = new RdbBaseValueTypeResolver(this.primaryMetaData, this.metaContext, this.rdb);
        }
        return this.valueTypeResolver;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public StringBuilder getCurrentSb() {
        return this.currentSb;
    }

    public List<String> getIndexTable() {
        return this.indexTable;
    }

    public void setIndexTable(List<String> indexTable) {
        this.indexTable = indexTable;
    }

    public String addIndexTable(String table) {
        if (this.indexTable == null) {
            this.indexTable = new ArrayList<String>();
        }
        int index = this.indexTable.size();
        String talias = "i" + index;
        this.indexTable.add(table + " " + talias);
        return talias;
    }

    public void addTableHint(String tableName, String hint) {
        StringBuilder sb;
        if (this.tableHintSbMap == null) {
            this.tableHintSbMap = new HashMap();
        }
        if ((sb = this.tableHintSbMap.get(tableName)) == null) {
            sb = new StringBuilder(hint);
            this.tableHintSbMap.put(tableName, sb);
        } else {
            sb.append(",");
            sb.append(hint);
        }
    }

    void appendTableHint(String tableName, StringBuilder sb) {
        if (this.tableHintSbMap == null) {
            return;
        }
        if (!this.rdb.isSupportTableHint()) {
            return;
        }
        StringBuilder thsb = this.tableHintSbMap.get(tableName);
        if (thsb != null) {
            String[] bracket = this.rdb.getTableHintBracket();
            if (bracket != null && bracket[0] != null) {
                sb.append(bracket[0]);
            }
            sb.append((CharSequence)thsb);
            if (bracket != null && bracket[1] != null) {
                sb.append(bracket[1]);
            }
            sb.append(" ");
        }
    }

    private boolean needAppendHint() {
        return this.rdb.isSupportOptimizerHint() && (this.hintSb.length() != 0 || this.rdb.getOptimizerHint() != null);
    }

    private void appendHint(StringBuilder sb) {
        String[] hintBracket = this.rdb.getOptimizerHintBracket();
        if (hintBracket != null && hintBracket[0] != null) {
            sb.append(hintBracket[0]);
        }
        if (this.hintSb.length() != 0) {
            sb.append((CharSequence)this.hintSb);
        } else {
            sb.append(this.rdb.getOptimizerHint());
        }
        if (hintBracket != null && hintBracket[1] != null) {
            sb.append(hintBracket[1]);
        }
    }

    public List<ToSqlResult.BindValue> toOrderedBindVariables(boolean withJoin) {
        List<ToSqlResult.BindValue> joinClauseBindVariables = null;
        if (withJoin) {
            joinClauseBindVariables = this.joinPath.getOrderedBindVariables();
        }
        if (!(this.bindVariables != null && this.bindVariables.size() != 0 || joinClauseBindVariables != null && joinClauseBindVariables.size() != 0)) {
            if (this.getLimitCount() != -1 && this.enableBindVariable && this.limitBind) {
                Object[] limitBindValues;
                int limitOffset = 0;
                if (this.getLimitOffset() != -1) {
                    limitOffset = this.getLimitOffset();
                }
                ArrayList<ToSqlResult.BindValue> limited = new ArrayList<ToSqlResult.BindValue>(2);
                for (Object v : limitBindValues = this.rdb.toLimitSqlBindValue(this.getLimitCount(), limitOffset)) {
                    limited.add(new QueryBindValue(v, this.rdb.getRdbTypeAdapter(v), Clause.ORDERBYGROUPBY, false));
                }
                return limited;
            }
            return this.bindVariables;
        }
        if (joinClauseBindVariables != null || this.indexTable != null && this.indexTable.size() > 0) {
            ArrayList<ToSqlResult.BindValue> ordered = this.bindVariables == null ? new ArrayList<ToSqlResult.BindValue>() : new ArrayList(this.bindVariables.size() + 10);
            if (this.bindVariables != null) {
                for (ToSqlResult.BindValue b : this.bindVariables) {
                    if (((QueryBindValue)b).clause != Clause.SELECT) break;
                    if (((QueryBindValue)b).inIndexTable) continue;
                    ordered.add(b);
                }
            }
            if (joinClauseBindVariables != null) {
                for (ToSqlResult.BindValue b : joinClauseBindVariables) {
                    ordered.add(b);
                }
            }
            if (this.bindVariables != null) {
                for (ToSqlResult.BindValue b : this.bindVariables) {
                    if (!((QueryBindValue)b).inIndexTable) continue;
                    ordered.add(b);
                }
                for (ToSqlResult.BindValue b : this.bindVariables) {
                    if (((QueryBindValue)b).clause == Clause.SELECT || ((QueryBindValue)b).inIndexTable) continue;
                    ordered.add(b);
                }
            }
            if (this.getLimitCount() != -1 && this.enableBindVariable && this.limitBind) {
                Object[] limitBindValues;
                int limitOffset = 0;
                if (this.getLimitOffset() != -1) {
                    limitOffset = this.getLimitOffset();
                }
                for (Object v : limitBindValues = this.rdb.toLimitSqlBindValue(this.getLimitCount(), limitOffset)) {
                    ordered.add(new QueryBindValue(v, this.rdb.getRdbTypeAdapter(v), Clause.ORDERBYGROUPBY, false));
                }
            }
            return ordered;
        }
        if (this.getLimitCount() != -1 && this.enableBindVariable && this.limitBind) {
            Object[] limitBindValues;
            int limitOffset = 0;
            if (this.getLimitOffset() != -1) {
                limitOffset = this.getLimitOffset();
            }
            ArrayList<ToSqlResult.BindValue> limited = new ArrayList<ToSqlResult.BindValue>(2 + this.bindVariables.size());
            limited.addAll(this.bindVariables);
            for (Object v : limitBindValues = this.rdb.toLimitSqlBindValue(this.getLimitCount(), limitOffset)) {
                limited.add(new QueryBindValue(v, this.rdb.getRdbTypeAdapter(v), Clause.ORDERBYGROUPBY, false));
            }
            return limited;
        }
        return this.bindVariables;
    }

    public String toSelectSql() {
        return this.toSelectSql(null);
    }

    public String toSelectSql(String additionalJoin) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (this.needAppendHint() && this.rdb.getOptimizerHintPlace() == HintPlace.AFTER_SELECT) {
            this.appendHint(sb);
            sb.append(" ");
        }
        sb.append((CharSequence)this.selectSb);
        sb.append(" FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)this.primaryMetaData.getEntityStoreRuntime()).OBJ_STORE());
        sb.append(" ");
        if (this.getPrefix() != null) {
            sb.append(this.getPrefix()).append(" ");
            this.appendTableHint(this.getPrefix(), sb);
        }
        this.joinPath.appendJoinCause(sb, this);
        if (this.indexTable != null) {
            for (String t : this.indexTable) {
                sb.append(",");
                sb.append(t);
            }
        }
        sb.append(" WHERE ");
        if (this.getPrefix() != null) {
            sb.append(this.getPrefix()).append(".");
        }
        sb.append("OBJ_DEF_ID='").append(this.rdb.sanitize(this.primaryMetaData.getMetaData().getId()));
        sb.append("' AND ");
        if (this.getPrefix() != null) {
            sb.append(this.getPrefix()).append(".");
        }
        sb.append("TENANT_ID=").append(this.metaContext.getTenantId(this.primaryMetaData));
        sb.append(" AND ");
        if (this.getPrefix() != null) {
            sb.append(this.getPrefix()).append(".");
        }
        sb.append("PG_NO=0");
        if (StringUtil.isNotEmpty(additionalJoin)) {
            sb.append(" AND (").append(additionalJoin).append(")");
        }
        if (this.whereSb.length() != 0) {
            sb.append(" AND (");
            sb.append((CharSequence)this.whereSb);
            sb.append(")");
        }
        if (this.orderBySb.length() != 0) {
            sb.append((CharSequence)this.orderBySb);
        }
        CharSequence sql = null;
        if (this.getLimitCount() != -1) {
            int limitOffset = 0;
            if (this.getLimitOffset() != -1) {
                limitOffset = this.getLimitOffset();
            }
            if (this.orderBySb.length() == 0) {
                sb.append(this.rdb.getDefaultOrderByForLimit());
            }
            sql = this.rdb.toLimitSql(sb.toString(), this.getLimitCount(), limitOffset, this.enableBindVariable && this.limitBind);
        } else {
            sql = sb;
        }
        if (this.needAppendHint() && this.rdb.getOptimizerHintPlace() == HintPlace.HEAD_OF_SQL) {
            StringBuilder sb2 = new StringBuilder();
            this.appendHint(sb2);
            sb2.append(" ");
            sb2.append(sql);
            sql = sb2;
        }
        return sql.toString();
    }

    public String sqlEnded(CharSequence sql) {
        if (this.rdb.getOptimizerHintPlace() == HintPlace.END_OF_SQL && this.parentContext == null && this.needAppendHint()) {
            StringBuilder sb2 = sql instanceof StringBuilder ? (StringBuilder)sql : new StringBuilder(sql);
            sb2.append(" ");
            this.appendHint(sb2);
            sql = sb2;
        }
        return sql.toString();
    }

    public RdbAdapter getRdb() {
        return this.rdb;
    }

    public void setFrom(String entityName) {
        if (this.primaryMetaData == null || !this.primaryMetaData.getMetaData().getName().equals(entityName)) {
            EntityHandler e = this.metaContext.getHandlerByName(entityName);
            if (e == null) {
                throw new QueryException(entityName + " undefined.");
            }
            this.primaryMetaData = e;
        }
    }

    public void changeCurrentClause(Clause currentClause) {
        this.currentClause = currentClause;
        switch (currentClause.ordinal()) {
            case 0: {
                this.currentSb = this.selectSb;
                break;
            }
            case 1: {
                this.currentSb = this.whereSb;
                break;
            }
            case 2: {
                this.currentSb = this.orderBySb;
                break;
            }
            case 3: {
                this.currentSb = this.hintSb;
                break;
            }
            default: {
                throw new UnsupportedOperationException("no impl of " + String.valueOf((Object)currentClause));
            }
        }
    }

    public Clause getCurrentClause() {
        return this.currentClause;
    }

    public SqlQueryContext append(CharSequence charSeq) {
        this.currentSb.append(charSeq);
        return this;
    }

    public SqlQueryContext append(int intValue) {
        this.currentSb.append(intValue);
        return this;
    }

    public JoinPath getJoinPath() {
        return this.joinPath;
    }

    public TableAliasMapping getAliases() {
        return this.aliases;
    }

    public EntityContext getMetaContext() {
        return this.metaContext;
    }

    public EntityHandler getFromEntity() {
        return this.primaryMetaData;
    }

    public int getLimitCount() {
        return this.limitCount;
    }

    public void setLimitCount(int limitCount) {
        this.limitCount = limitCount;
    }

    public int getLimitOffset() {
        return this.limitOffset;
    }

    public void setLimitOffset(int limitOffset) {
        this.limitOffset = limitOffset;
    }

    public void setLimitBind(boolean limitBind) {
        this.limitBind = limitBind;
    }

    private static int unnestCount(String propName) {
        for (int i = 0; i < propName.length(); ++i) {
            if (propName.charAt(i) == '.') continue;
            return i;
        }
        return 0;
    }

    private SqlQueryContext parent(int unnestCount) {
        SqlQueryContext ret = this;
        for (int i = 0; i < unnestCount; ++i) {
            if (this.parentContext == null) {
                return null;
            }
            ret = this.parentContext;
        }
        return ret;
    }

    public PropertyHandler getProperty(String propName) {
        int unnestCount;
        SqlQueryContext target = this;
        if (this.enableCorrelation && (unnestCount = SqlQueryContext.unnestCount(propName)) != 0) {
            target = this.parent(unnestCount);
            if (target == null) {
                throw new QueryException(propName + " undefined (can't unnest property).");
            }
            propName = propName.substring(unnestCount);
        }
        return target.getFromEntity().getPropertyCascade(propName, this.getMetaContext());
    }

    public void notifyUsedPropertyName(String propertyName) {
        int unnestCount;
        SqlQueryContext target = this;
        if (this.enableCorrelation && (unnestCount = SqlQueryContext.unnestCount(propertyName)) != 0) {
            target = this.parent(unnestCount);
            if (target == null) {
                throw new QueryException(propertyName + " undefined (can't unnest property).");
            }
            propertyName = propertyName.substring(unnestCount);
        }
        boolean useIndex = SqlQueryContext.checkIndexHint(target, propertyName);
        target.joinPath.addPath(propertyName.split("[.]"), -1, this.metaContext, target.primaryMetaData, target.currentClause == Clause.WHERE, useIndex);
    }

    public String getColPrefix(String propName, MetaGRdbPropertyStore.GRdbPropertyStoreHandler targetCol) {
        int unnestCount;
        SqlQueryContext target = this;
        if (this.enableCorrelation && (unnestCount = SqlQueryContext.unnestCount(propName)) != 0) {
            target = this.parent(unnestCount);
            if (target == null) {
                throw new QueryException(propName + " undefined (can't unnest property).");
            }
            propName = propName.substring(unnestCount);
        }
        StringBuilder sb = new StringBuilder();
        if (propName.contains(".")) {
            sb.append(target.aliases.getAlias(propName.substring(0, propName.lastIndexOf(46))));
        } else if (target.getPrefix() != null) {
            sb.append(target.getPrefix());
        }
        if (!targetCol.isNative()) {
            if (targetCol.getIndexColName() != null && SqlQueryContext.checkIndexHint(target, propName)) {
                if (targetCol.getMetaData().getIndexPageNo() > 0) {
                    sb.append(JoinPath.PAGE_PREFIX).append(targetCol.getMetaData().getIndexPageNo());
                }
            } else if (targetCol.getMetaData().getPageNo() > 0) {
                sb.append(JoinPath.PAGE_PREFIX).append(targetCol.getMetaData().getPageNo());
            }
        }
        if (sb.length() > 0) {
            sb.append(".");
        }
        return sb.toString();
    }

    public static class QueryBindValue
    extends ToSqlResult.BindValue {
        public Clause clause;
        public boolean inIndexTable;

        public QueryBindValue(Object value, BaseRdbTypeAdapter type, Clause clause, boolean inIndexTable) {
            super(value, type);
            this.clause = clause;
            this.inIndexTable = inIndexTable;
        }
    }

    public static enum Clause {
        SELECT,
        WHERE,
        ORDERBYGROUPBY,
        HINT,
        REFER;

    }
}

