/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.bulkupdate.BulkUpdateEntity;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreSearchSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.GRdbEntityStoreStrategy;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkDeleteHandler;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkInsertHandler;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkUpdateHandler;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkUpdateState
implements AutoCloseable {
    private static Logger logger = LoggerFactory.getLogger(BulkUpdateState.class);
    GRdbEntityStoreStrategy storeStrategy;
    int tenantId;
    String clientId;
    EntityContext entityContext;
    EntityHandler eh;
    BulkUpdatable bulkUpdatable;
    Connection con;
    RdbAdapter rdb;
    int bufferSize;
    private List<BulkUpdateEntity> buffer;
    private List<Object[]> mergeList;
    private Set<OidVer> existsOidVers;
    private Statement search;
    private BulkInsertHandler insert;
    private BulkUpdateHandler update;
    private BulkDeleteHandler delete;

    BulkUpdateState(GRdbEntityStoreStrategy storeStrategy, int tenantId, String clientId, EntityContext entityContext, EntityHandler eh, BulkUpdatable bulkUpdatable, Connection con, RdbAdapter rdb, int bufferSize) {
        this.tenantId = tenantId;
        this.clientId = clientId;
        this.entityContext = entityContext;
        this.eh = eh;
        this.bulkUpdatable = bulkUpdatable;
        this.con = con;
        this.rdb = rdb;
        this.bufferSize = bufferSize;
        this.buffer = new ArrayList<BulkUpdateEntity>(bufferSize);
        this.existsOidVers = new HashSet<OidVer>(bufferSize);
    }

    void addToBuffer(BulkUpdateEntity e) {
        this.buffer.add(e);
        if (e.getMethod() == BulkUpdateEntity.UpdateMethod.MERGE && e.getEntity().getOid() != null) {
            if (this.mergeList == null) {
                this.mergeList = new ArrayList<Object[]>();
            }
            this.mergeList.add(new Object[]{e.getEntity().getOid(), e.getEntity().getVersion()});
        }
    }

    private void searchMergeOidVer() throws SQLException {
        if (this.mergeList != null) {
            if (this.search == null) {
                this.search = this.con.createStatement();
                int fetchSize = this.bufferSize < this.rdb.getMaxFetchSize() ? this.bufferSize : this.rdb.getMaxFetchSize();
                this.search.setFetchSize(fetchSize);
            }
            try (ResultSet rs = this.search.executeQuery(ObjStoreSearchSql.checkExistsByKeysSql(this.tenantId, this.eh, this.mergeList, this.rdb));){
                while (rs.next()) {
                    this.existsOidVers.add(new OidVer(rs.getString(1), rs.getLong(2)));
                }
            }
        }
    }

    void doUpdate() throws SQLException {
        this.searchMergeOidVer();
        for (BulkUpdateEntity bue : this.buffer) {
            BulkUpdateEntity.UpdateMethod um = bue.getMethod();
            if (um == BulkUpdateEntity.UpdateMethod.MERGE) {
                um = this.existsOidVers.contains(new OidVer(bue.getEntity().getOid(), bue.getEntity().getVersion())) ? BulkUpdateEntity.UpdateMethod.UPDATE : BulkUpdateEntity.UpdateMethod.INSERT;
            }
            switch (um) {
                case DELETE: {
                    if (this.delete == null) {
                        this.delete = new BulkDeleteHandler(this);
                    }
                    this.delete.addValue(this, bue.getEntity());
                    break;
                }
                case INSERT: {
                    if (this.insert == null) {
                        this.insert = new BulkInsertHandler(this, this.bulkUpdatable.isEnableAuditPropertySpecification());
                    }
                    if (bue.getEntity().getOid() == null) {
                        bue.getEntity().setOid(this.storeStrategy.newOid(this.entityContext, this.eh));
                    }
                    this.insert.addValue(this, bue.getEntity());
                    break;
                }
                case UPDATE: {
                    if (this.update == null) {
                        this.update = new BulkUpdateHandler(this);
                    }
                    bue.getEntity().setUpdateBy(this.clientId);
                    this.update.addValue(this, bue.getEntity());
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            this.bulkUpdatable.updated(bue);
        }
        this.clearBuffer();
    }

    private void clearBuffer() {
        this.buffer.clear();
        this.existsOidVers.clear();
        this.mergeList = null;
    }

    public void flushAll() throws SQLException {
        if (this.insert != null) {
            this.insert.flushAll();
        }
        if (this.update != null) {
            this.update.flushAll();
        }
        if (this.delete != null) {
            this.delete.flushAll();
        }
    }

    @Override
    public void close() {
        if (this.search != null) {
            try {
                this.search.close();
            }
            catch (SQLException e) {
                logger.error("fail to BulkUpdateState close. maybe resource leak.", (Throwable)e);
            }
        }
        if (this.insert != null) {
            this.insert.close();
        }
        if (this.update != null) {
            this.update.close();
        }
        if (this.delete != null) {
            this.delete.close();
        }
    }

    private static class OidVer {
        String oid;
        long ver;

        OidVer(String oid, long ver) {
            this.oid = oid;
            this.ver = ver;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.oid == null ? 0 : this.oid.hashCode());
            result = 31 * result + (int)(this.ver ^ this.ver >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            OidVer other = (OidVer)obj;
            if (this.oid == null ? other.oid != null : !this.oid.equals(other.oid)) {
                return false;
            }
            return this.ver == other.ver;
        }
    }
}

