/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.bulkupdate.BulkUpdateEntity;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreSearchSql;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreUpdateSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.GRdbEntityStoreStrategy;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.BulkUpdateStrategy;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EachRecordBulkUpdateStrategy
implements BulkUpdateStrategy {
    private static Logger log = LoggerFactory.getLogger(EachRecordBulkUpdateStrategy.class);
    private GRdbEntityStoreStrategy storeStrategy;
    private RdbAdapter rdb;
    private ObjStoreSearchSql searchSql;

    public EachRecordBulkUpdateStrategy(GRdbEntityStoreStrategy storeStrategy, RdbAdapter rdb) {
        this.storeStrategy = storeStrategy;
        this.rdb = rdb;
        this.searchSql = rdb.getQuerySqlCreator(ObjStoreSearchSql.class);
    }

    @Override
    public void bulkUpdate(BulkUpdatable bulkUpdatable, EntityContext entityContext, EntityHandler entityHandler, String clientId) {
        int tenantId = entityContext.getLocalTenantId();
        DeleteOption delOp = new DeleteOption(false);
        UpdateOption upOp = new UpdateOption(false);
        ArrayList<String> updateProps = new ArrayList<String>();
        if (bulkUpdatable.getUpdateProperties() != null) {
            for (String string : bulkUpdatable.getUpdateProperties()) {
                if (!ObjStoreUpdateSql.canUpdateProperty(entityHandler.getProperty(string, entityContext))) continue;
                updateProps.add(string);
            }
        } else {
            for (PropertyHandler propertyHandler : entityHandler.getPropertyList(entityContext)) {
                if (propertyHandler instanceof PrimitivePropertyHandler) {
                    if (!ObjStoreUpdateSql.canUpdateProperty(propertyHandler)) continue;
                    updateProps.add(propertyHandler.getName());
                    continue;
                }
                if (!(propertyHandler instanceof ReferencePropertyHandler) || ((ReferencePropertyHandler)propertyHandler).getMetaData().getMappedByPropertyMetaDataId() != null) continue;
                updateProps.add(propertyHandler.getName());
            }
        }
        upOp.setUpdateProperties(updateProps);
        Statement stmt = null;
        try {
            for (BulkUpdateEntity target : bulkUpdatable) {
                if (target.getEntity().getVersion() == null) {
                    target.getEntity().setVersion(0L);
                }
                switch (target.getMethod()) {
                    case DELETE: {
                        this.storeStrategy.delete(entityContext, target.getEntity(), entityHandler, delOp);
                        break;
                    }
                    case INSERT: {
                        if (target.getEntity().getOid() == null) {
                            target.getEntity().setOid(this.storeStrategy.newOid(entityContext, entityHandler));
                        }
                        this.storeStrategy.insert(entityContext, entityHandler, target.getEntity());
                        break;
                    }
                    case MERGE: {
                        String oid = target.getEntity().getOid();
                        if (oid == null) {
                            target.getEntity().setOid(this.storeStrategy.newOid(entityContext, entityHandler));
                            this.storeStrategy.insert(entityContext, entityHandler, target.getEntity());
                            break;
                        }
                        if (stmt == null) {
                            stmt = this.rdb.getConnection().prepareStatement(this.searchSql.checkExistsSql(tenantId, entityHandler, target.getEntity(), this.rdb));
                        }
                        this.searchSql.checkExistsParameter((PreparedStatement)stmt, tenantId, entityHandler, target.getEntity());
                        try (ResultSet rs = stmt.executeQuery();){
                            if (rs.next()) {
                                this.storeStrategy.update(entityContext, entityHandler, target.getEntity(), upOp);
                                break;
                            }
                            this.storeStrategy.insert(entityContext, entityHandler, target.getEntity());
                            break;
                        }
                    }
                    case UPDATE: {
                        this.storeStrategy.update(entityContext, entityHandler, target.getEntity(), upOp);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                bulkUpdatable.updated(target);
            }
        }
        catch (SQLException sQLException) {
            throw new EntityRuntimeException(sQLException);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    log.error("Fail to close DB connection Resource. Check whether resource is leak or not.", (Throwable)e);
                }
            }
        }
    }
}

