/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.iplass.mtp.impl.rdb.adapter.BaseRdbTypeAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.bulk.DynamicColumnValue;

public class PropertyColumnValue
extends DynamicColumnValue {
    private BaseRdbTypeAdapter type;
    private RdbAdapter rdb;
    private boolean asNative;
    private Object defaultValue;

    public PropertyColumnValue(String colName, BaseRdbTypeAdapter type, boolean asNative, Object defaultValue, RdbAdapter rdb) {
        super(colName, rdb);
        this.type = type;
        this.asNative = asNative;
        this.defaultValue = defaultValue;
        this.rdb = rdb;
    }

    @Override
    public void bindExpression(StringBuilder sb) {
        if (this.asNative) {
            super.bindExpression(sb);
        } else {
            this.type.appendToTypedCol(sb, this.rdb, () -> this.type.appendParameterPlaceholder(sb, this.rdb));
        }
    }

    @Override
    public void valueExpression(Object value, StringBuilder sb) {
        if (this.asNative) {
            this.type.appendToSqlAsRealType(value == null ? this.defaultValue : value, sb, this.rdb);
        } else {
            this.type.appendToTypedCol(sb, this.rdb, () -> this.type.appendToSqlAsRealType(value == null ? this.defaultValue : value, sb, this.rdb));
        }
    }

    @Override
    public void setParameter(Object value, int index, PreparedStatement ps) throws SQLException {
        this.type.setParameter(index, value == null ? this.defaultValue : value, ps, this.rdb);
    }
}

