/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.impl.datastore.grdb.ColumnPosition;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbMultiplePropertyStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.RawColIndexType;
import org.iplass.mtp.impl.datastore.grdb.RawColType;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColContext;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColConverter;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColConverterFactory;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.UsedCol;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.MetaRdbColumnMapping;
import org.iplass.mtp.impl.entity.MetaSchemalessRdbStoreMapping;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.spi.ServiceRegistry;

public class ColResolver {
    private static ColConverterFactory ccFactory = ServiceRegistry.getRegistry().getService(ColConverterFactory.class);
    private StorageSpaceMap storage;
    private MetaGRdbEntityStore metaStore;
    private MetaSchemalessRdbStoreMapping newStoreMap;
    private ColContext colContext;
    private EnumMap<RawColType, EnumMap<RawColIndexType, List<ColumnPosition>>> unused = new EnumMap(RawColType.class);
    private HashSet<UsedCol> usedCol = new HashSet();
    private boolean storageSpaceMismatch;

    public ColResolver(MetaEntity currentMetaEntity, MetaSchemalessRdbStoreMapping newStoreMap, StorageSpaceMap storage, RdbAdapter rdb) {
        if (newStoreMap != null && !storage.getStorageSpaceName().equals(newStoreMap.getStorageSpace())) {
            this.storageSpaceMismatch = true;
        }
        if (currentMetaEntity == null) {
            this.metaStore = new MetaGRdbEntityStore();
        } else {
            this.metaStore = (MetaGRdbEntityStore)currentMetaEntity.getEntityStoreDefinition().copy();
            for (MetaProperty p : currentMetaEntity.getDeclaredPropertyList()) {
                if (!(p instanceof MetaPrimitiveProperty)) continue;
                this.initUsed((MetaPrimitiveProperty)p);
            }
            for (RawColType ct : RawColType.values()) {
                for (RawColIndexType cit : RawColIndexType.values()) {
                    ColumnPosition currentMax = ct.getColumnPositionOf(this.metaStore, cit);
                    if (currentMax == null) continue;
                    for (int pageNo = currentMax.getPageNo(); pageNo >= 0; --pageNo) {
                        int colNo;
                        int n = colNo = pageNo == currentMax.getPageNo() ? currentMax.getColumnNo() : ct.getMaxCol(storage, cit);
                        while (colNo > 0) {
                            ColumnPosition cp = new ColumnPosition(pageNo, colNo);
                            if (!this.usedCol.contains(new UsedCol(ct, cit, cp))) {
                                List<ColumnPosition> perIndex;
                                EnumMap<RawColIndexType, List<ColumnPosition>> perType = this.unused.get((Object)ct);
                                if (perType == null) {
                                    perType = new EnumMap(RawColIndexType.class);
                                    this.unused.put(ct, perType);
                                }
                                if ((perIndex = perType.get((Object)cit)) == null) {
                                    perIndex = new ArrayList<ColumnPosition>();
                                    perType.put(cit, perIndex);
                                }
                                perIndex.add(cp);
                            }
                            --colNo;
                        }
                    }
                }
            }
        }
        this.newStoreMap = newStoreMap;
        this.storage = storage;
        this.colContext = new ColContext();
    }

    private void initUsed(MetaPrimitiveProperty p) {
        if (p.getType().isVirtual()) {
            return;
        }
        RawColType ct = RawColType.typeOf(p.getType());
        if (p.getEntityStoreProperty() instanceof MetaGRdbMultiplePropertyStore) {
            for (int i = 0; i < p.getMultiplicity(); ++i) {
                MetaGRdbPropertyStore col = ((MetaGRdbMultiplePropertyStore)p.getEntityStoreProperty()).getStore().get(i);
                this.addUsedCol(p, col, ct);
            }
        } else {
            MetaGRdbPropertyStore col = (MetaGRdbPropertyStore)p.getEntityStoreProperty();
            this.addUsedCol(p, col, ct);
            this.addUsedIndex(p, col, ct);
        }
    }

    private void addUsedCol(MetaPrimitiveProperty p, MetaGRdbPropertyStore col, RawColType ct) {
        if (col.getColumnName().startsWith(ct.getColNamePrefix())) {
            int no = -1;
            try {
                no = Integer.parseInt(col.getColumnName().substring(ct.getColNamePrefix().length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (no != -1) {
                this.usedCol.add(new UsedCol(ct, RawColIndexType.NONE, new ColumnPosition(col.getPageNo(), no), col, p));
            }
        }
    }

    private void addUsedIndex(MetaPrimitiveProperty p, MetaGRdbPropertyStore col, RawColType ct) {
        RawColIndexType cit = RawColIndexType.typeOf(p.getIndexType());
        if (!col.isNative() && !col.isExternalIndex() && cit != RawColIndexType.NONE) {
            this.usedCol.add(new UsedCol(ct, cit, new ColumnPosition(col.getIndexPageNo(), col.getIndexColumnNo()), col, p));
        }
    }

    public MetaGRdbEntityStore getMetaStore() {
        return this.metaStore;
    }

    public ColContext getColContext() {
        return this.colContext;
    }

    private MetaRdbColumnMapping getMapping(MetaProperty prop) {
        if (this.newStoreMap != null && !this.storageSpaceMismatch && this.newStoreMap.getColumnMappingList() != null) {
            for (MetaRdbColumnMapping cm : this.newStoreMap.getColumnMappingList()) {
                if (!prop.getId().equals(cm.getPropertyId())) continue;
                return cm;
            }
        }
        return null;
    }

    private MetaGRdbPropertyStore newCol(RawColType pt) {
        ColumnPosition current = pt.getColumnPositionOf(this.metaStore, RawColIndexType.NONE);
        if (current == null) {
            current = new ColumnPosition();
            pt.setColumnPositionOf(this.metaStore, RawColIndexType.NONE, current);
        }
        if (current.getColumnNo() >= pt.getMaxNormalCol(this.storage)) {
            current.setPageNo(current.getPageNo() + 1);
            current.setColumnNo(1);
        } else {
            current.setColumnNo(current.getColumnNo() + 1);
        }
        MetaGRdbPropertyStore col = new MetaGRdbPropertyStore(current.getPageNo(), pt.getColNamePrefix() + current.getColumnNo());
        return col;
    }

    private boolean isNative(MetaPrimitiveProperty prop) {
        if (prop.getEntityStoreProperty() instanceof MetaGRdbMultiplePropertyStore) {
            return ((MetaGRdbMultiplePropertyStore)prop.getEntityStoreProperty()).getStore().get(0).isNative();
        }
        if (prop.getEntityStoreProperty() instanceof MetaGRdbPropertyStore) {
            return ((MetaGRdbPropertyStore)prop.getEntityStoreProperty()).isNative();
        }
        return false;
    }

    public void allocateCol(MetaPrimitiveProperty prop, MetaPrimitiveProperty old, VersionControlType vcType) {
        if (prop.getType().isVirtual()) {
            return;
        }
        MetaRdbColumnMapping colMapped = this.getMapping(prop);
        RawColType newType = RawColType.typeOf(prop.getType());
        if (prop.getMultiplicity() == 1) {
            if (colMapped != null) {
                prop.setEntityStoreProperty(new MetaGRdbPropertyStore(0, colMapped.getColumnName(), true));
            } else {
                IndexType oldIt;
                MetaGRdbPropertyStore newPs;
                ColConverter converter = old == null || this.isNative(old) ? null : ccFactory.getColConverter(old.getType(), prop.getType());
                MetaGRdbPropertyStore oldPs = null;
                if (old != null) {
                    if (old.getEntityStoreProperty() instanceof MetaGRdbMultiplePropertyStore) {
                        oldPs = ((MetaGRdbMultiplePropertyStore)old.getEntityStoreProperty()).getStore().get(0);
                    } else if (old.getEntityStoreProperty() instanceof MetaGRdbPropertyStore) {
                        oldPs = (MetaGRdbPropertyStore)old.getEntityStoreProperty();
                    }
                }
                if (converter != null && converter.canUseSameCol()) {
                    newPs = oldPs.copy();
                } else {
                    newPs = this.newCol(newType);
                    if (converter != null && oldPs != null) {
                        this.colContext.addConvert(converter, newPs, oldPs);
                    }
                }
                prop.setEntityStoreProperty(newPs);
                IndexType newIt = prop.getIndexType() == null ? IndexType.NON_INDEXED : prop.getIndexType();
                IndexType indexType = oldIt = old == null || old.getMultiplicity() > 1 || old.getIndexType() == null ? IndexType.NON_INDEXED : old.getIndexType();
                if (newIt == IndexType.NON_INDEXED) {
                    ((MetaGRdbPropertyStore)prop.getEntityStoreProperty()).resetIndex();
                } else if (old == null) {
                    this.newIndex(prop.getType(), prop.getIndexType(), vcType, newPs, oldPs, null);
                } else if (converter == null || !converter.canUseSameCol() || newIt != oldIt || newPs.isExternalIndex() != oldPs.isExternalIndex()) {
                    if (converter != null) {
                        this.newIndex(prop.getType(), prop.getIndexType(), vcType, newPs, oldPs, converter);
                    } else {
                        this.newIndex(prop.getType(), prop.getIndexType(), vcType, newPs, oldPs, null);
                    }
                }
            }
        } else if (colMapped != null) {
            MetaGRdbMultiplePropertyStore ps = new MetaGRdbMultiplePropertyStore();
            ArrayList<MetaGRdbPropertyStore> cols = new ArrayList<MetaGRdbPropertyStore>();
            for (int i = 0; i < prop.getMultiplicity(); ++i) {
                cols.add(new MetaGRdbPropertyStore(0, colMapped.getColumnName() + "_" + i, true));
            }
            ps.setStore(cols);
            prop.setEntityStoreProperty(ps);
        } else {
            ColConverter converter = old == null || this.isNative(old) ? null : ccFactory.getColConverter(old.getType(), prop.getType());
            ArrayList<MetaGRdbPropertyStore> cols = new ArrayList<MetaGRdbPropertyStore>();
            int needSize = prop.getMultiplicity();
            if (converter != null && converter.canUseSameCol()) {
                if (old.getEntityStoreProperty() instanceof MetaGRdbPropertyStore) {
                    MetaGRdbPropertyStore copy = (MetaGRdbPropertyStore)old.getEntityStoreProperty().copy();
                    copy.resetIndex();
                    cols.add(copy);
                    --needSize;
                } else if (old.getEntityStoreProperty() instanceof MetaGRdbMultiplePropertyStore) {
                    MetaGRdbMultiplePropertyStore mulStore = (MetaGRdbMultiplePropertyStore)old.getEntityStoreProperty();
                    for (MetaGRdbPropertyStore s : mulStore.getStore()) {
                        if (needSize <= 0) break;
                        MetaGRdbPropertyStore copy = s.copy();
                        copy.resetIndex();
                        cols.add(copy);
                        --needSize;
                    }
                }
                for (int i = 0; i < needSize; ++i) {
                    cols.add(this.newCol(newType));
                }
                prop.setEntityStoreProperty(new MetaGRdbMultiplePropertyStore(cols));
            } else {
                for (int i = 0; i < prop.getMultiplicity(); ++i) {
                    cols.add(this.newCol(newType));
                }
                MetaGRdbMultiplePropertyStore ret = new MetaGRdbMultiplePropertyStore(cols);
                if (converter != null) {
                    List<MetaGRdbPropertyStore> oldStoreCols = null;
                    if (old.getEntityStoreProperty() instanceof MetaGRdbMultiplePropertyStore) {
                        oldStoreCols = ((MetaGRdbMultiplePropertyStore)old.getEntityStoreProperty()).getStore();
                    } else if (old.getEntityStoreProperty() instanceof MetaGRdbPropertyStore) {
                        oldStoreCols = Collections.singletonList((MetaGRdbPropertyStore)old.getEntityStoreProperty());
                    }
                    if (oldStoreCols != null) {
                        int loops = Math.min(cols.size(), oldStoreCols.size());
                        for (int i = 0; i < loops; ++i) {
                            this.colContext.addConvert(converter, cols.get(i), oldStoreCols.get(i));
                        }
                    }
                }
                prop.setEntityStoreProperty(ret);
                return;
            }
        }
    }

    private boolean isVersionedUnique(IndexType iType, VersionControlType vcType) {
        return !(iType != IndexType.UNIQUE && iType != IndexType.UNIQUE_WITHOUT_NULL || vcType != VersionControlType.VERSIONED && vcType != VersionControlType.TIMEBASE && vcType != VersionControlType.SIMPLE_TIMEBASE && vcType != VersionControlType.STATEBASE);
    }

    private void newIndex(PropertyType pt, IndexType indexType, VersionControlType vcType, MetaGRdbPropertyStore ps, MetaGRdbPropertyStore fromStore, ColConverter converter) {
        RawColType rawColType = RawColType.typeOf(pt);
        int maxCol = rawColType.getMaxCol(this.storage, indexType);
        boolean external = maxCol == 0 || this.isVersionedUnique(indexType, vcType);
        ps.setExternalIndex(external);
        if (!external) {
            List<ColumnPosition> list;
            ColumnPosition current = rawColType.getColumnPositionOf(this.metaStore, indexType);
            if (current == null) {
                current = new ColumnPosition();
                rawColType.setColumnPositionOf(this.metaStore, indexType, current);
            }
            RawColIndexType rawColIndexType = RawColIndexType.typeOf(indexType);
            boolean reuse = false;
            ColumnPosition currentPosi = null;
            EnumMap<RawColIndexType, List<ColumnPosition>> perType = this.unused.get((Object)rawColType);
            if (perType != null && (list = perType.get((Object)rawColIndexType)) != null && list.size() > 0) {
                currentPosi = list.remove(list.size() - 1);
                reuse = true;
            }
            if (reuse) {
                ps.setIndexPageNo(currentPosi.getPageNo());
                ps.setIndexColumnNo(currentPosi.getColumnNo());
            } else {
                if (current.getColumnNo() >= maxCol) {
                    current.setPageNo(current.getPageNo() + 1);
                    current.setColumnNo(1);
                } else {
                    current.setColumnNo(current.getColumnNo() + 1);
                }
                ps.setIndexPageNo(current.getPageNo());
                ps.setIndexColumnNo(current.getColumnNo());
            }
            if (converter != null) {
                this.colContext.addIndexConvert(converter, indexType, ps, fromStore);
            } else if (reuse && fromStore == null) {
                this.colContext.addIndexConvert(new ColConverter.NoneColConverter(pt, pt), indexType, ps, ps);
            }
        }
    }

    public void moveToUnusedCol(UsedCol col) {
        List<ColumnPosition> list;
        EnumMap<RawColIndexType, List<ColumnPosition>> perType;
        if (!col.getCol().isNative() && (perType = this.unused.get((Object)col.getRawColType())) != null && (list = perType.get((Object)col.getRawColIndexType())) != null && list.size() > 0) {
            ColumnPosition toMove = list.remove(list.size() - 1);
            if (toMove.compareTo(col.getPosition()) < 0) {
                IndexType it = switch (col.getRawColIndexType()) {
                    case RawColIndexType.NONE -> null;
                    case RawColIndexType.INDEX, RawColIndexType.UNIQUE_INDEX -> col.getProperty().getIndexType();
                    default -> null;
                };
                this.colContext.addMove(toMove, col.getPosition(), col.getRawColType(), it);
                this.colContext.addSetNull(col.getPosition(), col.getRawColType(), it);
                col.getPosition().setPageNo(toMove.getPageNo());
                col.getPosition().setColumnNo(toMove.getColumnNo());
                MetaGRdbPropertyStore store = col.getCol();
                switch (col.getRawColIndexType()) {
                    case NONE: {
                        store.setPageNo(col.getPosition().getPageNo());
                        store.setColumnName(col.getRawColType().getColNamePrefix() + col.getPosition().getColumnNo());
                        break;
                    }
                    case INDEX: 
                    case UNIQUE_INDEX: {
                        store.setIndexPageNo(col.getPosition().getPageNo());
                        store.setIndexColumnNo(col.getPosition().getColumnNo());
                    }
                }
            } else {
                list.add(toMove);
            }
        }
    }

    public void shrink() {
        if (this.unused.size() > 0) {
            UsedCol[] orderedUsedCol = this.usedCol.toArray(new UsedCol[this.usedCol.size()]);
            Arrays.sort(orderedUsedCol, Comparator.naturalOrder());
            for (UsedCol uc : orderedUsedCol) {
                this.moveToUnusedCol(uc);
            }
            for (Map.Entry entry : this.unused.entrySet()) {
                for (Map.Entry list : ((EnumMap)entry.getValue()).entrySet()) {
                    if (list.getValue() == null) continue;
                    for (ColumnPosition cp : (List)list.getValue()) {
                        this.colContext.addSetNull(cp, (RawColType)((Object)entry.getKey()), switch ((RawColIndexType)((Object)list.getKey())) {
                            case RawColIndexType.NONE -> null;
                            case RawColIndexType.INDEX -> IndexType.NON_UNIQUE;
                            case RawColIndexType.UNIQUE_INDEX -> IndexType.UNIQUE;
                            default -> null;
                        });
                    }
                }
            }
            this.metaStore.clearColumnPosition();
            for (UsedCol usedCol : this.usedCol) {
                ColumnPosition cp = usedCol.getRawColType().getColumnPositionOf(this.metaStore, usedCol.getRawColIndexType());
                if (cp == null) {
                    cp = new ColumnPosition();
                    usedCol.getRawColType().setColumnPositionOf(this.metaStore, usedCol.getRawColIndexType(), cp);
                }
                if (cp.compareTo(usedCol.getPosition()) >= 0) continue;
                cp.setPageNo(usedCol.getPosition().getPageNo());
                cp.setColumnNo(usedCol.getPosition().getColumnNo());
            }
        }
    }
}

