/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity;

import java.lang.reflect.Array;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.iplass.mtp.entity.DeleteCondition;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.DeleteTargetVersion;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityApplicationException;
import org.iplass.mtp.entity.EntityConcurrentUpdateException;
import org.iplass.mtp.entity.EntityLockedByUserException;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.UpdateCondition;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.properties.ReferenceType;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.hint.FetchSizeHint;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.datastore.DataStore;
import org.iplass.mtp.impl.datastore.EntityStoreRuntime;
import org.iplass.mtp.impl.datastore.MetaEntityStore;
import org.iplass.mtp.impl.datastore.StoreService;
import org.iplass.mtp.impl.datastore.strategy.EntityStoreStrategy;
import org.iplass.mtp.impl.datastore.strategy.RecycleBinIterator;
import org.iplass.mtp.impl.datastore.strategy.SearchResultIterator;
import org.iplass.mtp.impl.entity.BulkUpdateAdapter;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.EntityStreamSearchHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.MetaEventListener;
import org.iplass.mtp.impl.entity.VirtualPropertyAdapter;
import org.iplass.mtp.impl.entity.builder.EntityBuilder;
import org.iplass.mtp.impl.entity.interceptor.EntityDeleteInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityLoadInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityQueryInvocationImpl;
import org.iplass.mtp.impl.entity.l10n.MetaDataLocalizationStrategy;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferenceSortSpec;
import org.iplass.mtp.impl.entity.versioning.DeleteTarget;
import org.iplass.mtp.impl.entity.versioning.VersionedQueryNormalizer;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.properties.extend.AutoNumberType;
import org.iplass.mtp.impl.properties.extend.BinaryType;
import org.iplass.mtp.impl.properties.extend.ComplexWrapperType;
import org.iplass.mtp.impl.properties.extend.LongTextType;
import org.iplass.mtp.impl.properties.extend.SelectType;
import org.iplass.mtp.impl.properties.extend.select.Value;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityHandler
extends BaseMetaDataRuntime {
    public static final String ROOT_ENTITY_ID = "/entity/Entity";
    private static Logger log = LoggerFactory.getLogger(EntityHandler.class);
    private boolean isRoot;
    private MetaEntity metaData;
    private DataStore dataStore;
    private EntityStoreRuntime entityStoreRuntime;
    private List<PropertyHandler> propertyHandlers;
    private Map<String, PropertyHandler> propertyHandlerMap;
    private Map<String, PropertyHandler> propertyHandlerMapById;
    private List<MetaEventListener.EventListenerRuntime> eventListenerHandlers;
    private Class<? extends Entity> mappingClass;
    private EntityService service;
    private MetaDataConfig metaDataConfig;
    private Map<String, String> localizedStringMap;
    private MetaDataLocalizationStrategy.DataLocalizationStrategyRuntime dataLocalizationStrategyRuntime;

    public EntityHandler(MetaEntity metaData, MetaDataConfig metaDataConfig) {
        try {
            this.metaData = metaData;
            this.metaDataConfig = metaDataConfig;
            this.propertyHandlers = new ArrayList<PropertyHandler>();
            this.propertyHandlerMap = new HashMap<String, PropertyHandler>();
            this.propertyHandlerMapById = new HashMap<String, PropertyHandler>();
            this.eventListenerHandlers = new ArrayList<MetaEventListener.EventListenerRuntime>();
            this.localizedStringMap = new HashMap<String, String>();
            this.dataStore = ServiceRegistry.getRegistry().getService(StoreService.class).getDataStore();
            MetaEntityStore mes = metaData.getEntityStoreDefinition();
            if (mes != null) {
                if (!mes.getClass().equals(this.dataStore.getEntityStoreType())) {
                    throw new IllegalStateException("missmatch dataStore type in config:" + String.valueOf(this.dataStore.getEntityStoreType()) + " and metadata(" + metaData.getName() + "):" + String.valueOf(mes.getClass()));
                }
                this.entityStoreRuntime = mes.createRuntime(this);
            }
            if (metaData.getDeclaredPropertyList() != null) {
                for (MetaProperty pDef : metaData.getDeclaredPropertyList()) {
                    PropertyHandler pHandler = pDef.createRuntime(metaData);
                    this.propertyHandlers.add(pHandler);
                    this.propertyHandlerMap.put(pDef.getName(), pHandler);
                    this.propertyHandlerMapById.put(pDef.getId(), pHandler);
                    pHandler.setParent(this);
                }
            }
            if (metaData.getId().equals(ROOT_ENTITY_ID)) {
                this.isRoot = true;
            }
            if (metaData.getEventListenerList() != null) {
                for (MetaEventListener e : metaData.getEventListenerList()) {
                    this.eventListenerHandlers.add(e.createRuntime(metaData));
                }
            }
            if (metaData.getMapping() != null) {
                this.mappingClass = this.classForName(metaData.getMapping().getMappingClass());
            }
            if (metaData.getLocalizedDisplayNameList() != null) {
                for (MetaLocalizedString mls : metaData.getLocalizedDisplayNameList()) {
                    this.localizedStringMap.put(mls.getLocaleName(), mls.getStringValue());
                }
            }
            if (metaData.getDataLocalizationStrategy() != null) {
                this.dataLocalizationStrategyRuntime = metaData.getDataLocalizationStrategy().createDataLocalizationStrategyRuntime(this);
            }
            this.service = ServiceRegistry.getRegistry().getService(EntityService.class);
        }
        catch (RuntimeException e) {
            this.setIllegalStateException(e);
        }
    }

    private Class<? extends Entity> classForName(String className) {
        Class<?> c = null;
        try {
            c = Class.forName(className);
            if (!Entity.class.isAssignableFrom(c)) {
                log.error("Illegal definition on " + this.metaData.getName() + ". Entity Mapping Class:" + className + " must implements Entity interface.");
            }
        }
        catch (ClassNotFoundException e) {
            log.error("MappingClass:" + className + " Not Found on " + this.metaData.getName());
        }
        return c;
    }

    public MetaDataLocalizationStrategy.DataLocalizationStrategyRuntime getDataLocalizationStrategyRuntime() {
        return this.dataLocalizationStrategyRuntime;
    }

    public EntityStoreRuntime getEntityStoreRuntime() {
        return this.entityStoreRuntime;
    }

    public boolean isUseSharedPermission() {
        return this.metaDataConfig.isPermissionSharable();
    }

    public boolean isUseSharedMetaData() {
        if (!this.metaDataConfig.isSharable()) {
            return false;
        }
        MetaDataEntry ent = MetaDataContext.getContext().getMetaDataEntryById(this.getMetaData().getId());
        return ent.getRepositryType() == MetaDataEntry.RepositoryType.SHARED;
    }

    public boolean isUseSharedData() {
        if (!this.metaDataConfig.isDataSharable()) {
            return false;
        }
        MetaDataEntry ent = MetaDataContext.getContext().getMetaDataEntryById(this.getMetaData().getId());
        return ent.getRepositryType() == MetaDataEntry.RepositoryType.SHARED;
    }

    public Map<String, String> getLocalizedStringMap() {
        return this.localizedStringMap;
    }

    public void setLocalizedStringMap(Map<String, String> localizedStringMap) {
        this.localizedStringMap = localizedStringMap;
    }

    public Entity newInstance() {
        this.checkState();
        Entity res = null;
        if (this.mappingClass != null) {
            try {
                res = this.mappingClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new EntityRuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new EntityRuntimeException(e);
            }
        } else {
            res = new GenericEntity();
        }
        res.setDefinitionName(this.getMetaData().getName());
        return res;
    }

    public Entity[] newArrayInstance(int size) {
        this.checkState();
        Entity[] res = null;
        res = this.mappingClass != null ? (Entity[])Array.newInstance(this.mappingClass, size) : new Entity[size];
        return res;
    }

    public EntityService getService() {
        return this.service;
    }

    public List<MetaEventListener.EventListenerRuntime> getEventListenerHandlers() {
        return this.eventListenerHandlers;
    }

    public DataStore getDataStore() {
        return this.dataStore;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    @Override
    public MetaEntity getMetaData() {
        return this.metaData;
    }

    public PropertyHandler getDeclaredProperty(String propName) {
        this.checkState();
        if (this.propertyHandlerMap == null) {
            return null;
        }
        return this.propertyHandlerMap.get(propName);
    }

    public List<PropertyHandler> getDeclaredPropertyList() {
        this.checkState();
        if (this.propertyHandlers == null) {
            return Collections.emptyList();
        }
        return this.propertyHandlers;
    }

    public EntityHandler getSuperDataModelHandler(EntityContext context) {
        if (this.isRoot) {
            return null;
        }
        String superEntityMetaDataId = this.metaData.getInheritedEntityMetaDataId();
        if (superEntityMetaDataId == null) {
            return context.getHandlerById(ROOT_ENTITY_ID);
        }
        EntityHandler superHandler = context.getHandlerById(superEntityMetaDataId);
        if (superHandler == null) {
            throw new EntityRuntimeException("super entity definition is not defined.");
        }
        return superHandler;
    }

    public PropertyHandler getProperty(String propName, EntityContext context) {
        EntityHandler superHandler;
        this.checkState();
        PropertyHandler p = this.getDeclaredProperty(propName);
        if (p == null && (superHandler = this.getSuperDataModelHandler(context)) != null) {
            p = superHandler.getProperty(propName, context);
        }
        return p;
    }

    public PropertyHandler getPropertyCascade(String propName, EntityContext context) {
        this.checkState();
        int indexOfDot = propName.indexOf(46);
        if (indexOfDot > -1) {
            String objPropName = propName.substring(0, indexOfDot);
            String subPropPath = propName.substring(indexOfDot + 1, propName.length());
            PropertyHandler prop = this.getProperty(objPropName, context);
            if (!(prop instanceof ReferencePropertyHandler)) {
                throw new IllegalArgumentException("path is invalid:" + objPropName + " is not ObjectReferenceProperty of " + this.getMetaData().getName());
            }
            ReferencePropertyHandler refProp = (ReferencePropertyHandler)prop;
            EntityHandler refHandler = refProp.getReferenceEntityHandler(context);
            if (refHandler == null) {
                throw new EntityRuntimeException(objPropName + "'s Entity is not defined.");
            }
            return refHandler.getPropertyCascade(subPropPath, context);
        }
        return this.getProperty(propName, context);
    }

    public List<PropertyHandler> getPropertyListByPropertyType(Class<? extends PropertyType> type, EntityContext context) {
        List<PropertyHandler> parentPropList;
        this.checkState();
        ArrayList<PropertyHandler> propList = null;
        EntityHandler superHandler = this.getSuperDataModelHandler(context);
        if (superHandler != null && (parentPropList = superHandler.getPropertyListByPropertyType(type, context)).size() > 0) {
            if (propList == null) {
                propList = new ArrayList<PropertyHandler>();
            }
            propList.addAll(parentPropList);
        }
        for (PropertyHandler ph : this.getDeclaredPropertyList()) {
            if (!(ph instanceof PrimitivePropertyHandler) || !type.isAssignableFrom(((PrimitivePropertyHandler)ph).getMetaData().getType().getClass())) continue;
            if (propList == null) {
                propList = new ArrayList();
            }
            propList.add(ph);
        }
        if (propList == null) {
            return Collections.emptyList();
        }
        return propList;
    }

    public List<PrimitivePropertyHandler> getIndexedPropertyList(EntityContext context) {
        List<PrimitivePropertyHandler> parentPropList;
        this.checkState();
        ArrayList<PrimitivePropertyHandler> propList = null;
        EntityHandler superHandler = this.getSuperDataModelHandler(context);
        if (superHandler != null && (parentPropList = superHandler.getIndexedPropertyList(context)).size() > 0) {
            if (propList == null) {
                propList = new ArrayList<PrimitivePropertyHandler>();
            }
            propList.addAll(parentPropList);
        }
        for (PropertyHandler ph : this.getDeclaredPropertyList()) {
            if (!(ph instanceof PrimitivePropertyHandler) || ((PrimitivePropertyHandler)ph).getMetaData().getType().isVirtual() || ((PrimitivePropertyHandler)ph).getMetaData().getIndexType() == null || ((PrimitivePropertyHandler)ph).getMetaData().getIndexType() == IndexType.NON_INDEXED) continue;
            if (propList == null) {
                propList = new ArrayList();
            }
            propList.add((PrimitivePropertyHandler)ph);
        }
        if (propList == null) {
            return Collections.emptyList();
        }
        return propList;
    }

    public List<ReferencePropertyHandler> getReferencePropertyList(ReferenceType type, EntityContext context) {
        List<ReferencePropertyHandler> parentPropList;
        this.checkState();
        ArrayList<ReferencePropertyHandler> propList = null;
        EntityHandler superHandler = this.getSuperDataModelHandler(context);
        if (superHandler != null && (parentPropList = superHandler.getReferencePropertyList(type, context)).size() > 0) {
            if (propList == null) {
                propList = new ArrayList<ReferencePropertyHandler>();
            }
            propList.addAll(parentPropList);
        }
        for (PropertyHandler ph : this.getDeclaredPropertyList()) {
            if (!(ph instanceof ReferencePropertyHandler)) continue;
            ReferencePropertyHandler rph = (ReferencePropertyHandler)ph;
            if (type != null && type != rph.getMetaData().getReferenceType()) continue;
            if (propList == null) {
                propList = new ArrayList();
            }
            propList.add(rph);
        }
        if (propList == null) {
            return Collections.emptyList();
        }
        return propList;
    }

    public List<ReferencePropertyHandler> getReferencePropertyList(boolean withoutMappedBy, EntityContext context) {
        List<ReferencePropertyHandler> parentPropList;
        this.checkState();
        ArrayList<ReferencePropertyHandler> propList = null;
        EntityHandler superHandler = this.getSuperDataModelHandler(context);
        if (superHandler != null && (parentPropList = superHandler.getReferencePropertyList(withoutMappedBy, context)).size() > 0) {
            if (propList == null) {
                propList = new ArrayList<ReferencePropertyHandler>();
            }
            propList.addAll(parentPropList);
        }
        for (PropertyHandler ph : this.getDeclaredPropertyList()) {
            if (!(ph instanceof ReferencePropertyHandler)) continue;
            ReferencePropertyHandler rph = (ReferencePropertyHandler)ph;
            if (withoutMappedBy && rph.getMetaData().getMappedByPropertyMetaDataId() != null) continue;
            if (propList == null) {
                propList = new ArrayList();
            }
            propList.add(rph);
        }
        if (propList == null) {
            return Collections.emptyList();
        }
        return propList;
    }

    public List<PropertyHandler> getPropertyList(EntityContext context) {
        this.checkState();
        EntityHandler superHandler = this.getSuperDataModelHandler(context);
        if (superHandler == null) {
            return this.getDeclaredPropertyList();
        }
        ArrayList<PropertyHandler> propList = new ArrayList<PropertyHandler>();
        propList.addAll(superHandler.getPropertyList(context));
        propList.addAll(this.getDeclaredPropertyList());
        return propList;
    }

    public List<ValidateError> validate(Entity model, List<String> updateValue) {
        return this.validateInternal(model, updateValue, this.getMetaData().getNamePropertyId() != null);
    }

    private List<ValidateError> validateInternal(Entity model, List<String> updateValue, boolean isNamePropSpecify) {
        this.checkState();
        EntityContext context = EntityContext.getCurrentContext();
        ArrayList<ValidateError> validateResults = new ArrayList<ValidateError>();
        EntityHandler superHandler = this.getSuperDataModelHandler(context);
        if (superHandler != null) {
            validateResults.addAll(superHandler.validateInternal(model, updateValue, isNamePropSpecify));
        }
        if (this.propertyHandlers != null) {
            for (PropertyHandler propertyHandler : this.propertyHandlers) {
                ValidateError valRes;
                if (updateValue != null && !updateValue.contains(propertyHandler.getName())) continue;
                ValidationContext vc = new ValidationContext(model, propertyHandler.getName());
                if (propertyHandler.getName().equals("name")) {
                    if (isNamePropSpecify) continue;
                    propertyHandler.normalize(vc);
                    valRes = propertyHandler.validate(vc);
                    if (valRes == null) continue;
                    validateResults.add(valRes);
                    continue;
                }
                propertyHandler.normalize(vc);
                valRes = propertyHandler.validate(vc);
                if (valRes == null) continue;
                validateResults.add(valRes);
            }
        }
        return validateResults;
    }

    private void checkLimitOfReferences(Entity e, ReferencePropertyHandler rh, EntityContext entityContext) {
        Entity[] refList;
        if (rh.getMetaData().getMappedByPropertyMetaDataId() == null && rh.getMetaData().getMultiplicity() != 1 && (refList = (Entity[])e.getValue(rh.getName())) != null && refList.length > this.service.getLimitOfReferences()) {
            throw new EntityRuntimeException("reference count is over the " + this.service.getLimitOfReferences() + " limit. EntityDefinition:" + e.getDefinitionName() + ", ReferenceName:" + rh.getName());
        }
    }

    public String insertDirect(Entity entity, EntityContext entityContext) {
        this.checkState();
        for (PropertyHandler ph : this.getDeclaredPropertyList()) {
            if (!(ph instanceof ReferencePropertyHandler)) continue;
            this.checkLimitOfReferences(entity, (ReferencePropertyHandler)ph, entityContext);
        }
        List<PropertyHandler> propList = this.getPropertyListByPropertyType(ComplexWrapperType.class, entityContext);
        this.preprocessInsertDirect(entity, entityContext, propList);
        EntityStoreStrategy insertStrategy = this.getStrategy();
        String oid = insertStrategy.insert(entityContext, this, entity);
        return oid;
    }

    public String insert(Entity entity, InsertOption option) {
        this.checkState();
        ExecuteContext mtfContext = ExecuteContext.getCurrentContext();
        EntityContext entityContext = EntityContext.getCurrentContext();
        GenericEntity copyEntity = ((GenericEntity)entity).copy();
        if (option.isEnableAuditPropertySpecification()) {
            if (copyEntity.getCreateBy() == null) {
                copyEntity.setCreateBy(mtfContext.getClientId());
            }
            if (copyEntity.getUpdateBy() == null) {
                copyEntity.setUpdateBy(mtfContext.getClientId());
            }
        } else {
            copyEntity.setCreateBy(mtfContext.getClientId());
            copyEntity.setUpdateBy(mtfContext.getClientId());
        }
        if (copyEntity.getState() == null) {
            copyEntity.setState(new SelectValue("V"));
        }
        if (!option.isEnableAuditPropertySpecification()) {
            copyEntity.setCreateDate(null);
            copyEntity.setUpdateDate(null);
        }
        if (option.isRegenerateOid()) {
            copyEntity.setOid(null);
        }
        List<PropertyHandler> pList = this.getPropertyListByPropertyType(AutoNumberType.class, entityContext);
        if (option.isRegenerateAutoNumber()) {
            for (PropertyHandler ph : pList) {
                copyEntity.setValue(ph.getName(), null);
            }
        }
        this.service.getVersionController(this).normalizeForInsert(copyEntity, option, entityContext);
        for (PropertyHandler ph : this.getDeclaredPropertyList()) {
            if (!(ph instanceof ReferencePropertyHandler) || ((ReferencePropertyHandler)ph).getMetaData().getMappedByPropertyMetaDataId() != null || copyEntity.getValue(ph.getName()) == null) continue;
            ReferencePropertyHandler rph = (ReferencePropertyHandler)ph;
            if (rph.getMetaData().getMultiplicity() != 1) {
                copyEntity.setValue(rph.getName(), this.service.getVersionController(rph.getReferenceEntityHandler(entityContext)).normalizeRefEntity((Entity[])copyEntity.getValue(rph.getName()), rph, entityContext));
                continue;
            }
            Entity[] holder = new Entity[]{(Entity)copyEntity.getValue(rph.getName())};
            if (holder[0] == null) continue;
            copyEntity.setValue(rph.getName(), this.service.getVersionController(rph.getReferenceEntityHandler(entityContext)).normalizeRefEntity(holder, rph, entityContext)[0]);
        }
        String oid = this.insertDirect(copyEntity, entityContext);
        entity.setOid(oid);
        entity.setVersion(copyEntity.getVersion());
        if (pList != null) {
            for (PropertyHandler ph : pList) {
                entity.setValue(ph.getName(), copyEntity.getValue(ph.getName()));
            }
        }
        return oid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Entity getEntityWithPropList(String oid, Long version, List<PropertyHandler> pList, EntityContext entityContext) {
        Query q = new Query();
        q.select().add((Object)"oid");
        for (PropertyHandler p : pList) {
            if (!(p instanceof PrimitivePropertyHandler)) continue;
            q.select().add((Object)p.getName());
        }
        if (q.getSelect() != null && q.getSelect().getSelectValues() != null && q.getSelect().getSelectValues().size() != 0) {
            q.from(this.getMetaData().getName());
            q.where(new And(new Equals("oid", oid), new Equals("version", version)));
            q.select().addHint(new FetchSizeHint(1));
            try (SearchResultIterator it = this.getStrategy().search(entityContext, q, this);){
                if (it.next()) {
                    Entity ret;
                    Entity entity = ret = EntityHandler.getAsEntity(this, it, q);
                    return entity;
                }
                Entity entity = null;
                return entity;
            }
        }
        return null;
    }

    private String toName(Object val, PrimitivePropertyHandler pph) {
        PropertyType type = pph.getMetaData().getType();
        if (type instanceof SelectType) {
            SelectType st = (SelectType)type;
            List<Value> stvList = st.runtimeValues();
            if (stvList != null) {
                for (Value vDef : stvList) {
                    if (!vDef.getValue().equals(((SelectValue)val).getValue())) continue;
                    String lang = ExecuteContext.getCurrentContext().getLanguage();
                    if (lang != null && vDef.getLocalizedDisplayNameList() != null) {
                        for (MetaLocalizedString mls : vDef.getLocalizedDisplayNameList()) {
                            if (!mls.getLocaleName().equals(lang)) continue;
                            return mls.getStringValue();
                        }
                    }
                    return vDef.getDisplayName();
                }
            }
            throw new EntityRuntimeException(((SelectValue)val).getValue() + " not define at " + pph.getName());
        }
        return val.toString();
    }

    public void normalize(Entity entity, List<String> targetProperties) {
        this.checkState();
        this.normalizeInternal(entity, targetProperties, EntityContext.getCurrentContext());
    }

    void normalizeInternal(Entity entity, List<String> targetProperties, EntityContext entityContext) {
        EntityHandler superHandler = this.getSuperDataModelHandler(entityContext);
        if (superHandler != null) {
            superHandler.normalizeInternal(entity, targetProperties, entityContext);
        }
        if (this.propertyHandlers != null) {
            for (PropertyHandler propertyHandler : this.propertyHandlers) {
                if (targetProperties != null && !targetProperties.contains(propertyHandler.getName())) continue;
                ValidationContext vc = new ValidationContext(entity, propertyHandler.getName());
                propertyHandler.normalize(vc);
            }
        }
    }

    void preprocessInsertDirect(Entity entity, EntityContext entityContext, List<PropertyHandler> complexWrapperTypePropList) {
        String oid = entity.getOid();
        if (oid == null) {
            if (this.getMetaData().getOidPropertyId() == null || this.getMetaData().getOidPropertyId().size() == 0) {
                oid = this.getStrategy().newOid(entityContext, this);
                entity.setOid(oid);
            } else {
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.getMetaData().getOidPropertyId().size(); ++i) {
                    PrimitivePropertyHandler pph;
                    Object oidVal;
                    if (i != 0) {
                        sb.append("-");
                    }
                    if ((oidVal = entity.getValue((pph = (PrimitivePropertyHandler)this.getDeclaredPropertyById(this.getMetaData().getOidPropertyId().get(i))).getName())) == null) {
                        if (pph.getMetaData().getType() instanceof AutoNumberType) {
                            AutoNumberType autoNum = (AutoNumberType)pph.getMetaData().getType();
                            oidVal = autoNum.toStoreTypeValue(null, null, pph, this, null, entity.getVersion(), entity);
                            entity.setValue(pph.getName(), oidVal);
                        } else {
                            throw new EntityRuntimeException(pph.getName() + " must not null.");
                        }
                    }
                    String oidValStr = pph.getMetaData().getType().toString(oidVal);
                    this.service.checkValidOidPattern(oidValStr);
                    sb.append(oidValStr);
                }
                entity.setOid(sb.toString());
            }
        } else {
            this.service.checkValidOidPattern(oid);
        }
        if (this.getMetaData().getNamePropertyId() != null) {
            PrimitivePropertyHandler pph = (PrimitivePropertyHandler)this.getDeclaredPropertyById(this.getMetaData().getNamePropertyId());
            Object nameVal = entity.getValue(pph.getName());
            if (nameVal == null) {
                if (pph.getMetaData().getType() instanceof AutoNumberType) {
                    AutoNumberType autoNum = (AutoNumberType)pph.getMetaData().getType();
                    nameVal = autoNum.toStoreTypeValue(null, null, pph, this, null, entity.getVersion(), entity);
                    entity.setValue(pph.getName(), nameVal);
                } else {
                    throw new EntityRuntimeException(pph.getName() + " must not null.");
                }
            }
            entity.setName(this.toName(nameVal, pph));
        }
        if (entity.getVersion() == null) {
            entity.setVersion(0L);
        }
        for (PropertyHandler ph : complexWrapperTypePropList) {
            ComplexWrapperType type = (ComplexWrapperType)((PrimitivePropertyHandler)ph).getMetaData().getType();
            Object val = entity.getValue(ph.getName());
            if (val == null || ph.getMetaData().getMultiplicity() == 1) {
                entity.setValue(ph.getName(), type.toStoreTypeValue(val, null, ph, this, entity.getOid(), entity.getVersion(), entity));
                continue;
            }
            Object[] newArrayVal = (Object[])Array.newInstance(type.storeType(), ((Object[])val).length);
            for (int i = 0; i < newArrayVal.length; ++i) {
                newArrayVal[i] = type.toStoreTypeValue(((Object[])val)[i], null, ph, this, entity.getOid(), entity.getVersion(), entity);
            }
            entity.setValue(ph.getName(), newArrayVal);
        }
    }

    boolean preprocessUpdateDirect(Entity entity, UpdateOption option, EntityContext entityContext, List<PropertyHandler> complexWrapperTypePropList, boolean checkPrevExists) {
        boolean prevExists = false;
        if (entity.getVersion() == null) {
            entity.setVersion(0L);
        }
        if (option != null) {
            ArrayList<PropertyHandler> updatePropList = new ArrayList<PropertyHandler>();
            for (String pName : option.getUpdateProperties()) {
                for (PropertyHandler ph : complexWrapperTypePropList) {
                    if (!ph.getName().equals(pName)) continue;
                    updatePropList.add(ph);
                }
            }
            complexWrapperTypePropList = updatePropList;
        }
        if (complexWrapperTypePropList.size() > 0) {
            boolean needPrevEntity = false;
            for (PropertyHandler ph : complexWrapperTypePropList) {
                ComplexWrapperType type = (ComplexWrapperType)((PrimitivePropertyHandler)ph).getMetaData().getType();
                needPrevEntity = needPrevEntity || type.isNeedPrevStoreTypeValueOnToStoreTypeValue();
            }
            Entity beforeUpdateEntity = null;
            if (needPrevEntity) {
                beforeUpdateEntity = this.getEntityWithPropList(entity.getOid(), entity.getVersion(), complexWrapperTypePropList, entityContext);
                if (beforeUpdateEntity == null && checkPrevExists) {
                    throw new EntityConcurrentUpdateException(EntityHandler.resourceString("impl.core.EntityHandler.alreadyOperated", this.getMetaData().getDisplayName()));
                }
                prevExists = beforeUpdateEntity != null;
            }
            for (PropertyHandler ph : complexWrapperTypePropList) {
                Object[] oldArrayVal;
                ComplexWrapperType type = (ComplexWrapperType)((PrimitivePropertyHandler)ph).getMetaData().getType();
                Object val = entity.getValue(ph.getName());
                Object beforeVal = null;
                if (beforeUpdateEntity != null && type.isNeedPrevStoreTypeValueOnToStoreTypeValue()) {
                    beforeVal = beforeUpdateEntity.getValue(ph.getName());
                }
                if (ph.getMetaData().getMultiplicity() == 1) {
                    entity.setValue(ph.getName(), type.toStoreTypeValue(val, beforeVal, ph, this, entity.getOid(), entity.getVersion(), entity));
                    continue;
                }
                int count = 0;
                Object[] newArrayVal = null;
                if (val != null) {
                    newArrayVal = (Object[])Array.newInstance(type.storeType(), ((Object[])val).length);
                    count = newArrayVal.length;
                }
                if ((oldArrayVal = (Object[])beforeVal) != null && count < oldArrayVal.length) {
                    count = oldArrayVal.length;
                }
                for (int i = 0; i < count; ++i) {
                    Object newVal = null;
                    if (val != null && newArrayVal != null && i < newArrayVal.length) {
                        newVal = ((Object[])val)[i];
                    }
                    Object oldVal = null;
                    if (oldArrayVal != null && i < oldArrayVal.length) {
                        oldVal = oldArrayVal[i];
                    }
                    Object ret = type.toStoreTypeValue(newVal, oldVal, ph, this, entity.getOid(), entity.getVersion(), entity);
                    if (newArrayVal == null || i >= newArrayVal.length) continue;
                    newArrayVal[i] = ret;
                }
                entity.setValue(ph.getName(), newArrayVal);
            }
        }
        if (this.getMetaData().getNamePropertyId() != null) {
            PrimitivePropertyHandler pph = (PrimitivePropertyHandler)this.getDeclaredPropertyById(this.getMetaData().getNamePropertyId());
            if (option == null || option.getUpdateProperties() != null && option.getUpdateProperties().contains(pph.getName())) {
                Object val = entity.getValue(pph.getName());
                if (val == null) {
                    throw new EntityRuntimeException(pph.getName() + " must not null.");
                }
                entity.setName(this.toName(val, pph));
                if (option != null && !option.getUpdateProperties().contains("name")) {
                    option.getUpdateProperties().add("name");
                }
            }
        }
        return prevExists;
    }

    public void updateDirect(Entity entity, UpdateOption option, EntityContext entityContext) {
        this.checkState();
        if (entity.getOid() == null) {
            throw new NullPointerException("oid is null");
        }
        for (PropertyHandler ph : this.getDeclaredPropertyList()) {
            if (!(ph instanceof ReferencePropertyHandler) || !option.getUpdateProperties().contains(ph.getName())) continue;
            this.checkLimitOfReferences(entity, (ReferencePropertyHandler)ph, entityContext);
        }
        List<PropertyHandler> propList = this.getPropertyListByPropertyType(ComplexWrapperType.class, entityContext);
        this.preprocessUpdateDirect(entity, option, entityContext, propList, true);
        EntityStoreStrategy updateStrategy = this.getStrategy();
        updateStrategy.update(entityContext, this, entity, option);
    }

    public void update(Entity entity, UpdateOption option) {
        this.checkState();
        ExecuteContext context = ExecuteContext.getCurrentContext();
        EntityContext entityContext = EntityContext.getCurrentContext();
        for (String propName : option.getUpdateProperties()) {
            PropertyHandler ph = this.getProperty(propName, entityContext);
            if (ph == null) {
                throw new EntityRuntimeException(propName + " is not defined on " + this.getMetaData().getName());
            }
            if (ph instanceof ReferencePropertyHandler && ((ReferencePropertyHandler)ph).getMetaData().getMappedByPropertyMetaDataId() != null) {
                throw new EntityApplicationException(EntityHandler.resourceString("impl.core.EntityHandler.notChange", this.getProperty(propName, entityContext).getMetaData().getDisplayName()));
            }
            if (ph instanceof PrimitivePropertyHandler && ((MetaPrimitiveProperty)ph.getMetaData()).getType().isVirtual()) {
                throw new EntityApplicationException(EntityHandler.resourceString("impl.core.EntityHandler.notChange", this.getProperty(propName, entityContext).getMetaData().getDisplayName()));
            }
            if (!(option.isWithValidation() ? !ph.getMetaData().isUpdatable() : ph instanceof PrimitivePropertyHandler && (propName.equals("oid") || propName.equals("version") || propName.equals("updateBy") || propName.equals("updateDate") || propName.equals("createBy") || propName.equals("createDate")))) continue;
            throw new EntityApplicationException(EntityHandler.resourceString("impl.core.EntityHandler.notChange", this.getProperty(propName, entityContext).getMetaData().getDisplayName()));
        }
        Entity beforeEntity = null;
        List<ReferencePropertyHandler> cascadeDelTarget = this.cascadeDeleteTarget(option, entityContext);
        if (option.isCheckLockedByUser() || cascadeDelTarget != null) {
            if (cascadeDelTarget == null) {
                beforeEntity = (Entity)new EntityLoadInvocationImpl(entity.getOid(), entity.getVersion(), new LoadOption(false, false), false, this.service.getInterceptors(), this).proceed();
            } else {
                ArrayList<String> refs = new ArrayList<String>(cascadeDelTarget.size());
                for (ReferencePropertyHandler referencePropertyHandler : cascadeDelTarget) {
                    refs.add(referencePropertyHandler.getName());
                }
                beforeEntity = (Entity)new EntityLoadInvocationImpl(entity.getOid(), entity.getVersion(), new LoadOption(refs), false, this.service.getInterceptors(), this).proceed();
            }
            if (beforeEntity == null) {
                throw new EntityConcurrentUpdateException(EntityHandler.resourceString("impl.core.EntityHandler.alreadyOperated", this.getMetaData().getDisplayName()));
            }
        }
        String lockedByUser = null;
        if (option.isCheckLockedByUser() && (lockedByUser = beforeEntity.getLockedBy()) != null && !lockedByUser.equals(context.getClientId())) {
            throw new EntityLockedByUserException(EntityHandler.resourceString("impl.core.EntityHandler.locked", new Object[0]));
        }
        GenericEntity copyEntity = ((GenericEntity)entity).copy();
        if (!option.getUpdateProperties().contains("updateBy")) {
            option.getUpdateProperties().add("updateBy");
        }
        copyEntity.setUpdateBy(context.getClientId());
        if (copyEntity.getState() == null) {
            copyEntity.setState(new SelectValue("V"));
        }
        if (lockedByUser != null) {
            copyEntity.setLockedBy(lockedByUser);
        }
        for (String propName : option.getUpdateProperties()) {
            PropertyHandler ph = this.getProperty(propName, entityContext);
            if (!(ph instanceof ReferencePropertyHandler) || ((ReferencePropertyHandler)ph).getMetaData().getMappedByPropertyMetaDataId() != null) continue;
            ReferencePropertyHandler rph = (ReferencePropertyHandler)ph;
            if (rph.getMetaData().getMultiplicity() != 1) {
                copyEntity.setValue(rph.getName(), this.service.getVersionController(rph.getReferenceEntityHandler(entityContext)).normalizeRefEntity((Entity[])copyEntity.getValue(rph.getName()), rph, entityContext));
                continue;
            }
            Entity[] holder = new Entity[]{(Entity)copyEntity.getValue(rph.getName())};
            if (holder[0] == null) continue;
            copyEntity.setValue(rph.getName(), this.service.getVersionController(rph.getReferenceEntityHandler(entityContext)).normalizeRefEntity(holder, rph, entityContext)[0]);
        }
        this.service.getVersionController(this).update(copyEntity, option, this, entityContext);
        if (cascadeDelTarget != null) {
            DeleteOption deleteOption = new DeleteOption(false);
            deleteOption.setPurge(option.isPurgeCompositionedEntity());
            for (ReferencePropertyHandler rph : cascadeDelTarget) {
                if (rph.getMetaData().getReferenceType() != ReferenceType.COMPOSITION) continue;
                EntityHandler reh = rph.getReferenceEntityHandler(entityContext);
                Object beforeVal = beforeEntity.getValue(rph.getName());
                if (beforeVal == null) continue;
                Entity[] delEntities = null;
                if (rph.getMetaData().getMultiplicity() != 1) {
                    delEntities = this.service.getVersionController(reh).getCascadeDeleteTargetForUpdate((Entity[])copyEntity.getValue(rph.getName()), (Entity[])beforeVal, rph, beforeEntity, this, entityContext);
                } else {
                    Entity[] holder = new Entity[]{(Entity)copyEntity.getValue(rph.getName())};
                    if (holder[0] == null) {
                        holder = null;
                    }
                    Entity[] beforeHolder = new Entity[]{(Entity)beforeVal};
                    delEntities = this.service.getVersionController(reh).getCascadeDeleteTargetForUpdate(holder, beforeHolder, rph, beforeEntity, this, entityContext);
                }
                if (delEntities == null) continue;
                for (Entity val : delEntities) {
                    EntityDeleteInvocationImpl deleteInvocation = new EntityDeleteInvocationImpl(val, deleteOption, this.service.getInterceptors(), reh);
                    deleteInvocation.proceed();
                }
            }
        }
        entity.setVersion(copyEntity.getVersion());
    }

    private List<ReferencePropertyHandler> cascadeDeleteTarget(UpdateOption option, EntityContext entityContext) {
        LinkedList<ReferencePropertyHandler> ret = null;
        for (String propName : option.getUpdateProperties()) {
            ReferencePropertyHandler rph;
            PropertyHandler ph = this.getProperty(propName, entityContext);
            if (!(ph instanceof ReferencePropertyHandler) || ((ReferencePropertyHandler)ph).getMetaData().getMappedByPropertyMetaDataId() != null || (rph = (ReferencePropertyHandler)ph).getMetaData().getReferenceType() != ReferenceType.COMPOSITION) continue;
            if (ret == null) {
                ret = new LinkedList<ReferencePropertyHandler>();
            }
            ret.add(rph);
        }
        return ret;
    }

    public void purge(Long rbid) {
        this.checkState();
        ExecuteContext context = ExecuteContext.getCurrentContext();
        EntityContext entityContext = EntityContext.getCurrentContext();
        final String[] oid = new String[1];
        this.getRecycleBin(new Predicate<Entity>(){

            @Override
            public boolean test(Entity dataModel) {
                oid[0] = dataModel.getOid();
                return false;
            }
        }, rbid);
        if (oid[0] == null) {
            throw new EntityConcurrentUpdateException(EntityHandler.resourceString("impl.core.EntityHandler.alreadyRestored", new Object[0]));
        }
        this.getStrategy().deleteFromRecycleBin(entityContext, this, rbid, context.getClientId());
        List<PropertyHandler> wrapperPropList = this.getPropertyListByPropertyType(ComplexWrapperType.class, entityContext);
        if (wrapperPropList.size() > 0) {
            HashSet called = new HashSet();
            for (PropertyHandler ph : wrapperPropList) {
                ComplexWrapperType type = (ComplexWrapperType)((PrimitivePropertyHandler)ph).getMetaData().getType();
                if (called.contains(type.getClass())) continue;
                type.notifyAfterPurge(this, rbid);
                called.add(type.getClass());
            }
        }
    }

    public Entity restore(Long rbid) {
        this.checkState();
        ExecuteContext context = ExecuteContext.getCurrentContext();
        EntityContext entityContext = EntityContext.getCurrentContext();
        final String[] oid = new String[1];
        this.getRecycleBin(new Predicate<Entity>(){

            @Override
            public boolean test(Entity dataModel) {
                oid[0] = dataModel.getOid();
                return false;
            }
        }, rbid);
        if (oid[0] == null) {
            throw new EntityConcurrentUpdateException(EntityHandler.resourceString("impl.core.EntityHandler.alreadyRestored", new Object[0]));
        }
        this.getStrategy().copyFromRecycleBin(entityContext, this, rbid, context.getClientId());
        this.getStrategy().deleteFromRecycleBin(entityContext, this, rbid, context.getClientId());
        List<PropertyHandler> wrapperPropList = this.getPropertyListByPropertyType(ComplexWrapperType.class, entityContext);
        if (wrapperPropList.size() > 0) {
            HashSet called = new HashSet();
            for (PropertyHandler ph : wrapperPropList) {
                ComplexWrapperType type = (ComplexWrapperType)((PrimitivePropertyHandler)ph).getMetaData().getType();
                if (called.contains(type.getClass())) continue;
                type.notifyAfterRestore(this, rbid);
                called.add(type.getClass());
            }
        }
        return (Entity)new EntityLoadInvocationImpl(oid[0], null, null, false, this.service.getInterceptors(), this).proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getRecycleBin(Predicate<Entity> callback, Long rbid) {
        this.checkState();
        EntityContext entityContext = EntityContext.getCurrentContext();
        try (RecycleBinIterator it = this.getStrategy().getRecycleBin(entityContext, this, rbid);){
            while (it.next()) {
                Entity e = this.newInstance();
                e.setOid(it.getOid());
                e.setName(it.getName());
                e.setRecycleBinId(it.getRbid());
                e.setUpdateDate(it.getRbDate());
                e.setUpdateBy(it.getRbUser());
                if (callback.test(e)) continue;
                break;
            }
        }
    }

    public int countRecycleBin(Timestamp ts) {
        this.checkState();
        EntityContext entityContext = EntityContext.getCurrentContext();
        return this.getStrategy().countRecycleBin(entityContext, this, ts);
    }

    public void delete(Entity entity, DeleteOption option) {
        this.checkState();
        ExecuteContext execContext = ExecuteContext.getCurrentContext();
        EntityContext entityContext = EntityContext.getCurrentContext();
        if (option.getTargetVersion() == DeleteTargetVersion.SPECIFIC && !option.isPurge()) {
            throw new EntityRuntimeException("Version-specified option is only supported when the purge option is true.");
        }
        boolean isLocked = this.getStrategy().lock(entityContext, this, entity.getOid());
        if (!isLocked) {
            if (option.isCheckTimestamp()) {
                throw new EntityConcurrentUpdateException(EntityHandler.resourceString("impl.core.EntityHandler.alreadyOperated", this.getMetaData().getDisplayName()));
            }
            return;
        }
        Entity beforeEntity = (Entity)new EntityLoadInvocationImpl(entity.getOid(), entity.getVersion(), new LoadOption(true, false), false, this.service.getInterceptors(), this).proceed();
        if (beforeEntity == null) {
            throw new EntityConcurrentUpdateException(EntityHandler.resourceString("impl.core.EntityHandler.alreadyOperated", this.getMetaData().getDisplayName()));
        }
        String lockedByUser = beforeEntity.getLockedBy();
        if (lockedByUser != null && option.isCheckLockedByUser() && !lockedByUser.equals(execContext.getClientId())) {
            throw new EntityLockedByUserException(EntityHandler.resourceString("impl.core.EntityHandler.locked", new Object[0]));
        }
        List<ReferencePropertyHandler> refPropList = this.getReferencePropertyList(ReferenceType.COMPOSITION, entityContext);
        if (refPropList.size() > 0 && this.isVersioned() && option.getTargetVersion() == DeleteTargetVersion.SPECIFIC) {
            throw new EntityRuntimeException("Cascade deletion with version-specified option is not supported.");
        }
        HashMap<String, HashSet<String>> cascadeDelMap = new HashMap<String, HashSet<String>>();
        if (refPropList.size() > 0) {
            for (ReferencePropertyHandler rph : refPropList) {
                EntityHandler refEh = rph.getReferenceEntityHandler(entityContext);
                String[] cascadeOids = this.service.getVersionController(refEh).getCascadeDeleteTarget(entity, this, rph, entityContext);
                if (cascadeOids == null) continue;
                HashSet<String> oids = (HashSet<String>)cascadeDelMap.get(refEh.getMetaData().getName());
                if (oids == null) {
                    oids = new HashSet<String>();
                    cascadeDelMap.put(refEh.getMetaData().getName(), oids);
                }
                oids.addAll(Arrays.asList(cascadeOids));
            }
        }
        entity.setUpdateBy(execContext.getClientId());
        entity.setLockedBy(beforeEntity.getLockedBy());
        this.deleteDirect(entity, option, entityContext);
        if (cascadeDelMap.size() > 0) {
            DeleteOption cascadeDelOption = new DeleteOption(false);
            cascadeDelOption.setPurge(option.isPurge());
            for (Map.Entry oidsEntry : cascadeDelMap.entrySet()) {
                if (((Set)oidsEntry.getValue()).size() <= 0) continue;
                for (String oid : (Set)oidsEntry.getValue()) {
                    GenericEntity val = new GenericEntity((String)oidsEntry.getKey(), oid, null);
                    EntityDeleteInvocationImpl deleteInvocation = new EntityDeleteInvocationImpl(val, cascadeDelOption, this.service.getInterceptors(), entityContext.getHandlerByName((String)oidsEntry.getKey()));
                    deleteInvocation.proceed();
                }
            }
        }
    }

    Entity preporcessDeleteDirect(Entity entity, EntityContext entityContext, List<PropertyHandler> complexWrapperTypePropList) {
        Entity beforeDeleteEntity = null;
        boolean needPrevEntity = false;
        for (PropertyHandler ph : complexWrapperTypePropList) {
            ComplexWrapperType type = (ComplexWrapperType)((PrimitivePropertyHandler)ph).getMetaData().getType();
            needPrevEntity = needPrevEntity || type.isNeedPrevStoreTypeValueOnToStoreTypeValue();
        }
        if (needPrevEntity) {
            beforeDeleteEntity = this.getEntityWithPropList(entity.getOid(), entity.getVersion(), complexWrapperTypePropList, entityContext);
        }
        return beforeDeleteEntity;
    }

    void postporcessDeleteDirect(Entity beforeDeleteEntity, EntityContext entityContext, List<PropertyHandler> complexWrapperTypePropList, Long rbid) {
        if (complexWrapperTypePropList.size() > 0) {
            for (PropertyHandler ph : complexWrapperTypePropList) {
                ComplexWrapperType type = (ComplexWrapperType)((PrimitivePropertyHandler)ph).getMetaData().getType();
                if (beforeDeleteEntity == null) continue;
                Object val = beforeDeleteEntity.getValue(ph.getName());
                if (val == null || ph.getMetaData().getMultiplicity() == 1) {
                    type.notifyAfterDelete(val, ph, this, beforeDeleteEntity.getOid(), rbid);
                    continue;
                }
                Object[] arrayVal = (Object[])val;
                for (int i = 0; i < arrayVal.length; ++i) {
                    type.notifyAfterDelete(arrayVal[i], ph, this, beforeDeleteEntity.getOid(), rbid);
                }
            }
        }
    }

    private void deleteDirect(Entity entity, DeleteOption option, EntityContext entityContext) {
        this.checkState();
        DeleteTarget[] delTarget = this.service.getVersionController(this).getDeleteTarget(entity, option, this, entityContext);
        Long rbid = null;
        if (delTarget != null && delTarget.length != 0 && !option.isPurge()) {
            rbid = this.getStrategy().copyToRecycleBin(entityContext, this, entity.getOid(), entity.getUpdateBy());
        }
        List<PropertyHandler> complexWrapperTypePropList = this.getPropertyListByPropertyType(ComplexWrapperType.class, entityContext);
        for (DeleteTarget dt : delTarget) {
            GenericEntity delEntity = new GenericEntity(this.getMetaData().getName());
            delEntity.setOid(dt.oid);
            delEntity.setVersion(dt.version);
            delEntity.setUpdateDate(dt.updateDate);
            delEntity.setUpdateBy(entity.getUpdateBy());
            Entity beforeDeleteEntity = this.preporcessDeleteDirect(delEntity, entityContext, complexWrapperTypePropList);
            EntityStoreStrategy deleteStrategy = this.getStrategy();
            deleteStrategy.delete(entityContext, delEntity, this, option);
            this.postporcessDeleteDirect(beforeDeleteEntity, entityContext, complexWrapperTypePropList, rbid);
        }
    }

    public boolean lock(String oid) {
        this.checkState();
        EntityContext entityContext = EntityContext.getCurrentContext();
        return this.getStrategy().lock(entityContext, this, oid);
    }

    public Entity load(String oid, Long version, LoadOption option, boolean withLock) {
        this.checkState();
        final ExecuteContext mtfContext = ExecuteContext.getCurrentContext();
        final EntityContext entityContext = EntityContext.getCurrentContext();
        if (withLock && !this.getStrategy().lock(entityContext, this, oid)) {
            throw new EntityConcurrentUpdateException(EntityHandler.resourceString("impl.core.EntityHandler.alreadyDeleted", new Object[0]));
        }
        ArrayList<Object> select = new ArrayList<Object>();
        ArrayList<String> refSingle = new ArrayList<String>();
        final ArrayList<ReferencePropertyHandler> refList = new ArrayList<ReferencePropertyHandler>();
        final Query searchCond = new Query();
        searchCond.from(this.getMetaData().getName());
        for (PropertyHandler p : this.getPropertyList(entityContext)) {
            if (p instanceof ReferencePropertyHandler) {
                ReferencePropertyHandler rp = (ReferencePropertyHandler)p;
                if (option != null && (option.getLoadReferences() == null || !option.getLoadReferences().contains(p.getName())) && (option.getLoadReferences() != null || !option.isWithReference() || rp.getMetaData().getMappedByPropertyMetaDataId() != null && !option.isWithMappedByReference()) || rp.getReferenceEntityHandler(entityContext) == null) continue;
                if (rp.getMetaData().getMultiplicity() != 1) {
                    refList.add((ReferencePropertyHandler)p);
                    continue;
                }
                refSingle.add(p.getName());
                select.add(rp.getName() + ".oid");
                select.add(rp.getName() + ".name");
                select.add(rp.getName() + ".version");
                continue;
            }
            select.add(p.getName());
        }
        searchCond.select(select.toArray(new Object[select.size()]));
        if (version == null) {
            searchCond.where(new Equals("oid", oid));
        } else {
            searchCond.where(new And(new Equals("oid", oid), new Equals("version", version)));
        }
        searchCond.select().addHint(new FetchSizeHint(1));
        if (option != null && option.isVersioned()) {
            if (!this.isVersioned()) {
                searchCond.versioned();
            } else if (version != null) {
                searchCond.versioned();
            } else {
                log.warn("LoadOption.versioned=true specified, but since the Entity to be load is itself versioned, this flag will be enabled if the version of the load target is also specified.");
            }
        }
        final Entity[] result = new Entity[]{null};
        new EntityQueryInvocationImpl(searchCond, new SearchOption().unnotifyListeners(), new Predicate<Entity>(){

            @Override
            public boolean test(Entity val) {
                if (result[0] == null) {
                    result[0] = val;
                    if (refList.size() != 0) {
                        for (ReferencePropertyHandler refProp : refList) {
                            EntityHandler.this.setLoadRef(val, refProp, mtfContext, entityContext, searchCond.isVersioned());
                        }
                    }
                    return true;
                }
                log.warn("The multiplicity of the reference property is defined to be 1, but in fact, multiple references are associated with Entity:" + EntityHandler.this.getMetaData().getName() + "(oid=" + val.getOid() + ")");
                return false;
            }
        }, InvocationType.SEARCH_ENTITY, this.getService().getInterceptors(), this).proceed();
        return result[0];
    }

    private void setLoadRef(Entity e, ReferencePropertyHandler refProp, ExecuteContext mtfContext, EntityContext entityContext, boolean versioned) {
        Query searchCond = new Query();
        searchCond.from(this.getMetaData().getName());
        searchCond.select(refProp.getName() + ".oid", refProp.getName() + ".version", refProp.getName() + ".name");
        And whereCond = new And(new Equals("oid", e.getOid()), new Equals("version", e.getVersion()));
        searchCond.where(whereCond);
        final EntityHandler refEH = refProp.getReferenceEntityHandler(entityContext);
        if (refProp.getMetaData().getOrderBy() != null && refProp.getMetaData().getOrderBy().size() > 0) {
            OrderBy q = new OrderBy();
            for (ReferenceSortSpec rss : refProp.getMetaData().getOrderBy()) {
                PropertyHandler ph = refEH.getPropertyById(rss.getSortPropertyMetaDataId(), entityContext);
                if (ph == null || ph instanceof ReferencePropertyHandler) continue;
                searchCond.getSelect().add((Object)(refProp.getName() + "." + ph.getName()));
                if (rss.getSortType() == ReferenceSortSpec.SortType.DESC) {
                    q.add(new SortSpec(refProp.getName() + "." + ph.getName(), SortSpec.SortType.DESC));
                    continue;
                }
                q.add(new SortSpec(refProp.getName() + "." + ph.getName(), SortSpec.SortType.ASC));
            }
            if (q.getSortSpecList() != null && q.getSortSpecList().size() > 0) {
                searchCond.setOrderBy(q);
            }
        }
        if (refEH.isVersioned() && versioned) {
            searchCond.versioned();
        }
        final ArrayList refList = new ArrayList();
        new EntityQueryInvocationImpl(searchCond, new SearchOption().unnotifyListeners(), new Predicate<Object[]>(){

            @Override
            public boolean test(Object[] val) {
                if (val[0] != null) {
                    Entity refEntity = refEH.newInstance();
                    refEntity.setValue("oid", val[0]);
                    refEntity.setValue("version", val[1]);
                    refEntity.setValue("name", val[2]);
                    refList.add(refEntity);
                }
                return true;
            }
        }, InvocationType.SEARCH, this.service.getInterceptors(), this).proceed();
        if (refList.size() != 0) {
            e.setValue(refProp.getName(), refList.toArray(refEH.newArrayInstance(refList.size())));
        }
    }

    private VirtualPropertyAdapter createExtendPropertyAdapter(Query cond, EntityContext entityContext) {
        return this.service.getExtendPropertyAdapterFactory().create(cond, entityContext, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(Query cond, EntityStreamSearchHandler<Object[]> streamSearchHandler, Predicate<Object[]> callback) {
        this.checkState();
        EntityContext entityContext = EntityContext.getCurrentContext();
        if (!cond.isVersioned()) {
            cond = (Query)new VersionedQueryNormalizer(this.service.getVersionController(this), this, entityContext, null).visit(cond);
            if (log.isDebugEnabled()) {
                log.debug("translate to versioned query:" + String.valueOf(cond));
            }
        }
        VirtualPropertyAdapter vpa = this.createExtendPropertyAdapter(cond, entityContext);
        if (streamSearchHandler != null) {
            vpa.setIterator(this.getStrategy().search(entityContext, vpa.getTransformedQuery(), this));
            streamSearchHandler.setStreamSearchResult(cond, vpa, callback);
        } else {
            try {
                vpa.setIterator(this.getStrategy().search(entityContext, vpa.getTransformedQuery(), this));
                while (vpa.next()) {
                    List<ValueExpression> select = cond.getSelect().getSelectValues();
                    Object[] row = new Object[select.size()];
                    for (int i = 0; i < row.length; ++i) {
                        row[i] = vpa.getValue(i);
                    }
                    if (callback.test(row)) continue;
                    break;
                }
            }
            finally {
                log.trace("iterate done");
                if (vpa != null) {
                    vpa.close();
                }
            }
        }
    }

    public void searchEntity(Query query, boolean structuredEntity, EntityStreamSearchHandler<Entity> streamSearchHandler, Predicate<Entity> searchCallback) {
        this.checkState();
        ExecuteContext mtfContext = ExecuteContext.getCurrentContext();
        EntityContext entityContext = EntityContext.getCurrentContext();
        this.searchEntity(query, structuredEntity, mtfContext, entityContext, streamSearchHandler, searchCallback);
    }

    public int count(Query query) {
        this.checkState();
        EntityContext entityContext = EntityContext.getCurrentContext();
        if (!query.isVersioned()) {
            query = (Query)new VersionedQueryNormalizer(this.service.getVersionController(this), this, entityContext, null).visit(query);
            if (log.isDebugEnabled()) {
                log.debug("translate to versioned query:" + String.valueOf(query));
            }
        }
        VirtualPropertyAdapter vpa = this.createExtendPropertyAdapter(query, entityContext);
        return this.getStrategy().count(entityContext, vpa.getTransformedQuery());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchEntity(Query cond, boolean structuredEntity, ExecuteContext mtfContext, EntityContext entityContext, EntityStreamSearchHandler<Entity> streamSearchHandler, Predicate<Entity> callback) {
        block13: {
            if (!cond.isVersioned()) {
                cond = (Query)new VersionedQueryNormalizer(this.service.getVersionController(this), this, entityContext, null).visit(cond);
                if (log.isDebugEnabled()) {
                    log.debug("translate to versioned query:" + String.valueOf(cond));
                }
            }
            VirtualPropertyAdapter vpa = this.createExtendPropertyAdapter(cond, entityContext);
            if (streamSearchHandler != null) {
                vpa.setIterator(this.getStrategy().search(entityContext, vpa.getTransformedQuery(), this));
                streamSearchHandler.setStreamSearchResult(cond, vpa, callback);
            } else {
                try {
                    vpa.setIterator(this.getStrategy().search(entityContext, vpa.getTransformedQuery(), this));
                    EntityHandler handler = null;
                    handler = this.getMetaData().getName().equals(cond.getFrom().getEntityName()) ? this : entityContext.getHandlerByName(cond.getFrom().getEntityName());
                    if (structuredEntity) {
                        EntityBuilder builder = new EntityBuilder(this, entityContext, cond.getSelect().getSelectValues());
                        while (vpa.next()) {
                            List<ValueExpression> select = cond.getSelect().getSelectValues();
                            Object[] row = new Object[select.size()];
                            for (int i = 0; i < row.length; ++i) {
                                row[i] = vpa.getValue(i);
                            }
                            builder.handle(row, null);
                        }
                        builder.finished();
                        for (Entity entity : builder.getCollection()) {
                            if (callback.test(entity)) continue;
                            break block13;
                        }
                        break block13;
                    }
                    while (vpa.next()) {
                        Entity entity = EntityHandler.getAsEntity(handler, vpa, cond);
                        if (callback.test(entity)) continue;
                        break;
                    }
                }
                finally {
                    log.trace("iterate done");
                    if (vpa != null) {
                        vpa.close();
                    }
                }
            }
        }
    }

    public PropertyHandler getDeclaredPropertyById(String id) {
        this.checkState();
        if (this.propertyHandlerMap == null) {
            return null;
        }
        return this.propertyHandlerMapById.get(id);
    }

    public PropertyHandler getPropertyById(String id, EntityContext context) {
        EntityHandler superHandler;
        this.checkState();
        PropertyHandler p = this.getDeclaredPropertyById(id);
        if (p == null && (superHandler = this.getSuperDataModelHandler(context)) != null) {
            p = superHandler.getPropertyById(id, context);
        }
        return p;
    }

    public EntityStoreStrategy getStrategy() {
        this.checkState();
        EntityStoreStrategy strategy = this.dataStore.getEntityStoreStrategy();
        if (strategy == null) {
            throw new EntityRuntimeException("operation not supported");
        }
        return strategy;
    }

    static Entity getAsEntity(EntityHandler eh, SearchResultIterator it, Query query) {
        Entity model = eh.newInstance();
        for (int i = 0; i < query.getSelect().getSelectValues().size(); ++i) {
            ValueExpression propName = query.getSelect().getSelectValues().get(i);
            if (!(propName instanceof EntityField)) continue;
            EntityField ef = (EntityField)propName;
            model.setValue(ef.getPropertyName(), it.getValue(i));
        }
        return model;
    }

    public Integer updateAll(UpdateCondition cond) {
        this.checkState();
        ExecuteContext context = ExecuteContext.getCurrentContext();
        EntityContext entityContext = EntityContext.getCurrentContext();
        for (UpdateCondition.UpdateValue uv : cond.getValues()) {
            PropertyHandler ph = this.getProperty(uv.getEntityField(), entityContext);
            if (ph instanceof PrimitivePropertyHandler) {
                if (cond.isCheckUpdatable()) {
                    if (((PrimitivePropertyHandler)ph).getMetaData().getType() instanceof ComplexWrapperType) {
                        throw new EntityRuntimeException("can not updateAll because not support of Reference type or LOB type or AutoNumber type");
                    }
                    if (this.getMetaData().getNamePropertyId() != null && ph.getName().equals(this.getMetaData().getNamePropertyId())) {
                        throw new EntityRuntimeException("can not updateAll because not support of nameProperty-ed property");
                    }
                    if (ph instanceof PrimitivePropertyHandler && ((MetaPrimitiveProperty)ph.getMetaData()).getType().isVirtual()) {
                        throw new EntityRuntimeException("can not updateAll because not support of Expression Type");
                    }
                    if (ph.getMetaData().isUpdatable()) continue;
                    throw new EntityApplicationException(EntityHandler.resourceString("impl.core.EntityHandler.notChange", ph.getMetaData().getDisplayName()));
                }
                if (((PrimitivePropertyHandler)ph).getMetaData().getType() instanceof ComplexWrapperType && !(((PrimitivePropertyHandler)ph).getMetaData().getType() instanceof AutoNumberType)) {
                    throw new EntityRuntimeException("can not updateAll because not support of Reference type or LOB type");
                }
                if (ph instanceof PrimitivePropertyHandler && ((MetaPrimitiveProperty)ph.getMetaData()).getType().isVirtual()) {
                    throw new EntityRuntimeException("can not updateAll because not support of Expression Type");
                }
                if (!ph.getName().equals("oid") && !ph.getName().equals("version") && !ph.getName().equals("updateBy") && !ph.getName().equals("updateDate") && !ph.getName().equals("createBy") && !ph.getName().equals("createDate")) continue;
                throw new EntityApplicationException(EntityHandler.resourceString("impl.core.EntityHandler.notChange", ph.getMetaData().getDisplayName()));
            }
            throw new EntityRuntimeException("can not updateAll because not support of Reference");
        }
        VirtualPropertyAdapter vpa = this.service.getExtendPropertyAdapterFactory().create(cond, entityContext, this);
        return this.getStrategy().updateAll(vpa.getTransformedUpdateCondition(), entityContext, this, context.getClientId());
    }

    public boolean canDeleteAll() {
        this.checkState();
        EntityContext entityContext = EntityContext.getCurrentContext();
        List<PropertyHandler> pList = this.getPropertyList(entityContext);
        for (PropertyHandler ph : pList) {
            PropertyType pType;
            if (!(ph instanceof PrimitivePropertyHandler ? (pType = ((PrimitivePropertyHandler)ph).getMetaData().getType()) instanceof BinaryType || pType instanceof LongTextType : ((ReferencePropertyHandler)ph).getMetaData().getReferenceType() == ReferenceType.COMPOSITION)) continue;
            return false;
        }
        return true;
    }

    public Integer deleteAll(DeleteCondition cond) {
        this.checkState();
        ExecuteContext context = ExecuteContext.getCurrentContext();
        EntityContext entityContext = EntityContext.getCurrentContext();
        if (!this.canDeleteAll()) {
            throw new EntityRuntimeException("can not deleteAll because not support of COMPOSITION type or LOB type");
        }
        VirtualPropertyAdapter vpa = this.service.getExtendPropertyAdapterFactory().create(cond, entityContext, this);
        return this.getStrategy().deleteAll(vpa.getTransformedDeleteCondition(), entityContext, this, context.getClientId());
    }

    public boolean unlockEntityByUser(String oid, final String userId, boolean force) {
        UpdateCondition cond;
        int count;
        this.checkState();
        if (!this.lock(oid)) {
            return false;
        }
        if (!force) {
            Query q = new Query().select("lockedBy").from(this.getMetaData().getName()).where(new Equals("oid", oid)).versioned(true);
            final boolean[] res = new boolean[]{true};
            this.search(q, null, new Predicate<Object[]>(){

                @Override
                public boolean test(Object[] dataModel) {
                    String lockedUser = (String)dataModel[0];
                    if (lockedUser != null && !lockedUser.equals(userId)) {
                        res[0] = false;
                        return false;
                    }
                    return true;
                }
            });
            if (!res[0]) {
                return false;
            }
        }
        return (count = this.updateAll(cond = new UpdateCondition(this.getMetaData().getName()).value("lockedBy", null).where(new Equals("oid", oid))).intValue()) > 0;
    }

    public boolean lockEntityByUser(String oid, final String userId, boolean force) {
        UpdateCondition cond;
        int count;
        this.checkState();
        if (!this.lock(oid)) {
            return false;
        }
        if (!force) {
            Query q = new Query().select("lockedBy").from(this.getMetaData().getName()).where(new Equals("oid", oid)).versioned(true);
            final boolean[] res = new boolean[]{true};
            this.search(q, null, new Predicate<Object[]>(){

                @Override
                public boolean test(Object[] dataModel) {
                    String lockedUser = (String)dataModel[0];
                    if (lockedUser != null && !lockedUser.equals(userId)) {
                        res[0] = false;
                        return false;
                    }
                    return true;
                }
            });
            if (!res[0]) {
                return false;
            }
        }
        return (count = this.updateAll(cond = new UpdateCondition(this.getMetaData().getName()).value("lockedBy", userId).where(new Equals("oid", oid))).intValue()) > 0;
    }

    public String getLocalizedDisplayName() {
        String dispName = this.getMetaData().getDisplayName();
        if (dispName == null) {
            dispName = this.getMetaData().getName();
        }
        return I18nUtil.stringMeta(dispName, this.getMetaData().getLocalizedDisplayNameList());
    }

    public void bulkUpdate(BulkUpdatable bulkUpdatable) {
        ExecuteContext context = ExecuteContext.getCurrentContext();
        EntityContext entityContext = EntityContext.getCurrentContext();
        try (BulkUpdatable bu = bulkUpdatable;
             BulkUpdateAdapter target = new BulkUpdateAdapter(bu, this, entityContext);){
            this.getStrategy().bulkUpdate(target, entityContext, this, context.getClientId());
        }
    }

    public boolean isVersioned() {
        return this.metaData.getVersionControlType() != null && this.metaData.getVersionControlType() != VersionControlType.NONE;
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

