/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.file.Files;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.DeepCopyOption;
import org.iplass.mtp.entity.DeleteCondition;
import org.iplass.mtp.entity.DeleteOption;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityConcurrentUpdateException;
import org.iplass.mtp.entity.EntityKey;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.EntityValidationException;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.TargetVersion;
import org.iplass.mtp.entity.UpdateCondition;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.ValidateResult;
import org.iplass.mtp.entity.bulkupdate.BulkUpdatable;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.properties.AutoNumberProperty;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceType;
import org.iplass.mtp.entity.definition.properties.StringProperty;
import org.iplass.mtp.entity.fulltextsearch.FulltextSearchOption;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.ReadOnlyHint;
import org.iplass.mtp.entity.query.value.RowValueList;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityProcessCallback;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.EntityStreamSearchHandler;
import org.iplass.mtp.impl.entity.interceptor.EntityBulkUpdateInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityCountInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityDeleteAllInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityDeleteInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityGetRecycleBinInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityInsertInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityLoadInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityLockByUserInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityNormalizeInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityPurgeInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityQueryInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityRestoreInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityUnlockByUserInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityUpdateAllInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityUpdateInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityValidateInvocationImpl;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.fulltextsearch.FulltextSearchService;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.lob.Lob;
import org.iplass.mtp.impl.lob.LobHandler;
import org.iplass.mtp.impl.session.SessionService;
import org.iplass.mtp.impl.transaction.TransactionService;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Propagation;
import org.iplass.mtp.transaction.Transaction;
import org.iplass.mtp.transaction.TransactionOption;
import org.iplass.mtp.transaction.TransactionStatus;
import org.iplass.mtp.util.CollectionUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerImpl
implements EntityManager {
    private static Logger logger = LoggerFactory.getLogger(EntityManagerImpl.class);
    @Deprecated
    private final boolean loadLatestVersionedEntity = Boolean.parseBoolean(System.getProperty("mtp.entity.update.targetSpecific.loadLatestVersionedEntity"));
    private EntityService ehService = ServiceRegistry.getRegistry().getService(EntityService.class);
    private SessionService sessionService = ServiceRegistry.getRegistry().getService(SessionService.class);
    private FulltextSearchService fulltextSearchService = ServiceRegistry.getRegistry().getService(FulltextSearchService.class);

    private EntityHandler getEntityHandler(String defName) {
        EntityHandler handler = this.ehService.getRuntimeByName(defName);
        if (handler == null) {
            throw new EntityRuntimeException(defName + " is undefined.");
        }
        return handler;
    }

    private void setRollbackOnly() {
        Transaction t = ServiceRegistry.getRegistry().getService(TransactionService.class).getTransacitonManager().currentTransaction();
        if (t != null && t.getStatus() == TransactionStatus.ACTIVE) {
            t.setRollbackOnly();
        }
    }

    private <R> R withReadOnlyCheck(Query q, SearchResult.ResultMode resultMode, Function<Transaction, R> func) {
        Transaction t = Transaction.getCurrent();
        if (!t.isReadOnly() && resultMode == SearchResult.ResultMode.AT_ONCE && this.hasReadOnlyHint(q)) {
            return Transaction.with(new TransactionOption(Propagation.REQUIRES_NEW).readOnly().throwExceptionIfSetRollbackOnly(), func);
        }
        return func.apply(t);
    }

    private boolean hasReadOnlyHint(Query q) {
        if (q.getSelect().getHintComment() == null) {
            return false;
        }
        List<Hint> hintList = q.getSelect().getHintComment().getHintList();
        if (hintList == null) {
            return false;
        }
        for (Hint h : hintList) {
            if (!(h instanceof ReadOnlyHint)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int count(Query query) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("count():" + String.valueOf(query));
            }
            return this.withReadOnlyCheck(query, SearchResult.ResultMode.AT_ONCE, t -> {
                EntityHandler handler = this.getEntityHandler(query.getFrom().getEntityName());
                return (Integer)new EntityCountInvocationImpl(query, this.ehService.getInterceptors(), handler).proceed();
            });
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public void delete(Entity entity, DeleteOption option) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("delete():" + String.valueOf(entity) + ", option=" + String.valueOf(option));
            }
            if (entity.getDefinitionName() == null) {
                throw new EntityRuntimeException("no definitionName");
            }
            EntityHandler handler = this.getEntityHandler(entity.getDefinitionName());
            new EntityDeleteInvocationImpl(entity, option, this.ehService.getInterceptors(), handler).proceed();
        }
        catch (ApplicationException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Entity load(String oid, String definitionName) {
        return this.load(oid, null, definitionName);
    }

    @Override
    public Entity load(String oid, Long version, String definitionName) {
        return this.load(oid, version, definitionName, null);
    }

    @Override
    public Entity load(String oid, String definitionName, LoadOption option) {
        return this.load(oid, null, definitionName, option);
    }

    @Override
    public Entity load(String oid, Long version, String definitionName, LoadOption option) {
        if (option == null) {
            option = new LoadOption();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("load():oid=" + oid + ", version=" + version + ", definitionName=" + definitionName + ", option=" + String.valueOf(option));
            }
            EntityHandler handler = this.getEntityHandler(definitionName);
            return (Entity)new EntityLoadInvocationImpl(oid, version, option, false, this.ehService.getInterceptors(), handler).proceed();
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Entity loadAndLock(String oid, String definitionName) {
        return this.loadAndLock(oid, definitionName, null);
    }

    @Override
    public Entity loadAndLock(String oid, String definitionName, LoadOption option) {
        if (option == null) {
            option = new LoadOption();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("loadAndLock():oid=" + oid + ", definitionName=" + definitionName + ", option=" + String.valueOf(option));
            }
            EntityHandler handler = this.getEntityHandler(definitionName);
            return (Entity)new EntityLoadInvocationImpl(oid, null, option, true, this.ehService.getInterceptors(), handler).proceed();
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public List<Entity> batchLoad(List<EntityKey> keys, String definitionName) {
        return this.batchLoad(keys, definitionName, null);
    }

    @Override
    public List<Entity> batchLoad(List<EntityKey> keys, String definitionName, LoadOption option) {
        LoadOption loadOption = option != null ? option : new LoadOption();
        EntityContext entityContext = EntityContext.getCurrentContext();
        EntityDefinition ed = this.getEntityHandler(definitionName).getMetaData().currentConfig(entityContext);
        Select select = new Select();
        ed.getPropertyList().forEach(pd -> {
            if (pd instanceof ReferenceProperty) {
                ReferenceProperty rp = (ReferenceProperty)pd;
                if (CollectionUtil.isNotEmpty(loadOption.getLoadReferences()) ? !loadOption.getLoadReferences().contains(rp.getName()) : (StringUtil.isNotEmpty(rp.getMappedBy()) ? !loadOption.isWithMappedByReference() : !loadOption.isWithReference())) {
                    return;
                }
                select.add((Object)new EntityField(pd.getName() + ".oid"));
                select.add((Object)new EntityField(pd.getName() + ".version"));
            } else {
                select.add((Object)pd.getName());
            }
        });
        In condition = null;
        OrderBy orderBy = new OrderBy();
        if (ed.getVersionControlType() != VersionControlType.NONE) {
            values = keys.stream().map(key -> new RowValueList(key.getOid(), key.getVersion() != null ? key.getVersion() : 0L)).collect(Collectors.toList());
            condition = new In(new String[]{"oid", "version"}, values);
            orderBy.add(new SortSpec("oid", SortSpec.SortType.DESC));
            orderBy.add(new SortSpec("version", SortSpec.SortType.DESC));
        } else {
            values = keys.stream().map(key -> new Literal(key.getOid())).collect(Collectors.toList());
            condition = new In((ValueExpression)new EntityField("oid"), values);
            orderBy.add(new SortSpec("oid", SortSpec.SortType.DESC));
        }
        Query query = new Query();
        query.setSelect(select);
        query.from(definitionName);
        query.where(condition);
        query.setOrderBy(orderBy);
        SearchOption searchOption = new SearchOption();
        searchOption.setCountTotal(false);
        searchOption.setNotifyListeners(loadOption.isNotifyListeners());
        searchOption.setReturnStructuredEntity(true);
        return this.searchEntity(query, searchOption).getList();
    }

    @Override
    public SearchResult<Object[]> search(Query query) {
        return this.search(query, new SearchOption());
    }

    @Override
    public <T extends Entity> SearchResult<T> searchEntity(Query query) {
        return this.searchEntity(query, new SearchOption());
    }

    @Override
    public SearchResult<Object[]> search(Query query, SearchOption option) {
        SearchOption finalOption = option == null ? new SearchOption() : option;
        try {
            return this.withReadOnlyCheck(query, finalOption.getResultMode(), t -> {
                int counts = -1;
                if (finalOption.isCountTotal()) {
                    Query countQuery = query.copy();
                    countQuery.setLimit(null);
                    counts = this.count(countQuery);
                }
                EntityHandler eh = this.getEntityHandler(query.getFrom().getEntityName());
                if (finalOption.getResultMode() == SearchResult.ResultMode.AT_ONCE) {
                    final ArrayList list = new ArrayList();
                    this.search(eh, query, finalOption, new Predicate<Object[]>(){

                        @Override
                        public boolean test(Object[] val) {
                            list.add(val);
                            return true;
                        }
                    }, null);
                    return new SearchResult(counts, list);
                }
                EntityStreamSearchHandler<Object[]> ssh = new EntityStreamSearchHandler<Object[]>(eh, Object[].class);
                ssh.setTotalCount(counts);
                this.search(eh, query, finalOption, null, ssh);
                return ssh.getStreamSearchResult();
            });
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public <T extends Entity> SearchResult<T> searchEntity(Query query, SearchOption option) {
        SearchOption finalOption = option == null ? new SearchOption() : option;
        try {
            return this.withReadOnlyCheck(query, finalOption.getResultMode(), t -> {
                int counts = -1;
                if (finalOption.isCountTotal()) {
                    Query countQuery = query.copy();
                    countQuery.setLimit(null);
                    counts = this.count(countQuery);
                }
                EntityHandler eh = this.getEntityHandler(query.getFrom().getEntityName());
                if (finalOption.getResultMode() == SearchResult.ResultMode.AT_ONCE) {
                    final ArrayList list = new ArrayList();
                    this.searchEntity(eh, query, finalOption, new Predicate<T>(){

                        @Override
                        public boolean test(T val) {
                            list.add(val);
                            return true;
                        }
                    }, null);
                    return new SearchResult(counts, list);
                }
                EntityStreamSearchHandler<Entity> ssh = new EntityStreamSearchHandler<Entity>(eh, Entity.class);
                ssh.setTotalCount(counts);
                this.searchEntity(eh, query, finalOption, null, ssh);
                return ssh.getStreamSearchResult();
            });
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public <T extends Entity> void searchEntity(Query query, Predicate<T> callback) {
        this.searchEntity(this.getEntityHandler(query.getFrom().getEntityName()), query, new SearchOption(), callback, null);
    }

    @Override
    public <T extends Entity> void searchEntity(Query query, SearchOption option, Predicate<T> callback) {
        if (option == null) {
            option = new SearchOption();
        }
        this.searchEntity(this.getEntityHandler(query.getFrom().getEntityName()), query, option, callback, null);
    }

    private <T extends Entity> void searchEntity(EntityHandler handler, Query query, SearchOption option, Predicate<T> callback, EntityStreamSearchHandler<T> streamSearchHandler) {
        long time = 0L;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("searchEntity():" + String.valueOf(query));
                time = System.currentTimeMillis();
            }
            this.withReadOnlyCheck(query, option.getResultMode(), t -> {
                if (streamSearchHandler == null) {
                    new EntityQueryInvocationImpl(query, option, callback, InvocationType.SEARCH_ENTITY, this.ehService.getInterceptors(), handler).proceed();
                } else {
                    new EntityQueryInvocationImpl(query, option, streamSearchHandler, InvocationType.SEARCH_ENTITY, this.ehService.getInterceptors(), handler).proceed();
                }
                return null;
            });
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
        finally {
            if (logger.isDebugEnabled()) {
                if (streamSearchHandler == null) {
                    logger.debug("searchEntity() end:time=" + (System.currentTimeMillis() - time) + "ms. query=" + String.valueOf(query));
                } else {
                    logger.debug("searchEntity() end (without resultset iterate):time=" + (System.currentTimeMillis() - time) + "ms. query=" + String.valueOf(query));
                }
            }
        }
    }

    @Override
    public void search(Query query, Predicate<Object[]> callback) {
        this.search(this.getEntityHandler(query.getFrom().getEntityName()), query, new SearchOption(), callback, null);
    }

    @Override
    public void search(Query query, SearchOption option, Predicate<Object[]> callback) {
        if (option == null) {
            option = new SearchOption();
        }
        this.search(this.getEntityHandler(query.getFrom().getEntityName()), query, option, callback, null);
    }

    private void search(EntityHandler handler, Query query, SearchOption option, Predicate<Object[]> callback, EntityStreamSearchHandler<Object[]> streamSearchHandler) {
        long time = 0L;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("search():" + String.valueOf(query));
                time = System.currentTimeMillis();
            }
            this.withReadOnlyCheck(query, option.getResultMode(), t -> {
                if (streamSearchHandler == null) {
                    new EntityQueryInvocationImpl(query, option, callback, InvocationType.SEARCH, this.ehService.getInterceptors(), handler).proceed();
                } else {
                    new EntityQueryInvocationImpl(query, option, streamSearchHandler, InvocationType.SEARCH, this.ehService.getInterceptors(), handler).proceed();
                }
                return null;
            });
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
        finally {
            if (logger.isDebugEnabled()) {
                if (streamSearchHandler == null) {
                    logger.debug("search() end:time=" + (System.currentTimeMillis() - time) + "ms. query=" + String.valueOf(query));
                } else {
                    logger.debug("search() end (without resultset iterate):time=" + (System.currentTimeMillis() - time) + "ms. query=" + String.valueOf(query));
                }
            }
        }
    }

    @Override
    public String insert(Entity entity) {
        return this.insert(entity, new InsertOption());
    }

    @Override
    public String insert(Entity entity, InsertOption option) {
        if (option == null) {
            option = new InsertOption();
        }
        try {
            AuthContext auth;
            User user;
            if (logger.isDebugEnabled()) {
                logger.debug("insert():" + String.valueOf(entity) + ", option=" + String.valueOf(option));
            }
            if (entity.getDefinitionName() == null) {
                throw new EntityRuntimeException("no definitionName");
            }
            EntityHandler handler = this.getEntityHandler(entity.getDefinitionName());
            if (option.isEnableAuditPropertySpecification() && ((user = (auth = AuthContext.getCurrentContext()).getUser()) == null || !auth.getUser().isAdmin())) {
                throw new EntityRuntimeException("Only admin user can set enableAuditPropertySpecification to true.");
            }
            if (option.isWithValidation()) {
                ValidateResult validateResult = (ValidateResult)new EntityValidateInvocationImpl(entity, option, this.ehService.getInterceptors(), handler).proceed();
                if (validateResult.hasError()) {
                    throw new EntityValidationException("valiation error.", validateResult.getErrors());
                }
            } else {
                new EntityNormalizeInvocationImpl(entity, null, this.ehService.getInterceptors(), handler).proceed();
            }
            EntityInsertInvocationImpl invocation = new EntityInsertInvocationImpl(entity, option, this.ehService.getInterceptors(), handler);
            return (String)invocation.proceed();
        }
        catch (ApplicationException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public void update(Entity entity, UpdateOption option) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("update():" + String.valueOf(entity) + ", option=" + String.valueOf(option));
            }
            if (entity.getDefinitionName() == null) {
                throw new EntityRuntimeException("no definitionName");
            }
            if (option == null) {
                throw new EntityRuntimeException("updateOption is null");
            }
            EntityHandler handler = this.getEntityHandler(entity.getDefinitionName());
            if (option.isWithValidation()) {
                ValidateResult validateResult = (ValidateResult)new EntityValidateInvocationImpl(entity, option.getUpdateProperties(), option, this.ehService.getInterceptors(), handler).proceed();
                if (validateResult.hasError()) {
                    throw new EntityValidationException("valiation error.", validateResult.getErrors());
                }
            } else {
                new EntityNormalizeInvocationImpl(entity, option.getUpdateProperties(), this.ehService.getInterceptors(), handler).proceed();
            }
            if (!option.isForceUpdate()) {
                Entity currentStore = null;
                LoadOption lop = new LoadOption(true, false);
                if (option.isLocalized()) {
                    lop.localized();
                }
                if (option.getTargetVersion() == TargetVersion.SPECIFIC) {
                    if (entity.getVersion() == null) {
                        throw new EntityRuntimeException("target version not specified:" + String.valueOf(entity));
                    }
                    if (!this.loadLatestVersionedEntity) {
                        lop.setVersioned(true);
                    }
                    currentStore = this.load(entity.getOid(), entity.getVersion(), entity.getDefinitionName(), lop);
                } else {
                    currentStore = option.getTargetVersion() == TargetVersion.NEW ? (entity.getVersion() != null ? this.load(entity.getOid(), entity.getVersion(), entity.getDefinitionName(), lop) : this.load(entity.getOid(), entity.getDefinitionName(), lop)) : this.load(entity.getOid(), entity.getDefinitionName(), lop);
                }
                if (currentStore == null) {
                    throw new EntityConcurrentUpdateException(CoreResourceBundleUtil.resourceString("impl.core.EntityManagerImpl.alreadyDeleted", new Object[0]));
                }
                UpdateOption toRealyUpate = this.checkSame(handler, currentStore, entity, option);
                if (toRealyUpate.getUpdateProperties().size() == 0) {
                    logger.debug("no value is changed. so skip update process:" + entity.getDefinitionName() + "(oid=" + entity.getOid() + ")");
                    return;
                }
                option = toRealyUpate;
            } else {
                option = option.copy();
            }
            new EntityUpdateInvocationImpl(entity, option, this.ehService.getInterceptors(), handler).proceed();
        }
        catch (ApplicationException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    private UpdateOption checkSame(EntityHandler handler, Entity currentStore, Entity entity, UpdateOption option) {
        ArrayList<String> toReturn;
        if (!option.isForceUpdate()) {
            toReturn = new ArrayList();
            EntityContext entityContext = EntityContext.getCurrentContext();
            block0: for (String propName : option.getUpdateProperties()) {
                Object currentRef;
                if (propName.equals("updateBy")) continue;
                PropertyHandler ph = handler.getProperty(propName, entityContext);
                Object currentValue = currentStore.getValue(propName);
                Object newValue = entity.getValue(propName);
                if (ph instanceof PrimitivePropertyHandler) {
                    if (currentValue == null) {
                        if (newValue == null) continue;
                        if (newValue instanceof Object[]) {
                            if (((Object[])newValue).length == 0) continue;
                            toReturn.add(propName);
                            continue;
                        }
                        toReturn.add(propName);
                        continue;
                    }
                    if (currentValue instanceof Object[]) {
                        Object[] na;
                        Object[] ca;
                        if (!(newValue instanceof Object[])) {
                            if (newValue == null) {
                                if (((Object[])currentValue).length == 0) continue;
                                toReturn.add(propName);
                                continue;
                            }
                            toReturn.add(propName);
                            continue;
                        }
                        if (Arrays.equals((Object[])currentValue, (Object[])newValue) || (ca = (Object[])currentValue) == (na = (Object[])newValue)) continue;
                        if (ca.length != na.length) {
                            toReturn.add(propName);
                            continue;
                        }
                        for (int i = 0; i < ca.length; ++i) {
                            boolean isDiff = false;
                            if (ca[i] instanceof BigDecimal && na[i] instanceof BigDecimal) {
                                if (((BigDecimal)ca[i]).compareTo((BigDecimal)na[i]) != 0) {
                                    isDiff = true;
                                }
                            } else if (ca[i] instanceof SelectValue && na[i] instanceof String) {
                                String cv = ((SelectValue)ca[i]).getValue();
                                if (cv == null || !cv.equals(na[i])) {
                                    isDiff = true;
                                }
                            } else if (ca[i] == null ? na[i] != null : !ca[i].equals(na[i])) {
                                isDiff = true;
                            }
                            if (!isDiff) continue;
                            toReturn.add(propName);
                            continue block0;
                        }
                        continue;
                    }
                    if (currentValue instanceof BigDecimal && newValue instanceof BigDecimal) {
                        if (((BigDecimal)currentValue).compareTo((BigDecimal)newValue) == 0) continue;
                        toReturn.add(propName);
                        continue;
                    }
                    if (currentValue instanceof SelectValue && newValue instanceof String) {
                        String cv = ((SelectValue)currentValue).getValue();
                        if (cv != null && cv.equals(newValue)) continue;
                        toReturn.add(propName);
                        continue;
                    }
                    if (currentValue.equals(newValue)) continue;
                    toReturn.add(propName);
                    continue;
                }
                ReferencePropertyHandler rh = (ReferencePropertyHandler)ph;
                if (rh.getMappedByPropertyHandler(entityContext) != null) continue;
                if (currentValue == null) {
                    if (newValue == null) continue;
                    if (newValue instanceof Object[]) {
                        if (((Object[])newValue).length == 0) continue;
                        toReturn.add(propName);
                        continue;
                    }
                    toReturn.add(propName);
                    continue;
                }
                if (newValue == null) {
                    toReturn.add(propName);
                    continue;
                }
                if (rh.getMetaData().getMultiplicity() != 1) {
                    Entity[] newRef = (Entity[])newValue;
                    currentRef = (Entity[])currentValue;
                    int length = ((Entity[])currentRef).length;
                    if (newRef.length != length) {
                        toReturn.add(propName);
                        continue;
                    }
                    boolean isChange = false;
                    for (int i = 0; i < length; ++i) {
                        Object e1 = currentRef[i];
                        Entity e2 = newRef[i];
                        if (e1 != null ? e1.getOid().equals(e2.getOid()) && (e2.getVersion() == null || e2.getVersion().equals(e1.getVersion())) : e2 == null) continue;
                        isChange = true;
                        break;
                    }
                    if (!isChange) continue;
                    toReturn.add(propName);
                    continue;
                }
                currentRef = (Entity)currentValue;
                Entity newRef = (Entity)newValue;
                if (currentRef.getOid().equals(newRef.getOid()) && (newRef.getVersion() == null || newRef.getVersion().equals(currentRef.getVersion()))) continue;
                toReturn.add(propName);
            }
        } else {
            toReturn = new ArrayList<String>(option.getUpdateProperties());
        }
        UpdateOption realyUpdate = new UpdateOption(option.isCheckTimestamp(), option.getTargetVersion());
        realyUpdate.setCheckLockedByUser(option.isCheckLockedByUser());
        realyUpdate.setUpdateProperties(toReturn);
        realyUpdate.setPurgeCompositionedEntity(option.isPurgeCompositionedEntity());
        realyUpdate.setForceUpdate(option.isForceUpdate());
        realyUpdate.setWithValidation(option.isWithValidation());
        realyUpdate.setNotifyListeners(option.isNotifyListeners());
        realyUpdate.setLocalized(option.isLocalized());
        return realyUpdate;
    }

    @Override
    public int deleteAll(DeleteCondition cond) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("deleteAll():" + String.valueOf(cond));
            }
            if (cond.getDefinitionName() == null) {
                throw new EntityRuntimeException("no definitionName");
            }
            EntityHandler handler = this.getEntityHandler(cond.getDefinitionName());
            return (Integer)new EntityDeleteAllInvocationImpl(cond, this.ehService.getInterceptors(), handler).proceed();
        }
        catch (ApplicationException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public int updateAll(UpdateCondition cond) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("updateAll():" + String.valueOf(cond));
            }
            if (cond.getDefinitionName() == null) {
                throw new EntityRuntimeException("no definitionName");
            }
            EntityHandler handler = this.getEntityHandler(cond.getDefinitionName());
            return (Integer)new EntityUpdateAllInvocationImpl(cond, this.ehService.getInterceptors(), handler).proceed();
        }
        catch (ApplicationException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public ValidateResult validate(Entity entity, List<String> validatePropertyList) {
        try {
            if (entity.getDefinitionName() == null) {
                throw new EntityRuntimeException("no definitionName");
            }
            EntityHandler handler = this.getEntityHandler(entity.getDefinitionName());
            return (ValidateResult)new EntityValidateInvocationImpl(entity, validatePropertyList, null, this.ehService.getInterceptors(), handler).proceed();
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public ValidateResult validate(Entity entity) {
        return this.validate(entity, null);
    }

    @Override
    public void normalize(Entity entity) {
        this.normalize(entity, null);
    }

    @Override
    public void normalize(Entity entity, List<String> properties) {
        try {
            if (entity.getDefinitionName() == null) {
                throw new EntityRuntimeException("no definitionName");
            }
            EntityHandler handler = this.getEntityHandler(entity.getDefinitionName());
            new EntityNormalizeInvocationImpl(entity, properties, this.ehService.getInterceptors(), handler).proceed();
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public BinaryReference loadBinaryReference(long lobId) {
        try {
            EntityContext entityContext = EntityContext.getCurrentContext();
            LobHandler lm = LobHandler.getInstance("binaryStore");
            Lob bin = lm.getBinaryData(lobId);
            if (bin == null) {
                return null;
            }
            if (!lm.canAccess(bin)) {
                return null;
            }
            BinaryReference br = lm.toBinaryReference(bin, entityContext);
            return br;
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BinaryReference createBinaryReference(String name, String type, InputStream is) {
        BinaryReference binaryReference;
        long start;
        block25: {
            start = 0L;
            if (logger.isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            try {
                LobHandler lm = LobHandler.getInstance("binaryStore");
                Lob bin = lm.crateBinaryDataTemporary(name, type, this.sessionService.getSession(true).getId());
                if (is != null) {
                    byte[] buf = new byte[8192];
                    try (OutputStream os = bin.getBinaryOutputStream();){
                        int count;
                        while ((count = is.read(buf)) != -1) {
                            os.write(buf, 0, count);
                        }
                        os.flush();
                    }
                    catch (IOException e) {
                        throw new EntityRuntimeException(e);
                    }
                }
                binaryReference = lm.toBinaryReference(bin, EntityContext.getCurrentContext());
                if (is == null) break block25;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            logger.warn("can not close inputstream resource:" + String.valueOf(is), (Throwable)e);
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("createBinaryReference done.time:" + (System.currentTimeMillis() - start));
                    }
                    throw throwable;
                }
                catch (ApplicationException e) {
                    this.setRollbackOnly();
                    throw e;
                }
                catch (Error | RuntimeException e) {
                    this.setRollbackOnly();
                    throw e;
                }
            }
            try {
                is.close();
            }
            catch (IOException e) {
                logger.warn("can not close inputstream resource:" + String.valueOf(is), (Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("createBinaryReference done.time:" + (System.currentTimeMillis() - start));
        }
        return binaryReference;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BinaryReference createBinaryReference(File file, String name, String type) {
        try {
            long start = 0L;
            if (logger.isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            if (!file.exists()) {
                throw new EntityRuntimeException("file is not exists:" + file.getPath());
            }
            if (file.isDirectory()) {
                throw new EntityRuntimeException("file is directory:" + file.getPath());
            }
            if (type == null) {
                try {
                    type = Files.probeContentType(file.toPath());
                }
                catch (IOException e) {
                    logger.warn("can't determine the MIME type due to IOException: " + file.getName(), (Throwable)e);
                    type = "application/octet-stream";
                }
            }
            if (name == null) {
                name = file.getName();
            }
            try {
                LobHandler lm = LobHandler.getInstance("binaryStore");
                Lob bin = lm.crateBinaryDataTemporary(name, type, this.sessionService.getSession(true).getId());
                bin.transferFrom(file);
                BinaryReference binaryReference = lm.toBinaryReference(bin, EntityContext.getCurrentContext());
                return binaryReference;
            }
            catch (IOException e) {
                throw new EntityRuntimeException(e.getMessage(), e);
            }
            finally {
                if (logger.isDebugEnabled()) {
                    logger.debug("createBinaryReference done.time:" + (System.currentTimeMillis() - start));
                }
            }
        }
        catch (ApplicationException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public OutputStream getOutputStream(BinaryReference binaryReference) {
        try {
            LobHandler lm = LobHandler.getInstance("binaryStore");
            Lob bin = lm.getBinaryData(binaryReference.getLobId());
            if (bin == null) {
                return null;
            }
            if (!lm.canAccess(bin)) {
                return null;
            }
            return bin.getBinaryOutputStream();
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public InputStream getInputStream(BinaryReference binaryReference) {
        try {
            LobHandler lm = LobHandler.getInstance("binaryStore");
            Lob bin = lm.getBinaryData(binaryReference.getLobId());
            if (bin == null) {
                return null;
            }
            if (!lm.canAccess(bin)) {
                return null;
            }
            return bin.getBinaryInputStream();
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public boolean lockByUser(String oid, String definitionName) {
        try {
            EntityHandler handler = this.getEntityHandler(definitionName);
            return (Boolean)new EntityLockByUserInvocationImpl(oid, ExecuteContext.getCurrentContext().getClientId(), false, this.ehService.getInterceptors(), handler).proceed();
        }
        catch (ApplicationException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public boolean unlockByUser(String oid, String definitionName) {
        try {
            AuthContext authContext = AuthContext.getCurrentContext();
            User user = authContext.getUser();
            EntityHandler handler = this.getEntityHandler(definitionName);
            if (user != null && user.isAdmin() || authContext.isPrivileged()) {
                return (Boolean)new EntityUnlockByUserInvocationImpl(oid, ExecuteContext.getCurrentContext().getClientId(), true, this.ehService.getInterceptors(), handler).proceed();
            }
            return (Boolean)new EntityUnlockByUserInvocationImpl(oid, ExecuteContext.getCurrentContext().getClientId(), false, this.ehService.getInterceptors(), handler).proceed();
        }
        catch (ApplicationException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public void purge(long rbid, String definitionName) {
        try {
            new EntityPurgeInvocationImpl(rbid, this.ehService.getInterceptors(), this.getEntityHandler(definitionName)).proceed();
        }
        catch (ApplicationException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Entity restore(long rbid, String definitionName) {
        try {
            return (Entity)new EntityRestoreInvocationImpl(rbid, this.ehService.getInterceptors(), this.getEntityHandler(definitionName)).proceed();
        }
        catch (ApplicationException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public void getRecycleBin(String definitionName, Predicate<Entity> callback) {
        try {
            new EntityGetRecycleBinInvocationImpl(callback, null, this.ehService.getInterceptors(), this.getEntityHandler(definitionName)).proceed();
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    @Override
    public Entity getRecycleBin(long rbid, String definitionName) {
        try {
            Entity[] ret = new Entity[1];
            new EntityGetRecycleBinInvocationImpl(e -> {
                ret[0] = e;
                return false;
            }, rbid, this.ehService.getInterceptors(), this.getEntityHandler(definitionName)).proceed();
            return ret[0];
        }
        catch (ApplicationException e2) {
            throw e2;
        }
        catch (Error | RuntimeException e3) {
            this.setRollbackOnly();
            throw e3;
        }
    }

    @Override
    public Timestamp getCurrentTimestamp() {
        return ExecuteContext.getCurrentContext().getCurrentTimestamp();
    }

    @Override
    public Entity deepCopy(String oid, String definitionName) {
        return this.deepCopy(oid, definitionName, new DeepCopyOption());
    }

    @Override
    public Entity deepCopy(String oid, String definitionName, DeepCopyOption option) {
        try {
            ArrayList<EntityProcessCallback> callbacks = new ArrayList<EntityProcessCallback>();
            Entity entity = this.load(oid, definitionName);
            this.resetProperty(entity, callbacks, option.isShallowCopyLobData());
            String copyOid = this.insert(entity);
            for (EntityProcessCallback callback : callbacks) {
                callback.handle(entity);
            }
            return this.load(copyOid, definitionName);
        }
        catch (ApplicationException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }

    private void resetProperty(Entity entity, ArrayList<EntityProcessCallback> callbacks, boolean shallowCopyLobData) {
        EntityContext entityContext = EntityContext.getCurrentContext();
        EntityDefinition ed = this.getEntityHandler(entity.getDefinitionName()).getMetaData().currentConfig(entityContext);
        entity.setOid(null);
        for (PropertyDefinition pd : ed.getPropertyList()) {
            if (pd instanceof AutoNumberProperty) {
                entity.setValue(pd.getName(), null);
                continue;
            }
            if (pd instanceof BinaryProperty) {
                BinaryReference[] value = null;
                if (pd.getMultiplicity() == 1) {
                    br = (BinaryReference[])entity.getValue(pd.getName());
                    if (br != null) {
                        value = shallowCopyLobData ? br.copy() : this.createBinaryReference(br.getName(), br.getType(), this.getInputStream((BinaryReference)br));
                    }
                } else {
                    br = (BinaryReference[])entity.getValue(pd.getName());
                    if (br != null && br.length > 0) {
                        BinaryReference[] _br = new BinaryReference[br.length];
                        for (int i = 0; i < br.length; ++i) {
                            _br[i] = shallowCopyLobData ? br[i].copy() : this.createBinaryReference(br[i].getName(), br[i].getType(), this.getInputStream(br[i]));
                        }
                        value = _br;
                    }
                }
                entity.setValue(pd.getName(), value);
                continue;
            }
            if (pd instanceof ReferenceProperty) {
                ReferenceProperty rp = (ReferenceProperty)pd;
                EntityDefinition red = this.getEntityHandler(rp.getObjectDefinitionName()).getMetaData().currentConfig(entityContext);
                String mappingClass = red.getMapping() != null ? red.getMapping().getMappingModelClass() : null;
                Object[] value = null;
                if (pd.getMultiplicity() == 1) {
                    Entity ref = (Entity)entity.getValue(pd.getName());
                    try {
                        value = this.copyReference(ref, rp, callbacks, shallowCopyLobData);
                    }
                    catch (EntityValidationException e) {
                        this.setParentPropNameToValidateResult(e, rp);
                        throw e;
                    }
                }
                ArrayList<Entity> array = new ArrayList<Entity>();
                Entity[] _ref = (Entity[])entity.getValue(pd.getName());
                if (_ref != null) {
                    try {
                        for (Entity ref : _ref) {
                            Entity ret = this.copyReference(ref, rp, callbacks, shallowCopyLobData);
                            if (ret == null) continue;
                            array.add(ret);
                        }
                    }
                    catch (EntityValidationException e) {
                        this.setParentPropNameToValidateResult(e, rp);
                        throw e;
                    }
                    if (mappingClass == null) {
                        value = array.toArray(new Entity[array.size()]);
                    } else {
                        try {
                            Class<?> cls = Class.forName(mappingClass);
                            Object[] newArray = (Object[])Array.newInstance(cls, array.size());
                            for (int i = 0; i < array.size(); ++i) {
                                newArray[i] = array.get(i);
                            }
                            value = newArray;
                        }
                        catch (ClassNotFoundException e) {
                            logger.error("mappingClass : " + mappingClass + "is Not Found.", (Throwable)e);
                            value = array.toArray(new Entity[array.size()]);
                        }
                    }
                }
                entity.setValue(pd.getName(), value);
                continue;
            }
            if (!(pd instanceof StringProperty)) continue;
            if (pd.getIndexType() == IndexType.UNIQUE) {
                if (pd.getMultiplicity() != 1) continue;
                entity.setValue(pd.getName(), "copy of " + String.valueOf(entity.getValue(pd.getName())));
                continue;
            }
            if (pd.getIndexType() != IndexType.UNIQUE_WITHOUT_NULL || pd.getMultiplicity() != 1) continue;
            entity.setValue(pd.getName(), null);
        }
    }

    private Entity copyReference(final Entity entity, final ReferenceProperty rp, ArrayList<EntityProcessCallback> callbacks, final boolean shallowCopyLobData) {
        String mappingClass;
        if (entity == null) {
            return null;
        }
        Entity ret = null;
        EntityDefinition ed = this.getEntityHandler(rp.getObjectDefinitionName()).getMetaData().currentConfig(EntityContext.getCurrentContext());
        String string = mappingClass = ed.getMapping() != null ? ed.getMapping().getMappingModelClass() : null;
        if (rp.getReferenceType() == ReferenceType.ASSOCIATION) {
            ret = rp.getMappedBy() == null || rp.getMappedBy().isEmpty() ? entity : null;
        } else if (rp.getMappedBy() == null || rp.getMappedBy().isEmpty()) {
            ret = this.deepCopy(entity.getOid(), entity.getDefinitionName(), new DeepCopyOption(shallowCopyLobData));
        } else {
            ret = entity;
            EntityProcessCallback callback = new EntityProcessCallback(){

                @Override
                public void handle(Entity dataModel) {
                    ArrayList<EntityProcessCallback> callbacks = new ArrayList<EntityProcessCallback>();
                    Entity ref = EntityManagerImpl.this.load(entity.getOid(), entity.getDefinitionName());
                    EntityManagerImpl.this.resetProperty(ref, callbacks, shallowCopyLobData);
                    ref.setValue(rp.getMappedBy(), dataModel);
                    try {
                        EntityManagerImpl.this.insert(ref);
                        for (EntityProcessCallback callback : callbacks) {
                            callback.handle(ref);
                        }
                    }
                    catch (EntityValidationException e) {
                        EntityManagerImpl.this.setParentPropNameToValidateResult(e, rp);
                        throw e;
                    }
                    if (rp.getMultiplicity() == 1) {
                        dataModel.setValue(rp.getName(), ref);
                    } else {
                        Object value = dataModel.getValue(rp.getName());
                        ArrayList<Entity> array = new ArrayList<Entity>();
                        if (value instanceof Entity) {
                            array.add((Entity)value);
                        } else if (value instanceof Entity[]) {
                            array.addAll(Arrays.asList((Entity[])value));
                        } else if (value instanceof Object[]) {
                            for (Object obj : (Object[])value) {
                                array.add((Entity)obj);
                            }
                        }
                        array.add(ref);
                        if (mappingClass == null) {
                            dataModel.setValue(rp.getName(), array.toArray(new Entity[array.size()]));
                        } else {
                            try {
                                Class<?> cls = Class.forName(mappingClass);
                                Object[] newArray = (Object[])Array.newInstance(cls, array.size());
                                for (int i = 0; i < array.size(); ++i) {
                                    newArray[i] = array.get(i);
                                }
                                dataModel.setValue(rp.getName(), newArray);
                            }
                            catch (ClassNotFoundException e) {
                                logger.error("mappingClass : " + mappingClass + "is Not Found.", (Throwable)e);
                                dataModel.setValue(rp.getName(), array.toArray(new Entity[array.size()]));
                            }
                        }
                    }
                }
            };
            callbacks.add(callback);
        }
        return ret;
    }

    private void setParentPropNameToValidateResult(EntityValidationException e, ReferenceProperty referenceProperty) {
        ValidateError err = new ValidateError();
        err.setPropertyName(referenceProperty.getName());
        err.setPropertyDisplayName(I18nUtil.stringDef(referenceProperty.getDisplayName(), referenceProperty.getLocalizedDisplayNameList()));
        e.getValidateResults().add(err);
    }

    @Override
    public <T extends Entity> SearchResult<T> fulltextSearchEntity(String defName, String fulltext) {
        return this.fulltextSearchService.fulltextSearchEntity(defName, fulltext);
    }

    @Override
    public List<String> fulltextSearchOidList(String defName, String fulltext) {
        return this.fulltextSearchService.fulltextSearchOidList(defName, fulltext);
    }

    @Override
    public Map<String, List<String>> fulltextSearchOidList(List<String> defNames, String fulltext) {
        return this.fulltextSearchService.fulltextSearchOidList(defNames, fulltext);
    }

    @Override
    public <T extends Entity> SearchResult<T> fulltextSearchEntity(Map<String, List<String>> entityProperties, String fulltext) {
        return this.fulltextSearchService.fulltextSearchEntity(entityProperties, fulltext);
    }

    @Override
    public <T extends Entity> SearchResult<T> fulltextSearchEntity(String fulltext, FulltextSearchOption option) {
        return this.fulltextSearchService.fulltextSearchEntity(fulltext, option);
    }

    @Override
    public <T extends Entity> SearchResult<T> fulltextSearchEntity(Query query, String fulltext, final SearchOption option) {
        String defName = query.getFrom().getEntityName();
        List<String> oids = this.fulltextSearchService.fulltextSearchOidList(defName, fulltext);
        if (oids == null || oids.size() == 0) {
            if (option == null || !option.isCountTotal()) {
                return new SearchResult(-1, null);
            }
            return new SearchResult(0, null);
        }
        final Map<String, String> oidMap = oids.stream().collect(Collectors.toMap(oid -> oid, oid -> oid));
        Query cpQuery = query.copy();
        cpQuery.setLimit(null);
        final Limit limit = query.getLimit();
        final ArrayList entityList = new ArrayList();
        final int[] count = new int[1];
        this.searchEntity(cpQuery, new Predicate<T>(){

            @Override
            public boolean test(T t) {
                if (oidMap.containsKey(t.getOid())) {
                    count[0] = count[0] + 1;
                    if (limit == null) {
                        entityList.add(t);
                    } else {
                        if (limit.getOffset() != -1 && count[0] <= limit.getOffset()) {
                            return true;
                        }
                        if (limit.getLimit() != -1 && entityList.size() >= limit.getLimit()) {
                            return option == null ? false : option.isCountTotal();
                        }
                        entityList.add(t);
                    }
                }
                return true;
            }
        });
        if (option == null || !option.isCountTotal()) {
            return new SearchResult(-1, entityList);
        }
        return new SearchResult(count[0], entityList);
    }

    @Override
    public void bulkUpdate(BulkUpdatable bulkUpdatable) {
        try {
            AuthContext auth;
            User user;
            if (logger.isDebugEnabled()) {
                logger.debug("bulkUpdate():" + bulkUpdatable.getDefinitionName());
            }
            if (bulkUpdatable.getDefinitionName() == null) {
                throw new EntityRuntimeException("no definitionName");
            }
            EntityHandler handler = this.getEntityHandler(bulkUpdatable.getDefinitionName());
            if (bulkUpdatable.isEnableAuditPropertySpecification() && ((user = (auth = AuthContext.getCurrentContext()).getUser()) == null || !auth.getUser().isAdmin())) {
                throw new EntityRuntimeException("Only admin user can set enableAuditPropertySpecification to true.");
            }
            EntityBulkUpdateInvocationImpl invocation = new EntityBulkUpdateInvocationImpl(bulkUpdatable, this.ehService.getInterceptors(), handler);
            invocation.proceed();
        }
        catch (ApplicationException e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Error | RuntimeException e) {
            this.setRollbackOnly();
            throw e;
        }
    }
}

