/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.SearchResult;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.datastore.strategy.SearchResultIterator;
import org.iplass.mtp.impl.entity.EntityHandler;

public class EntityStreamSearchHandler<T> {
    private T currentRow;
    private EntityHandler eh;
    private Class<T> resultType;
    private int totalCount = -1;
    private Query q;
    private SearchResultIterator sri;
    private Predicate<T> callback;
    private StreamSearchResult result;
    private It it;

    public EntityStreamSearchHandler(EntityHandler eh, Class<T> resultType) {
        this.eh = eh;
        this.resultType = resultType;
    }

    public Predicate<T> getDummyCallback() {
        return new DummyCallback();
    }

    public void setTotalCount(int totalCount) {
        this.totalCount = totalCount;
    }

    public void setStreamSearchResult(Query q, SearchResultIterator sri, Predicate<T> callback) {
        this.sri = sri;
        this.q = q;
        this.callback = callback;
        this.result = new StreamSearchResult(this.totalCount);
    }

    public StreamSearchResult getStreamSearchResult() {
        return this.result;
    }

    class DummyCallback
    implements Predicate<T> {
        DummyCallback() {
        }

        @Override
        public boolean test(T dataModel) {
            EntityStreamSearchHandler.this.currentRow = dataModel;
            return true;
        }
    }

    class StreamSearchResult
    extends SearchResult<T> {
        public StreamSearchResult(int totalCount) {
            super(totalCount, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<T> getList() {
            if (EntityStreamSearchHandler.this.it != null) {
                throw new IllegalStateException("SearchResult Iterator already fetched, so can not get as list.");
            }
            ArrayList ret = new ArrayList();
            try {
                for (Object t : this) {
                    ret.add(t);
                }
            }
            finally {
                this.close();
            }
            return ret;
        }

        @Override
        public T getFirst() {
            if (EntityStreamSearchHandler.this.it != null) {
                throw new IllegalStateException("SearchResult Iterator already fetched, so can not get first data.");
            }
            try {
                Iterator myIt = this.iterator();
                if (myIt.hasNext()) {
                    Object t = myIt.next();
                    return t;
                }
                Object t = null;
                return t;
            }
            finally {
                this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <P> List<P> getValueList(String propertyName) {
            if (EntityStreamSearchHandler.this.it != null) {
                throw new IllegalStateException("SearchResult Iterator already fetched, so can not get as list.");
            }
            if (EntityStreamSearchHandler.this.resultType != Entity.class) {
                throw new EntityRuntimeException("for use getValueList(propertyName), result type must Entity.");
            }
            ArrayList res = new ArrayList();
            try {
                for (Object t : this) {
                    res.add(((Entity)t).getValue(propertyName));
                }
            }
            finally {
                this.close();
            }
            return res;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <P> List<P> getValueList(int index) {
            if (EntityStreamSearchHandler.this.it != null) {
                throw new IllegalStateException("SearchResult Iterator already fetched, so can not get as list.");
            }
            if (EntityStreamSearchHandler.this.resultType != Object[].class) {
                throw new EntityRuntimeException("for use getValueList(index), result type must Object[].");
            }
            ArrayList<Object> res = new ArrayList<Object>();
            try {
                for (Object t : this) {
                    res.add(((Object[])t)[index]);
                }
            }
            finally {
                this.close();
            }
            return res;
        }

        @Override
        public Iterator<T> iterator() {
            if (EntityStreamSearchHandler.this.it != null) {
                throw new IllegalStateException("SearchResult Iterator already created, so can not create new iterator.");
            }
            EntityStreamSearchHandler.this.it = new It();
            return EntityStreamSearchHandler.this.it;
        }

        @Override
        public SearchResult.ResultMode getResultMode() {
            return SearchResult.ResultMode.STREAM;
        }

        @Override
        public void close() {
            if (EntityStreamSearchHandler.this.sri != null) {
                EntityStreamSearchHandler.this.sri.close();
                EntityStreamSearchHandler.this.sri = null;
            }
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }

    private class It
    implements Iterator<T> {
        private boolean nextCalled;
        private boolean hasNext;

        private It() {
        }

        @Override
        public boolean hasNext() {
            if (!this.nextCalled) {
                this.hasNext = EntityStreamSearchHandler.this.sri.next();
                this.nextCalled = true;
            }
            return this.hasNext;
        }

        @Override
        public T next() {
            if (!this.nextCalled) {
                this.hasNext();
            }
            if (!this.hasNext) {
                throw new NoSuchElementException("no such Element");
            }
            Object t = null;
            if (EntityStreamSearchHandler.this.resultType == Object[].class) {
                List<ValueExpression> select = EntityStreamSearchHandler.this.q.getSelect().getSelectValues();
                Object[] row = new Object[select.size()];
                for (int i = 0; i < row.length; ++i) {
                    row[i] = EntityStreamSearchHandler.this.sri.getValue(i);
                }
                t = row;
            } else if (EntityStreamSearchHandler.this.resultType == Entity.class) {
                Entity entity = EntityHandler.getAsEntity(EntityStreamSearchHandler.this.eh, EntityStreamSearchHandler.this.sri, EntityStreamSearchHandler.this.q);
                t = entity;
            } else {
                throw new IllegalArgumentException("resultType:" + String.valueOf(EntityStreamSearchHandler.this.resultType) + " not supported");
            }
            EntityStreamSearchHandler.this.callback.test((Object[])t);
            this.nextCalled = false;
            return EntityStreamSearchHandler.this.currentRow;
        }
    }
}

