/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityMapping;
import org.iplass.mtp.entity.definition.EventListenerDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.listeners.ScriptingEventListenerDefinition;
import org.iplass.mtp.entity.definition.listeners.SendNotificationEventListenerDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.impl.datastore.MetaEntityStore;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntityMapping;
import org.iplass.mtp.impl.entity.MetaEventListener;
import org.iplass.mtp.impl.entity.MetaStoreMapping;
import org.iplass.mtp.impl.entity.l10n.MetaDataLocalizationStrategy;
import org.iplass.mtp.impl.entity.listener.MetaJavaClassEventListener;
import org.iplass.mtp.impl.entity.listener.MetaScriptingEventListener;
import org.iplass.mtp.impl.entity.listener.MetaSendNotificationEventListener;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.MetaReferenceProperty;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.properties.basic.BasicType;
import org.iplass.mtp.impl.properties.extend.AutoNumberType;
import org.iplass.mtp.impl.properties.extend.SelectType;
import org.iplass.mtp.impl.util.KeyGenerator;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.MetaValidationNotNull;

public class MetaEntity
extends BaseRootMetaData
implements DefinableMetaData<EntityDefinition> {
    private static final long serialVersionUID = 6349144477923315083L;
    private List<String> oidPropertyId;
    private String namePropertyId;
    private List<String> crawlPropertyId;
    private String inheritedEntityMetaDataId;
    private MetaEntityMapping mapping;
    private List<MetaProperty> declaredPropertyList = new ArrayList<MetaProperty>();
    private List<MetaEventListener> eventListenerList = new ArrayList<MetaEventListener>();
    private MetaEntityStore entityStoreDefinition;
    private MetaStoreMapping storeMapping;
    private VersionControlType versionControlType;
    private boolean crawl;
    private boolean queryCache;
    private MetaDataLocalizationStrategy dataLocalizationStrategy;

    public MetaDataLocalizationStrategy getDataLocalizationStrategy() {
        return this.dataLocalizationStrategy;
    }

    public void setDataLocalizationStrategy(MetaDataLocalizationStrategy dataLocalizationStrategy) {
        this.dataLocalizationStrategy = dataLocalizationStrategy;
    }

    public boolean isQueryCache() {
        return this.queryCache;
    }

    public void setQueryCache(boolean queryCache) {
        this.queryCache = queryCache;
    }

    public boolean isCrawl() {
        return this.crawl;
    }

    public void setCrawl(boolean crawl) {
        this.crawl = crawl;
    }

    public String getNamePropertyId() {
        return this.namePropertyId;
    }

    public void setNamePropertyId(String namePropertyId) {
        this.namePropertyId = namePropertyId;
    }

    public VersionControlType getVersionControlType() {
        return this.versionControlType;
    }

    public void setVersionControlType(VersionControlType versionControlType) {
        this.versionControlType = versionControlType;
    }

    public List<String> getOidPropertyId() {
        return this.oidPropertyId;
    }

    public void setOidPropertyId(List<String> oidPropertyId) {
        this.oidPropertyId = oidPropertyId;
    }

    public List<String> getCrawlPropertyId() {
        return this.crawlPropertyId;
    }

    public void setCrawlPropertyId(List<String> crawlPropertyId) {
        this.crawlPropertyId = crawlPropertyId;
    }

    public String getInheritedEntityMetaDataId() {
        return this.inheritedEntityMetaDataId;
    }

    public void setInheritedEntityMetaDataId(String inheritedEntityMetaDataId) {
        this.inheritedEntityMetaDataId = inheritedEntityMetaDataId;
    }

    public List<MetaProperty> getDeclaredPropertyList() {
        return this.declaredPropertyList;
    }

    public void setDeclaredPropertyList(List<MetaProperty> propList) {
        this.declaredPropertyList = propList;
    }

    public MetaProperty getDeclaredProperty(String propName) {
        if (this.declaredPropertyList == null) {
            return null;
        }
        for (MetaProperty p : this.declaredPropertyList) {
            if (!propName.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public MetaProperty getDeclaredPropertyById(String propId) {
        if (this.declaredPropertyList == null) {
            return null;
        }
        for (MetaProperty p : this.declaredPropertyList) {
            if (!propId.equals(p.getId())) continue;
            return p;
        }
        return null;
    }

    public List<MetaEventListener> getEventListenerList() {
        return this.eventListenerList;
    }

    public void setEventListenerList(List<MetaEventListener> eventListenerList) {
        this.eventListenerList = eventListenerList;
    }

    public MetaEntityMapping getMapping() {
        return this.mapping;
    }

    public void setMapping(MetaEntityMapping mapping) {
        this.mapping = mapping;
    }

    public MetaEntityStore getEntityStoreDefinition() {
        return this.entityStoreDefinition;
    }

    public void setEntityStoreDefinition(MetaEntityStore entityStoreDefinition) {
        this.entityStoreDefinition = entityStoreDefinition;
    }

    public MetaStoreMapping getStoreMapping() {
        return this.storeMapping;
    }

    public void setStoreMapping(MetaStoreMapping storeMapping) {
        this.storeMapping = storeMapping;
    }

    public void applyConfig(EntityDefinition definition, EntityContext context, KeyGenerator keyGene) {
        if (this.id == null) {
            this.id = keyGene.generateId();
        }
        this.name = this.convertName(definition.getName());
        if (!definition.getName().equals(definition.getDisplayName())) {
            this.displayName = definition.getDisplayName();
        }
        this.description = definition.getDescription();
        if (definition.getInheritedDefinition() != null) {
            EntityHandler superEntity = context.getHandlerByName(definition.getInheritedDefinition());
            if (superEntity == null) {
                throw new EntityRuntimeException("metaData is not find. " + definition.getInheritedDefinition());
            }
            this.inheritedEntityMetaDataId = superEntity.getMetaData().getId();
        } else {
            this.inheritedEntityMetaDataId = "/entity/Entity";
        }
        this.mapping = definition.getMapping() != null ? new MetaEntityMapping(definition.getMapping().getMappingModelClass()) : null;
        ArrayList<MetaProperty> newDeclaredPropertyList = new ArrayList<MetaProperty>();
        if (definition.getPropertyList() != null) {
            for (PropertyDefinition pDef : definition.getPropertyList()) {
                if (pDef.isInherited()) continue;
                MetaProperty pMeta = this.getDeclaredProperty(pDef.getName());
                if (pMeta == null) {
                    pMeta = pDef instanceof ReferenceProperty ? new MetaReferenceProperty() : new MetaPrimitiveProperty();
                    pMeta.setId(keyGene.generateId());
                }
                pMeta.applyConfig(pDef, context);
                newDeclaredPropertyList.add(pMeta);
            }
        }
        this.declaredPropertyList = newDeclaredPropertyList;
        if (definition.getEventListenerList() != null) {
            this.eventListenerList = new ArrayList<MetaEventListener>();
            for (EventListenerDefinition ed : definition.getEventListenerList()) {
                MetaEventListener ms;
                if (ed instanceof ScriptingEventListenerDefinition) {
                    ms = new MetaScriptingEventListener();
                    ((MetaScriptingEventListener)ms).applyConfig(ed);
                    this.eventListenerList.add(ms);
                    continue;
                }
                if (ed instanceof SendNotificationEventListenerDefinition) {
                    MetaSendNotificationEventListener msn = new MetaSendNotificationEventListener();
                    msn.applyConfig(ed);
                    this.eventListenerList.add(msn);
                    continue;
                }
                ms = new MetaJavaClassEventListener();
                ((MetaJavaClassEventListener)ms).applyConfig(ed);
                this.eventListenerList.add(ms);
            }
        } else {
            this.eventListenerList = null;
        }
        this.localizedDisplayNameList = I18nUtil.toMeta(definition.getLocalizedDisplayNameList());
        List<MetaProperty> superPropertyList = null;
        if (!"/entity/Entity".equals(this.getId())) {
            EntityHandler thisHandler = context.getHandlerById(this.getId());
            if (thisHandler != null) {
                superEntityHandler = thisHandler.getSuperDataModelHandler(context);
                if (superEntityHandler != null) {
                    superEntity = superEntityHandler.getMetaData();
                    superPropertyList = superEntity.declaredPropertyList;
                }
            } else {
                superEntityHandler = context.getHandlerById(this.inheritedEntityMetaDataId);
                if (superEntityHandler != null) {
                    superEntity = superEntityHandler.getMetaData();
                    superPropertyList = superEntity.declaredPropertyList;
                }
            }
        }
        if (definition.getOidPropertyName() != null) {
            if (this.declaredPropertyList == null && superPropertyList == null) {
                throw new EntityRuntimeException("oidProperty not found:" + String.valueOf(definition.getOidPropertyName()));
            }
            this.oidPropertyId = new ArrayList<String>();
            for (String oidPropName : definition.getOidPropertyName()) {
                boolean match = false;
                match = this.validateOidProperty(this.declaredPropertyList, oidPropName);
                if (!match && superPropertyList != null) {
                    match = this.validateOidProperty(superPropertyList, oidPropName);
                }
                if (match) continue;
                throw new EntityRuntimeException("oidProperty not found:" + oidPropName);
            }
        } else {
            this.oidPropertyId = null;
        }
        this.namePropertyId = null;
        if (definition.getNamePropertyName() != null) {
            if (this.declaredPropertyList == null && superPropertyList == null) {
                throw new EntityRuntimeException("nameProperty not found:" + definition.getNamePropertyName());
            }
            boolean match = false;
            match = this.validateNameProperty(this.declaredPropertyList, definition.getNamePropertyName());
            if (!match && superPropertyList != null) {
                match = this.validateNameProperty(superPropertyList, definition.getNamePropertyName());
            }
            if (!match) {
                throw new EntityRuntimeException("nameProperty not found:" + definition.getNamePropertyName());
            }
        }
        if (definition.getCrawlPropertyName() != null) {
            if (this.declaredPropertyList == null && superPropertyList == null) {
                throw new EntityRuntimeException("crawlProperty not found:" + String.valueOf(definition.getCrawlPropertyName()));
            }
            this.crawlPropertyId = new ArrayList<String>();
            for (String crawlPropName : definition.getCrawlPropertyName()) {
                boolean match = false;
                match = this.validateCrawlProperty(this.declaredPropertyList, crawlPropName);
                if (!match && superPropertyList != null) {
                    match = this.validateCrawlProperty(superPropertyList, crawlPropName);
                }
                if (match) continue;
                throw new EntityRuntimeException("crawlProperty not found:" + crawlPropName);
            }
        } else {
            this.crawlPropertyId = null;
        }
        this.versionControlType = definition.getVersionControlType();
        this.crawl = definition.isCrawl();
        this.queryCache = definition.isQueryCache();
        if (definition.getStoreDefinition() != null) {
            this.storeMapping = MetaStoreMapping.newInstance(definition.getStoreDefinition());
            this.storeMapping.applyConfig(definition.getStoreDefinition(), this);
        } else {
            this.storeMapping = null;
        }
        if (definition.getDataLocalizationStrategy() != null) {
            this.dataLocalizationStrategy = MetaDataLocalizationStrategy.newInstance(definition.getDataLocalizationStrategy());
            this.dataLocalizationStrategy.applyConfig(definition.getDataLocalizationStrategy());
        } else {
            this.dataLocalizationStrategy = null;
        }
    }

    private boolean validateOidProperty(List<MetaProperty> properties, String oidPropName) {
        boolean match = false;
        if (properties != null) {
            for (MetaProperty p : properties) {
                MetaPrimitiveProperty pp;
                if (!p.getName().equals(oidPropName)) continue;
                if (p instanceof MetaPrimitiveProperty) {
                    pp = (MetaPrimitiveProperty)p;
                    if (pp.getMultiplicity() != 1) {
                        throw new EntityRuntimeException("oidProperty:" + oidPropName + " must multiplicity=1.");
                    }
                    if (!(pp.getType() instanceof BasicType) && !(pp.getType() instanceof AutoNumberType)) {
                        throw new EntityRuntimeException("oidProperty:" + oidPropName + " can not use for oidProperty.");
                    }
                    if (pp.isUpdatable()) {
                        throw new EntityRuntimeException("oidProperty:" + oidPropName + " must updatable=false.");
                    }
                    if (!this.isRequiredPrimitiveProperty(pp)) {
                        throw new EntityRuntimeException("oidProperty:" + oidPropName + " must not null.(must required)");
                    }
                } else {
                    throw new EntityRuntimeException("oidProperty:" + oidPropName + " must primitive type.");
                }
                this.oidPropertyId.add(pp.getId());
                match = true;
                break;
            }
        }
        return match;
    }

    private boolean validateNameProperty(List<MetaProperty> properties, String namePropName) {
        boolean match = false;
        if (properties != null) {
            for (MetaProperty p : properties) {
                MetaPrimitiveProperty pp;
                if (!p.getName().equals(namePropName)) continue;
                if (p instanceof MetaPrimitiveProperty) {
                    pp = (MetaPrimitiveProperty)p;
                    if (pp.getMultiplicity() != 1) {
                        throw new EntityRuntimeException("nameProperty:" + namePropName + " must multiplicity=1.");
                    }
                    if (!(pp.getType() instanceof BasicType || pp.getType() instanceof AutoNumberType || pp.getType() instanceof SelectType)) {
                        throw new EntityRuntimeException("nameProperty:" + namePropName + " can not use for nameProperty.");
                    }
                    if (!this.isRequiredPrimitiveProperty(pp)) {
                        throw new EntityRuntimeException("nameProperty:" + namePropName + " must not null.(must required)");
                    }
                } else {
                    throw new EntityRuntimeException("nameProperty:" + namePropName + " must primitive type.");
                }
                this.namePropertyId = pp.getId();
                match = true;
                break;
            }
        }
        return match;
    }

    private boolean validateCrawlProperty(List<MetaProperty> properties, String crawlPropName) {
        boolean match = false;
        if (properties != null) {
            for (MetaProperty p : properties) {
                if (!p.getName().equals(crawlPropName)) continue;
                this.crawlPropertyId.add(p.getId());
                match = true;
                break;
            }
        }
        return match;
    }

    private boolean isRequiredPrimitiveProperty(MetaPrimitiveProperty pp) {
        if (pp.getType() instanceof AutoNumberType) {
            return true;
        }
        if (pp.getValidations() == null) {
            return false;
        }
        boolean isNotNullDef = false;
        for (MetaValidation mv : pp.getValidations()) {
            if (!(mv instanceof MetaValidationNotNull)) continue;
            isNotNullDef = true;
            break;
        }
        return isNotNullDef;
    }

    public EntityDefinition currentConfig(EntityContext context) {
        boolean match;
        EntityDefinition def = new EntityDefinition();
        def.setName(this.getName());
        if (this.getDisplayName() != null) {
            def.setDisplayName(this.getDisplayName());
        } else {
            def.setDisplayName(this.getName());
        }
        def.setDescription(this.getDescription());
        EntityDefinition superEntity = null;
        List<MetaProperty> superPropertyList = null;
        if (!"/entity/Entity".equals(this.getId())) {
            EntityHandler thisHandler = context.getHandlerById(this.getId());
            EntityHandler superEntityHandler = thisHandler.getSuperDataModelHandler(context);
            if (superEntityHandler == null) {
                throw new EntityRuntimeException("metaData is not find.");
            }
            superEntity = superEntityHandler.getMetaData().currentConfig(context);
            superPropertyList = superEntityHandler.getMetaData().declaredPropertyList;
            def.setInheritedDefinition(superEntity.getName());
        }
        ArrayList<PropertyDefinition> propertyDefList = new ArrayList<PropertyDefinition>();
        if (superEntity != null) {
            for (PropertyDefinition pd : superEntity.getPropertyList()) {
                pd.setInherited(true);
                propertyDefList.add(pd);
            }
        }
        if (this.declaredPropertyList != null) {
            for (MetaProperty pMeta : this.declaredPropertyList) {
                PropertyDefinition pDef = pMeta.currentConfig(context);
                if (pDef == null) continue;
                propertyDefList.add(pDef);
            }
        }
        def.setPropertyList(propertyDefList);
        if (this.eventListenerList != null) {
            for (MetaEventListener me : this.eventListenerList) {
                def.addEventListener(me.currentConfig());
            }
        }
        def.setLocalizedDisplayNameList(I18nUtil.toDef(this.localizedDisplayNameList));
        if (this.oidPropertyId != null) {
            ArrayList<String> oidNames = new ArrayList<String>();
            block3: for (String oidPropId : this.oidPropertyId) {
                match = false;
                if (this.declaredPropertyList != null) {
                    for (MetaProperty pMeta : this.declaredPropertyList) {
                        if (!pMeta.getId().equals(oidPropId)) continue;
                        oidNames.add(pMeta.getName());
                        match = true;
                        break;
                    }
                }
                if (match || superPropertyList == null) continue;
                for (MetaProperty pMeta : superPropertyList) {
                    if (!pMeta.getId().equals(oidPropId)) continue;
                    oidNames.add(pMeta.getName());
                    match = true;
                    continue block3;
                }
            }
            def.setOidPropertyName(oidNames);
        }
        if (this.namePropertyId != null) {
            boolean match2 = false;
            if (this.declaredPropertyList != null) {
                for (MetaProperty pMeta : this.declaredPropertyList) {
                    if (!pMeta.getId().equals(this.namePropertyId)) continue;
                    def.setNamePropertyName(pMeta.getName());
                    match2 = true;
                    break;
                }
            }
            if (!match2 && superPropertyList != null) {
                for (MetaProperty pMeta : superPropertyList) {
                    if (!pMeta.getId().equals(this.namePropertyId)) continue;
                    def.setNamePropertyName(pMeta.getName());
                    match2 = true;
                    break;
                }
            }
        }
        if (this.crawlPropertyId != null) {
            ArrayList<String> crawlNames = new ArrayList<String>();
            block8: for (String crawlPropId : this.crawlPropertyId) {
                match = false;
                if (this.declaredPropertyList != null) {
                    for (MetaProperty pMeta : this.declaredPropertyList) {
                        if (!pMeta.getId().equals(crawlPropId)) continue;
                        crawlNames.add(pMeta.getName());
                        match = true;
                        break;
                    }
                }
                if (match || superPropertyList == null) continue;
                for (MetaProperty pMeta : superPropertyList) {
                    if (!pMeta.getId().equals(crawlPropId)) continue;
                    crawlNames.add(pMeta.getName());
                    match = true;
                    continue block8;
                }
            }
            def.setCrawlPropertyName(crawlNames);
        }
        if (this.mapping != null) {
            def.setMapping(new EntityMapping(this.mapping.getMappingClass()));
        }
        if (this.versionControlType == null) {
            def.setVersionControlType(VersionControlType.NONE);
        } else {
            def.setVersionControlType(this.versionControlType);
        }
        def.setCrawl(this.crawl);
        def.setQueryCache(this.queryCache);
        if (this.storeMapping != null) {
            def.setStoreDefinition(this.storeMapping.currentConfig(this));
        }
        if (this.dataLocalizationStrategy != null) {
            def.setDataLocalizationStrategy(this.dataLocalizationStrategy.currentConfig());
        }
        return def;
    }

    @Override
    public MetaEntity copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.crawl ? 1231 : 1237);
        result = 31 * result + (this.crawlPropertyId == null ? 0 : this.crawlPropertyId.hashCode());
        result = 31 * result + (this.dataLocalizationStrategy == null ? 0 : this.dataLocalizationStrategy.hashCode());
        result = 31 * result + (this.declaredPropertyList == null ? 0 : this.declaredPropertyList.hashCode());
        result = 31 * result + (this.entityStoreDefinition == null ? 0 : this.entityStoreDefinition.hashCode());
        result = 31 * result + (this.eventListenerList == null ? 0 : this.eventListenerList.hashCode());
        result = 31 * result + (this.inheritedEntityMetaDataId == null ? 0 : this.inheritedEntityMetaDataId.hashCode());
        result = 31 * result + (this.mapping == null ? 0 : this.mapping.hashCode());
        result = 31 * result + (this.namePropertyId == null ? 0 : this.namePropertyId.hashCode());
        result = 31 * result + (this.oidPropertyId == null ? 0 : this.oidPropertyId.hashCode());
        result = 31 * result + (this.queryCache ? 1231 : 1237);
        result = 31 * result + (this.storeMapping == null ? 0 : this.storeMapping.hashCode());
        result = 31 * result + (this.versionControlType == null ? 0 : this.versionControlType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaEntity other = (MetaEntity)obj;
        if (this.crawl != other.crawl) {
            return false;
        }
        if (this.crawlPropertyId == null ? other.crawlPropertyId != null : !this.crawlPropertyId.equals(other.crawlPropertyId)) {
            return false;
        }
        if (this.dataLocalizationStrategy == null ? other.dataLocalizationStrategy != null : !this.dataLocalizationStrategy.equals(other.dataLocalizationStrategy)) {
            return false;
        }
        if (this.declaredPropertyList == null ? other.declaredPropertyList != null : !this.declaredPropertyList.equals(other.declaredPropertyList)) {
            return false;
        }
        if (this.entityStoreDefinition == null ? other.entityStoreDefinition != null : !this.entityStoreDefinition.equals(other.entityStoreDefinition)) {
            return false;
        }
        if (this.eventListenerList == null ? other.eventListenerList != null : !this.eventListenerList.equals(other.eventListenerList)) {
            return false;
        }
        if (this.inheritedEntityMetaDataId == null ? other.inheritedEntityMetaDataId != null : !this.inheritedEntityMetaDataId.equals(other.inheritedEntityMetaDataId)) {
            return false;
        }
        if (this.mapping == null ? other.mapping != null : !this.mapping.equals(other.mapping)) {
            return false;
        }
        if (this.namePropertyId == null ? other.namePropertyId != null : !this.namePropertyId.equals(other.namePropertyId)) {
            return false;
        }
        if (this.oidPropertyId == null ? other.oidPropertyId != null : !this.oidPropertyId.equals(other.oidPropertyId)) {
            return false;
        }
        if (this.queryCache != other.queryCache) {
            return false;
        }
        if (this.storeMapping == null ? other.storeMapping != null : !this.storeMapping.equals(other.storeMapping)) {
            return false;
        }
        return this.versionControlType == other.versionControlType;
    }

    @Override
    public EntityHandler createRuntime(MetaDataConfig metaDataConfig) {
        return new EntityHandler(this, metaDataConfig);
    }

    private String convertName(String name) {
        return name != null ? name.replace("/", ".") : null;
    }

    @Override
    public void applyConfig(EntityDefinition definition) {
    }

    @Override
    public EntityDefinition currentConfig() {
        EntityContext ec = EntityContext.getCurrentContext();
        return this.currentConfig(ec);
    }
}

