/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.StoreDefinition;
import org.iplass.mtp.entity.definition.stores.ColumnMapping;
import org.iplass.mtp.entity.definition.stores.SchemalessRdbStore;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.MetaRdbColumnMapping;
import org.iplass.mtp.impl.entity.MetaStoreMapping;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;

public class MetaSchemalessRdbStoreMapping
extends MetaStoreMapping {
    private static final long serialVersionUID = 1247940347601034869L;
    private String storageSpace;
    private List<MetaRdbColumnMapping> columnMappingList;

    public String getStorageSpace() {
        return this.storageSpace;
    }

    public void setStorageSpace(String storageSpace) {
        this.storageSpace = storageSpace;
    }

    public List<MetaRdbColumnMapping> getColumnMappingList() {
        return this.columnMappingList;
    }

    public void setColumnMappingList(List<MetaRdbColumnMapping> columnMappingList) {
        this.columnMappingList = columnMappingList;
    }

    @Override
    public MetaData copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnMappingList == null ? 0 : this.columnMappingList.hashCode());
        result = 31 * result + (this.storageSpace == null ? 0 : this.storageSpace.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaSchemalessRdbStoreMapping other = (MetaSchemalessRdbStoreMapping)obj;
        if (this.columnMappingList == null ? other.columnMappingList != null : !this.columnMappingList.equals(other.columnMappingList)) {
            return false;
        }
        return !(this.storageSpace == null ? other.storageSpace != null : !this.storageSpace.equals(other.storageSpace));
    }

    @Override
    public void applyConfig(StoreDefinition storeDefinition, MetaEntity metaEntity) {
        SchemalessRdbStore srs = (SchemalessRdbStore)storeDefinition;
        this.storageSpace = srs.getStorageSpace();
        if (srs.getColumnMappingList() == null) {
            this.columnMappingList = null;
        } else {
            ArrayList<MetaRdbColumnMapping> list = new ArrayList<MetaRdbColumnMapping>();
            for (ColumnMapping cm : srs.getColumnMappingList()) {
                MetaProperty p = metaEntity.getDeclaredProperty(cm.getPropertyName());
                if (p == null) {
                    throw new EntityRuntimeException("ColumnMapping's property not found:" + cm.getPropertyName());
                }
                list.add(new MetaRdbColumnMapping(p.getId(), cm.getColumnName()));
            }
            this.columnMappingList = list;
        }
    }

    @Override
    public StoreDefinition currentConfig(MetaEntity metaEntity) {
        SchemalessRdbStore srs = new SchemalessRdbStore();
        if (this.storageSpace != null) {
            srs.setStorageSpace(this.storageSpace);
        }
        if (this.columnMappingList != null) {
            ArrayList<ColumnMapping> list = new ArrayList<ColumnMapping>();
            for (MetaRdbColumnMapping cm : this.columnMappingList) {
                MetaProperty p = metaEntity.getDeclaredPropertyById(cm.getPropertyId());
                if (p == null) continue;
                list.add(new ColumnMapping(p.getName(), cm.getColumnName()));
            }
            srs.setColumnMappingList(list);
        }
        return srs;
    }
}

