/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.auditlog;

import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.interceptor.EntityBulkUpdateInvocation;
import org.iplass.mtp.entity.interceptor.EntityCountInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteInvocation;
import org.iplass.mtp.entity.interceptor.EntityInsertInvocation;
import org.iplass.mtp.entity.interceptor.EntityInterceptorAdapter;
import org.iplass.mtp.entity.interceptor.EntityPurgeInvocation;
import org.iplass.mtp.entity.interceptor.EntityQueryInvocation;
import org.iplass.mtp.entity.interceptor.EntityRestoreInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateInvocation;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityService;
import org.iplass.mtp.impl.entity.auditlog.AuditLoggingService;
import org.iplass.mtp.impl.entity.interceptor.EntityDeleteInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityLoadInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityUpdateInvocationImpl;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceInitListener;

public class AuditLogInterceptor
extends EntityInterceptorAdapter
implements ServiceInitListener<EntityService> {
    private AuditLoggingService historyLoggingService;

    @Override
    public int count(EntityCountInvocation invocation) {
        this.historyLoggingService.logQuery(invocation.getQuery(), true);
        return super.count(invocation);
    }

    @Override
    public void query(EntityQueryInvocation invocation) {
        this.historyLoggingService.logQuery(invocation.getQuery(), false);
        super.query(invocation);
    }

    @Override
    public String insert(EntityInsertInvocation invocation) {
        String ret = (String)invocation.proceed();
        this.historyLoggingService.logInsert(invocation.getEntity());
        return ret;
    }

    @Override
    public void update(EntityUpdateInvocation invocation) {
        EntityHandler eh = ((EntityUpdateInvocationImpl)invocation).getEntityHandler();
        Entity beforeUpdate = null;
        if (this.historyLoggingService.isLogBeforeEntity(eh.getMetaData().getName())) {
            beforeUpdate = (Entity)new EntityLoadInvocationImpl(invocation.getEntity().getOid(), invocation.getEntity().getVersion(), new LoadOption(true, false), false, eh.getService().getInterceptors(), eh).proceed();
        }
        invocation.proceed();
        this.historyLoggingService.logUpdate(beforeUpdate, invocation.getEntity(), invocation.getUpdateOption());
    }

    @Override
    public void delete(EntityDeleteInvocation invocation) {
        Entity entity = null;
        EntityHandler eh = ((EntityDeleteInvocationImpl)invocation).getEntityHandler();
        if (this.historyLoggingService.isLogBeforeEntity(eh.getMetaData().getName())) {
            entity = (Entity)new EntityLoadInvocationImpl(invocation.getEntity().getOid(), invocation.getEntity().getVersion(), new LoadOption(true, false), false, eh.getService().getInterceptors(), eh).proceed();
        }
        invocation.proceed();
        if (entity == null) {
            entity = invocation.getEntity();
        }
        this.historyLoggingService.logDelete(entity, invocation.getDeleteOption());
    }

    @Override
    public int updateAll(EntityUpdateAllInvocation invocation) {
        Integer ret = (Integer)invocation.proceed();
        this.historyLoggingService.logUpdateAll(invocation.getUpdateCondition());
        return ret;
    }

    @Override
    public int deleteAll(EntityDeleteAllInvocation invocation) {
        Integer ret = (Integer)invocation.proceed();
        this.historyLoggingService.logDeleteAll(invocation.getDeleteCondition());
        return ret;
    }

    @Override
    public void purge(EntityPurgeInvocation invocation) {
        invocation.proceed();
        this.historyLoggingService.logPurge(invocation.getRecycleBinId());
    }

    @Override
    public Entity restore(EntityRestoreInvocation invocation) {
        Entity e = (Entity)invocation.proceed();
        this.historyLoggingService.logRestore(e.getOid(), e.getDefinitionName(), invocation.getRecycleBinId());
        return e;
    }

    @Override
    public void bulkUpdate(EntityBulkUpdateInvocation invocation) {
        invocation.proceed();
        this.historyLoggingService.logBulkUpdate(invocation.getBulkUpdatable().getDefinitionName());
    }

    @Override
    public void inited(EntityService service, Config config) {
        this.historyLoggingService = config.getDependentService(AuditLoggingService.class);
    }

    @Override
    public void destroyed() {
    }
}

