/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.auth;

import java.util.ArrayList;
import java.util.function.Predicate;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.auth.NoPermissionException;
import org.iplass.mtp.entity.DeleteCondition;
import org.iplass.mtp.entity.DeleteTargetVersion;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityConcurrentUpdateException;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.TargetVersion;
import org.iplass.mtp.entity.UpdateCondition;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.interceptor.EntityBulkUpdateInvocation;
import org.iplass.mtp.entity.interceptor.EntityCountInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityDeleteInvocation;
import org.iplass.mtp.entity.interceptor.EntityGetRecycleBinInvocation;
import org.iplass.mtp.entity.interceptor.EntityInsertInvocation;
import org.iplass.mtp.entity.interceptor.EntityInterceptorAdapter;
import org.iplass.mtp.entity.interceptor.EntityLoadInvocation;
import org.iplass.mtp.entity.interceptor.EntityPurgeInvocation;
import org.iplass.mtp.entity.interceptor.EntityQueryInvocation;
import org.iplass.mtp.entity.interceptor.EntityRestoreInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateAllInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateInvocation;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.permission.EntityPropertyPermission;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.expr.And;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.In;
import org.iplass.mtp.entity.query.value.RowValueList;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.auth.EntityAuthContext;
import org.iplass.mtp.impl.entity.auth.EntityQueryAuthContextHolder;
import org.iplass.mtp.impl.entity.interceptor.EntityBulkUpdateInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityCountInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityDeleteAllInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityDeleteInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityGetRecycleBinInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityInsertInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityPurgeInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityQueryInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityRestoreInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityUpdateAllInvocationImpl;
import org.iplass.mtp.impl.entity.interceptor.EntityUpdateInvocationImpl;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityAuthInterceptor
extends EntityInterceptorAdapter {
    private static final Logger logger = LoggerFactory.getLogger(EntityAuthInterceptor.class);

    @Override
    public String insert(EntityInsertInvocation invocation) {
        EntityInsertInvocationImpl inv = (EntityInsertInvocationImpl)invocation;
        EntityHandler eh = inv.getEntityHandler();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        if (user.isPrivilegedExecution()) {
            if (logger.isDebugEnabled()) {
                logger.debug("privileged insert call. shrot cut auth check.");
            }
            return (String)invocation.proceed();
        }
        EntityPermission perm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.CREATE);
        if (!user.checkPermission(perm)) {
            throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noRegist", eh.getLocalizedDisplayName()));
        }
        EntityContext ectx = EntityContext.getCurrentContext();
        for (PropertyHandler ph : eh.getPropertyList(ectx)) {
            ReferencePropertyHandler rph;
            Object value = inv.getEntity().getValue(ph.getName());
            if (value == null) continue;
            if (!user.checkPermission(new EntityPropertyPermission(eh.getMetaData().getName(), ph.getName(), EntityPropertyPermission.Action.CREATE))) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noRegistProperty", eh.getLocalizedDisplayName(), ph.getLocalizedDisplayName()));
            }
            if (!(ph instanceof ReferencePropertyHandler) || (rph = (ReferencePropertyHandler)ph).getMetaData().getMappedByPropertyMetaDataId() != null) continue;
            EntityHandler reh = rph.getReferenceEntityHandler(ectx);
            EntityPermission rerPerm = new EntityPermission(reh.getMetaData().getName(), EntityPermission.Action.REFERENCE);
            if (!user.checkPermission(rerPerm)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noReference", reh.getLocalizedDisplayName()));
            }
            this.checkLimitCondition(reh, value, rerPerm, user, false);
        }
        Object[] oid = (Object[])invocation.proceed();
        Object[] key = eh.isVersioned() && invocation.getInsertOption().isVersionSpecified() ? new Object[]{oid, inv.getEntity().getVersion()} : oid;
        this.checkLimitCondition(eh, key, perm, user, eh.isVersioned());
        return oid;
    }

    /*
     * WARNING - void declaration
     */
    private void checkLimitCondition(EntityHandler eh, Object value, EntityPermission permission, AuthContextHolder user, final boolean versionSpecified) {
        EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext(permission);
        if (eac.hasLimitCondition(permission, user)) {
            ArrayList<ValueExpression> oids;
            Query q = new Query().select("oid").from(eh.getMetaData().getName());
            if (versionSpecified) {
                q.select().add((Object)"version");
            }
            Condition cond = null;
            if (value instanceof Entity[]) {
                void var11_14;
                Entity[] eList = (Entity[])value;
                oids = new ArrayList<ValueExpression>();
                for (Entity e : eList) {
                    if (versionSpecified) {
                        Long ver = e.getVersion();
                        if (ver == null) {
                            ver = 0L;
                        }
                        oids.add(new RowValueList(new Literal(e.getOid()), new Literal(ver)));
                        continue;
                    }
                    oids.add(new Literal(e.getOid()));
                }
                if (oids.size() == 0) {
                    return;
                }
                if (versionSpecified) {
                    In in = new In(new String[]{"oid", "version"}, new Object[0][]);
                } else {
                    In in = new In("oid", new Object[0]);
                }
                var11_14.setValue(oids);
                cond = var11_14;
            } else if (value instanceof Entity) {
                if (versionSpecified) {
                    Long ver = ((Entity)value).getVersion();
                    if (ver == null) {
                        ver = 0L;
                    }
                    cond = new And(new Equals("oid", ((Entity)value).getOid()), new Equals("version", ver));
                } else {
                    cond = new Equals("oid", ((Entity)value).getOid());
                }
            } else if (versionSpecified) {
                Long ver;
                String oid;
                if (value instanceof Object[]) {
                    oid = (String)((Object[])value)[0];
                    ver = (Long)((Object[])value)[1];
                    if (ver == null) {
                        ver = 0L;
                    }
                } else {
                    oid = (String)value;
                    ver = 0L;
                }
                cond = new And(new Equals("oid", oid), new Equals("version", ver));
            } else {
                cond = new Equals("oid", (String)value);
            }
            q.where(cond);
            Query transQuery = eac.modifyQuery(q, permission.getAction(), user);
            oids = new ArrayList();
            AuthContext.doPrivileged(() -> new EntityQueryInvocationImpl(transQuery, new SearchOption().unnotifyListeners(), new Predicate<Object[]>(){

                @Override
                public boolean test(Object[] dataModel) {
                    if (versionSpecified) {
                        oids.add((String)dataModel[0] + "." + String.valueOf(dataModel[1]));
                    } else {
                        oids.add((String)dataModel[0]);
                    }
                    return true;
                }
            }, InvocationType.SEARCH, eh.getService().getInterceptors(), eh).proceed());
            if (value instanceof Entity[]) {
                for (Entity e : (Entity[])value) {
                    Object ct;
                    if (versionSpecified) {
                        Long ver = e.getVersion();
                        if (ver == null) {
                            ver = 0L;
                        }
                        ct = e.getOid() + "." + ver;
                    } else {
                        ct = e.getOid();
                    }
                    if (oids.contains(ct)) continue;
                    throw new NoPermissionException(this.getPermissionExceptionMessage(eh, permission.getAction()));
                }
            } else if (value instanceof Entity) {
                void var11_18;
                if (versionSpecified) {
                    Long ver = ((Entity)value).getVersion();
                    if (ver == null) {
                        ver = 0L;
                    }
                    String string = ((Entity)value).getOid() + "." + ver;
                } else {
                    String string = ((Entity)value).getOid();
                }
                if (!oids.contains(var11_18)) {
                    throw new NoPermissionException(this.getPermissionExceptionMessage(eh, permission.getAction()));
                }
            } else {
                void var11_21;
                if (versionSpecified) {
                    Long ver;
                    String oid;
                    if (value instanceof Object[]) {
                        oid = (String)((Object[])value)[0];
                        ver = (Long)((Object[])value)[1];
                        if (ver == null) {
                            ver = 0L;
                        }
                    } else {
                        oid = (String)value;
                        ver = 0L;
                    }
                    String string = oid + "." + ver;
                } else {
                    String string = (String)value;
                }
                if (!oids.contains(var11_21)) {
                    throw new NoPermissionException(this.getPermissionExceptionMessage(eh, permission.getAction()));
                }
            }
        }
    }

    private String getPermissionExceptionMessage(EntityHandler entityDefinition, EntityPermission.Action action) {
        String bundleKey = null;
        if (EntityPermission.Action.CREATE.equals((Object)action)) {
            bundleKey = "impl.entity.auth.EntityAuthInterceptor.noRegist";
        } else if (EntityPermission.Action.DELETE.equals((Object)action)) {
            bundleKey = "impl.entity.auth.EntityAuthInterceptor.noDelete";
        } else if (EntityPermission.Action.REFERENCE.equals((Object)action)) {
            bundleKey = "impl.entity.auth.EntityAuthInterceptor.noReference";
        } else if (EntityPermission.Action.UPDATE.equals((Object)action)) {
            bundleKey = "impl.entity.auth.EntityAuthInterceptor.noUpdate";
        } else {
            return null;
        }
        return EntityAuthInterceptor.resourceString(bundleKey, entityDefinition.getLocalizedDisplayName());
    }

    @Override
    public void update(EntityUpdateInvocation invocation) {
        EntityUpdateInvocationImpl inv = (EntityUpdateInvocationImpl)invocation;
        EntityHandler eh = inv.getEntityHandler();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        if (user.isPrivilegedExecution()) {
            if (logger.isDebugEnabled()) {
                logger.debug("privileged update call. shrot cut auth check.");
            }
            invocation.proceed();
        } else {
            EntityPermission perm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.UPDATE);
            if (!user.checkPermission(perm)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noUpdate", eh.getLocalizedDisplayName()));
            }
            this.checkLimitCondition(eh, inv.getEntity(), perm, user, eh.isVersioned() && TargetVersion.CURRENT_VALID != inv.getUpdateOption().getTargetVersion());
            UpdateOption updateOption = invocation.getUpdateOption();
            EntityContext ectx = EntityContext.getCurrentContext();
            for (String pName : updateOption.getUpdateProperties()) {
                ReferencePropertyHandler rph;
                Object value;
                PropertyHandler ph = eh.getProperty(pName, ectx);
                if (ph == null) continue;
                if (!user.checkPermission(new EntityPropertyPermission(eh.getMetaData().getName(), ph.getName(), EntityPropertyPermission.Action.UPDATE))) {
                    throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noUpdateProperty", eh.getLocalizedDisplayName(), ph.getLocalizedDisplayName()));
                }
                if (!(ph instanceof ReferencePropertyHandler) || (value = inv.getEntity().getValue(pName)) == null || (rph = (ReferencePropertyHandler)ph).getMetaData().getMappedByPropertyMetaDataId() != null) continue;
                EntityHandler reh = rph.getReferenceEntityHandler(ectx);
                EntityPermission refPerm = new EntityPermission(reh.getMetaData().getName(), EntityPermission.Action.REFERENCE);
                if (!user.checkPermission(refPerm)) {
                    throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noReference", reh.getLocalizedDisplayName()));
                }
                this.checkLimitCondition(reh, value, refPerm, user, false);
            }
            invocation.proceed();
        }
    }

    @Override
    public void delete(EntityDeleteInvocation invocation) {
        EntityDeleteInvocationImpl inv = (EntityDeleteInvocationImpl)invocation;
        EntityHandler eh = inv.getEntityHandler();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        if (user.isPrivilegedExecution()) {
            if (logger.isDebugEnabled()) {
                logger.debug("privileged delete call. shrot cut auth check.");
            }
            invocation.proceed();
        } else {
            EntityPermission perm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.DELETE);
            if (!user.checkPermission(perm)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noDelete", eh.getLocalizedDisplayName()));
            }
            this.checkLimitCondition(eh, inv.getEntity(), perm, user, eh.isVersioned() && DeleteTargetVersion.SPECIFIC == inv.getDeleteOption().getTargetVersion());
            invocation.proceed();
        }
    }

    @Override
    public Entity load(EntityLoadInvocation invocation) {
        Entity e = (Entity)invocation.proceed();
        return e;
    }

    @Override
    public void query(EntityQueryInvocation invocation) {
        EntityQueryInvocationImpl inv = (EntityQueryInvocationImpl)invocation;
        EntityHandler eh = inv.getEntityHandler();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        if (user.isPrivilegedExecution()) {
            if (logger.isDebugEnabled()) {
                logger.debug("privileged query call. shrot cut auth check.");
            }
            invocation.proceed();
        } else {
            EntityPermission perm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.REFERENCE);
            if (!user.checkPermission(perm)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noReference", eh.getLocalizedDisplayName()));
            }
            EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext(perm);
            EntityPermission.Action action = EntityQueryAuthContextHolder.getContext().getQueryAction();
            inv.setQuery(eac.modifyQuery(inv.getQuery(), action, EntityPropertyPermission.Action.REFERENCE, user));
            invocation.proceed();
        }
    }

    @Override
    public int count(EntityCountInvocation invocation) {
        EntityCountInvocationImpl inv = (EntityCountInvocationImpl)invocation;
        EntityHandler eh = inv.getEntityHandler();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        if (user.isPrivilegedExecution()) {
            if (logger.isDebugEnabled()) {
                logger.debug("privileged count call. shrot cut auth check.");
            }
            return (Integer)invocation.proceed();
        }
        EntityPermission perm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.REFERENCE);
        if (!user.checkPermission(perm)) {
            throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noReference", eh.getLocalizedDisplayName()));
        }
        EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext(perm);
        EntityPermission.Action action = EntityQueryAuthContextHolder.getContext().getQueryAction();
        inv.setQuery(eac.modifyQuery(inv.getQuery(), action, EntityPropertyPermission.Action.REFERENCE, user));
        return (Integer)invocation.proceed();
    }

    @Override
    public int updateAll(EntityUpdateAllInvocation invocation) {
        EntityUpdateAllInvocationImpl inv = (EntityUpdateAllInvocationImpl)invocation;
        EntityHandler eh = inv.getEntityHandler();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        if (user.isPrivilegedExecution()) {
            if (logger.isDebugEnabled()) {
                logger.debug("privileged updateAll call. shrot cut auth check.");
            }
            return (Integer)invocation.proceed();
        }
        EntityPermission perm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.UPDATE);
        if (!user.checkPermission(perm)) {
            throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noUpdate", eh.getLocalizedDisplayName()));
        }
        UpdateCondition updateCond = invocation.getUpdateCondition();
        EntityContext ectx = EntityContext.getCurrentContext();
        for (UpdateCondition.UpdateValue uv : updateCond.getValues()) {
            PropertyHandler ph = eh.getProperty(uv.getEntityField(), ectx);
            if (user.checkPermission(new EntityPropertyPermission(eh.getMetaData().getName(), ph.getName(), EntityPropertyPermission.Action.UPDATE))) continue;
            throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noUpdateProperty", eh.getLocalizedDisplayName(), ph.getLocalizedDisplayName()));
        }
        EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext(perm);
        if (eac.hasLimitCondition(perm, user)) {
            updateCond = new UpdateCondition(updateCond.getDefinitionName(), updateCond.getValues(), updateCond.getWhere());
            Condition cond = null;
            if (updateCond.getWhere() != null) {
                cond = updateCond.getWhere().getCondition();
            }
            cond = eac.addLimitingCondition(cond, EntityPermission.Action.UPDATE, user);
            updateCond.setWhere(new Where(cond));
            inv.setUpdateCondition(updateCond);
        }
        return (Integer)invocation.proceed();
    }

    @Override
    public int deleteAll(EntityDeleteAllInvocation invocation) {
        EntityDeleteAllInvocationImpl inv = (EntityDeleteAllInvocationImpl)invocation;
        EntityHandler eh = inv.getEntityHandler();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        if (user.isPrivilegedExecution()) {
            if (logger.isDebugEnabled()) {
                logger.debug("privileged deleteAll call. shrot cut auth check.");
            }
            return (Integer)invocation.proceed();
        }
        EntityPermission perm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.DELETE);
        if (!user.checkPermission(perm)) {
            throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noDelete", eh.getLocalizedDisplayName()));
        }
        EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext(perm);
        if (eac.hasLimitCondition(perm, user)) {
            DeleteCondition org = inv.getDeleteCondition();
            DeleteCondition delCond = new DeleteCondition(org.getDefinitionName(), org.getWhere());
            Condition cond = null;
            if (delCond.getWhere() != null) {
                cond = delCond.getWhere().getCondition();
            }
            cond = eac.addLimitingCondition(cond, EntityPermission.Action.DELETE, user);
            delCond.setWhere(new Where(cond));
            inv.setDeleteCondition(delCond);
        }
        return (Integer)invocation.proceed();
    }

    @Override
    public void getRecycleBin(EntityGetRecycleBinInvocation invocation) {
        EntityGetRecycleBinInvocationImpl inv = (EntityGetRecycleBinInvocationImpl)invocation;
        EntityHandler eh = inv.getEntityHandler();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        if (user.isPrivilegedExecution()) {
            if (logger.isDebugEnabled()) {
                logger.debug("privileged restore call. shrot cut auth check.");
            }
            invocation.proceed();
        } else {
            EntityPermission perm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.DELETE);
            if (!user.checkPermission(perm)) {
                return;
            }
            EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext(perm);
            if (eac.hasLimitCondition(perm, user)) {
                String clientId = ExecuteContext.getCurrentContext().getClientId();
                Predicate<Entity> cb = inv.getCallback();
                inv.setCallback(e -> {
                    if (clientId.equals(e.getUpdateBy())) {
                        return cb.test((Entity)e);
                    }
                    return true;
                });
            }
            invocation.proceed();
        }
    }

    @Override
    public void purge(EntityPurgeInvocation invocation) {
        EntityPurgeInvocationImpl inv = (EntityPurgeInvocationImpl)invocation;
        EntityHandler eh = inv.getEntityHandler();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        if (user.isPrivilegedExecution()) {
            if (logger.isDebugEnabled()) {
                logger.debug("privileged purge call. shrot cut auth check.");
            }
            invocation.proceed();
        } else {
            EntityPermission perm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.DELETE);
            if (!user.checkPermission(perm)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noDelete", eh.getLocalizedDisplayName()));
            }
            EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext(perm);
            if (eac.hasLimitCondition(perm, user)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noDeleteAll", eh.getLocalizedDisplayName()));
            }
            invocation.proceed();
        }
    }

    @Override
    public Entity restore(EntityRestoreInvocation invocation) {
        EntityRestoreInvocationImpl inv = (EntityRestoreInvocationImpl)invocation;
        EntityHandler eh = inv.getEntityHandler();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        if (user.isPrivilegedExecution()) {
            if (logger.isDebugEnabled()) {
                logger.debug("privileged restore call. shrot cut auth check.");
            }
            return (Entity)invocation.proceed();
        }
        EntityPermission perm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.DELETE);
        if (!user.checkPermission(perm)) {
            throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noUndo", eh.getLocalizedDisplayName()));
        }
        EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext(perm);
        if (eac.hasLimitCondition(perm, user)) {
            Entity[] ret = new Entity[1];
            eh.getRecycleBin(e -> {
                ret[0] = e;
                return false;
            }, inv.getRecycleBinId());
            if (ret[0] == null) {
                throw new EntityConcurrentUpdateException(EntityAuthInterceptor.resourceString("impl.core.EntityHandler.alreadyRestored", new Object[0]));
            }
            String clientId = ExecuteContext.getCurrentContext().getClientId();
            if (!clientId.equals(ret[0].getUpdateBy())) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noUndoAll", eh.getLocalizedDisplayName()));
            }
        }
        return (Entity)invocation.proceed();
    }

    @Override
    public void bulkUpdate(EntityBulkUpdateInvocation invocation) {
        EntityBulkUpdateInvocationImpl inv = (EntityBulkUpdateInvocationImpl)invocation;
        EntityHandler eh = inv.getEntityHandler();
        AuthContextHolder user = AuthContextHolder.getAuthContext();
        if (user.isPrivilegedExecution()) {
            if (logger.isDebugEnabled()) {
                logger.debug("privileged bulkUpdate call. shrot cut auth check.");
            }
            invocation.proceed();
        } else {
            EntityPermission delPerm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.DELETE);
            if (!user.checkPermission(delPerm)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noDelete", eh.getLocalizedDisplayName()));
            }
            EntityPermission crePerm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.CREATE);
            if (!user.checkPermission(crePerm)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noRegist", eh.getLocalizedDisplayName()));
            }
            EntityPermission updPerm = new EntityPermission(eh.getMetaData().getName(), EntityPermission.Action.UPDATE);
            if (!user.checkPermission(updPerm)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noUpdate", eh.getLocalizedDisplayName()));
            }
            EntityAuthContext eac = (EntityAuthContext)user.getAuthorizationContext(updPerm);
            if (eac.hasLimitCondition(delPerm, user)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noDelete", eh.getLocalizedDisplayName()));
            }
            if (eac.hasLimitCondition(updPerm, user)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noUpdate", eh.getLocalizedDisplayName()));
            }
            if (eac.hasLimitCondition(crePerm, user)) {
                throw new NoPermissionException(EntityAuthInterceptor.resourceString("impl.entity.auth.EntityAuthInterceptor.noRegist", eh.getLocalizedDisplayName()));
            }
            invocation.proceed();
        }
    }

    private static String resourceString(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

