/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.auth;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityQueryAuthContextHolder {
    public static final String REFERENCE_THIS = "this";
    private static final String HOLDER_NAME = "mtp.entity.auth.entityQueryAuthContextHolder";
    private static final Logger logger = LoggerFactory.getLogger(EntityQueryAuthContextHolder.class);
    private static final EntityQueryAuthContextHolder DEFAULT = new EntityQueryAuthContextHolder(EntityPermission.Action.REFERENCE, null, null);
    private final EntityPermission.Action queryAction;
    private final Set<String> withoutConditionReferenceNameSet;
    private final EntityQueryAuthContextHolder previous;

    private EntityQueryAuthContextHolder(EntityPermission.Action queryAction, String[] withoutConditionReferenceName, EntityQueryAuthContextHolder previous) {
        this.queryAction = queryAction == null ? EntityPermission.Action.REFERENCE : queryAction;
        if (withoutConditionReferenceName == null) {
            this.withoutConditionReferenceNameSet = Collections.emptySet();
        } else {
            this.withoutConditionReferenceNameSet = new HashSet<String>();
            for (String wcrn : withoutConditionReferenceName) {
                if (REFERENCE_THIS.equalsIgnoreCase(wcrn)) {
                    this.withoutConditionReferenceNameSet.add(REFERENCE_THIS);
                    continue;
                }
                this.withoutConditionReferenceNameSet.add(wcrn);
            }
        }
        this.previous = previous;
    }

    public static EntityQueryAuthContextHolder getContext() {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        EntityQueryAuthContextHolder holder = (EntityQueryAuthContextHolder)ec.getAttribute(HOLDER_NAME);
        if (holder == null) {
            return DEFAULT;
        }
        return holder;
    }

    public static void set(EntityPermission.Action queryAction, String[] withoutConditionReferenceName) {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        EntityQueryAuthContextHolder pre = (EntityQueryAuthContextHolder)ec.getAttribute(HOLDER_NAME);
        ec.setAttribute(HOLDER_NAME, new EntityQueryAuthContextHolder(queryAction, withoutConditionReferenceName, pre), false);
        if (logger.isDebugEnabled()) {
            logger.debug("set EntityQueryAuthContext to " + String.valueOf((Object)queryAction));
        }
    }

    public static void clear() {
        ExecuteContext ec = ExecuteContext.getCurrentContext();
        EntityQueryAuthContextHolder holder = (EntityQueryAuthContextHolder)ec.getAttribute(HOLDER_NAME);
        if (holder != null) {
            if (holder.previous == null) {
                ec.removeAttribute(HOLDER_NAME);
            } else {
                ec.setAttribute(HOLDER_NAME, holder.previous, false);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("clear EntityQueryAuthContext");
        }
    }

    public EntityPermission.Action getQueryAction() {
        return this.queryAction;
    }

    public boolean isWithoutConditionReferenceName(String referenceName) {
        return this.withoutConditionReferenceNameSet.contains(referenceName);
    }
}

