/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.cache;

import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.cache.store.keyresolver.CacheKeyResolver;
import org.iplass.mtp.impl.entity.cache.QueryCacheKey;

public class QueryCacheKeyResolver
implements CacheKeyResolver {
    static final String FLAG_RETURN_STRUCTURED_ENTITY = "RSE:";
    static final String FLAG_COUNT_ONLY = "CO:";

    @Override
    public String toString(Object cacheKey) {
        QueryCacheKey k = (QueryCacheKey)cacheKey;
        StringBuilder sb = new StringBuilder();
        if (k.countOnly) {
            sb.append(FLAG_COUNT_ONLY);
        }
        if (k.returnStructuredEntity) {
            sb.append(FLAG_RETURN_STRUCTURED_ENTITY);
        }
        sb.append(k.query.toString());
        return sb.toString();
    }

    @Override
    public Object toCacheKey(String cacheKeyString) {
        boolean countOnly = false;
        boolean returnStructuredEntity = false;
        if (cacheKeyString.startsWith(FLAG_COUNT_ONLY)) {
            countOnly = true;
            cacheKeyString = cacheKeyString.substring(FLAG_COUNT_ONLY.length());
        }
        if (cacheKeyString.startsWith(FLAG_RETURN_STRUCTURED_ENTITY)) {
            returnStructuredEntity = true;
            cacheKeyString = cacheKeyString.substring(FLAG_RETURN_STRUCTURED_ENTITY.length());
        }
        return new QueryCacheKey(Query.newQuery(cacheKeyString), returnStructuredEntity, countOnly);
    }
}

