/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.fileport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.impl.entity.fileport.EntityCsvException;
import org.iplass.mtp.impl.entity.fileport.EntityFileReader;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.io.CsvListReader;
import org.supercsv.prefs.CsvPreference;

public class EntityCsvReader
extends EntityFileReader<EntityCsvReader> {
    private static final Logger logger = LoggerFactory.getLogger(EntityCsvReader.class);
    private Reader reader;
    private CsvListReader csvListReader;

    public EntityCsvReader(EntityDefinition definition, InputStream inputStream) throws UnsupportedEncodingException {
        this(definition, inputStream, "UTF-8");
    }

    public EntityCsvReader(EntityDefinition definition, InputStream inputStream, String charset) throws UnsupportedEncodingException {
        super(definition);
        InputStreamReader reader = new InputStreamReader(inputStream, charset);
        BufferedReader buffered = new BufferedReader(reader);
        this.reader = buffered;
    }

    public EntityCsvReader(EntityDefinition definition, Reader reader) {
        super(definition);
        BufferedReader buffered = null;
        buffered = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.reader = buffered;
    }

    @Override
    protected List<String> readHeader() {
        this.csvListReader = new CsvListReader(this.reader, new CsvPreference.Builder(CsvPreference.STANDARD_PREFERENCE).surroundingSpacesNeedQuotes(true).build());
        List headerLine = null;
        try {
            headerLine = this.csvListReader.read();
        }
        catch (IOException e) {
            throw new EntityCsvException(e);
        }
        if (CollectionUtil.isEmpty(headerLine)) {
            throw new EntityCsvException("CE2000", EntityCsvReader.rs("impl.csv.EntityCsvReader.emptyFile", new Object[0]));
        }
        headerLine.set(0, this.excludeBOM((String)headerLine.get(0)));
        return headerLine;
    }

    @Override
    protected List<String> readData() {
        try {
            List currentLine = this.csvListReader.read();
            return currentLine;
        }
        catch (IOException e) {
            throw new EntityCsvException(e);
        }
    }

    @Override
    public void close() {
        Object closable;
        Object object = closable = this.csvListReader != null ? this.csvListReader : this.reader;
        if (closable != null) {
            try {
                closable.close();
            }
            catch (IOException e) {
                logger.warn("fail to close EntityCsvReader resource. check whether resource is leak or not.", (Throwable)e);
            }
            this.csvListReader = null;
            this.reader = null;
        }
    }

    private String excludeBOM(String value) {
        if (value.charAt(0) == '\ufeff') {
            return String.copyValueOf(value.toCharArray(), 1, value.toCharArray().length - 1);
        }
        return value;
    }

    private static String rs(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

