/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.fileport;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.format.CellFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.fileport.EntityCsvException;
import org.iplass.mtp.impl.entity.fileport.EntityFileReader;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityExcelReader
extends EntityFileReader<EntityExcelReader> {
    private static final Logger logger = LoggerFactory.getLogger(EntityExcelReader.class);
    private InputStream inputStream;
    private Workbook workbook;
    private Sheet sheet;
    private int rowIndex = 1;
    private String dateFormat;
    private String dateTimeFormat;
    private String timeFormat;

    public EntityExcelReader(EntityDefinition definition, InputStream inputStream) {
        super(definition);
        this.inputStream = inputStream;
    }

    @Override
    public void close() throws Exception {
        if (this.workbook != null) {
            try {
                this.workbook.close();
            }
            catch (IOException e) {
                logger.warn("fail to close EntityExcelReader resource. check whether resource is leak or not.", (Throwable)e);
            }
            this.workbook = null;
        }
    }

    @Override
    protected List<String> readHeader() {
        String cellValue;
        try {
            this.workbook = WorkbookFactory.create((InputStream)this.inputStream);
        }
        catch (IOException | EncryptedDocumentException e) {
            throw new EntityCsvException("fail to read EntityExcelReader.", e);
        }
        this.sheet = this.workbook.getSheetAt(0);
        int lastRow = this.sheet.getLastRowNum();
        if (lastRow < 1) {
            throw new EntityCsvException("CE2000", EntityExcelReader.rs("impl.csv.EntityCsvReader.emptyFile", new Object[0]));
        }
        Row headerRow = this.sheet.getRow(0);
        if (headerRow == null) {
            throw new EntityCsvException("CE2000", EntityExcelReader.rs("impl.csv.EntityCsvReader.emptyFile", new Object[0]));
        }
        int lastCell = headerRow.getLastCellNum();
        if (lastCell < 1) {
            throw new EntityCsvException("CE2000", EntityExcelReader.rs("impl.csv.EntityCsvReader.emptyFile", new Object[0]));
        }
        ArrayList<String> headerLine = new ArrayList<String>();
        for (int i = 0; i < lastCell && !StringUtil.isEmpty(cellValue = headerRow.getCell(i).getStringCellValue()); ++i) {
            headerLine.add(cellValue);
        }
        return headerLine;
    }

    @Override
    protected List<String> readData() {
        if (this.sheet.getLastRowNum() < this.rowIndex) {
            return null;
        }
        Row currentRow = this.sheet.getRow(this.rowIndex);
        if (currentRow == null) {
            return null;
        }
        int lastCell = currentRow.getLastCellNum();
        int maxCellNum = lastCell > this.header().size() ? this.header().size() : lastCell;
        ArrayList<String> currentLine = new ArrayList<String>();
        for (int i = 0; i < maxCellNum; ++i) {
            PropertyDefinition propertyDefinition = this.definition.getProperty(this.properties().get(i));
            String cellValue = this.getCellStringValue(currentRow.getCell(i), propertyDefinition);
            currentLine.add(cellValue);
        }
        if (currentLine.stream().anyMatch(value -> StringUtil.isNotEmpty(value))) {
            ++this.rowIndex;
            return currentLine;
        }
        return null;
    }

    private String getCellStringValue(Cell cell, PropertyDefinition propertyDefinition) {
        String value = null;
        CellType cellType = cell.getCellType();
        switch (cellType) {
            case STRING: {
                value = cell.getStringCellValue();
                break;
            }
            case NUMERIC: {
                value = this.getNumericStringValue(cell, propertyDefinition);
                break;
            }
            case BOOLEAN: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
        }
        return value;
    }

    private String getNumericStringValue(Cell cell, PropertyDefinition propertyDefinition) {
        if (org.apache.poi.ss.usermodel.DateUtil.isCellDateFormatted((Cell)cell)) {
            if (propertyDefinition == null) {
                return null;
            }
            switch (propertyDefinition.getType()) {
                case DATE: {
                    return DateUtil.getSimpleDateFormat(this.getDateFormat(), false).format(cell.getDateCellValue());
                }
                case DATETIME: {
                    return DateUtil.getSimpleDateFormat(this.getDateTimeFormat(), false).format(cell.getDateCellValue());
                }
                case TIME: {
                    return DateUtil.getSimpleDateFormat(this.getTimeFormat(), false).format(cell.getDateCellValue());
                }
            }
            return null;
        }
        if (164 <= cell.getCellStyle().getDataFormat()) {
            CellFormat cellFormat = CellFormat.getInstance((String)cell.getCellStyle().getDataFormatString());
            return cellFormat.apply((Cell)cell).text;
        }
        if (propertyDefinition != null && propertyDefinition.getType() == PropertyDefinitionType.BOOLEAN) {
            return ConvertUtil.convertToString((int)cell.getNumericCellValue());
        }
        return ConvertUtil.convertToString(cell.getNumericCellValue());
    }

    private String getDateFormat() {
        if (this.dateFormat != null) {
            return this.dateFormat;
        }
        this.dateFormat = ExecuteContext.getCurrentContext().getLocaleFormat().getOutputDateFormat();
        return this.dateFormat;
    }

    private String getDateTimeFormat() {
        if (this.dateTimeFormat != null) {
            return this.dateTimeFormat;
        }
        this.dateTimeFormat = ExecuteContext.getCurrentContext().getLocaleFormat().getOutputDatetimeSecFormat();
        return this.dateTimeFormat;
    }

    private String getTimeFormat() {
        if (this.timeFormat != null) {
            return this.timeFormat;
        }
        this.timeFormat = ExecuteContext.getCurrentContext().getLocaleFormat().getOutputTimeSecFormat();
        return this.timeFormat;
    }

    private static String rs(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }
}

