/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.fileport;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.permission.EntityPropertyPermission;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.fileport.EntityCsvException;
import org.iplass.mtp.impl.entity.fileport.EntityExcelWriteOption;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.util.CollectionUtil;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityExcelWriter
implements AutoCloseable,
Flushable {
    private static final Logger logger = LoggerFactory.getLogger(EntityExcelWriter.class);
    private static final String DATE_EXCEL_FORMAT = "yyyy/mm/dd";
    private static final String TIME_EXCEL_FORMAT = "hh:mm:ss";
    private EntityDefinition definition;
    private OutputStream out;
    private EntityExcelWriteOption option;
    private ZipOutputStream binaryStore;
    private AuthContext auth;
    private EntityDefinitionManager edm;
    private EntityManager em;
    private boolean isInit;
    private List<PropertyDefinition> properties;
    private String dateFormat;
    private String dateTimeFormat;
    private String timeFormat;
    private ObjectMapper mapper;
    private SXSSFWorkbook workbook;
    private SXSSFSheet sheet;
    private Row headerRow;
    private CellStyle headerCellStyle;
    private int rowIndex = 0;
    private CellStyle dataCellStyle;
    private CellStyle dateTimeCellStyle;
    private CellStyle dateCellStyle;
    private CellStyle timeCellStyle;
    private Row currentRow;

    public EntityExcelWriter(EntityDefinition definition, OutputStream out) throws IOException {
        this(definition, out, new EntityExcelWriteOption());
    }

    public EntityExcelWriter(EntityDefinition definition, OutputStream out, EntityExcelWriteOption option) throws IOException {
        this(definition, out, option, null);
    }

    public EntityExcelWriter(EntityDefinition definition, OutputStream out, EntityExcelWriteOption option, ZipOutputStream binaryStore) throws IOException {
        this.definition = definition;
        this.out = out;
        this.option = option;
        this.binaryStore = binaryStore;
        this.auth = AuthContext.getCurrentContext();
        this.edm = ManagerLocator.getInstance().getManager(EntityDefinitionManager.class);
        this.em = ManagerLocator.getInstance().getManager(EntityManager.class);
        String sheetName = I18nUtil.stringDef(definition.getDisplayName(), definition.getLocalizedDisplayNameList());
        this.workbook = new SXSSFWorkbook();
        this.sheet = this.workbook.createSheet(WorkbookUtil.createSafeSheetName((String)sheetName));
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() {
        if (this.workbook != null) {
            try {
                this.workbook.close();
            }
            catch (IOException e) {
                logger.warn("fail to close EntityExcelWriter resource. check whether resource is leak or not.", (Throwable)e);
            }
            this.workbook = null;
        }
    }

    public List<PropertyDefinition> getProperties() {
        this.init();
        return this.properties;
    }

    public void writeHeader() {
        this.init();
        this.headerRow = this.sheet.createRow(0);
        this.headerCellStyle = this.workbook.createCellStyle();
        this.headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        this.headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        this.headerCellStyle.setBorderLeft(BorderStyle.THIN);
        this.headerCellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        this.headerCellStyle.setBorderTop(BorderStyle.THIN);
        this.headerCellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        this.headerCellStyle.setBorderRight(BorderStyle.THIN);
        this.headerCellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        this.headerCellStyle.setBorderBottom(BorderStyle.THIN);
        this.headerCellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        int[] columnIndex = new int[]{0};
        IntStream.range(0, this.properties.size()).forEach(i -> {
            PropertyDefinition property = this.properties.get(i);
            if (!(property instanceof ReferenceProperty) && property.getMultiplicity() != 1) {
                IntStream.range(0, property.getMultiplicity()).forEach(j -> {
                    if (j != 0) {
                        columnIndex[0] = columnIndex[0] + 1;
                    }
                    this.writeHeaderColumn(columnIndex[0], this.option.getMultipleColumnName().apply(property, j));
                });
            } else {
                this.writeHeaderColumn(columnIndex[0], this.option.getColumnName().apply(property));
            }
            columnIndex[0] = columnIndex[0] + 1;
        });
    }

    private void writeHeaderColumn(int columnIndex, String text) {
        Cell cell = this.headerRow.createCell(columnIndex);
        cell.setCellStyle(this.headerCellStyle);
        cell.setCellValue(text);
    }

    public void beforeWriteData() {
        this.dataCellStyle = this.workbook.createCellStyle();
        this.applyDataCellStyle(this.dataCellStyle);
        CreationHelper createHelper = this.workbook.getCreationHelper();
        this.dateCellStyle = this.workbook.createCellStyle();
        this.applyDataCellStyle(this.dateCellStyle);
        this.dateCellStyle.setDataFormat(createHelper.createDataFormat().getFormat(DATE_EXCEL_FORMAT));
        this.dateTimeCellStyle = this.workbook.createCellStyle();
        this.applyDataCellStyle(this.dateTimeCellStyle);
        this.dateTimeCellStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyyy/mm/dd hh:mm:ss"));
        this.timeCellStyle = this.workbook.createCellStyle();
        this.applyDataCellStyle(this.timeCellStyle);
        this.timeCellStyle.setDataFormat(createHelper.createDataFormat().getFormat(TIME_EXCEL_FORMAT));
    }

    private void applyDataCellStyle(CellStyle cellStyle) {
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.getIndex());
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.getIndex());
    }

    public void writeEntity(Entity entity) {
        this.init();
        ++this.rowIndex;
        this.currentRow = this.sheet.createRow(this.rowIndex);
        int[] columnIndex = new int[]{0};
        Iterator<PropertyDefinition> it = this.properties.iterator();
        while (it.hasNext()) {
            PropertyDefinition property = it.next();
            if (!(property instanceof ReferenceProperty) && property.getMultiplicity() != 1) {
                Object[] values = (Object[])entity.getValue(property.getName());
                if (property instanceof SelectProperty && this.option.getSortSelectValue().apply((SelectProperty)property).booleanValue()) {
                    SelectProperty sp = (SelectProperty)property;
                    List<SelectValue> selectableValues = sp.getSelectValueList();
                    IntStream.range(0, property.getMultiplicity()).forEach(i -> {
                        if (i != 0) {
                            columnIndex[0] = columnIndex[0] + 1;
                        }
                        if (values == null || i > selectableValues.size() - 1) {
                            this.writeValue(columnIndex[0], null, property, this.binaryStore);
                        } else {
                            SelectValue targetValue = (SelectValue)selectableValues.get(i);
                            boolean exist = Arrays.stream(values).anyMatch(value -> value != null && ((SelectValue)value).getValue().equals(targetValue.getValue()));
                            if (exist) {
                                this.writeValue(columnIndex[0], targetValue, property, this.binaryStore);
                            } else {
                                this.writeValue(columnIndex[0], null, property, this.binaryStore);
                            }
                        }
                    });
                } else {
                    IntStream.range(0, property.getMultiplicity()).forEach(i -> {
                        if (i != 0) {
                            columnIndex[0] = columnIndex[0] + 1;
                        }
                        if (values == null || i >= values.length) {
                            this.writeValue(columnIndex[0], null, property, this.binaryStore);
                        } else {
                            this.writeValue(columnIndex[0], values[i], property, this.binaryStore);
                        }
                    });
                }
            } else {
                Object val = entity.getValue(property.getName());
                this.writeValue(columnIndex[0], val, property, this.binaryStore);
            }
            if (!it.hasNext()) continue;
            columnIndex[0] = columnIndex[0] + 1;
        }
    }

    public void endData() {
        try {
            this.workbook.write(this.out);
        }
        catch (IOException e) {
            throw new EntityCsvException("fail to write EntityExcelWriter.", e);
        }
    }

    protected void init() {
        if (this.isInit) {
            return;
        }
        List<PropertyDefinition> outputProperties = this.getOutputProperties();
        this.properties = outputProperties.stream().filter(property -> this.auth.checkPermission(new EntityPropertyPermission(this.definition.getName(), property.getName(), EntityPropertyPermission.Action.REFERENCE))).filter(property -> !"version".equals(property.getName()) || this.definition.getVersionControlType() != VersionControlType.NONE).filter(property -> this.option.isWithMappedByReference() || CollectionUtil.isNotEmpty(this.option.getProperties()) || !(property instanceof ReferenceProperty) || ((ReferenceProperty)property).getMappedBy() == null).filter(property -> this.option.isWithBinary() || CollectionUtil.isNotEmpty(this.option.getProperties()) || !(property instanceof BinaryProperty)).collect(Collectors.toList());
        this.isInit = true;
    }

    private List<PropertyDefinition> getOutputProperties() {
        ArrayList<PropertyDefinition> outputProperties = null;
        if (CollectionUtil.isNotEmpty(this.option.getProperties())) {
            outputProperties = new ArrayList();
            outputProperties.add(this.definition.getProperty("oid"));
            outputProperties.add(this.definition.getProperty("version"));
            outputProperties.addAll(this.option.getProperties().stream().filter(propertyName -> !propertyName.equals("oid") && !propertyName.equals("version")).map(propertyName -> {
                PropertyDefinition property = this.definition.getProperty((String)propertyName);
                if (property == null) {
                    throw new EntityCsvException(propertyName + " is invalid property in " + this.definition.getName());
                }
                return property;
            }).collect(Collectors.toList()));
        } else {
            outputProperties = this.definition.getPropertyList();
        }
        return outputProperties;
    }

    private void writeText(Cell cell, String text) {
        if (StringUtil.isEmpty(text)) {
            return;
        }
        cell.setCellValue(text);
    }

    private void writeValue(int columnIndex, Object val, PropertyDefinition pd, ZipOutputStream binaryStore) {
        Cell cell = this.currentRow.createCell(columnIndex);
        cell.setCellStyle(this.getCellStyle(pd));
        if (val == null) {
            return;
        }
        switch (pd.getType()) {
            case EXPRESSION: {
                ExpressionProperty ep = (ExpressionProperty)pd;
                if (ep.getResultType() != null) {
                    this.writeValue(cell, val, ep.getResultType());
                    break;
                }
                this.writeValue(cell, val, ep.getType());
                break;
            }
            case REFERENCE: {
                ReferenceProperty rpd = (ReferenceProperty)pd;
                EntityDefinition ed = this.edm.get(rpd.getObjectDefinitionName());
                if (rpd.getMultiplicity() == 1) {
                    Entity entity = (Entity)val;
                    if (ed.getVersionControlType().equals((Object)VersionControlType.NONE) && !this.option.isWithReferenceVersion()) {
                        this.writeText(cell, entity.getOid());
                        break;
                    }
                    this.writeText(cell, entity.getOid() + "." + entity.getVersion());
                    break;
                }
                Entity[] eList = (Entity[])val;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < eList.length; ++i) {
                    if (i != 0) {
                        sb.append(",");
                    }
                    if (eList[i] == null) continue;
                    if (ed.getVersionControlType().equals((Object)VersionControlType.NONE) && !this.option.isWithReferenceVersion()) {
                        sb.append(eList[i].getOid());
                        continue;
                    }
                    sb.append(eList[i].getOid() + "." + eList[i].getVersion());
                }
                this.writeText(cell, sb.toString());
                break;
            }
            case BINARY: {
                BinaryReference br = (BinaryReference)val;
                LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
                valueMap.put("lobid", String.valueOf(br.getLobId()));
                valueMap.put("name", br.getName());
                valueMap.put("type", br.getType());
                this.writeText(cell, this.toJsonString(valueMap));
                this.writeBinaryData(br, binaryStore);
                break;
            }
            default: {
                this.writeValue(cell, val, pd.getType());
            }
        }
    }

    private void writeValue(Cell cell, Object val, PropertyDefinitionType type) {
        switch (type) {
            case BOOLEAN: {
                Boolean b = (Boolean)val;
                this.writeText(cell, b.toString());
                break;
            }
            case DATE: {
                this.writeText(cell, DateUtil.getSimpleDateFormat(this.getDateFormat(), false).format((Date)val));
                break;
            }
            case DATETIME: {
                this.writeText(cell, DateUtil.getSimpleDateFormat(this.getDateTimeFormat(), false).format((Timestamp)val));
                break;
            }
            case TIME: {
                this.writeText(cell, DateUtil.getSimpleDateFormat(this.getTimeFormat(), false).format((Time)val));
                break;
            }
            case SELECT: {
                SelectValue sv = (SelectValue)val;
                this.writeText(cell, sv.getValue());
                break;
            }
            case DECIMAL: {
                this.writeText(cell, ((BigDecimal)val).toPlainString());
                break;
            }
            case FLOAT: {
                this.writeText(cell, BigDecimal.valueOf((Double)val).toPlainString());
                break;
            }
            case EXPRESSION: 
            case INTEGER: 
            case LONGTEXT: 
            case STRING: 
            case AUTONUMBER: {
                this.writeText(cell, val.toString());
                break;
            }
            case REFERENCE: 
            case BINARY: {
                break;
            }
            default: {
                throw new EntityCsvException("can not convert from " + String.valueOf((Object)type) + ":" + String.valueOf(val));
            }
        }
    }

    private CellStyle getCellStyle(PropertyDefinition propertyDefinition) {
        PropertyDefinitionType type = propertyDefinition.getType();
        switch (type) {
            case DATE: {
                return this.dateCellStyle;
            }
            case DATETIME: {
                return this.dateTimeCellStyle;
            }
            case TIME: {
                return this.timeCellStyle;
            }
        }
        return this.dataCellStyle;
    }

    private void writeBinaryData(BinaryReference br, ZipOutputStream binaryStore) {
        block13: {
            try {
                File lobFile;
                if (binaryStore != null) {
                    String entryName = "lobs/" + this.definition.getName() + "." + br.getLobId();
                    ZipEntry zentry = new ZipEntry(entryName);
                    binaryStore.putNextEntry(zentry);
                    if (this.write(br, binaryStore)) {
                        binaryStore.closeEntry();
                    }
                    break block13;
                }
                if (!StringUtil.isNotBlank(this.option.getExportBinaryDataDir())) break block13;
                File lobDir = new File(this.option.getExportBinaryDataDir());
                if (!lobDir.exists()) {
                    lobDir.mkdir();
                }
                if ((lobFile = new File(this.option.getExportBinaryDataDir(), this.definition.getName() + "." + br.getLobId())).exists()) {
                    lobFile.delete();
                }
                lobFile.createNewFile();
                try (FileOutputStream fileBinaryStore = new FileOutputStream(lobFile);){
                    this.write(br, fileBinaryStore);
                }
                catch (IOException e) {
                    throw new EntityCsvException(e);
                }
            }
            catch (IOException e) {
                throw new EntityCsvException(e);
            }
        }
    }

    private boolean write(BinaryReference br, OutputStream outputStream) throws IOException {
        InputStream is = this.em.getInputStream(br);
        if (is != null) {
            try (BufferedInputStream bis = new BufferedInputStream(is);){
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = ((InputStream)bis).read(buf)) >= 0) {
                    outputStream.write(buf, 0, len);
                }
                boolean bl = true;
                return bl;
            }
        }
        logger.warn("cannot output binary data. entity = " + br.getDefinitionName() + ", lobid = " + br.getLobId());
        return false;
    }

    private String toJsonString(Object value) {
        String string;
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.mapper.configOverride(Date.class).setFormat(JsonFormat.Value.forPattern((String)"yyyy-MM-dd").withTimeZone(TimeZone.getDefault()));
        }
        StringWriter writer = new StringWriter();
        try {
            this.mapper.writeValue((Writer)writer, value);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonProcessingException e) {
                throw new EntityCsvException(e);
            }
            catch (IOException e) {
                throw new EntityCsvException(e);
            }
        }
        writer.close();
        return string;
    }

    private String getDateFormat() {
        if (this.dateFormat != null) {
            return this.dateFormat;
        }
        this.dateFormat = this.option.getDateFormat() != null ? this.option.getDateFormat() : ExecuteContext.getCurrentContext().getLocaleFormat().getOutputDateFormat();
        return this.dateFormat;
    }

    private String getDateTimeFormat() {
        if (this.dateTimeFormat != null) {
            return this.dateTimeFormat;
        }
        this.dateTimeFormat = this.option.getDatetimeSecFormat() != null ? this.option.getDatetimeSecFormat() : ExecuteContext.getCurrentContext().getLocaleFormat().getOutputDatetimeSecFormat();
        return this.dateTimeFormat;
    }

    private String getTimeFormat() {
        if (this.timeFormat != null) {
            return this.timeFormat;
        }
        this.timeFormat = this.option.getTimeSecFormat() != null ? this.option.getTimeSecFormat() : ExecuteContext.getCurrentContext().getLocaleFormat().getOutputTimeSecFormat();
        return this.timeFormat;
    }
}

