/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.fileport;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TimeZone;
import org.iplass.mtp.ApplicationException;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.EntityMapping;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.VersionControlType;
import org.iplass.mtp.entity.definition.properties.AutoNumberProperty;
import org.iplass.mtp.entity.definition.properties.BinaryProperty;
import org.iplass.mtp.entity.definition.properties.BooleanProperty;
import org.iplass.mtp.entity.definition.properties.DateProperty;
import org.iplass.mtp.entity.definition.properties.DateTimeProperty;
import org.iplass.mtp.entity.definition.properties.DecimalProperty;
import org.iplass.mtp.entity.definition.properties.ExpressionProperty;
import org.iplass.mtp.entity.definition.properties.FloatProperty;
import org.iplass.mtp.entity.definition.properties.IntegerProperty;
import org.iplass.mtp.entity.definition.properties.LongTextProperty;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.definition.properties.SelectProperty;
import org.iplass.mtp.entity.definition.properties.StringProperty;
import org.iplass.mtp.entity.definition.properties.TimeProperty;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.entity.fileport.EntityCsvException;
import org.iplass.mtp.impl.util.ConvertUtil;
import org.iplass.mtp.impl.util.CoreResourceBundleUtil;
import org.iplass.mtp.util.CollectionUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EntityFileReader<T extends EntityFileReader<?>>
implements Iterable<Entity>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(EntityFileReader.class);
    public static final String CTRL_CODE_KEY = "_useCtrl";
    public static final String CTRL_INSERT = "I";
    public static final String CTRL_UPDATE = "U";
    public static final String CTRL_DELETE = "D";
    public static final String CTRL_MERGE = "M";
    public static final int NVL = -1;
    protected EntityDefinition definition;
    private boolean withReferenceVersion;
    private String prefixOid;
    private boolean ignoreNotExistsProperty;
    private boolean enableAuditPropertySpecification;
    private Map<String, String> customColumnNameMap;
    private List<String> virtualProperties;
    private List<String> headers;
    private List<String> properties;
    private List<String> excludeProperties;
    private List<Integer> arrayIndex;
    private Map<String, ReferenceInfo> references;
    private boolean isInit;
    private boolean isIterate;
    private boolean useCtrl;
    private ObjectMapper mapper;
    private boolean usePrefixOid;
    private EntityDefinitionManager edm = ManagerLocator.manager(EntityDefinitionManager.class);
    private EntityManager em = ManagerLocator.manager(EntityManager.class);

    public EntityFileReader(EntityDefinition definition) {
        this.definition = definition;
    }

    protected abstract List<String> readHeader();

    protected abstract List<String> readData();

    private void init() {
        if (this.isInit) {
            return;
        }
        List<String> headerLine = this.readHeader();
        this.analyzeHeader(headerLine);
        this.validateHeader();
        this.usePrefixOid = StringUtil.isNotEmpty(this.prefixOid) && CollectionUtil.isEmpty(this.definition.getOidPropertyName());
        this.isInit = true;
    }

    public void setWithReferenceVersion(boolean withReferenceVersion) {
        this.withReferenceVersion = withReferenceVersion;
    }

    public T withReferenceVersion(boolean withReferenceVersion) {
        this.withReferenceVersion = withReferenceVersion;
        return (T)this;
    }

    public void setPrefixOid(String prefixOid) {
        this.prefixOid = prefixOid;
    }

    public T prefixOid(String prefixOid) {
        this.prefixOid = prefixOid;
        return (T)this;
    }

    public void setIgnoreNotExistsProperty(boolean ignoreNotExistsProperty) {
        this.ignoreNotExistsProperty = ignoreNotExistsProperty;
    }

    public T ignoreNotExistsProperty(boolean ignoreNotExistsProperty) {
        this.ignoreNotExistsProperty = ignoreNotExistsProperty;
        return (T)this;
    }

    public void setEnableAuditPropertySpecification(boolean enableAuditPropertySpecification) {
        this.enableAuditPropertySpecification = enableAuditPropertySpecification;
    }

    public T enableAuditPropertySpecification(boolean enableAuditPropertySpecification) {
        this.enableAuditPropertySpecification = enableAuditPropertySpecification;
        return (T)this;
    }

    public void setCustomColumnNameMap(Map<String, String> customColumnNameMap) {
        this.customColumnNameMap = customColumnNameMap;
    }

    public T customColumnNameMap(Map<String, String> customColumnNameMap) {
        this.customColumnNameMap = customColumnNameMap;
        return (T)this;
    }

    public void setVirtualProperties(List<String> virtualProperties) {
        this.virtualProperties = virtualProperties;
    }

    public T virtualProperties(List<String> virtualProperties) {
        this.virtualProperties = virtualProperties;
        return (T)this;
    }

    public boolean isUseCtrl() {
        this.init();
        return this.useCtrl;
    }

    public List<String> properties() {
        this.init();
        return this.properties;
    }

    @Override
    public Iterator<Entity> iterator() {
        this.init();
        if (this.isIterate) {
            throw new UnsupportedOperationException("concurrent iterate not supported.");
        }
        this.isIterate = true;
        return new Iterator<Entity>(){
            private List<String> currentLine;

            @Override
            public boolean hasNext() {
                this.read();
                return this.currentLine != null;
            }

            private void read() {
                if (this.currentLine == null) {
                    this.currentLine = EntityFileReader.this.readData();
                }
            }

            @Override
            public Entity next() {
                this.read();
                if (this.currentLine == null) {
                    throw new NoSuchElementException();
                }
                EntityFileReader.this.validateLine(this.currentLine);
                EntityMapping mapping = EntityFileReader.this.definition.getMapping();
                Entity entity = EntityFileReader.this.generateEntity(mapping, null);
                entity.setDefinitionName(EntityFileReader.this.definition.getName());
                HashSet<String> multiProp = new HashSet<String>();
                for (int i = 0; i < EntityFileReader.this.headers.size(); ++i) {
                    String headerName = EntityFileReader.this.headers.get(i);
                    String propName = EntityFileReader.this.properties.get(i);
                    if (!EntityFileReader.this.enableAuditPropertySpecification && (propName.equals("updateBy") || propName.equals("updateDate") || propName.equals("createBy") || propName.equals("createDate"))) continue;
                    String value = this.currentLine.get(i);
                    if (i == 0 && propName.equals(EntityFileReader.CTRL_CODE_KEY)) {
                        entity.setValue(EntityFileReader.CTRL_CODE_KEY, value);
                        continue;
                    }
                    if (EntityFileReader.this.excludeProperties.contains(propName)) continue;
                    try {
                        Object propValue = null;
                        if (headerName.contains(".")) {
                            if (EntityFileReader.this.references.get(propName) != null) {
                                propName = EntityFileReader.this.references.get((Object)propName).propName;
                                propValue = EntityFileReader.this.references.get(propName).convEntity(value);
                            } else {
                                propValue = EntityFileReader.this.conv(value, propName, null);
                            }
                        } else {
                            propValue = EntityFileReader.this.conv(value, propName, EntityFileReader.this.definition.getProperty(propName));
                        }
                        if (EntityFileReader.this.arrayIndex.get(i) == -1) {
                            entity.setValue(propName, propValue);
                            continue;
                        }
                        if (EntityFileReader.this.definition.getProperty(propName) != null) {
                            Object[] valArray = (Object[])entity.getValue(propName);
                            if (valArray == null) {
                                valArray = (Object[])Array.newInstance(EntityFileReader.this.definition.getProperty(propName).getJavaType(), EntityFileReader.this.definition.getProperty(propName).getMultiplicity());
                                entity.setValue(propName, valArray);
                                multiProp.add(propName);
                            }
                            valArray[EntityFileReader.this.arrayIndex.get((int)i).intValue()] = propValue;
                            continue;
                        }
                        entity.setValue(propName, propValue);
                        continue;
                    }
                    catch (Exception e) {
                        throw new EntityCsvException("CE1001", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidValue", headerName, value), e);
                    }
                }
                if (EntityFileReader.this.usePrefixOid && entity.getOid() != null) {
                    entity.setOid(EntityFileReader.this.prefixOid + entity.getOid());
                }
                EntityFileReader.this.trimMultipleValue(entity, multiProp);
                this.currentLine = null;
                return entity;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void validate(int errorLimit) {
        try {
            List<String> list;
            this.init();
            ArrayList<String> errorMsgList = new ArrayList<String>();
            int cnt = 0;
            while ((list = this.readLine()) != null) {
                int start;
                ++cnt;
                try {
                    this.validateLine(list);
                }
                catch (EntityCsvException e) {
                    throw new EntityCsvException(e.getCode(), EntityFileReader.rs("impl.csv.EntityCsvReader.rowError", cnt, e.getMessage()), e);
                }
                for (int i = start = this.isUseCtrl() ? 1 : 0; i < this.header().size(); ++i) {
                    String headerName = this.header().get(i);
                    String propName = this.properties().get(i);
                    String value = list.get(i);
                    try {
                        this.validateValue(headerName, propName, value);
                        continue;
                    }
                    catch (EntityCsvException e) {
                        errorMsgList.add(EntityFileReader.rs("impl.csv.EntityCsvReader.rowError", cnt, e.getMessage()));
                    }
                }
            }
            if (!errorMsgList.isEmpty()) {
                Object errorMsg = EntityFileReader.rs("impl.csv.EntityCsvReader.errorHead", new Object[0]);
                if (errorLimit < 0 || errorMsgList.size() <= errorLimit) {
                    for (String s : errorMsgList) {
                        errorMsg = (String)errorMsg + "\n" + s;
                    }
                } else {
                    for (String s : errorMsgList.subList(0, errorLimit)) {
                        errorMsg = (String)errorMsg + "\n" + s;
                    }
                    errorMsg = (String)errorMsg + "\n...";
                }
                throw new EntityCsvException("CE1001", (String)errorMsg);
            }
        }
        catch (IOException e) {
            throw new ApplicationException(e);
        }
    }

    protected List<String> header() {
        this.init();
        return this.headers;
    }

    protected final List<String> readLine() throws IOException {
        this.init();
        return this.readData();
    }

    protected final void validateLine(List<String> line) {
        this.init();
        if (line.size() != this.headers.size()) {
            throw new EntityCsvException("CE2006", EntityFileReader.rs("impl.csv.EntityCsvReader.mismatchHeadSize", this.headers.size(), line.size()));
        }
    }

    protected final void validateValue(String headerName, String propName, String value) {
        this.init();
        try {
            if (!this.enableAuditPropertySpecification && (propName.equals("updateBy") || propName.equals("updateDate") || propName.equals("createBy") || propName.equals("createDate"))) {
                return;
            }
            if (headerName.contains(".")) {
                if (this.references.get(propName) != null) {
                    this.conv(value, propName, this.references.get((Object)propName).unique);
                } else {
                    this.conv(value, propName, null);
                }
            } else {
                this.conv(value, propName, this.definition.getProperty(propName));
            }
        }
        catch (Exception e) {
            throw new EntityCsvException("CE1001", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidValue", headerName, value), e);
        }
    }

    private void analyzeHeader(List<String> headerLine) {
        this.headers = new ArrayList<String>(headerLine.size());
        this.arrayIndex = new ArrayList<Integer>(headerLine.size());
        this.properties = new ArrayList<String>(headerLine.size());
        for (int i = 0; i < headerLine.size(); ++i) {
            String customPropertyName;
            String headerValue = headerLine.get(i);
            if (StringUtil.isEmpty(headerValue)) {
                throw new EntityCsvException("CE2001", EntityFileReader.rs("impl.csv.EntityCsvReader.emptyHead", i + 1));
            }
            String headerName = headerValue.split("\\(")[0];
            int index = -1;
            if (headerName.contains("[")) {
                try {
                    index = Integer.parseInt(headerName.substring(headerName.indexOf(91) + 1, headerName.lastIndexOf(93)));
                }
                catch (NumberFormatException e) {
                    throw new EntityCsvException("CE2002", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidHeadIndex", i + 1, headerValue));
                }
                headerName = headerName.substring(0, headerName.indexOf(91));
            }
            this.headers.add(headerName);
            this.arrayIndex.add(index);
            String propName = headerName;
            if (this.customColumnNameMap != null && StringUtil.isNotEmpty(customPropertyName = this.customColumnNameMap.get(headerName))) {
                propName = customPropertyName;
            }
            if (headerName.contains(".")) {
                propName = headerName.substring(0, headerName.indexOf("."));
            }
            this.properties.add(propName);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void validateHeader() {
        this.excludeProperties = new ArrayList<String>();
        for (int i = 0; i < this.headers.size(); ++i) {
            String headerName = this.headers.get(i);
            String propName = this.properties.get(i);
            if (i == 0 && CTRL_CODE_KEY.equals(headerName)) {
                this.useCtrl = true;
                continue;
            }
            PropertyDefinition pd = null;
            ReferenceInfo reference = null;
            if (headerName.contains(".")) {
                String uniqueKey = headerName.substring(propName.length() + 1);
                ReferenceProperty rp = (ReferenceProperty)this.definition.getProperty(propName);
                if (rp == null) {
                    if (this.virtualProperties != null && this.virtualProperties.contains(propName)) {
                        logger.info(this.definition.getName() + "'s " + propName + " property is virtual property.");
                    } else {
                        if (!this.ignoreNotExistsProperty) throw new EntityCsvException("CE2003", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidHeadNotFindProp", i + 1, headerName));
                        logger.warn(this.definition.getName() + " has not " + propName + " property. skip header.");
                        this.excludeProperties.add(propName);
                    }
                } else {
                    EntityDefinition red = this.edm.get(rp.getObjectDefinitionName());
                    if (red == null) {
                        throw new EntityCsvException("CE2003", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidHeadNotFindProp", i + 1, headerName));
                    }
                    PropertyDefinition unique = red.getProperty(uniqueKey);
                    if (unique == null) {
                        throw new EntityCsvException("CE2003", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidHeadNotFindProp", i + 1, headerName));
                    }
                    if (!unique.getName().equals("oid") && unique.getIndexType() != IndexType.UNIQUE && unique.getIndexType() != IndexType.UNIQUE_WITHOUT_NULL) {
                        throw new EntityCsvException("CE2009", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidHeadRefUniqueKey", i + 1, headerName, uniqueKey));
                    }
                    reference = new ReferenceInfo(propName, red, unique);
                    pd = rp;
                }
            } else {
                pd = this.definition.getProperty(propName);
                if (pd == null) {
                    if (this.virtualProperties != null && this.virtualProperties.contains(propName)) {
                        logger.info(this.definition.getName() + "'s " + propName + " property is virtual property.");
                    } else {
                        if (!this.ignoreNotExistsProperty) throw new EntityCsvException("CE2003", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidHeadNotFindProp", i + 1, headerName));
                        logger.warn(this.definition.getName() + " has not " + propName + " property. skip header.");
                        this.excludeProperties.add(propName);
                    }
                } else if (pd instanceof ReferenceProperty) {
                    EntityDefinition red = this.edm.get(((ReferenceProperty)pd).getObjectDefinitionName());
                    if (red == null) {
                        throw new EntityCsvException("CE2003", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidHeadNotFindProp", i + 1, headerName));
                    }
                    reference = new ReferenceInfo(propName, red, null);
                }
            }
            if (pd != null) {
                if (pd instanceof ReferenceProperty) {
                    if (this.arrayIndex.get(i) != -1) {
                        throw new EntityCsvException("CE2003", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidHeadRefProp", i + 1, headerName));
                    }
                } else if (pd.getMultiplicity() == 1) {
                    if (this.arrayIndex.get(i) != -1) {
                        throw new EntityCsvException("CE2004", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidHeadSingleProp", i + 1, headerName));
                    }
                } else if (this.arrayIndex.get(i) == -1) {
                    throw new EntityCsvException("CE2005", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidHeadMultiProp", i + 1, headerName));
                }
            }
            if (reference == null) continue;
            if (this.references == null) {
                this.references = new HashMap<String, ReferenceInfo>();
            }
            this.references.put(propName, reference);
        }
    }

    private Object conv(String valStr, String propName, PropertyDefinition pd) {
        if (pd == null) {
            if (StringUtil.isEmpty(valStr)) {
                return null;
            }
            return valStr;
        }
        if (pd instanceof BinaryProperty) {
            if (StringUtil.isEmpty(valStr)) {
                return null;
            }
            BinaryReference br = null;
            try {
                JsonNode root;
                JsonNode lobidNode;
                if (this.mapper == null) {
                    this.mapper = new ObjectMapper();
                    this.mapper.configOverride(Date.class).setFormat(JsonFormat.Value.forPattern((String)"yyyy-MM-dd").withTimeZone(TimeZone.getDefault()));
                }
                if ((lobidNode = (root = (JsonNode)this.mapper.readValue(valStr, JsonNode.class)).get("lobid")) != null) {
                    JsonNode typeNode;
                    br = new BinaryReference();
                    br.setLobId(Long.parseLong(lobidNode.asText()));
                    JsonNode nameNode = root.get("name");
                    if (nameNode != null) {
                        br.setName(nameNode.asText());
                    }
                    if ((typeNode = root.get("type")) != null) {
                        br.setType(typeNode.asText());
                    }
                }
            }
            catch (IOException e) {
                throw new EntityCsvException("fail to create binary value. value:" + valStr);
            }
            return br;
        }
        if (pd instanceof BooleanProperty) {
            if (StringUtil.isEmpty(valStr)) {
                return null;
            }
            if (valStr.equals("1") || valStr.equalsIgnoreCase("true") || valStr.equalsIgnoreCase("t") || valStr.equalsIgnoreCase("yes") || valStr.equalsIgnoreCase("y")) {
                return Boolean.TRUE;
            }
            if (valStr.trim().length() == 0 || valStr.equals("0") || valStr.equalsIgnoreCase("false") || valStr.equalsIgnoreCase("f") || valStr.equalsIgnoreCase("no") || valStr.equalsIgnoreCase("n")) {
                return Boolean.FALSE;
            }
        } else {
            if (pd instanceof DateProperty) {
                return ConvertUtil.convertFromString(Date.class, valStr);
            }
            if (pd instanceof DateTimeProperty) {
                return ConvertUtil.convertFromString(Timestamp.class, valStr);
            }
            if (pd instanceof DecimalProperty) {
                if (StringUtil.isEmpty(valStr)) {
                    return null;
                }
                return new BigDecimal(valStr);
            }
            if (pd instanceof ExpressionProperty) {
                return null;
            }
            if (pd instanceof FloatProperty) {
                if (StringUtil.isEmpty(valStr)) {
                    return null;
                }
                return Double.parseDouble(valStr);
            }
            if (pd instanceof IntegerProperty) {
                if (StringUtil.isEmpty(valStr)) {
                    return null;
                }
                return Long.parseLong(valStr);
            }
            if (pd instanceof LongTextProperty) {
                if (StringUtil.isEmpty(valStr)) {
                    return null;
                }
                return valStr;
            }
            if (pd instanceof ReferenceProperty) {
                String[] oidList;
                String refOidPrefix;
                if (StringUtil.isEmpty(valStr)) {
                    return null;
                }
                ReferenceProperty rpd = (ReferenceProperty)pd;
                ReferenceInfo reference = this.references.get(propName);
                String string = refOidPrefix = StringUtil.isNotEmpty(this.prefixOid) && CollectionUtil.isEmpty(reference.ed.getOidPropertyName()) ? this.prefixOid : "";
                if (rpd.getMultiplicity() == 1) {
                    Entity entity = this.generateReferenceEntity(valStr, rpd, reference.ed, refOidPrefix);
                    return entity;
                }
                ArrayList<Entity> eList = new ArrayList<Entity>();
                for (String oid : oidList = valStr.split(",")) {
                    if ((oid = oid.trim()).length() == 0) continue;
                    eList.add(this.generateReferenceEntity(oid, rpd, reference.ed, refOidPrefix));
                }
                if (reference.ed.getMapping() != null && reference.ed.getMapping().getMappingModelClass() != null) {
                    String className = reference.ed.getMapping().getMappingModelClass();
                    try {
                        Object[] hoge = (Object[])Array.newInstance(Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getClass(), eList.size());
                        return eList.toArray(hoge);
                    }
                    catch (Exception e) {
                        throw new EntityCsvException("CE2008", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidRefJavaMappingClass", rpd.getName(), className), e);
                    }
                }
                return eList.toArray(new Entity[eList.size()]);
            }
            if (pd instanceof SelectProperty) {
                if (StringUtil.isEmpty(valStr)) {
                    return null;
                }
                SelectProperty selectDef = (SelectProperty)pd;
                for (SelectValue sv : selectDef.getSelectValueList()) {
                    if (!valStr.equals(sv.getValue())) continue;
                    return sv;
                }
            } else {
                if (pd instanceof StringProperty) {
                    if (StringUtil.isEmpty(valStr)) {
                        return null;
                    }
                    return valStr;
                }
                if (pd instanceof TimeProperty) {
                    return ConvertUtil.convertFromString(Time.class, valStr);
                }
                if (pd instanceof AutoNumberProperty) {
                    if (StringUtil.isEmpty(valStr)) {
                        return null;
                    }
                    return valStr;
                }
            }
        }
        throw new EntityCsvException("CE2007", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidValueType", pd.getName(), pd.getClass().getName(), valStr));
    }

    private Entity generateEntity(EntityMapping mapping, String propName) {
        Entity entity = null;
        if (mapping != null) {
            try {
                entity = (Entity)Class.forName(mapping.getMappingModelClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (propName == null) {
                    throw new EntityCsvException("CE2008", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidJavaMappingClass", mapping.getMappingModelClass()), e);
                }
                throw new EntityCsvException("CE2008", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidRefJavaMappingClass", propName, mapping.getMappingModelClass()), e);
            }
        } else {
            entity = new GenericEntity();
        }
        return entity;
    }

    private Entity generateReferenceEntity(String value, ReferenceProperty rpd, EntityDefinition red, String refOidPrefix) {
        String ver;
        String oid;
        Entity entity = this.generateEntity(red.getMapping(), rpd.getName());
        entity.setDefinitionName(red.getName());
        if (!this.withReferenceVersion && red != null && red.getVersionControlType() == VersionControlType.NONE) {
            oid = value;
            ver = "0";
        } else if (value.lastIndexOf(46) > 0) {
            oid = value.substring(0, value.lastIndexOf(46));
            ver = value.substring(value.lastIndexOf(46) + 1);
        } else {
            oid = value;
            ver = "0";
        }
        entity.setOid(refOidPrefix + oid);
        entity.setVersion(Long.parseLong(ver));
        return entity;
    }

    private void trimMultipleValue(Entity entity, Set<String> multiProperty) {
        for (String propName : multiProperty) {
            Object[] valArray = (Object[])entity.getValue(propName);
            if (valArray == null) continue;
            int lastIndex = -1;
            for (int i = valArray.length - 1; i >= 0; --i) {
                if (valArray[i] == null) continue;
                lastIndex = i;
                break;
            }
            if (lastIndex < 0) {
                entity.setValue(propName, null);
                continue;
            }
            if (lastIndex == valArray.length - 1) continue;
            entity.setValue(propName, Arrays.copyOf(valArray, lastIndex + 1));
        }
    }

    private static String rs(String key, Object ... arguments) {
        return CoreResourceBundleUtil.resourceString(key, arguments);
    }

    private class ReferenceInfo {
        private String propName;
        private EntityDefinition ed;
        private PropertyDefinition unique;
        private Query uniqueQuery;

        public ReferenceInfo(String propName, EntityDefinition ed, PropertyDefinition unique) {
            this.propName = propName;
            this.ed = ed;
            this.unique = unique;
        }

        public Object convEntity(String value) {
            String[] uniqueList;
            if (StringUtil.isEmpty(value)) {
                return null;
            }
            ReferenceProperty rp = (ReferenceProperty)EntityFileReader.this.definition.getProperty(this.propName);
            if (rp.getMultiplicity() == 1) {
                Object uniqueValue = EntityFileReader.this.conv(value, null, this.unique);
                if (uniqueValue != null) {
                    return this.search(uniqueValue);
                }
                return null;
            }
            ArrayList<Entity> eList = new ArrayList<Entity>();
            for (String uniqueStr : uniqueList = value.split(",")) {
                Entity ref;
                Object uniqueValue;
                if ((uniqueStr = uniqueStr.trim()).length() == 0 || (uniqueValue = EntityFileReader.this.conv(uniqueStr, null, this.unique)) == null || (ref = this.search(uniqueValue)) == null) continue;
                eList.add(ref);
            }
            if (this.ed.getMapping() != null && this.ed.getMapping().getMappingModelClass() != null) {
                String className = this.ed.getMapping().getMappingModelClass();
                try {
                    Object[] hoge = (Object[])Array.newInstance(Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]).getClass(), eList.size());
                    return eList.toArray(hoge);
                }
                catch (Exception e) {
                    throw new EntityCsvException("CE2008", EntityFileReader.rs("impl.csv.EntityCsvReader.invalidRefJavaMappingClass", this.propName, className), e);
                }
            }
            return eList.toArray(new Entity[eList.size()]);
        }

        private Entity search(Object uniqueValue) {
            if (this.uniqueQuery == null) {
                this.uniqueQuery = new Query().select("oid", "version").from(this.ed.getName());
            }
            Query query = this.uniqueQuery.copy().where(new Equals(this.unique.getName(), uniqueValue));
            return (Entity)EntityFileReader.this.em.searchEntity(query).getFirst();
        }
    }
}

