/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.fileport;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipOutputStream;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityKey;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.LoadOption;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.definition.EntityDefinition;
import org.iplass.mtp.entity.definition.EntityDefinitionManager;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.properties.ReferenceProperty;
import org.iplass.mtp.entity.permission.EntityPermission;
import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.entity.query.OrderBy;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryVisitorSupport;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.impl.entity.fileport.EntityCsvWriteOption;
import org.iplass.mtp.impl.entity.fileport.EntityExcelWriteOption;
import org.iplass.mtp.impl.entity.fileport.EntityExcelWriter;
import org.iplass.mtp.util.CollectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySearchExcelWriter
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(EntitySearchExcelWriter.class);
    private final OutputStream out;
    private final String definitionName;
    private final EntityExcelWriteOption option;
    private final ZipOutputStream binaryStore;
    private final EntityManager em;
    private final EntityDefinitionManager edm;
    private EntityExcelWriter writer;

    public EntitySearchExcelWriter(OutputStream out, String definitionName) {
        this(out, definitionName, new EntityExcelWriteOption(), null);
    }

    public EntitySearchExcelWriter(OutputStream out, String definitionName, EntityExcelWriteOption option) {
        this(out, definitionName, option, null);
    }

    public EntitySearchExcelWriter(OutputStream out, String definitionName, EntityExcelWriteOption option, ZipOutputStream binaryStore) {
        this.out = out;
        this.definitionName = definitionName;
        this.option = option;
        this.binaryStore = binaryStore;
        this.em = ManagerLocator.manager(EntityManager.class);
        this.edm = ManagerLocator.manager(EntityDefinitionManager.class);
    }

    public int write() throws IOException {
        EntityDefinition ed = this.edm.get(this.definitionName);
        if (this.writer != null) {
            this.close();
        }
        this.writer = new EntityExcelWriter(ed, this.out, this.option, this.binaryStore);
        boolean hasMultiReference = this.hasMultiReference();
        Query query = this.createQuery(ed, hasMultiReference);
        this.writer.writeHeader();
        return this.writeData(ed, query, hasMultiReference);
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    private boolean hasMultiReference() {
        return this.writer.getProperties().stream().filter(property -> property instanceof ReferenceProperty).anyMatch(property -> property.getMultiplicity() != 1);
    }

    private Query createQuery(EntityDefinition ed, boolean hasMultiReference) {
        ArrayList<String> select = new ArrayList<String>();
        if (hasMultiReference && !this.option.isLoadOnceOfHasMultipleReferenceEntity()) {
            select.add("oid");
            select.add("version");
        } else {
            this.writer.getProperties().forEach(property -> {
                String propName = property.getName();
                if (property instanceof ReferenceProperty) {
                    select.add(propName + ".oid");
                    select.add(propName + ".version");
                } else {
                    select.add(propName);
                }
            });
        }
        Query query = new Query().select(select.toArray(new Object[select.size()])).from(ed.getName());
        query.setWhere(this.option.getWhere());
        query.setOrderBy(this.option.getOrderBy());
        query.versioned(this.option.isVersioned());
        if (this.option.getLimit() > 0) {
            query.setLimit(new Limit(this.option.getLimit()));
        }
        return query;
    }

    private int writeData(EntityDefinition ed, Query query, boolean hasMultiReference) {
        EntityCsvWriteOption.SearchQueryCsvContext context = this.option.getBeforeSearch().apply(query);
        Query optQuery = context.getQuery();
        if (!optQuery.getSelect().isDistinct() && new MultiReferenceChecker(ed).test(optQuery.getWhere())) {
            optQuery.getSelect().setDistinct(true);
            logger.debug("specified distinct for select. because [where conditions] contains multiple reference property. query:" + String.valueOf(optQuery));
            if (optQuery.getOrderBy() != null) {
                logger.debug("query [order by] removed. because [where conditions] contains multiple reference property. removed order by:" + String.valueOf(optQuery.getOrderBy()));
                optQuery.setOrderBy(null);
            }
        }
        if (optQuery.getOrderBy() != null && new MultiReferenceChecker(ed).test(optQuery.getOrderBy())) {
            logger.debug("query [order by] removed. because [order by] contains multiple reference property. removed order by:" + String.valueOf(optQuery.getOrderBy()));
            optQuery.setOrderBy(null);
        }
        if (optQuery.getLimit() != null && optQuery.getOrderBy() == null && this.option.isMustOrderByWithLimit()) {
            logger.debug("query [order by] `oid desc` is specified. because mustOrderByWithLimit is true.");
            optQuery.order(new SortSpec("oid", SortSpec.SortType.DESC));
        }
        this.writer.beforeWriteData();
        if (context.isDoPrivileged()) {
            return AuthContext.doPrivileged(() -> this.doSearch(optQuery, hasMultiReference));
        }
        if (context.getWithoutConditionReferenceName() != null) {
            return EntityPermission.doQueryAs(context.getWithoutConditionReferenceName(), () -> this.doSearch(optQuery, hasMultiReference));
        }
        return this.doSearch(optQuery, hasMultiReference);
    }

    private int doSearch(Query query, boolean hasMultiReference) {
        if (hasMultiReference && !this.option.isLoadOnceOfHasMultipleReferenceEntity()) {
            return this.doSearchMultiReference(query);
        }
        int[] count = new int[1];
        SearchOption searchOption = new SearchOption();
        if (hasMultiReference && this.option.isLoadOnceOfHasMultipleReferenceEntity()) {
            searchOption.setReturnStructuredEntity(true);
        }
        this.em.searchEntity(query, searchOption, entity -> {
            this.option.getAfterSearch().accept(query.copy(), (Entity)entity);
            this.writer.writeEntity((Entity)entity);
            count[0] = count[0] + 1;
            return true;
        });
        this.writer.endData();
        return count[0];
    }

    private int doSearchMultiReference(Query query) {
        LoadOption loadOption = new LoadOption();
        if (CollectionUtil.isNotEmpty(this.option.getProperties())) {
            List<String> references = this.writer.getProperties().stream().filter(property -> property instanceof ReferenceProperty).map(property -> property.getName()).collect(Collectors.toList());
            loadOption.setLoadReferences(references);
        } else {
            loadOption.setWithMappedByReference(this.option.isWithMappedByReference());
        }
        int[] count = new int[1];
        ArrayList<Entity> entities = new ArrayList<Entity>();
        this.em.searchEntity(query, entity -> {
            if (this.option.getLoadSizeOfHasMultipleReferenceEntity() > 1) {
                entities.add((Entity)entity);
                if (entities.size() % this.option.getLoadSizeOfHasMultipleReferenceEntity() == 0) {
                    count[0] = count[0] + this.writeBatchLoadEntity(query, entities, loadOption);
                    entities.clear();
                }
            } else {
                Entity loadEntity = this.em.load(entity.getOid(), entity.getVersion(), entity.getDefinitionName(), loadOption);
                this.option.getAfterSearch().accept(query.copy(), loadEntity);
                this.writer.writeEntity(loadEntity);
                count[0] = count[0] + 1;
            }
            return true;
        });
        if (!entities.isEmpty()) {
            count[0] = count[0] + this.writeBatchLoadEntity(query, entities, loadOption);
        }
        this.writer.endData();
        return count[0];
    }

    private int writeBatchLoadEntity(Query query, List<Entity> entities, LoadOption loadOption) {
        List<EntityKey> keys = entities.stream().map(entity -> new EntityKey(entity.getOid(), entity.getVersion())).collect(Collectors.toList());
        List<Entity> loadEntities = this.em.batchLoad(keys, this.definitionName, loadOption);
        loadEntities.forEach(entity -> {
            this.option.getAfterSearch().accept(query.copy(), (Entity)entity);
            this.writer.writeEntity((Entity)entity);
        });
        return loadEntities.size();
    }

    private static class MultiReferenceChecker
    extends QueryVisitorSupport {
        private EntityDefinition ed;
        private boolean hasMultiReference;

        public MultiReferenceChecker(EntityDefinition ed) {
            this.ed = ed;
        }

        public boolean test(Where where) {
            this.hasMultiReference = false;
            if (where != null && where.getCondition() != null) {
                where.getCondition().accept(this);
            }
            return this.hasMultiReference;
        }

        public boolean test(OrderBy order) {
            this.hasMultiReference = false;
            if (order != null) {
                order.accept(this);
            }
            return this.hasMultiReference;
        }

        @Override
        public boolean visit(EntityField entityField) {
            PropertyDefinition pd;
            if (entityField.getPropertyName().contains(".") && (pd = this.ed.getProperty(entityField.getPropertyName().substring(0, entityField.getPropertyName().indexOf(".")))) != null && pd instanceof ReferenceProperty) {
                this.hasMultiReference = ((ReferenceProperty)pd).getMultiplicity() != 1;
            }
            return !this.hasMultiReference;
        }
    }
}

