/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.l10n;

import java.util.List;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.GenericEntity;
import org.iplass.mtp.entity.InsertOption;
import org.iplass.mtp.entity.UpdateOption;
import org.iplass.mtp.entity.interceptor.EntityCountInvocation;
import org.iplass.mtp.entity.interceptor.EntityInsertInvocation;
import org.iplass.mtp.entity.interceptor.EntityInterceptorAdapter;
import org.iplass.mtp.entity.interceptor.EntityLoadInvocation;
import org.iplass.mtp.entity.interceptor.EntityQueryInvocation;
import org.iplass.mtp.entity.interceptor.EntityUpdateInvocation;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.interceptor.EntityInvocationImpl;
import org.iplass.mtp.impl.entity.l10n.QueryLocalizer;
import org.iplass.mtp.impl.entity.l10n.SearchResultAdapter;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.properties.extend.AutoNumberType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityLocalizationInterceptor
extends EntityInterceptorAdapter {
    private static Logger logger = LoggerFactory.getLogger(EntityLocalizationInterceptor.class);

    @Override
    public String insert(EntityInsertInvocation invocation) {
        EntityHandler eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler();
        if (eh.getDataLocalizationStrategyRuntime() != null) {
            if (invocation.getInsertOption() != null && invocation.getInsertOption().isLocalized()) {
                Entity forRet = invocation.getEntity();
                GenericEntity e = ((GenericEntity)forRet).copy();
                InsertOption op = invocation.getInsertOption().copy();
                eh.getDataLocalizationStrategyRuntime().handleEntityForInsert(e, op);
                if (logger.isDebugEnabled()) {
                    logger.debug("translate to Local:from=" + String.valueOf(forRet) + ", to=" + String.valueOf(e));
                }
                invocation.setEntity(e);
                invocation.setInsertOption(op);
                String oid = (String)invocation.proceed();
                forRet.setOid(e.getOid());
                forRet.setVersion(e.getVersion());
                List<PropertyHandler> pList = eh.getPropertyListByPropertyType(AutoNumberType.class, EntityContext.getCurrentContext());
                if (pList != null) {
                    for (PropertyHandler ph : pList) {
                        forRet.setValue(ph.getName(), e.getValue(ph.getName()));
                    }
                }
                return oid;
            }
            return (String)invocation.proceed();
        }
        return (String)invocation.proceed();
    }

    @Override
    public void update(EntityUpdateInvocation invocation) {
        EntityHandler eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler();
        if (eh.getDataLocalizationStrategyRuntime() != null) {
            if (invocation.getUpdateOption() != null && invocation.getUpdateOption().isLocalized()) {
                Entity forRet = invocation.getEntity();
                GenericEntity e = ((GenericEntity)forRet).copy();
                UpdateOption op = invocation.getUpdateOption().copy();
                eh.getDataLocalizationStrategyRuntime().handleEntityForUpdate(e, op);
                if (logger.isDebugEnabled()) {
                    logger.debug("translate to Local:from=" + String.valueOf(forRet) + ", to=" + String.valueOf(e));
                }
                invocation.setEntity(e);
                invocation.setUpdateOption(op);
                invocation.proceed();
                forRet.setVersion(e.getVersion());
            } else {
                invocation.proceed();
            }
        } else {
            invocation.proceed();
        }
    }

    @Override
    public Entity load(EntityLoadInvocation invocation) {
        EntityHandler eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler();
        if (eh.getDataLocalizationStrategyRuntime() != null) {
            if (invocation.getLoadOption() != null && invocation.getLoadOption().isLocalized()) {
                Entity e = (Entity)invocation.proceed();
                Entity transed = eh.getDataLocalizationStrategyRuntime().handleEntityForLoad(e);
                if (logger.isDebugEnabled()) {
                    logger.debug("translate to Local:from=" + String.valueOf(e) + ", to=" + String.valueOf(transed));
                }
                return transed;
            }
            return (Entity)invocation.proceed();
        }
        return (Entity)invocation.proceed();
    }

    @Override
    public void query(EntityQueryInvocation invocation) {
        EntityHandler eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler();
        if (invocation.getQuery().isLocalized()) {
            QueryLocalizer ql = new QueryLocalizer(eh, EntityContext.getCurrentContext());
            Query q = (Query)invocation.getQuery().accept(ql);
            if (logger.isDebugEnabled()) {
                logger.debug("translate to Local:from=" + String.valueOf(invocation.getQuery()) + ", to=" + String.valueOf(q));
            }
            if (invocation.getType() == InvocationType.SEARCH_ENTITY) {
                SearchResultAdapter callback = new SearchResultAdapter(invocation.getQuery(), q, invocation.getPredicate());
                invocation.setPredicate(callback);
            }
            invocation.setQuery(q);
            invocation.proceed();
        } else {
            invocation.proceed();
        }
    }

    @Override
    public int count(EntityCountInvocation invocation) {
        EntityHandler eh = ((EntityInvocationImpl)((Object)invocation)).getEntityHandler();
        if (invocation.getQuery().isLocalized()) {
            QueryLocalizer ql = new QueryLocalizer(eh, EntityContext.getCurrentContext());
            Query q = (Query)invocation.getQuery().accept(ql);
            if (logger.isDebugEnabled()) {
                logger.debug("translate to Local:from=" + String.valueOf(invocation.getQuery()) + ", to=" + String.valueOf(q));
            }
            invocation.setQuery(q);
            return (Integer)invocation.proceed();
        }
        return (Integer)invocation.proceed();
    }
}

