/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.listener;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityEventContext;
import org.iplass.mtp.entity.EntityEventListener;
import org.iplass.mtp.entity.definition.EventListenerDefinition;
import org.iplass.mtp.entity.definition.listeners.EventType;
import org.iplass.mtp.entity.definition.listeners.ScriptingEventListenerDefinition;
import org.iplass.mtp.impl.auth.AuthContextHolder;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.MetaEventListener;
import org.iplass.mtp.impl.script.Script;
import org.iplass.mtp.impl.script.ScriptContext;
import org.iplass.mtp.impl.script.ScriptEngine;

public class MetaScriptingEventListener
extends MetaEventListener {
    private static final long serialVersionUID = -5525839977593609749L;
    public static final String ENTITY_BINDING_NAME = "entity";
    public static final String EVENT_TYPE_BINDING_NAME = "event";
    public static final String CONTEXT_BINDING_NAME = "context";
    public static final String USER_BINDING_NAME = "user";
    public static final String DATE_BINGING_NAME = "date";
    private String script;
    private List<EventType> listenEvent;

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public List<EventType> getListenEvent() {
        return this.listenEvent;
    }

    public void setListenEvent(List<EventType> listenEvent) {
        this.listenEvent = listenEvent;
    }

    @Override
    public MetaScriptingEventListener copy() {
        MetaScriptingEventListener copy = new MetaScriptingEventListener();
        this.copyTo(copy);
        copy.script = this.script;
        if (this.listenEvent != null) {
            copy.listenEvent = new ArrayList<EventType>();
            copy.listenEvent.addAll(this.listenEvent);
        }
        return copy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.listenEvent == null ? 0 : this.listenEvent.hashCode());
        result = 31 * result + (this.script == null ? 0 : this.script.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaScriptingEventListener other = (MetaScriptingEventListener)obj;
        if (this.listenEvent == null ? other.listenEvent != null : !this.listenEvent.equals(other.listenEvent)) {
            return false;
        }
        return !(this.script == null ? other.script != null : !this.script.equals(other.script));
    }

    @Override
    public void applyConfig(EventListenerDefinition def) {
        this.fillFrom(def);
        ScriptingEventListenerDefinition d = (ScriptingEventListenerDefinition)def;
        this.script = d.getScript();
        if (d.getListenEvent() != null) {
            this.listenEvent = new ArrayList<EventType>();
            this.listenEvent.addAll(d.getListenEvent());
        } else {
            this.listenEvent = null;
        }
    }

    @Override
    public EventListenerDefinition currentConfig() {
        ScriptingEventListenerDefinition d = new ScriptingEventListenerDefinition();
        this.fillTo(d);
        d.setScript(this.script);
        if (this.listenEvent != null) {
            ArrayList<EventType> es = new ArrayList<EventType>();
            es.addAll(this.listenEvent);
            d.setListenEvent(es);
        }
        return d;
    }

    @Override
    public ScriptingEventListenerHandler createRuntime(MetaEntity entity) {
        return new ScriptingEventListenerHandler(entity);
    }

    public class ScriptingEventListenerHandler
    extends MetaEventListener.EventListenerRuntime {
        private static final String SCRIPT_PREFIX = "ScriptingEventListenerHandler_script";
        private Script compiledScript;
        private ScriptEngine scriptEngine;
        private EntityEventListener listener;
        private boolean isAfterDelete;
        private boolean isAfterInsert;
        private boolean isAfterUpdate;
        private boolean isBeforeDelete;
        private boolean isBeforeInsert;
        private boolean isBeforeUpdate;
        private boolean isBeforeValidate;
        private boolean isOnLoad;
        private boolean isAfterRestore;
        private boolean isAfterPurge;

        public ScriptingEventListenerHandler(MetaEntity entity) {
            super(MetaScriptingEventListener.this);
            TenantContext tc = ExecuteContext.getCurrentContext().getTenantContext();
            this.scriptEngine = tc.getScriptEngine();
            if (MetaScriptingEventListener.this.script != null) {
                String scriptWithImport = "import " + EventType.class.getName() + ";\n" + MetaScriptingEventListener.this.script;
                String scriptName = null;
                for (int i = 0; i < entity.getEventListenerList().size(); ++i) {
                    if (MetaScriptingEventListener.this != entity.getEventListenerList().get(i)) continue;
                    scriptName = "ScriptingEventListenerHandler_script_" + entity.getId() + "_" + i;
                    break;
                }
                this.compiledScript = this.scriptEngine.createScript(scriptWithImport, scriptName);
                this.listener = this.compiledScript.isInstantiateAs(EntityEventListener.class) ? this.compiledScript.createInstanceAs(EntityEventListener.class, null) : null;
                if (MetaScriptingEventListener.this.listenEvent != null) {
                    for (EventType type : MetaScriptingEventListener.this.listenEvent) {
                        switch (type) {
                            case AFTER_DELETE: {
                                this.isAfterDelete = true;
                                break;
                            }
                            case AFTER_INSERT: {
                                this.isAfterInsert = true;
                                break;
                            }
                            case AFTER_UPDATE: {
                                this.isAfterUpdate = true;
                                break;
                            }
                            case BEFORE_DELETE: {
                                this.isBeforeDelete = true;
                                break;
                            }
                            case BEFORE_INSERT: {
                                this.isBeforeInsert = true;
                                break;
                            }
                            case BEFORE_UPDATE: {
                                this.isBeforeUpdate = true;
                                break;
                            }
                            case BEFORE_VALIDATE: {
                                this.isBeforeValidate = true;
                                break;
                            }
                            case ON_LOAD: {
                                this.isOnLoad = true;
                                break;
                            }
                            case AFTER_RESTORE: {
                                this.isAfterRestore = true;
                                break;
                            }
                            case AFTER_PURGE: {
                                this.isAfterPurge = true;
                            }
                        }
                    }
                }
            }
        }

        private Object callScript(Entity entity, EventType type, EntityEventContext context) {
            ScriptContext sc = this.scriptEngine.newScriptContext();
            sc.setAttribute(MetaScriptingEventListener.ENTITY_BINDING_NAME, entity);
            sc.setAttribute(MetaScriptingEventListener.EVENT_TYPE_BINDING_NAME, (Object)type);
            sc.setAttribute(MetaScriptingEventListener.CONTEXT_BINDING_NAME, context);
            ExecuteContext ex = ExecuteContext.getCurrentContext();
            sc.setAttribute(MetaScriptingEventListener.USER_BINDING_NAME, AuthContextHolder.getAuthContext().newUserBinding());
            sc.setAttribute(MetaScriptingEventListener.DATE_BINGING_NAME, ex.getCurrentTimestamp());
            return this.compiledScript.eval(sc);
        }

        @Override
        public void handleAfterDelete(Entity entity, EntityEventContext context) {
            if (this.isAfterDelete) {
                if (this.listener != null) {
                    this.listener.afterDelete(entity, context);
                } else {
                    this.callScript(entity, EventType.AFTER_DELETE, context);
                }
            }
        }

        @Override
        public void handleAfterInsert(Entity entity, EntityEventContext context) {
            if (this.isAfterInsert) {
                if (this.listener != null) {
                    this.listener.afterInsert(entity, context);
                } else {
                    this.callScript(entity, EventType.AFTER_INSERT, context);
                }
            }
        }

        @Override
        public void handleAfterUpdate(Entity entity, EntityEventContext context) {
            if (this.isAfterUpdate) {
                if (this.listener != null) {
                    this.listener.afterUpdate(entity, context);
                } else {
                    this.callScript(entity, EventType.AFTER_UPDATE, context);
                }
            }
        }

        @Override
        public boolean handleBeforeDelete(Entity entity, EntityEventContext context) {
            if (this.isBeforeDelete) {
                if (this.listener != null) {
                    return this.listener.beforeDelete(entity, context);
                }
                Object ret = this.callScript(entity, EventType.BEFORE_DELETE, context);
                if (ret instanceof Boolean && !((Boolean)ret).booleanValue()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean handleBeforeInsert(Entity entity, EntityEventContext context) {
            if (this.isBeforeInsert) {
                if (this.listener != null) {
                    return this.listener.beforeInsert(entity, context);
                }
                Object ret = this.callScript(entity, EventType.BEFORE_INSERT, context);
                if (ret instanceof Boolean && !((Boolean)ret).booleanValue()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean handleBeforeUpdate(Entity entity, EntityEventContext context) {
            if (this.isBeforeUpdate) {
                if (this.listener != null) {
                    return this.listener.beforeUpdate(entity, context);
                }
                Object ret = this.callScript(entity, EventType.BEFORE_UPDATE, context);
                if (ret instanceof Boolean && !((Boolean)ret).booleanValue()) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void handleOnLoad(Entity entity) {
            if (this.isOnLoad) {
                if (this.listener != null) {
                    this.listener.onLoad(entity);
                } else {
                    this.callScript(entity, EventType.ON_LOAD, null);
                }
            }
        }

        @Override
        public void handleBeforeValidate(Entity entity, EntityEventContext context) {
            if (this.isBeforeValidate) {
                if (this.listener != null) {
                    this.listener.beforeValidate(entity, context);
                } else {
                    this.callScript(entity, EventType.BEFORE_VALIDATE, context);
                }
            }
        }

        @Override
        public MetaScriptingEventListener getMetaData() {
            return MetaScriptingEventListener.this;
        }

        @Override
        public void handleAfterRestore(Entity entity) {
            if (this.isAfterRestore) {
                if (this.listener != null) {
                    this.listener.afterRestore(entity);
                } else {
                    this.callScript(entity, EventType.AFTER_RESTORE, null);
                }
            }
        }

        @Override
        public void handleAfterPurge(Entity entity) {
            if (this.isAfterPurge) {
                if (this.listener != null) {
                    this.listener.afterPurge(entity);
                } else {
                    this.callScript(entity, EventType.AFTER_PURGE, null);
                }
            }
        }
    }
}

