/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.normalizer;

import com.ibm.icu.text.Transliterator;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.NormalizerDefinition;
import org.iplass.mtp.entity.definition.normalizers.ICUTransliterator;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.normalizer.MetaNormalizer;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.util.ObjectUtil;

public class MetaICUTransliterator
extends MetaNormalizer {
    private static final long serialVersionUID = 8075490131535862272L;
    private String transliteratorId;

    public String getTransliteratorId() {
        return this.transliteratorId;
    }

    public void setTransliteratorId(String transliteratorId) {
        this.transliteratorId = transliteratorId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.transliteratorId == null ? 0 : this.transliteratorId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaICUTransliterator other = (MetaICUTransliterator)obj;
        return !(this.transliteratorId == null ? other.transliteratorId != null : !this.transliteratorId.equals(other.transliteratorId));
    }

    @Override
    public MetaICUTransliterator copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(NormalizerDefinition definition) {
        ICUTransliterator d = (ICUTransliterator)definition;
        this.transliteratorId = d.getTransliteratorId();
    }

    @Override
    public ICUTransliterator currentConfig(EntityContext context) {
        return new ICUTransliterator(this.transliteratorId);
    }

    @Override
    public MetaNormalizer.NormalizerRuntime createRuntime(MetaEntity entity, MetaProperty property) {
        return new ICUTransliteratorRuntime(this, property);
    }

    public class ICUTransliteratorRuntime
    extends MetaNormalizer.NormalizerRuntime {
        private Transliterator trans;

        ICUTransliteratorRuntime(MetaICUTransliterator this$0, MetaProperty property) {
            super(this$0);
            if (this$0.transliteratorId == null) {
                throw new NullPointerException(property.getName() + "'s ICUTransliterator transliteratorId must specified");
            }
            this.trans = Transliterator.getInstance((String)this$0.transliteratorId);
        }

        @Override
        public Object normalize(Object value, ValidationContext context) {
            if (value == null) {
                return null;
            }
            return this.trans.transliterate(value.toString());
        }
    }
}

