/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.normalizer;

import org.iplass.mtp.entity.PropertyNormalizer;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.NormalizerDefinition;
import org.iplass.mtp.entity.definition.normalizers.JavaClassNormalizer;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.normalizer.MetaNormalizer;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.util.ObjectUtil;

public class MetaJavaClassNormalizer
extends MetaNormalizer {
    private static final long serialVersionUID = 625875739932037108L;
    private String className;
    private boolean asArray = false;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isAsArray() {
        return this.asArray;
    }

    public void setAsArray(boolean asArray) {
        this.asArray = asArray;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.asArray ? 1231 : 1237);
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaJavaClassNormalizer other = (MetaJavaClassNormalizer)obj;
        if (this.asArray != other.asArray) {
            return false;
        }
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }

    @Override
    public MetaJavaClassNormalizer copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(NormalizerDefinition definition) {
        JavaClassNormalizer d = (JavaClassNormalizer)definition;
        this.className = d.getClassName();
        this.asArray = d.isAsArray();
    }

    @Override
    public JavaClassNormalizer currentConfig(EntityContext context) {
        JavaClassNormalizer d = new JavaClassNormalizer();
        d.setClassName(this.className);
        d.setAsArray(this.asArray);
        return d;
    }

    @Override
    public MetaNormalizer.NormalizerRuntime createRuntime(MetaEntity entity, MetaProperty property) {
        return new JavaClassNormalizerRuntime(property);
    }

    public class JavaClassNormalizerRuntime
    extends MetaNormalizer.NormalizerRuntime {
        PropertyNormalizer<?> propertyNormalizer;

        public JavaClassNormalizerRuntime(MetaProperty property) {
            super(MetaJavaClassNormalizer.this);
            if (MetaJavaClassNormalizer.this.className == null) {
                throw new NullPointerException(property.getName() + "'s JavaClassNormalizer className must specified");
            }
            try {
                this.propertyNormalizer = (PropertyNormalizer)Class.forName(MetaJavaClassNormalizer.this.className).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("can not instantiate " + MetaJavaClassNormalizer.this.className + " of " + property.getName() + "'s JavaClassNormalizer", e);
            }
        }

        @Override
        public Object normalize(Object value, ValidationContext context) {
            return this.propertyNormalizer.normalize(value, context);
        }

        @Override
        public Object normalizeArray(Object[] values, ValidationContext context) {
            if (MetaJavaClassNormalizer.this.asArray) {
                return this.normalize(values, context);
            }
            return super.normalizeArray(values, context);
        }
    }
}

